/*
###################################
#
# freergss.c Ver. 0.0.1
#
###################################
*/
#define FREERGSS_VERSION "0.0.1"

#undef DIRECTINPUT_VERSION
#define DIRECTINPUT_VERSION        (0x0800)            /* DirectInputo[W` */
#define WINVER 0x0500            //    o[W` Windows2000ȏ
#define _WIN32_WINNT WINVER

#include "ruby.h"
#include <stdlib.h>
#include <mmsystem.h>
#include <tchar.h>
#include <d3dx9.h>
#include <dmusici.h>
#include <dinput.h>
#include <memory.h>
#include <math.h>

#ifndef RSTRING_PTR
#  define RSTRING_PTR(s) (RSTRING(s)->ptr)
#endif
#ifndef RSTRING_LEN
#  define RSTRING_LEN(s) (RSTRING(s)->len)
#endif

#ifndef RARRAY_PTR
#  define RARRAY_PTR(s) (RARRAY(s)->ptr)
#endif
#ifndef RARRAY_LEN
#  define RARRAY_LEN(s) (RARRAY(s)->len)
#endif

#define RELEASE( x )  if( x ) { x->lpVtbl->Release( x ); x = NULL; }

#define FR_TYPECHECK( a, b ) \
        {if( TYPE( b ) != T_DATA || RDATA( b )->dfree != (RUBY_DATA_FUNC)release_##a )\
        rb_raise(rb_eTypeError, "wrong argument type %s (expected FreeRGSS::"#a")", rb_obj_classname( b ));}

#define FR_IS_TRUE( x ) (x != Qnil && x != Qfalse)
#define FR_IS_FALSE( x ) (x == Qnil || x == Qfalse)
#define FR_GET_STRUCT( c, v ) ((struct FR_##c *)DATA_PTR( v ))
#define FR_MAX( a, b ) (a > b ? a : b)
#define FR_MIN( a, b ) (a > b ? b : a)
#define FR_0_255( a ) (a > 255 ? 255 : (a < 0) ? 0 : a)
#define FR_M255_255( a ) (a > 255 ? 255 : (a < -255) ? -255 : a)

#define PADMAX 2

#define P_LEFT     0
#define P_RIGHT    1
#define P_UP       2
#define P_DOWN     3
#define P_BUTTON0  4
#define P_BUTTON1  5
#define P_BUTTON2  6
#define P_BUTTON3  7
#define P_BUTTON4  8
#define P_BUTTON5  9
#define P_BUTTON6  10
#define P_BUTTON7  11
#define P_BUTTON8  12
#define P_BUTTON9  13
#define P_BUTTON10 14
#define P_BUTTON11 15
#define P_BUTTON12 16
#define P_BUTTON13 17
#define P_BUTTON14 18
#define P_BUTTON15 19
#define M_LBUTTON   0
#define M_RBUTTON   1
#define M_MBUTTON   2
#define FRB_DOWN    2
#define FRB_LEFT    4
#define FRB_RIGHT   6
#define FRB_UP      8
#define FRB_A       11
#define FRB_B       12
#define FRB_C       13
#define FRB_X       14
#define FRB_Y       15
#define FRB_Z       16
#define FRB_L       17
#define FRB_R       18
#define FRB_SHIFT   21
#define FRB_CTRL    22
#define FRB_ALT     23
#define FRB_F5      25
#define FRB_F6      26
#define FRB_F7      27
#define FRB_F8      28
#define FRB_F9      29



static VALUE mFreeRGSS;     /* FreeRGSSW[   */
static VALUE cBitmap;       /* BitmapNX         */
static VALUE cSprite;       /* SpriteNX         */
static VALUE cRect;         /* RectNX           */
static VALUE cTone;         /* ToneNX           */
static VALUE cColor;        /* ColorNX          */
static VALUE cViewport;     /* ViewportNX       */
static VALUE cFont;         /* tHgNX       */
static VALUE cPlane;        /* PlaneNX          */
static VALUE cTable;        /* TableNX          */
static VALUE cTilemap;      /* TilemapNX        */
static VALUE cWindow;       /* WindowNX         */
static VALUE mGraphics;     /* GraphicsW[   */
static VALUE mInput;        /* CvbgW[ */
static VALUE mAudio;        /* AudioW[      */

static VALUE eFreeRGSSError;  /* O                 */

/* O[oϐ */
static HINSTANCE             g_hInstance   = NULL; /* AvP[VCX^X   */
static HANDLE                g_hWnd       = NULL; /* EBhEnh             */
static LPDIRECT3D9           g_pD3D        = NULL; /* Direct3DC^[tFCX       */
static LPDIRECT3DDEVICE9     g_pD3DDevice  = NULL; /* Direct3DDeviceC^[tFCX */
static D3DPRESENT_PARAMETERS g_D3DPP;              /* D3DDevice̐ݒ                */
static LPD3DXSPRITE          g_pD3DXSprite = NULL; /* XvCg                     */

static LPDIRECTINPUT8        g_pDInput            = NULL; /* DirectInput */
static LPDIRECTINPUTDEVICE8  g_pDIDKeyBoard       = NULL; /* DirectInput̃L[{[hfoCX */
static LPDIRECTINPUTDEVICE8  g_pDIDJoyPad[PADMAX];        /* DirectInput̃pbhfoCX     */
static BYTE g_diKeyState[256];                            /* DirectInputł̃L[{[h͗pobt@ */
static BYTE g_diKeyCount[256];                            /* DirectInputł̃L[{[h͗pJE^ */
static BYTE g_diKeyConfig[256];                           /* DirectInputł̃L[{[hEpbh蓖 */
static BYTE g_diKeyWait[256];                             /* I[gs[gEFCg */
static BYTE g_diKeyInterval[256];                         /* I[gs[gԊu */
static int g_JoystickCount = 0;
static BYTE g_byMouseState_L, g_byMouseStateOld_L;
static BYTE g_byMouseState_M, g_byMouseStateOld_M;
static BYTE g_byMouseState_R, g_byMouseStateOld_R;

static BYTE g_fr_button[30];
static BYTE g_fr_button_count[30];
static BYTE g_fr_button_old[30];


static int g_iRefAll = 1; /* C^[tF[X̎QƃJEg */

/* Q[p */
static int g_bActive = 0;

/* t[p */
static __int64 g_OneSecondCount       = 0;         /* bԂɃJE^鐔         */
static int     g_isPerformanceCounter = 0;         /* ptH[}XJE^P */
static __int64 g_OldTime              = 0;         /* Õt[I       */
static __int64 g_OneFrameCount        = 0;         /* Pt[̏ɂ     */
static __int64 g_DrawTime             = 0;         /* `ɂ                 */

/* EBhE\ */
static struct FR_WindowInfo {
    int x;              /* W */
    int y;              /* W */
    int width;          /*      */
    int height;         /*    */
    int windowed;       /* EBhE[hQtrue */
    int created;        /* EBhE쐬Qtrue */
    float scale;        /* EBhẼTCY{ */
    int RefreshRate;    /* tbV[g */
    int enablemouse;    /* }EX\邩ǂ */
    int mousewheelpos;  /* }EXzC[̈ʒu */
    int fps;            /* fps */
    int fpscheck;       /* ݂fps */
    int frameskip;      /* R}tO */
    int r;              /* wiNAF Ԑ */
    int g;              /* wiNAF ΐ */
    int b;              /* wiNAF  */
    int minfilter;      /* ktB^ */
    int magfilter;      /* gtB^ */
    HANDLE hIcon;       /* EBhEACRnh */
    int loop;           /* Window.loopĂ1 */
    int requestclose;   /* EBhEꂽ1 */
} g_WindowInfo;

LPD3DXEFFECT m_pEffect;
D3DXHANDLE m_hTechnique_sprite;
D3DXHANDLE m_hTechnique_viewport;
D3DXHANDLE g_hcolor_sprite;
D3DXHANDLE g_hcolor_viewport;
D3DXHANDLE g_htone_sprite;
D3DXHANDLE g_htone_viewport;

typedef struct tag_dx_TLVERTEX {
    float           x, y, z;
    D3DCOLOR        color;
    float           tu, tv;
}TLVERTX, *LPTLVERTEX;

struct FR_Graphics {
    VALUE vsprites;
    int frame_count;
    int brightness;
} g_graphics;

struct FR_SuperSprite {
    void (*internal_draw)(VALUE,int,int);
    int y;
    int z;
};

struct FR_Viewport {
    void (*internal_draw)(VALUE,int,int);
    int y;
    int z;
    VALUE vdispose;
    VALUE vvisible;
    VALUE vrect;
    int ox;
    int oy;
    VALUE vcolor;
    VALUE vtone;
    int flash_count;
    int flash_count_start;
    unsigned char flash_red;
    unsigned char flash_green;
    unsigned char flash_blue;
    unsigned char flash_alpha;
    int flash_delete;

    //
    VALUE vsprites;
};

struct FR_Sprite {
    void (*internal_draw)(VALUE,int,int);
    int y;
    int z;
    VALUE vdispose;
    VALUE vvisible;
    VALUE vbitmap;
    VALUE vrect;
    VALUE vviewport;
    VALUE vcolor;
    VALUE vtone;
    int blend_type;
    int flash_count;
    int flash_delete;
    int x;
    int ox;
    int oy;
    float zoom_x;
    float zoom_y;
    float angle;
    int opacity;
    int flash_count_start;
    unsigned char flash_red;
    unsigned char flash_green;
    unsigned char flash_blue;
    unsigned char flash_alpha;
    int vmirror;
    int wave_amp;
    int wave_length;
    int wave_speed;
    int wave_phase;
    int bush_depth;
    int bush_opacity;
};

struct FR_Plane {
    void (*internal_draw)(VALUE,int,int);
    int y;
    int z;
    VALUE vdispose;
    VALUE vvisible;
    VALUE vbitmap;
    VALUE vviewport;
    VALUE vcolor;
    VALUE vtone;
    int blend_type;
    int ox;
    int oy;
    float zoom_x;
    float zoom_y;
    int opacity;
};

struct FR_Window {
    void (*internal_draw)(VALUE,int,int);
    int y;
    int z;
    VALUE vwindowskin;
    VALUE vcontents;
    VALUE vviewport;
    VALUE vcursor_rect;
    int x;
    VALUE vactive;
    VALUE vdispose;
    VALUE vvisible;
    VALUE vpause;
    int width;
    int height;
    int ox;
    int oy;
    int back_opacity;
    int contents_opacity;
    int opacity;
    int openness;
    int pause_count;
    int active_count;
    int active_flag;
};

struct FR_Bitmap {
    LPDIRECT3DTEXTURE9 pD3DTexture;     /* eNX`   */
    VALUE vdispose;
    int width;
    int height;
    int real_width;
    int real_height;
    VALUE vfont;
};

struct FR_Rect {
    int x;
    int y;
    int width;
    int height;
};

struct Color {
    unsigned char blue;
    unsigned char green;
    unsigned char red;
    unsigned char alpha;
};

struct FR_Color {
    float blue;
    float green;
    float red;
    float alpha;
    union{
        unsigned int c;
        struct Color color;
    };
};


struct FR_Tone {
    float red;
    float green;
    float blue;
    float gray;
};

struct FR_Font {
    VALUE vname;
    VALUE vsize;
    VALUE vbold;
    VALUE vitalic;
    VALUE vshadow;
    VALUE vcolor;
};
struct FR_Font g_default_font;

struct FR_Table {
    short *memory;
    int xsize;
    int ysize;
    int zsize;
    int count;
};


/* Pad */
static struct DXRubyPadInfo {
    int right;
    int left;
    int up;
    int down;
    LPDIRECTINPUTDEVICE8  pDIDJoyPad; /* DirectInput̃pbhfoCX */
} g_PadInfo[PADMAX];

/* Pad */
static struct DXRubyPadState {
    char button[20];
    int PadConfig[20];
    int count[20];
    int wait[20];
    int interval[20];
} g_PadState[PADMAX];

/* vg^Cv錾 */
static void InitWindow( void );
static void InitDXGraphics( void );
static void InitDirectInput( void );
LRESULT CALLBACK MainWndProc( HWND hWnd,UINT msg,UINT wParam,LONG lParam );
static void InitSync( void );
static __int64 GetSystemCounter( void );
static void Window_DirectXRelease( void );
static void Input_SetConfig( int number, int fr, int pad, int key );
static void ChangeSize( void );
static void inputupdate( void);
static VALUE Input_update( VALUE );
static VALUE Window_sync( VALUE );
static void Window_create( void );

static void release_Font( struct FR_Font* font );
static void release_Viewport( struct FR_Viewport* vp );
static void Viewport_internal_draw( VALUE self, int ox, int oy );
static void Sprite_internal_draw( VALUE self, int ox, int oy );
static void Plane_internal_draw( VALUE self, int ox, int oy );
static void Window_internal_draw( VALUE self, int ox, int oy );
void SortSuperSpriteList( VALUE* vpsprites, int spritecount );
static VALUE Font_exist( VALUE klass, VALUE vstr );
static VALUE Bitmap_allocate( VALUE klass );
static VALUE Bitmap_initialize( int argc, VALUE *argv, VALUE self );

/*********************************************************************
 * WindowW[
 * EBhE̊ǗE`sB
 *********************************************************************/

/*--------------------------------------------------------------------
   EBhE̐Ə
 ---------------------------------------------------------------------*/
static void Window_create( void )
{
    HRESULT hr;
    RECT rect;

    /* EBhE\ */
    ShowWindow( g_hWnd, SW_HIDE );

    /* EBhẼTCYݒ */
    rect.top     = 0;
    rect.left    = 0;
    rect.right   = g_WindowInfo.width * g_WindowInfo.scale;
    rect.bottom  = g_WindowInfo.height * g_WindowInfo.scale;

    /* EBhẼTCYC */
    if( g_WindowInfo.windowed == Qnil || g_WindowInfo.windowed == Qfalse )
    {   /* tXN[ */
        SetWindowLong( g_hWnd, GWL_STYLE, WS_POPUP );
        SetWindowPos( g_hWnd, HWND_TOP, 0, 0, g_WindowInfo.width, g_WindowInfo.height, SWP_NOZORDER);
    }
    else
    {   /* EBhE[h */
        SetWindowLong( g_hWnd, GWL_STYLE, WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX);
        AdjustWindowRect( &rect, WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX, FALSE );

        /* ƍvZ */
        rect.right   = rect.right - rect.left;
        rect.bottom  = rect.bottom - rect.top;

        /* EBhEړ/TCYݒ */
        if( g_WindowInfo.x == CW_USEDEFAULT )
        {   /* ʒuftHg̏ꍇ */
            SetWindowPos( g_hWnd, HWND_TOP, 0, 0, rect.right, rect.bottom, SWP_NOZORDER | SWP_NOMOVE);
        }
        else
        {   /* ʒuw̏ꍇ */
            SetWindowPos( g_hWnd, HWND_TOP, g_WindowInfo.x, g_WindowInfo.y, rect.right, rect.bottom, SWP_NOZORDER );
        }
    }

    /* DirectX̃XN[TCYύX */
    ChangeSize();

    /* EBhE\ */
    ShowWindow( g_hWnd, SW_SHOWNORMAL );
    UpdateWindow( g_hWnd );

    /* V[̃NA */
    g_pD3DDevice->lpVtbl->Clear( g_pD3DDevice, 0, NULL, D3DCLEAR_TARGET,
                                 D3DCOLOR_XRGB( g_WindowInfo.r, g_WindowInfo.g, g_WindowInfo.b ), 0, 0 );
    g_pD3DDevice->lpVtbl->Present( g_pD3DDevice, NULL, NULL, NULL, NULL );

    /* t[ */
    InitSync();
}


/*--------------------------------------------------------------------
  i֐jXN[TCYύX
 ---------------------------------------------------------------------*/
static void ChangeSize( void )
{
    D3DVIEWPORT9 vp;
    HRESULT hr;


    g_D3DPP.BackBufferWidth    = g_WindowInfo.width;
    g_D3DPP.BackBufferHeight   = g_WindowInfo.height;

    if( g_WindowInfo.windowed == Qnil || g_WindowInfo.windowed == Qfalse )
    {
        /* tXN[i32bitColor/60HzŒ) */
        g_D3DPP.BackBufferFormat           = D3DFMT_X8R8G8B8;
        g_D3DPP.Windowed                   = FALSE;
        g_D3DPP.FullScreen_RefreshRateInHz = 60;
        g_D3DPP.PresentationInterval       = D3DPRESENT_INTERVAL_ONE;
        g_WindowInfo.RefreshRate = 60;
    }
    else
    {
        /* EBhE[h */
        g_D3DPP.BackBufferFormat           = D3DFMT_UNKNOWN;
        g_D3DPP.Windowed                   = TRUE;
        g_D3DPP.FullScreen_RefreshRateInHz = 0;
        g_D3DPP.PresentationInterval       = D3DPRESENT_INTERVAL_IMMEDIATE;
        g_WindowInfo.RefreshRate = 0;
    }

    /* XvCgXg */
    if( g_pD3DXSprite )
    {
        g_pD3DXSprite->lpVtbl->OnLostDevice( g_pD3DXSprite );
    }

    /* ݒύX */
    hr = g_pD3DDevice->lpVtbl->Reset( g_pD3DDevice, &g_D3DPP );
    if( FAILED( hr ) )
    {
        rb_raise( eFreeRGSSError, "ݒɎs܂ - Reset" );
    }

    /* XvCgA */
    if( g_pD3DXSprite )
    {
        g_pD3DXSprite->lpVtbl->OnResetDevice( g_pD3DXSprite );
    }

    /* r[|[g̐ݒ */
    vp.X       = 0;
    vp.Y       = 0;
    vp.Width   = g_D3DPP.BackBufferWidth;
    vp.Height  = g_D3DPP.BackBufferHeight;
    vp.MinZ    = 0.0f;
    vp.MaxZ    = 1.0f;

    hr = g_pD3DDevice->lpVtbl->SetViewport( g_pD3DDevice, &vp );

    if( FAILED( hr ) )
    {
        rb_raise( eFreeRGSSError, "ݒɎs܂ - SetViewport" );
    }
}


/*--------------------------------------------------------------------
   i֐jEBhEvV[W
 ---------------------------------------------------------------------*/
LRESULT CALLBACK MainWndProc( HWND hWnd, UINT msg, UINT wParam, LONG lParam )
{
    RECT rect;
    
    switch( msg )
    {
    /* EBhEANeBu^ANeBu */
    case WM_ACTIVATE:
        g_bActive = (LOWORD(wParam) != 0);
        break;
    case WM_CLOSE:
        /* O[v̏ꍇ͖ŃLZ */
        if( g_WindowInfo.loop == 1 )
        {
            g_WindowInfo.requestclose = 1;
            return 0;
        }
        break;
    /* EBhEj */
    case WM_DESTROY:
        /* EChE */
        PostQuitMessage( 0 );
        g_hWnd = NULL;
        return 0;

    case WM_MOUSEWHEEL:
        g_WindowInfo.mousewheelpos += (short)HIWORD(wParam);
        break;
    }

    /* ftHg */
    return DefWindowProc( hWnd, msg, wParam, lParam );
}


/*--------------------------------------------------------------------
  i֐jt[
 ---------------------------------------------------------------------*/
static VALUE Window_sync( VALUE obj )
{
    __int64 NowTime;
    __int64 WaitTime;
    static __int64 BeforeSecond = 0;
    static int fps = 0;
    static int skip = 0;

    NowTime = GetSystemCounter();

    /* EBhE[h */
    if( g_WindowInfo.windowed != Qnil && g_WindowInfo.windowed != Qfalse )
    {
        g_OneFrameCount = NowTime - g_OldTime;
        if ( g_WindowInfo.fps > 0 ) /* fpsw肪nil or 0̎WaitȂ */
        {
            __int64 SleepTime;

            WaitTime = g_OneSecondCount / g_WindowInfo.fps;

            /* ɑO񂩂Pt[̎ԂoĂ */
            if( g_OldTime + WaitTime < NowTime && skip == 0 )
            {
                /* R}䂵Ȃꍇ */
                if( g_WindowInfo.frameskip == Qfalse )
                {
                    fps++;
                    g_OldTime = NowTime;
                }
                else /* ꍇ */
                {
                    /* ̓EFCg`Ȃ */
                    skip++;
                    g_OldTime = g_OldTime + WaitTime;
                }
            }
            else
            {
                /* O`΂̂ɍԂɍĂȂꍇ */
                if( g_OldTime + WaitTime < NowTime && skip == 1 )
                {
                    /* ߂ď */
                    g_OldTime = NowTime;
                }
                else
                {
                    __int64 TempTime;
                    /* ܂ȎԂSleepő҂ */
                    TempTime = GetSystemCounter();
                    SleepTime = (WaitTime - (TempTime - g_OldTime)) * 1000 / g_OneSecondCount;
                    if( SleepTime > 2 )
                    {
                        Sleep( (unsigned long)(SleepTime - 2) );
                    }

                    TempTime = GetSystemCounter();

                    /* [vŌɏ */
                    for ( ; ; )
                    {
                        TempTime = GetSystemCounter();
                        if( g_OldTime +  WaitTime < TempTime )
                        {
                            break;
                        }
                    }
                    g_OldTime = g_OldTime +  WaitTime;
                }
                skip = 0;
                fps++;
            }
        }
        else
        {
            g_OldTime = NowTime;
            fps++;
        }

        /* FPSlݒ */
        if( (NowTime - BeforeSecond) >= g_OneSecondCount )
        {
            BeforeSecond = NowTime;
            g_WindowInfo.fpscheck = fps;
            fps = 0;
        }
    }
    else
    {
        g_OneFrameCount = NowTime - g_OldTime + g_DrawTime;
        WaitTime = g_OneSecondCount / g_WindowInfo.RefreshRate;

        /* ɑO񂩂Pt[̎ԂoĂ */
        if( g_OldTime +  WaitTime - g_DrawTime < NowTime && skip == 0 )
        {
            /* ̓EFCg`Ȃ */
            skip++;
//            g_OldTime = NowTime;
            return obj;
        }

        skip = 0;

//        g_OldTime = g_OldTime +  WaitTime;
        fps++;

        /* FPSlݒ */
        if( (NowTime - BeforeSecond) >= g_OneSecondCount )
        {
            BeforeSecond = NowTime;
            g_WindowInfo.fpscheck = fps;
            fps = 0;
        }
    }

    return obj;
}
/*--------------------------------------------------------------------
  i֐jt[pJE^l擾
 ---------------------------------------------------------------------*/
static __int64 GetSystemCounter( void )
{
    __int64 time;

    if( g_isPerformanceCounter == 1 )
    {
        QueryPerformanceCounter( (LARGE_INTEGER *)&time );
        return time;
    }
    else
    {
        return timeGetTime();
    }
}


/*--------------------------------------------------------------------
   EBhẼ[hiEBhE/Sʁjݒ肷B
 ---------------------------------------------------------------------*/
static VALUE Window_setwindowed( VALUE obj, VALUE windowed )
{
    g_WindowInfo.windowed = windowed;

    if( g_WindowInfo.created == Qtrue )
    {
        g_WindowInfo.created = Qfalse;
        Window_create();
    }

    return g_WindowInfo.windowed;
}


/*--------------------------------------------------------------------
   EBhẼ[hiEBhE/Sʁj擾B
 ---------------------------------------------------------------------*/
static VALUE Window_getwindowed( VALUE obj )
{
    return g_WindowInfo.windowed;
}


/*--------------------------------------------------------------------
   EBhËʒuixWjݒ肷B
 ---------------------------------------------------------------------*/
static VALUE Window_setx( VALUE obj, VALUE x )
{
    if( g_WindowInfo.created == Qtrue )
    {
        rb_raise( eFreeRGSSError, "EBhE쐬ɐݒύX邱Ƃ͂ł܂ - Window_setx" );
    }

    g_WindowInfo.x = NUM2INT( x );
    return x;
}


/*--------------------------------------------------------------------
   EBhËʒuiyWjݒ肷B
 ---------------------------------------------------------------------*/
static VALUE Window_sety( VALUE obj , VALUE y )
{
    if( g_WindowInfo.created == Qtrue )
    {
        rb_raise( eFreeRGSSError, "EBhE쐬ɐݒύX邱Ƃ͂ł܂ - Window_sety" );
    }

    g_WindowInfo.y = NUM2INT( y );
    return y;
}


/*--------------------------------------------------------------------
   EBhẼTCYijݒ肷B
 ---------------------------------------------------------------------*/
static VALUE Window_setwidth( VALUE obj, VALUE vwidth )
{
    int width;

    if( g_WindowInfo.created == Qtrue )
    {
        rb_raise( eFreeRGSSError, "EBhE쐬ɐݒύX邱Ƃ͂ł܂ - Window_setwidth" );
    }

    width = NUM2INT( vwidth );
    if( width < 0 )
    {
        width = 0;
    }

    g_WindowInfo.width = width;
    return vwidth;
}


/*--------------------------------------------------------------------
   EBhẼTCYijݒ肷B
 ---------------------------------------------------------------------*/
static VALUE Window_setheight( VALUE obj , VALUE vheight)
{
    int height;

    if( g_WindowInfo.created == Qtrue )
    {
        rb_raise( eFreeRGSSError, "EBhE쐬ɐݒύX邱Ƃ͂ł܂ - Window_setheight" );
    }

    height = NUM2INT( vheight );
    if( height < 0 )
    {
        height = 0;
    }

    g_WindowInfo.height = height;
    return vheight;
}


/*--------------------------------------------------------------------
   EBhËʒuixWjԂB
 ---------------------------------------------------------------------*/
static VALUE Window_x( VALUE obj )
{
    return INT2FIX( g_WindowInfo.x );
}


/*--------------------------------------------------------------------
   EBhËʒuiyWjԂB
 ---------------------------------------------------------------------*/
static VALUE Window_y( VALUE obj )
{
    return INT2FIX( g_WindowInfo.y );
}


/*--------------------------------------------------------------------
   EBhẼTCYijԂB
 ---------------------------------------------------------------------*/
static VALUE Window_width( VALUE obj )
{
    return INT2FIX( g_WindowInfo.width );
}


/*--------------------------------------------------------------------
   EBhẼTCYijԂB
 ---------------------------------------------------------------------*/
static VALUE Window_height( VALUE obj )
{
    return INT2FIX( g_WindowInfo.height );
}


/*--------------------------------------------------------------------
  EBhE^Cg擾
 ---------------------------------------------------------------------*/
static VALUE Window_getCaption( VALUE obj )
{
    char buf[256];

    GetWindowText( g_hWnd, buf, 256 );

    return rb_str_new2( buf );
}


/*--------------------------------------------------------------------
  EBhE^Cgݒ
 ---------------------------------------------------------------------*/
static VALUE Window_setCaption( VALUE obj, VALUE caption )
{
    Check_Type(caption, T_STRING);

    SetWindowText( g_hWnd, RSTRING_PTR( caption ) );

    return caption;
}


/*--------------------------------------------------------------------
  EBhẼTCY{擾
 ---------------------------------------------------------------------*/
static VALUE Window_getScale( VALUE obj )
{
    return rb_float_new( g_WindowInfo.scale );
}


/*--------------------------------------------------------------------
  EBhẼTCY{ݒ肷
 ---------------------------------------------------------------------*/
static VALUE Window_setScale( VALUE obj, VALUE scale )
{
    g_WindowInfo.scale = NUM2DBL(scale);

    return scale;
}


/*--------------------------------------------------------------------
  fpslݒ肷
 ---------------------------------------------------------------------*/
static VALUE Window_getrealfps( VALUE obj )
{
    return INT2FIX( g_WindowInfo.fpscheck );
}


/*--------------------------------------------------------------------
  fpsl擾
 ---------------------------------------------------------------------*/
static VALUE Window_getfps( VALUE obj )
{
    return INT2FIX( g_WindowInfo.fpscheck );
}


/*--------------------------------------------------------------------
  fpslݒ肷
 ---------------------------------------------------------------------*/
static VALUE Window_setfps( VALUE obj, VALUE fps )
{
    g_WindowInfo.fps = fps == Qnil ? 0 : NUM2INT(fps);

    return fps;
}


/*--------------------------------------------------------------------
   ktB^擾
 ---------------------------------------------------------------------*/
static VALUE Window_getMinFilter( VALUE obj )
{
    return INT2FIX( g_WindowInfo.minfilter );
}


/*--------------------------------------------------------------------
   ktB^ݒ
 ---------------------------------------------------------------------*/
static VALUE Window_setMinFilter( VALUE obj, VALUE minfilter )
{
    g_WindowInfo.minfilter = NUM2INT( minfilter );
    return minfilter;
}


/*--------------------------------------------------------------------
   gtB^擾
 ---------------------------------------------------------------------*/
static VALUE Window_getMagFilter( VALUE obj )
{
    return INT2FIX( g_WindowInfo.minfilter );
}


/*--------------------------------------------------------------------
   gtB^ݒ
 ---------------------------------------------------------------------*/
static VALUE Window_setMagFilter( VALUE obj, VALUE magfilter )
{
    g_WindowInfo.magfilter = NUM2INT( magfilter );
    return magfilter;
}


/*--------------------------------------------------------------------
  1t[ׂ̏Ŏ擾
 ---------------------------------------------------------------------*/
static VALUE Window_getload( VALUE obj )
{
    if( g_WindowInfo.fps == 0 )
    {
        return INT2FIX( 0 );
    }
    return rb_float_new( (double) ( (double)g_OneFrameCount * 100.0 / ((double)g_OneSecondCount / (double)g_WindowInfo.fps )) );
}


/*--------------------------------------------------------------------
  EBhEnh擾
 ---------------------------------------------------------------------*/
static VALUE Window_gethWnd( VALUE obj )
{
    return INT2NUM( (int)g_hWnd );
}


/*--------------------------------------------------------------------
  t[XLbvon/off擾
 ---------------------------------------------------------------------*/
static VALUE Window_getframeskip( VALUE obj )
{
    return g_WindowInfo.frameskip;
}


/*--------------------------------------------------------------------
  t[XLbvon/offݒ肷
 ---------------------------------------------------------------------*/
static VALUE Window_setframeskip( VALUE obj, VALUE skip )
{
    g_WindowInfo.frameskip = (skip == Qnil || skip == Qfalse) ? Qfalse : Qtrue;

    return skip;
}


/*--------------------------------------------------------------------
  EBhEACRݒ肷
 ---------------------------------------------------------------------*/
static VALUE Window_loadIcon( VALUE obj, VALUE filename )
{
    Check_Type( filename, T_STRING );
    g_WindowInfo.hIcon = LoadImage( 0, RSTRING_PTR(filename), IMAGE_ICON, 16, 16, LR_DEFAULTSIZE|LR_LOADFROMFILE );
    if( g_WindowInfo.hIcon == NULL )
    {
        rb_raise( eFreeRGSSError, "ACR摜t@C̃[hɎs܂ - Window_loadIcon" );
    }

    SendMessage(g_hWnd, WM_SETICON, (WPARAM)ICON_SMALL, (LPARAM)g_WindowInfo.hIcon);

    return Qnil;
}


/*--------------------------------------------------------------------
  t@CI[v_CAO\
 ---------------------------------------------------------------------*/
static VALUE Window_openDialog(VALUE obj, VALUE vfilter, VALUE vtitle)
{
    OPENFILENAME OFN; 
    char buf[MAX_PATH*2];
	VALUE filter;
	buf[0] = 0;

	Check_Type(vfilter, T_ARRAY);
	Check_Type(vtitle, T_STRING);

	ZeroMemory(&OFN,sizeof(OPENFILENAME));
    OFN.lStructSize = sizeof(OPENFILENAME); 
    OFN.hwndOwner = g_hWnd;

	OFN.lpstrFilter = "ׂẴt@C (*.*)\0*.*\0\0";
	filter = rb_ary_join( vfilter, rb_str_new( "\0", 1 ) );
	filter = rb_str_cat( filter, "\0", 1 );
	OFN.lpstrFilter = RSTRING_PTR(filter);
    OFN.lpstrFile = buf;
    OFN.nMaxFile = MAX_PATH*2;
    OFN.Flags = OFN_FILEMUSTEXIST;
	OFN.lpstrTitle = RSTRING_PTR(vtitle);
	OFN.lpstrDefExt = 0;
	if( !GetOpenFileName(&OFN) )
	{
        return Qnil;
	}

	return rb_str_new2( buf );
}


/*--------------------------------------------------------------------
  t@CZ[u_CAO\
 ---------------------------------------------------------------------*/
static VALUE Window_saveDialog(VALUE obj, VALUE vfilter, VALUE vtitle)
{
    OPENFILENAME OFN; 
    char buf[MAX_PATH*2];
	VALUE filter;
	buf[0] = 0;

	Check_Type(vfilter, T_ARRAY);
	Check_Type(vtitle, T_STRING);

	ZeroMemory(&OFN,sizeof(OPENFILENAME));
    OFN.lStructSize = sizeof(OPENFILENAME); 
    OFN.hwndOwner = g_hWnd;

	OFN.lpstrFilter = "ׂẴt@C (*.*)\0*.*\0\0";
	filter = rb_ary_join( vfilter, rb_str_new( "\0", 1 ) );
	filter = rb_str_cat( filter, "\0", 1 );
	OFN.lpstrFilter = RSTRING_PTR(filter);
    OFN.lpstrFile = buf;
    OFN.nMaxFile = MAX_PATH*2;
    OFN.Flags = OFN_CREATEPROMPT | OFN_OVERWRITEPROMPT;
	OFN.lpstrTitle = RSTRING_PTR(vtitle);
	OFN.lpstrDefExt = 0;
	if( !GetSaveFileName(&OFN) )
	{
        return Qnil;
	}

	return rb_locale_str_new( buf, strlen( buf ) );
}


/*--------------------------------------------------------------------
   IɎs
 ---------------------------------------------------------------------*/
static VALUE Window_shutdown( VALUE obj )
{
    /* ACR\[X */
    if( g_WindowInfo.hIcon != 0 )
    {
        DestroyIcon(g_WindowInfo.hIcon);
    }

    /* }EXԕ */
    if( g_WindowInfo.enablemouse == Qfalse )
    {
        int c;
        c = ShowCursor( TRUE );
        while( c < 0 ) c = ShowCursor( TRUE );
    }

    /* DirectX */
    Window_DirectXRelease();

    /* EChEENX̓o^ */
    UnregisterClass( "DXRuby", g_hInstance );

    /* t[̌n */
    timeEndPeriod( 1 );

	g_iRefAll--;
	if( g_iRefAll == 0 )
	{
		CoUninitialize();
	}

    return obj;
}


/*--------------------------------------------------------------------
   DirectXIuWFNg
 ---------------------------------------------------------------------*/
void Window_DirectXRelease()
{
    int i;
    HRESULT hr;

    /* XvCgIuWFNg̎gpI */
    if( g_pD3DXSprite )
    {
        g_pD3DXSprite->lpVtbl->OnLostDevice( g_pD3DXSprite );
    }

    /* XvCgIuWFNgj */
    RELEASE( g_pD3DXSprite );

    for( i = 0 ; i < g_JoystickCount; i++ )
    {
        /* DirectInputDevice(JoyPad)IuWFNg̎gpI */
        if( g_pDIDJoyPad[i] )
        {
            g_pDIDJoyPad[i]->lpVtbl->Unacquire( g_pDIDJoyPad[i] ); 
        }

        /* DirectInputDevide(JoyPad)IuWFNg̔j */
        RELEASE( g_pDIDJoyPad[i] );
    }

    /* DirectInputDevice(Keyboard)IuWFNg̎gpI */
    if( g_pDIDKeyBoard )
    {
           g_pDIDKeyBoard->lpVtbl->Unacquire( g_pDIDKeyBoard ); 
    }

    /* DirectInputDevide(Keyboard)IuWFNg̔j */
    RELEASE( g_pDIDKeyBoard );

    /* DirectInputIuWFNg̔j */
    RELEASE( g_pDInput );

    /* Direct3D DeviceIuWFNg̔j */
    RELEASE( g_pD3DDevice );

	/* Direct3DIuWFNg̔j */
    RELEASE( g_pD3D );
}


/*********************************************************************
 * GraphicsW[
 *
 * ʂ𐧌䂷郂W[
 *********************************************************************/
/*--------------------------------------------------------------------
   WindowsbZ[W
 ---------------------------------------------------------------------*/
static VALUE Graphics_message( void )
{
    MSG msg;
    msg.message = WM_NULL;
    g_WindowInfo.loop = 1;

    /* bZ[W[v */
    /* bZ[WȂȂ܂ŏ */
    /* bZ[W̓ubNyield */
    while (1)
    {
        if( PeekMessage( &msg, 0, 0, 0, PM_REMOVE ) != 0)
        {
            /* bZ[W鎞 */
            TranslateMessage( &msg );
            DispatchMessage( &msg );
        }
        else
        {
            break;
        }
    }

    if( g_WindowInfo.requestclose == 1 )
    {
        g_WindowInfo.requestclose = 0;
        return Qtrue;
    }

    return Qfalse;
}

static VALUE Graphics_update( VALUE klass )
{
    HRESULT hr;
    static int max;
    __int64 drawStartCounter;

    /* fps */
    Window_sync( klass );

    if( Graphics_message() == Qtrue )
    {
        rb_eval_string("exit");
    }

    g_graphics.frame_count++;

    while( 1 )
    {
        hr = g_pD3DDevice->lpVtbl->TestCooperativeLevel( g_pD3DDevice );
        if( FAILED( hr ) )
        {
            if( hr == D3DERR_DEVICELOST )  /* foCX̓XgԂł */
            {
                Sleep( 100 );
                continue;
            }
            else if( hr == D3DERR_DEVICENOTRESET ) /* foCX̓XgԂł邪Zbg\ł */
            {
                /* ֗̓foCXZbg\Ԃł */
                /* XvCgXg */
                if( g_pD3DXSprite )
                {
                    g_pD3DXSprite->lpVtbl->OnLostDevice( g_pD3DXSprite );
                }

                hr = g_pD3DDevice->lpVtbl->Reset( g_pD3DDevice, &g_D3DPP ); /* ݂ */
                if( FAILED( hr ) )
                {
                    if( hr == D3DERR_DEVICELOST )
                    {
                        return klass; /* ܂Xg */
                    }
                    rb_raise( eFreeRGSSError, "DirectX APǏĂяoɎs܂ - Reset" );
                }

                if( g_pD3DXSprite ) /* XvCgA */
                {
                    g_pD3DXSprite->lpVtbl->OnResetDevice( g_pD3DXSprite );
                }
                break;
            }
            else /* DirectX̓G[ */
            {
                rb_raise( eFreeRGSSError, "DirectX API̓G[܂ - TestCooperativeLevel" );
            }
        }
        else
        {
            break;
        }
    }

    drawStartCounter = GetSystemCounter();

    /* V[̃NA */
    g_pD3DDevice->lpVtbl->Clear( g_pD3DDevice, 0, NULL, D3DCLEAR_TARGET,
                                 D3DCOLOR_XRGB( g_WindowInfo.r, g_WindowInfo.g, g_WindowInfo.b ), 0, 0 );

    /* V[̕`Jn */
    if( SUCCEEDED( g_pD3DDevice->lpVtbl->BeginScene( g_pD3DDevice ) ) )
    {
        int i, j;
        int oldflag = 0;
        VALUE *vpsprites;
        int spritecount;

        /* XvCg̕`Jn */
        g_pD3DXSprite->lpVtbl->Begin( g_pD3DXSprite, D3DXSPRITE_ALPHABLEND );

        /* gktB^ݒ */
        g_pD3DDevice->lpVtbl->SetSamplerState(g_pD3DDevice, 0, D3DSAMP_MINFILTER,
                                         D3DTEXF_POINT );
        g_pD3DDevice->lpVtbl->SetSamplerState(g_pD3DDevice, 0, D3DSAMP_MAGFILTER,
                                         D3DTEXF_POINT );
        /* foCXɎgp钸_tH[}bgZbg */
        g_pD3DDevice->lpVtbl->SetFVF(g_pD3DDevice, D3DFVF_XYZ | D3DFVF_DIFFUSE | D3DFVF_TEX1);

        vpsprites = RARRAY_PTR( g_graphics.vsprites );
        spritecount = RARRAY_LEN( g_graphics.vsprites );

        /* XvCgz\[g */
        SortSuperSpriteList( vpsprites, spritecount );

        for( i = 0; i < spritecount; i++ )
        {
            FR_GET_STRUCT( SuperSprite, vpsprites[i] )->internal_draw( vpsprites[i], 0, 0 );
        }

        /* brightness */
        g_pD3DDevice->lpVtbl->SetRenderState(g_pD3DDevice, D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);
        g_pD3DDevice->lpVtbl->SetRenderState(g_pD3DDevice, D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA);

        {
            TLVERTX VertexDataTbl[6];

            /* _P */
            VertexDataTbl[0].x =  0;
            VertexDataTbl[0].y =  0;
            /* _Q */
            VertexDataTbl[1].x = VertexDataTbl[3].x =  g_WindowInfo.width;
            VertexDataTbl[1].y = VertexDataTbl[3].y =  0;
            /* _R */
            VertexDataTbl[4].x = g_WindowInfo.width;
            VertexDataTbl[4].y = g_WindowInfo.height;
            /* _S */
            VertexDataTbl[2].x = VertexDataTbl[5].x = 0;
            VertexDataTbl[2].y = VertexDataTbl[5].y = g_WindowInfo.height;
            /* yW */
            VertexDataTbl[0].z      =  
            VertexDataTbl[1].z      =  
            VertexDataTbl[2].z      =  
            VertexDataTbl[3].z      =  
            VertexDataTbl[4].z      =  
            VertexDataTbl[5].z      =  0.0f;
            /* eNX`W */
            VertexDataTbl[0].tu     =  VertexDataTbl[5].tu = VertexDataTbl[2].tu = 0;
            VertexDataTbl[0].tv     =  VertexDataTbl[1].tv = VertexDataTbl[3].tv = 0;
            VertexDataTbl[1].tu     =  VertexDataTbl[3].tu = VertexDataTbl[4].tu = 0;
            VertexDataTbl[4].tv     =  VertexDataTbl[5].tv = VertexDataTbl[2].tv = 0;

            /* _F */
            VertexDataTbl[0].color  =  
            VertexDataTbl[1].color  =  
            VertexDataTbl[2].color  =  
            VertexDataTbl[3].color  =  
            VertexDataTbl[4].color  =  
            VertexDataTbl[5].color  =  D3DCOLOR_ARGB(255-g_graphics.brightness, 0,0,0);
            /* ` */
            g_pD3DDevice->lpVtbl->SetTexture(g_pD3DDevice, 0, NULL);
            g_pD3DDevice->lpVtbl->DrawPrimitiveUP( g_pD3DDevice, D3DPT_TRIANGLELIST, 2, VertexDataTbl, sizeof(TLVERTX) );
        }

        /* XvCg̕`I */
        g_pD3DXSprite->lpVtbl->End( g_pD3DXSprite );
        /* V[̕`I */
        g_pD3DDevice->lpVtbl->EndScene( g_pD3DDevice );
    }

    if( g_WindowInfo.windowed == Qnil || g_WindowInfo.windowed == Qfalse )
    {
        g_DrawTime = GetSystemCounter() - drawStartCounter;
    }

    /* V[̕\ */
    hr = g_pD3DDevice->lpVtbl->Present( g_pD3DDevice, NULL, NULL, NULL, NULL );

    if( g_WindowInfo.windowed == Qnil || g_WindowInfo.windowed == Qfalse )
    {
        g_OldTime = GetSystemCounter();
    }

    return klass;
}

static VALUE Graphics_wait( VALUE klass, VALUE vduration )
{
    int i;
    for( i = 0; i < NUM2INT( vduration ); i++ )
    {
        Graphics_update( klass );
    }
    return vduration;
}

static VALUE Graphics_fadeout( VALUE klass, VALUE vduration )
{
    int i;
    for( i = 0; i < NUM2INT( vduration ); i++ )
    {
        g_graphics.brightness = 255.0f - 255.0f * i / NUM2INT( vduration );
        Graphics_update( klass );
    }
    return vduration;
}

static VALUE Graphics_fadein( VALUE klass, VALUE vduration )
{
    int i;
    for( i = 0; i < NUM2INT( vduration ); i++ )
    {
        g_graphics.brightness = 255.0f * i / NUM2INT( vduration );
        Graphics_update( klass );
    }
    return vduration;
}

static VALUE Graphics_resize_screen( VALUE klass, VALUE vwidth, VALUE vheight )
{
    g_WindowInfo.width = NUM2INT( vwidth );
    g_WindowInfo.height = NUM2INT( vheight );
    Window_create();
    return Qnil;
}

/*--------------------------------------------------------------------
   XN[VbgBitmapIuWFNgɍ
 ---------------------------------------------------------------------*/
static VALUE Graphics_snap_to_bitmap( VALUE klass )
{
    HRESULT hr;
    D3DDISPLAYMODE dmode;
    LPDIRECT3DSURFACE9 pBackSurface;
    LPDIRECT3DSURFACE9 pOffSurface;
    VALUE vbitmap;
    struct FR_Bitmap *bitmap;
    VALUE varg[2];
    D3DLOCKED_RECT srctrect;
    D3DLOCKED_RECT dsttrect;
    int i, j;
    RECT srcrect, dstrect;

    /* ݂̃fBXvC̃tH[}bgȂǂ擾 */
    hr = g_pD3D->lpVtbl->GetAdapterDisplayMode(g_pD3D, D3DADAPTER_DEFAULT, &dmode);
    if( FAILED( hr ) )
    {
        rb_raise( eFreeRGSSError, "XibvɎs܂ - GetAdapterDisplayMode" );
    }

    vbitmap = Bitmap_allocate( cBitmap );
    varg[0] = INT2FIX( g_WindowInfo.width );
    varg[1] = INT2FIX( g_WindowInfo.height );
    vbitmap = Bitmap_initialize( 2, varg, vbitmap );
    bitmap = FR_GET_STRUCT( Bitmap, vbitmap );

    /* XibvpT[tFCX쐬 */
    hr = g_pD3DDevice->lpVtbl->CreateOffscreenPlainSurface(g_pD3DDevice,
            g_WindowInfo.width,
            g_WindowInfo.height,
            D3DFMT_X8R8G8B8,
            D3DPOOL_SYSTEMMEM, &pOffSurface, NULL);
    if( FAILED( hr ) )
    {
        rb_raise( eFreeRGSSError, "XibvɎs܂ - CreateOffscreenPlainSurface" );
    }

    /* Xibv */
//    hr = g_pD3DDevice->lpVtbl->GetFrontBufferData(g_pD3DDevice, 0, pSurface);
    hr = g_pD3DDevice->lpVtbl->GetBackBuffer(g_pD3DDevice, 0, 0, D3DBACKBUFFER_TYPE_MONO, &pBackSurface);
    if( FAILED( hr ) )
    {
        RELEASE(pBackSurface);
        RELEASE(pOffSurface);
        rb_raise( eFreeRGSSError, "XibvɎs܂ - GetBackBuffer" );
    }

    hr = g_pD3DDevice->lpVtbl->GetRenderTargetData( g_pD3DDevice, pBackSurface, pOffSurface );
    if( FAILED( hr ) )
    {
        RELEASE(pBackSurface);
        RELEASE(pOffSurface);
        rb_raise( eFreeRGSSError, "XibvɎs܂ - GetRenderTargetData" );
    }

    /* C[WRs[ */
    dstrect.left = 0;
    dstrect.top = 0;
    dstrect.right = g_WindowInfo.width;
    dstrect.bottom = g_WindowInfo.height;

    hr = bitmap->pD3DTexture->lpVtbl->LockRect( bitmap->pD3DTexture, 0, &dsttrect, &dstrect, 0 );
    hr = pOffSurface->lpVtbl->LockRect( pOffSurface, &srctrect, &dstrect, D3DLOCK_READONLY );

    for( i = 0; i < g_WindowInfo.height; i++)
    {
        int *psrc = (int*)((char *)srctrect.pBits + i * srctrect.Pitch);
        int *pdst = (int*)((char *)dsttrect.pBits + i * dsttrect.Pitch);
        for( j = 0; j < g_WindowInfo.width; j++)
        {
                *(pdst++) = *(psrc++) | 0xff000000;
        }
    }

    bitmap->pD3DTexture->lpVtbl->UnlockRect( bitmap->pD3DTexture, 0 );
    pOffSurface->lpVtbl->UnlockRect( pOffSurface );

    RELEASE(pBackSurface);
    RELEASE(pOffSurface);

    return vbitmap;
}

static VALUE Graphics_frame_reset( VALUE klass )
{
    return klass;
}

static VALUE Graphics_get_width( VALUE klass )
{
    return INT2FIX( g_WindowInfo.width );
}

static VALUE Graphics_get_height( VALUE klass )
{
    return INT2FIX( g_WindowInfo.height );
}

static VALUE Graphics_set_frame_rate( VALUE klass, VALUE vfps )
{
    g_WindowInfo.fps = NUM2INT( vfps );
    return klass;
}

static VALUE Graphics_get_frame_rate( VALUE klass )
{
    return INT2FIX( g_WindowInfo.fps );
}

static VALUE Graphics_set_frame_count( VALUE klass, VALUE vframecount )
{
    g_graphics.frame_count = NUM2INT( vframecount );
    return klass;
}

static VALUE Graphics_get_frame_count( VALUE klass )
{
    return INT2FIX( g_graphics.frame_count );
}

static VALUE Graphics_set_brightness( VALUE klass, VALUE vbrightness )
{
    g_graphics.brightness = NUM2INT( vbrightness );
    return klass;
}

static VALUE Graphics_get_brightness( VALUE klass )
{
    return INT2FIX( g_graphics.brightness );
}



/*********************************************************************
 * RectNX
 *
 * ͈͏ێNXB
 *********************************************************************/

/*--------------------------------------------------------------------
   QƂȂȂƂGCĂ΂֐
 ---------------------------------------------------------------------*/
static void release_Rect( struct FR_Rect* rect )
{
    free( rect );
}

/*--------------------------------------------------------------------
   RectNXallocateBmۂׂinitializeOɌĂ΂B
 ---------------------------------------------------------------------*/
static VALUE Rect_allocate( VALUE klass )
{
    VALUE obj;
    struct FR_Rect *rect;

    /* 擾RectIuWFNg */
    rect = malloc(sizeof(struct FR_Rect));
    if( rect == NULL ) rb_raise( eFreeRGSSError, "̎擾Ɏs܂ - Rect_allocate" );
    obj = Data_Wrap_Struct(klass, 0, release_Rect, rect);

    rect->x = 0;
    rect->y = 0;
    rect->width = 0;
    rect->height = 0;

    return obj;
}

/*--------------------------------------------------------------------
   RectNXInitialize
 ---------------------------------------------------------------------*/
static VALUE Rect_initialize( VALUE self, VALUE vx, VALUE vy, VALUE vwidth, VALUE vheight )
{
    struct FR_Rect *rect = FR_GET_STRUCT( Rect, self );

    rect->x = NUM2INT( vx );
    rect->y = NUM2INT( vy );
    rect->width = NUM2INT( vwidth );
    rect->height = NUM2INT( vheight );

    return self;
}

static void Rect_copy( VALUE d, VALUE s)
{
    struct FR_Rect *rectd = FR_GET_STRUCT( Rect, d );
    struct FR_Rect *rects = FR_GET_STRUCT( Rect, s );

    rectd->x = rects->x;
    rectd->y = rects->y;
    rectd->width = rects->width;
    rectd->height = rects->height;
}

static VALUE Rect_dup( VALUE self )
{
    struct FR_Rect *rect = FR_GET_STRUCT( Rect, self );
    struct FR_Rect *new_rect;
    VALUE obj;

    /* 擾RectIuWFNg */
    new_rect = malloc(sizeof(struct FR_Rect));
    if( new_rect == NULL ) rb_raise( eFreeRGSSError, "̎擾Ɏs܂ - Rect_dup" );
    obj = Data_Wrap_Struct( cRect, 0, release_Rect, new_rect );

    Rect_copy( obj, self );

    return obj;
}

static VALUE Rect_equal( VALUE self, VALUE vrect )
{
    struct FR_Rect *rect1 = FR_GET_STRUCT( Rect, self );
    struct FR_Rect *rect2;
    FR_TYPECHECK( Rect, vrect );
    Data_Get_Struct( vrect, struct FR_Rect, rect2 );

    if( rect1->x == rect2->x && rect1->y == rect2->y &&
        rect1->width == rect2->width && rect1->height == rect2->height )
    {
        return Qtrue;
    }
    else
    {
        return Qfalse;
    }
}

static VALUE Rect_set_x( VALUE self, VALUE vx )
{
    FR_GET_STRUCT( Rect, self )->x = NUM2INT( vx );
    return vx;
}
static VALUE Rect_get_x( VALUE self )
{
    return INT2FIX( FR_GET_STRUCT( Rect, self )->x );
}
static VALUE Rect_set_y( VALUE self, VALUE vy )
{
    FR_GET_STRUCT( Rect, self )->y = NUM2INT( vy );
    return vy;
}
static VALUE Rect_get_y( VALUE self )
{
    return INT2FIX( FR_GET_STRUCT( Rect, self )->y );
}
static VALUE Rect_set_width( VALUE self, VALUE vwidth )
{
    FR_GET_STRUCT( Rect, self )->width = NUM2INT( vwidth );
    return vwidth;
}
static VALUE Rect_get_width( VALUE self )
{
    return INT2FIX( FR_GET_STRUCT( Rect, self )->width );
}
static VALUE Rect_set_height( VALUE self, VALUE vheight )
{
    FR_GET_STRUCT( Rect, self )->height = NUM2INT( vheight );
    return vheight;
}
static VALUE Rect_get_height( VALUE self )
{
    return INT2FIX( FR_GET_STRUCT( Rect, self )->height );
}
static VALUE Rect_to_s( VALUE self )
{
    struct FR_Rect *rect = FR_GET_STRUCT( Rect, self );
    char buf[128];
    sprintf( buf, "(%d, %d, %d, %d)", rect->x, rect->y, rect->width, rect->height );
    return rb_locale_str_new( buf, strlen( buf ) );
}
static VALUE Rect_empty( VALUE self )
{
    struct FR_Rect *rect = FR_GET_STRUCT( Rect, self );
    rect->x = 0;
    rect->y = 0;
    rect->width = 0;
    rect->height = 0;
    return self;
}


/*********************************************************************
 * ColorNX
 *
 * FێNXB
 *********************************************************************/

/*--------------------------------------------------------------------
   QƂȂȂƂGCĂ΂֐
 ---------------------------------------------------------------------*/
static void release_Color( struct FR_Color* color )
{
    free( color );
}

/*--------------------------------------------------------------------
   ColorNXallocateBmۂׂinitializeOɌĂ΂B
 ---------------------------------------------------------------------*/
static VALUE Color_allocate( VALUE klass )
{
    VALUE obj;
    struct FR_Color *color;

    /* 擾ColorIuWFNg */
    color = malloc(sizeof(struct FR_Color));
    if( color == NULL ) rb_raise( eFreeRGSSError, "̎擾Ɏs܂ - Color_allocate" );
    obj = Data_Wrap_Struct(klass, 0, release_Color, color);

    color->red = 0;
    color->green = 0;
    color->blue = 0;
    color->alpha = 0;
    color->c = 0;

    return obj;
}

static void Color_set_int( struct FR_Color *color)
{
    color->color.red = (unsigned char)color->red;
    color->color.green = (unsigned char)color->green;
    color->color.blue = (unsigned char)color->blue;
    color->color.alpha = (unsigned char)color->alpha;
}

/*--------------------------------------------------------------------
   ColorNXInitialize
 ---------------------------------------------------------------------*/
static VALUE Color_initialize( int argc, VALUE *argv, VALUE self )
{
    struct FR_Color *color = FR_GET_STRUCT( Color, self );
    VALUE vred, vgreen, vblue, valpha;

    rb_scan_args( argc, argv, "31", &vred, &vgreen, &vblue, &valpha );

    color->red = FR_0_255( (NUM2DBL( vred ) ) );
    color->green = FR_0_255( NUM2DBL( vgreen ) );
    color->blue = FR_0_255( NUM2DBL( vblue ) );
    color->alpha = valpha == Qnil ? 255 : FR_0_255( NUM2DBL( valpha ) );
    Color_set_int( color );

    return self;
}

static void Color_copy( VALUE d, VALUE s)
{
    struct FR_Color *colord = FR_GET_STRUCT( Color, d );
    struct FR_Color *colors = FR_GET_STRUCT( Color, s );

    colord->red = colors->red;
    colord->green = colors->green;
    colord->blue = colors->blue;
    colord->alpha = colors->alpha;
    colord->c = colors->c;
}

static VALUE Color_dup( VALUE self )
{
    struct FR_Color *color = FR_GET_STRUCT( Color, self );
    struct FR_Color *new_color;
    VALUE obj;

    /* 擾ColorIuWFNg */
    new_color = malloc(sizeof(struct FR_Color));
    if( new_color == NULL ) rb_raise( eFreeRGSSError, "̎擾Ɏs܂ - Color_dup" );
    obj = Data_Wrap_Struct( cColor, 0, release_Color, new_color );

    Color_copy( obj, self );

    return obj;
}

static VALUE Color_equal( VALUE self, VALUE vcolor )
{
    struct FR_Color *color1 = FR_GET_STRUCT( Color, self );
    struct FR_Color *color2;
    FR_TYPECHECK( Color, vcolor );
    Data_Get_Struct( vcolor, struct FR_Color, color2 );

    if( color1->alpha == color2->alpha && color1->red == color2->red &&
        color1->green == color2->green && color1->blue == color2->blue )
    {
        return Qtrue;
    }
    else
    {
        return Qfalse;
    }
}
static VALUE Color_set_red( VALUE self, VALUE vred )
{
    FR_GET_STRUCT( Color, self )->red = FR_0_255( NUM2DBL( vred ) );
    Color_set_int( FR_GET_STRUCT( Color, self ) );
    return vred;
}
static VALUE Color_get_red( VALUE self )
{
    return rb_float_new( FR_GET_STRUCT( Color, self )->red );
}
static VALUE Color_set_green( VALUE self, VALUE vgreen )
{
    FR_GET_STRUCT( Color, self )->green = FR_0_255( NUM2DBL( vgreen ) );
    Color_set_int( FR_GET_STRUCT( Color, self ) );
    return vgreen;
}
static VALUE Color_get_green( VALUE self )
{
    return rb_float_new( FR_GET_STRUCT( Color, self )->green );
}
static VALUE Color_set_blue( VALUE self, VALUE vblue )
{
    FR_GET_STRUCT( Color, self )->blue = FR_0_255( NUM2DBL( vblue ) );
    Color_set_int( FR_GET_STRUCT( Color, self ) );
    return vblue;
}
static VALUE Color_get_blue( VALUE self )
{
    return rb_float_new( FR_GET_STRUCT( Color, self )->blue );
}
static VALUE Color_set_alpha( VALUE self, VALUE valpha )
{
    FR_GET_STRUCT( Color, self )->alpha = FR_0_255( NUM2DBL( valpha ) );
    Color_set_int( FR_GET_STRUCT( Color, self ) );
    return valpha;
}
static VALUE Color_get_alpha( VALUE self )
{
    return rb_float_new( FR_GET_STRUCT( Color, self )->alpha );
}
static VALUE Color_to_s( VALUE self )
{
    struct FR_Color *color = FR_GET_STRUCT( Color, self );
    char buf[128];
    sprintf( buf, "(%f, %f, %f, %f)", color->red, color->green, color->blue, color->alpha );
    return rb_locale_str_new( buf, strlen( buf ) );
}

/*********************************************************************
 * ToneNX
 *
 * FێNXB
 *********************************************************************/

/*--------------------------------------------------------------------
   QƂȂȂƂGCĂ΂֐
 ---------------------------------------------------------------------*/
static void release_Tone( struct FR_Tone* tone )
{
    free( tone );
}

/*--------------------------------------------------------------------
   ToneNXallocateBmۂׂinitializeOɌĂ΂B
 ---------------------------------------------------------------------*/
static VALUE Tone_allocate( VALUE klass )
{
    VALUE obj;
    struct FR_Tone *tone;

    /* 擾ToneIuWFNg */
    tone = malloc(sizeof(struct FR_Tone));
    if( tone == NULL ) rb_raise( eFreeRGSSError, "̎擾Ɏs܂ - Tone_allocate" );
    obj = Data_Wrap_Struct(klass, 0, release_Tone, tone);

    tone->red = 0;
    tone->green = 0;
    tone->blue = 0;
    tone->gray = 0;

    return obj;
}

/*--------------------------------------------------------------------
   ToneNXInitialize
 ---------------------------------------------------------------------*/
static VALUE Tone_initialize( int argc, VALUE *argv, VALUE self )
{
    struct FR_Tone *tone = FR_GET_STRUCT( Tone, self );
    VALUE vred, vgreen, vblue, vgray;

    rb_scan_args( argc, argv, "31", &vred, &vgreen, &vblue, &vgray );

    tone->red = FR_M255_255( NUM2DBL( vred ) );
    tone->green = FR_M255_255( NUM2DBL( vgreen ) );
    tone->blue = FR_M255_255( NUM2DBL( vblue ) );
    tone->gray = vgray == Qnil ? 0 : FR_M255_255( NUM2DBL( vgray ) );

    return self;
}

static void Tone_copy( VALUE d, VALUE s)
{
    struct FR_Tone *toned = FR_GET_STRUCT( Tone, d );
    struct FR_Tone *tones = FR_GET_STRUCT( Tone, s );

    toned->red = tones->red;
    toned->green = tones->green;
    toned->blue = tones->blue;
    toned->gray = tones->gray;
}

static VALUE Tone_dup( VALUE self )
{
    struct FR_Tone *tone = FR_GET_STRUCT( Tone, self );
    struct FR_Tone *new_tone;
    VALUE obj;

    /* 擾ToneIuWFNg */
    new_tone = malloc(sizeof(struct FR_Tone));
    if( new_tone == NULL ) rb_raise( eFreeRGSSError, "̎擾Ɏs܂ - Tone_dup" );
    obj = Data_Wrap_Struct( cTone, 0, release_Tone, new_tone );

    Tone_copy( obj, self );

    return obj;
}

static VALUE Tone_equal( VALUE self, VALUE vtone )
{
    struct FR_Tone *tone1 = FR_GET_STRUCT( Tone, self );
    struct FR_Tone *tone2;
    FR_TYPECHECK( Tone, vtone );
    Data_Get_Struct( vtone, struct FR_Tone, tone2 );

    if( tone1->gray == tone2->gray && tone1->red == tone2->red &&
        tone1->green == tone2->green && tone1->blue == tone2->blue )
    {
        return Qtrue;
    }
    else
    {
        return Qfalse;
    }
}
static VALUE Tone_set_red( VALUE self, VALUE vred )
{
    FR_GET_STRUCT( Tone, self )->red = FR_M255_255( NUM2DBL( vred ) );
    return vred;
}
static VALUE Tone_get_red( VALUE self )
{
    return rb_float_new( FR_GET_STRUCT( Tone, self )->red );
}
static VALUE Tone_set_green( VALUE self, VALUE vgreen )
{
    FR_GET_STRUCT( Tone, self )->green = FR_M255_255( NUM2DBL( vgreen ) );
    return vgreen;
}
static VALUE Tone_get_green( VALUE self )
{
    return rb_float_new( FR_GET_STRUCT( Tone, self )->green );
}
static VALUE Tone_set_blue( VALUE self, VALUE vblue )
{
    FR_GET_STRUCT( Tone, self )->blue = FR_M255_255( NUM2DBL( vblue ) );
    return vblue;
}
static VALUE Tone_get_blue( VALUE self )
{
    return rb_float_new( FR_GET_STRUCT( Tone, self )->blue );
}
static VALUE Tone_set_gray( VALUE self, VALUE vgray )
{
    FR_GET_STRUCT( Tone, self )->gray = FR_0_255( NUM2DBL( vgray ) );
    return vgray;
}
static VALUE Tone_get_gray( VALUE self )
{
    return rb_float_new( FR_GET_STRUCT( Tone, self )->gray );
}
static VALUE Tone_to_s( VALUE self )
{
    struct FR_Tone *tone = FR_GET_STRUCT( Tone, self );
    char buf[128];
    sprintf( buf, "(%f, %f, %f, %f)", tone->red, tone->green, tone->blue, tone->gray );
    return rb_locale_str_new( buf, strlen( buf ) );
}


/*********************************************************************
 * FontNX
 *
 * tHg̏ێ
 *********************************************************************/
/*--------------------------------------------------------------------
   QƂȂȂƂGCĂ΂֐
 ---------------------------------------------------------------------*/
static void release_Font( struct FR_Font *font )
{
    free( font );
}

/*--------------------------------------------------------------------
   Fontmark֐
 ---------------------------------------------------------------------*/
static void mark_Font( struct FR_Font *font )
{
    rb_gc_mark( font->vname );
    rb_gc_mark( font->vsize );
    rb_gc_mark( font->vbold );
    rb_gc_mark( font->vitalic );
    rb_gc_mark( font->vshadow );
    rb_gc_mark( font->vcolor );
}

/*--------------------------------------------------------------------
   FontNXallocateBmۂׂinitializeOɌĂ΂B
 ---------------------------------------------------------------------*/
static VALUE Font_allocate( VALUE klass )
{
    VALUE obj;
    struct FR_Font *font;

    /* 擾FR_FontIuWFNg */
    font = malloc( sizeof(struct FR_Font) );
    if( font == NULL ) rb_raise( eFreeRGSSError, "̎擾Ɏs܂ - Font_allocate" );
    obj =  Data_Wrap_Struct( klass, mark_Font, release_Font, font );

    font->vname = g_default_font.vname;
    font->vsize = g_default_font.vsize;
    font->vbold = g_default_font.vbold;
    font->vitalic = g_default_font.vitalic;
    font->vshadow = g_default_font.vshadow;
    font->vcolor = g_default_font.vcolor;

    return obj;
}


/*--------------------------------------------------------------------
   FontNXInitialize
 ---------------------------------------------------------------------*/
static VALUE Font_initialize( int argc, VALUE *argv, VALUE self )
{
    struct FR_Font *font = FR_GET_STRUCT( Font, self );
    VALUE vname, vsize;

    rb_scan_args( argc, argv, "02", &vname, &vsize );

    if( vname != Qnil )
    {
        font->vname = vname;
    }
    else
    {
        font->vname = g_default_font.vname;
        if( vsize != Qnil )
        {
            font->vsize = FIX2INT( vsize );
        }
        else
        {
            font->vsize = g_default_font.vsize;
        }
    }

    return self;
}

// tHg񋓃R[obN֐
int CALLBACK EnumFontFamExProc( ENUMLOGFONTEX *lpelfe, NEWTEXTMETRICEX *lpntm,
                                                  int FontType, LPARAM lParam )
{
    if( strcmp( lpelfe->elfLogFont.lfFaceName, (char*)lParam ) == 0 ) return 0;
    return 1;
}

static VALUE Font_exist( VALUE klass, VALUE vstr )
{
    HDC hdc;
    LOGFONT LogFont;
    int result;

    hdc = GetDC( g_hWnd );

    ZeroMemory( &LogFont, sizeof(LOGFONT) );
    LogFont.lfCharSet = DEFAULT_CHARSET;

    result = EnumFontFamiliesEx( hdc, &LogFont, (FONTENUMPROC)EnumFontFamExProc, (LPARAM)RSTRING_PTR( vstr ), 0 );
    ReleaseDC( g_hWnd, hdc );

    return result == 0 ? Qtrue : Qfalse;
}


/*--------------------------------------------------------------------
   FontNXinstall
 ---------------------------------------------------------------------*/
static VALUE Font_install( VALUE klass, VALUE vstr )
{
    int result;
    Check_Type( vstr, T_STRING );

    result = AddFontResourceEx( RSTRING_PTR( vstr ), 0x10, 0 );
    if( result == 0 )
    {
        rb_raise( eFreeRGSSError, "tHg̃CXg[Ɏs܂ - Font_install" );
    }

    return INT2FIX( result );
}

static VALUE Font_set_name( VALUE self, VALUE vname )
{
    FR_GET_STRUCT( Font, self )->vname = vname;
    return vname;
}
static VALUE Font_get_name( VALUE self )
{
    return FR_GET_STRUCT( Font, self )->vname;
}
static VALUE Font_set_default_name( VALUE klass, VALUE vname )
{
    g_default_font.vname = vname;
    return vname;
}
static VALUE Font_get_default_name( VALUE klass )
{
    return g_default_font.vname;
}
static VALUE Font_set_size( VALUE self, VALUE vsize )
{
    FR_GET_STRUCT( Font, self )->vsize = vsize;
    return vsize;
}
static VALUE Font_get_size( VALUE self )
{
    return FR_GET_STRUCT( Font, self )->vsize;
}
static VALUE Font_set_default_size( VALUE klass, VALUE vsize )
{
    g_default_font.vsize = vsize;
    return vsize;
}
static VALUE Font_get_default_size( VALUE klass )
{
    return g_default_font.vsize;
}
static VALUE Font_set_bold( VALUE self, VALUE vbold )
{
    FR_GET_STRUCT( Font, self )->vbold = FR_IS_TRUE( vbold );
    return vbold;
}
static VALUE Font_get_bold( VALUE self )
{
    return FR_GET_STRUCT( Font, self )->vbold;
}
static VALUE Font_set_default_bold( VALUE klass, VALUE vbold )
{
    g_default_font.vbold = FR_IS_TRUE( vbold );
    return vbold;
}
static VALUE Font_get_default_bold( VALUE klass )
{
    return g_default_font.vbold;
}
static VALUE Font_set_italic( VALUE self, VALUE vitalic )
{
    FR_GET_STRUCT( Font, self )->vitalic = FR_IS_TRUE( vitalic );
    return vitalic;
}
static VALUE Font_get_italic( VALUE self )
{
    return FR_GET_STRUCT( Font, self )->vitalic;
}
static VALUE Font_set_default_italic( VALUE klass, VALUE vitalic )
{
    g_default_font.vitalic = FR_IS_TRUE( vitalic );
    return vitalic;
}
static VALUE Font_get_default_italic( VALUE klass )
{
    return g_default_font.vitalic;
}
static VALUE Font_set_shadow( VALUE self, VALUE vshadow )
{
    FR_GET_STRUCT( Font, self )->vshadow = FR_IS_TRUE( vshadow );
    return vshadow;
}
static VALUE Font_get_shadow( VALUE self )
{
    return FR_GET_STRUCT( Font, self )->vshadow;
}
static VALUE Font_set_default_shadow( VALUE klass, VALUE vshadow )
{
    g_default_font.vshadow = FR_IS_TRUE( vshadow );
    return vshadow;
}
static VALUE Font_get_default_shadow( VALUE klass )
{
    return g_default_font.vshadow;
}
static VALUE Font_set_color( VALUE self, VALUE vcolor )
{
    FR_GET_STRUCT( Font, self )->vcolor = vcolor;
    return vcolor;
}
static VALUE Font_get_color( VALUE self )
{
    return FR_GET_STRUCT( Font, self )->vcolor;
}
static VALUE Font_set_default_color( VALUE klass, VALUE vcolor )
{
    g_default_font.vcolor = vcolor;
    return vcolor;
}
static VALUE Font_get_default_color( VALUE klass )
{
    return g_default_font.vcolor;
}


/*********************************************************************
 * BitmapNX
 *
 * `p̉摜ێNXB
 *********************************************************************/

/*--------------------------------------------------------------------
   QƂȂȂƂGCĂ΂֐
 ---------------------------------------------------------------------*/
static void release_Bitmap( struct FR_Bitmap* bitmap )
{
    RELEASE( bitmap->pD3DTexture );
    free( bitmap );
}

/*--------------------------------------------------------------------
   Bitmapmark֐
 ---------------------------------------------------------------------*/
static void mark_Bitmap( struct FR_Bitmap *bitmap )
{
    rb_gc_mark( bitmap->vfont );
}

/*--------------------------------------------------------------------
   BitmapNXallocateBmۂׂinitializeOɌĂ΂B
 ---------------------------------------------------------------------*/
static VALUE Bitmap_allocate( VALUE klass )
{
    VALUE obj;
    struct FR_Bitmap *bitmap;

    /* 擾BitmapIuWFNg */
    bitmap = malloc(sizeof(struct FR_Bitmap));
    if( bitmap == NULL ) rb_raise( eFreeRGSSError, "̎擾Ɏs܂ - Bitmap_allocate" );
    obj = Data_Wrap_Struct(klass, mark_Bitmap, release_Bitmap, bitmap);

    bitmap->pD3DTexture = NULL;
    bitmap->vfont = Font_allocate( cFont );
    bitmap->width = 0;
    bitmap->height = 0;
    bitmap->real_width = 0;
    bitmap->real_height = 0;
    bitmap->vdispose = Qfalse;

    return obj;
}

/*--------------------------------------------------------------------
    Bitmap̃f[^ݒ(pbox`)
 ---------------------------------------------------------------------*/
static void Bitmap_fill( int x1, int y1, int width, int height, unsigned int col, struct FR_Bitmap *bitmap )
{
    D3DLOCKED_RECT texrect;
    int x, y;
    RECT rect;
    unsigned int *p;

    if( x1 < 0 )
    {
        x1 = 0;
    }
    if( y1 < 0 )
    {
        y1 = 0;
    }
    if( x1 + width > bitmap->width )
    {
        width = bitmap->width - x1;
    }
    if( y1 + height > bitmap->height )
    {
        height = bitmap->height - y1;
    }

    rect.left = x1;
    rect.top = y1;
    rect.right = x1 + width;
    rect.bottom = y1 + height;
    bitmap->pD3DTexture->lpVtbl->LockRect( bitmap->pD3DTexture, 0, &texrect, &rect, 0 );
    for( y = 0; y < height; y++ )
    {
        p = (unsigned int*)((char *)texrect.pBits + y * texrect.Pitch);
        for( x = 0; x < width; x++ )
        {
            *(p++) = col;
        }
    }
    bitmap->pD3DTexture->lpVtbl->UnlockRect( bitmap->pD3DTexture, 0 );
    return;
}

/*--------------------------------------------------------------------
   BitmapNXInitialize
 ---------------------------------------------------------------------*/
static VALUE Bitmap_initialize( int argc, VALUE *argv, VALUE self )
{
    struct FR_Bitmap *bitmap = FR_GET_STRUCT( Bitmap, self );
    HRESULT hr;
    D3DSURFACE_DESC desc;
    D3DXIMAGE_INFO srcinfo;
    VALUE arg1, arg2;
    int width, height;

    rb_scan_args( argc, argv, "11", &arg1, &arg2 );

    if( TYPE( arg1 ) == T_STRING )
    {
        /* t@C擾 */
        hr = D3DXGetImageInfoFromFile( RSTRING_PTR( arg1 ), &srcinfo );

        if( FAILED( hr ) )
        {
            rb_raise( eFreeRGSSError, "t@C̓ǂݍ݂Ɏs܂ - %s", RSTRING_PTR( arg1 ) );
        }

        /* t@CǂݍŃeNX`IuWFNg쐬 */
        hr = D3DXCreateTextureFromFileEx( g_pD3DDevice, RSTRING_PTR( arg1 ), srcinfo.Width, srcinfo.Height, 1, 0, D3DFMT_A8R8G8B8, D3DPOOL_MANAGED,
                                          D3DX_DEFAULT,  D3DX_DEFAULT, 0,
                                          0, 0, &bitmap->pD3DTexture);

        if( FAILED( hr ) )
        {
            rb_raise( eFreeRGSSError, "t@C̓ǂݍ݂Ɏs܂ - %s", arg1 );
        }
        width = srcinfo.Width;
        height = srcinfo.Height;
    }
    else
    {
        width = NUM2INT( arg1 );
        height = NUM2INT( arg2 );

        if( width <= 0 || height <= 0 )
        {
            rb_raise( eFreeRGSSError, "BitmapIuWFNg̍쐬Ɏs܂ - Bitmap_initialize" );
        }

        /* eNX`IuWFNg쐬 */
        hr = D3DXCreateTexture( g_pD3DDevice, width, height,
                                1, 0, D3DFMT_A8R8G8B8, D3DPOOL_MANAGED,
                                &bitmap->pD3DTexture);

        if( FAILED( hr ) )
        {
            rb_raise( eFreeRGSSError, "eNX`̍쐬Ɏs܂ - Bitmap_initialize" );
        }
    }

    bitmap->pD3DTexture->lpVtbl->GetLevelDesc(bitmap->pD3DTexture, 0, &desc );
    bitmap->width = width;
    bitmap->height = height;
    bitmap->real_width = desc.Width;
    bitmap->real_height = desc.Height;

    return self;
}


/*--------------------------------------------------------------------
   BitmapNXfill_rect
 ---------------------------------------------------------------------*/
static VALUE Bitmap_fill_rect( int argc, VALUE *argv, VALUE self )
{
    struct FR_Bitmap *bitmap = FR_GET_STRUCT( Bitmap, self );
    struct FR_Rect *rect;
    struct FR_Color *color;
    VALUE arg1, arg2, arg3, arg4, arg5, vcolor;
    int x, y, width, height, col;

    rb_scan_args( argc, argv, "23", &arg1, &arg2, &arg3, &arg4, &arg5 );

    if( TYPE( arg1 ) == T_FIXNUM )
    {
        x = NUM2INT( arg1 );
        y = NUM2INT( arg2 );
        width = NUM2INT( arg3 );
        height = NUM2INT( arg4 );
        vcolor = arg5;
    }
    else
    {
        FR_TYPECHECK( Rect, arg1 );
        Data_Get_Struct( arg1, struct FR_Rect, rect );
        x = rect->x;
        y = rect->y;
        width = rect->width;
        height = rect->height;
        vcolor = arg2;
    }
    FR_TYPECHECK( Color, vcolor );
    Data_Get_Struct( vcolor, struct FR_Color, color );

    Bitmap_fill( x, y, width, height, color->c, bitmap );

    return self;
}


/*--------------------------------------------------------------------
   BitmapNXclear
 ---------------------------------------------------------------------*/
static VALUE Bitmap_clear( VALUE self )
{
    struct FR_Bitmap *bitmap = FR_GET_STRUCT( Bitmap, self );
    Bitmap_fill( 0, 0, bitmap->width, bitmap->height, 0, bitmap );
    return self;
}


/*--------------------------------------------------------------------
   BitmapNXclear_rect
 ---------------------------------------------------------------------*/
static VALUE Bitmap_clear_rect( int argc, VALUE *argv, VALUE self )
{
    struct FR_Bitmap *bitmap = FR_GET_STRUCT( Bitmap, self );
    struct FR_Rect *rect;
    VALUE arg1, arg2, arg3, arg4;
    int x, y, width, height;

    rb_scan_args( argc, argv, "13", &arg1, &arg2, &arg3, &arg4 );

    if( TYPE( arg1 ) == T_FIXNUM )
    {
        x = NUM2INT( arg1 );
        y = NUM2INT( arg2 );
        width = NUM2INT( arg3 );
        height = NUM2INT( arg4 );
    }
    else
    {
        FR_TYPECHECK( Rect, arg1 );
        Data_Get_Struct( arg1, struct FR_Rect, rect );
        x = rect->x;
        y = rect->y;
        width = rect->width;
        height = rect->height;
    }

    Bitmap_fill( x, y, width, height, 0, bitmap );

    return self;
}


/*--------------------------------------------------------------------
   BitmapNXset_pixel
 ---------------------------------------------------------------------*/
static VALUE Bitmap_set_pixel( VALUE self, VALUE vx, VALUE vy, VALUE vcolor )
{
    struct FR_Bitmap *bitmap = FR_GET_STRUCT( Bitmap, self );
    D3DLOCKED_RECT texrect;
    int x, y;
    RECT rect;

    x = NUM2INT( vx );
    y = NUM2INT( vy );
    FR_TYPECHECK( Color, vcolor);

    if( x < 0 || x >= bitmap->width || y < 0 || y >= bitmap->height )
    {
        return self;
    }

    rect.left = x;
    rect.top = y;
    rect.right = x + 1;
    rect.bottom = y + 1;
    bitmap->pD3DTexture->lpVtbl->LockRect( bitmap->pD3DTexture, 0, &texrect, &rect, 0 );

    *((unsigned int*)(texrect.pBits)) = ((struct FR_Color*)DATA_PTR( vcolor ))->c;

    bitmap->pD3DTexture->lpVtbl->UnlockRect( bitmap->pD3DTexture, 0 );

    return self;
}


/*--------------------------------------------------------------------
   BitmapNXget_pixel
 ---------------------------------------------------------------------*/
static VALUE Bitmap_get_pixel( VALUE self, VALUE vx, VALUE vy )
{
    struct FR_Bitmap* bitmap = FR_GET_STRUCT( Bitmap, self );
    VALUE ary[4];
    VALUE vcolor;
    D3DLOCKED_RECT texrect;
    int x, y;
    RECT rect;

    x = NUM2INT( vx );
    y = NUM2INT( vy );

    vcolor = Color_allocate( cColor );
    
    if( x < 0 || x >= bitmap->width || y < 0 || y >= bitmap->height )
    {
        return vcolor;
    }

    rect.left = x;
    rect.top = y;
    rect.right = x + 1;
    rect.bottom = y + 1;
    bitmap->pD3DTexture->lpVtbl->LockRect( bitmap->pD3DTexture, 0, &texrect, &rect, D3DLOCK_READONLY );

    FR_GET_STRUCT( Color, vcolor )->red = (float)((struct Color*)texrect.pBits)->red;
    FR_GET_STRUCT( Color, vcolor )->green = (float)((struct Color*)texrect.pBits)->green;
    FR_GET_STRUCT( Color, vcolor )->blue = (float)((struct Color*)texrect.pBits)->blue;
    FR_GET_STRUCT( Color, vcolor )->alpha = (float)((struct Color*)texrect.pBits)->alpha;

    bitmap->pD3DTexture->lpVtbl->UnlockRect( bitmap->pD3DTexture, 0 );

    return vcolor;
}


static VALUE Bitmap_get_width( VALUE self )
{
    return INT2FIX( FR_GET_STRUCT( Bitmap, self )->width );
}
static VALUE Bitmap_get_height( VALUE self )
{
    return INT2FIX( FR_GET_STRUCT( Bitmap, self )->height );
}
static VALUE Bitmap_set_font( VALUE self, VALUE vfont )
{
    FR_GET_STRUCT( Bitmap, self )->vfont = vfont;
    return vfont;
}
static VALUE Bitmap_get_font( VALUE self )
{
    return INT2FIX( FR_GET_STRUCT( Bitmap, self )->vfont );
}
static VALUE Bitmap_get_rect( VALUE self )
{
    struct FR_Bitmap *bitmap = FR_GET_STRUCT( Bitmap, self );
    struct FR_Rect *rect;
    VALUE vrect;

    /* 擾RectIuWFNg */
    rect = malloc(sizeof(struct FR_Rect));
    if( rect == NULL ) rb_raise( eFreeRGSSError, "̎擾Ɏs܂ - Bitmap_get_rect" );
    vrect = Data_Wrap_Struct(cRect, 0, release_Rect, rect);

    rect->x = 0;
    rect->y = 0;
    rect->width = bitmap->width;
    rect->height = bitmap->height;

    return vrect;
}









/*--------------------------------------------------------------------
   BitmapɃtHg`
 ---------------------------------------------------------------------*/
static VALUE Bitmap_draw_text( int argc, VALUE *argv, VALUE self )
{
    struct FR_Font *font;
    struct FR_Bitmap *bitmap = FR_GET_STRUCT( Bitmap, self );
    VALUE vfont;
    VALUE arg1,arg2,arg3,arg4,arg5,arg6;
    int x, y, width, height, align;
    VALUE vstr;
    HANDLE hFont;
    int cr, cg, cb, ca;
    LPDIRECT3DSURFACE9 pD3DSurface;
    HDC hDC;
    RECT rc;
    HRESULT hr;
    D3DLOCKED_RECT srctrect;
    D3DLOCKED_RECT dsttrect;
    int i, j;
    int h;
    RECT srcrect;
    RECT dstrect;
    int *psrc;
    int *pdst;

    LOGFONT logfont;

    /* 擾 */
    rb_scan_args( argc, argv, "24", &arg1, &arg2, &arg3, &arg4, &arg5, &arg6 );

    FR_TYPECHECK( Font, bitmap->vfont );
    Data_Get_Struct( bitmap->vfont, struct FR_Font, font );

    if( TYPE( arg1 ) == T_FIXNUM )
    {
        x = NUM2INT( arg1 );
        y = NUM2INT( arg2 );
        width = NUM2INT( arg3 );
        height = NUM2INT( arg4 );
        vstr = arg5;
        align = arg6 == Qnil ? 0 : NUM2INT( arg6 );
    }
    else
    {
        FR_TYPECHECK( Rect, arg1 );
        x = ((struct FR_Rect*)DATA_PTR( arg1 ))->x;
        y = ((struct FR_Rect*)DATA_PTR( arg1 ))->y;
        width = ((struct FR_Rect*)DATA_PTR( arg1 ))->width;
        height = ((struct FR_Rect*)DATA_PTR( arg1 ))->height;
        vstr = arg2;
        align = arg3 == Qnil ? 0 : NUM2INT( arg3 );
    }
    Check_Type( vstr, T_STRING );

    cr = ((struct FR_Color*)DATA_PTR( font->vcolor ))->red;
    cg = ((struct FR_Color*)DATA_PTR( font->vcolor ))->green;
    cb = ((struct FR_Color*)DATA_PTR( font->vcolor ))->blue;
    ca = ((struct FR_Color*)DATA_PTR( font->vcolor ))->alpha;

    if( x >= bitmap->width || y >= bitmap->height )
    {
        return self;
    }

    /* ItXN[T[tFCXɕ` */
    hr = g_pD3DDevice->lpVtbl->CreateOffscreenPlainSurface ( g_pD3DDevice, bitmap->width, bitmap->height
                                      , D3DFMT_X8R8G8B8, D3DPOOL_SYSTEMMEM, &pD3DSurface, NULL );
    if( FAILED( hr ) )
    {
        rb_raise( eFreeRGSSError, "T[tFCX̐Ɏs܂ - CreateOffscreenPlainSurface" );
    }
    hr = pD3DSurface->lpVtbl->GetDC( pD3DSurface, &hDC );
    if( FAILED( hr ) )
    {
        rb_raise( eFreeRGSSError, "DC̎擾Ɏs܂ - GetDC" );
    }

    ZeroMemory( &logfont, sizeof(logfont) );
    logfont.lfHeight          = NUM2INT( font->vsize );
    logfont.lfWidth           = 0;
    logfont.lfWeight          = font->vbold == Qnil || font->vbold == Qfalse ? 400 : 1000;
    logfont.lfItalic          = font->vitalic == Qnil || font->vitalic == Qfalse ? FALSE : TRUE;
    logfont.lfCharSet         = DEFAULT_CHARSET;
    logfont.lfQuality         = ANTIALIASED_QUALITY;
    logfont.lfOutPrecision    = OUT_TT_ONLY_PRECIS;

    lstrcpy(logfont.lfFaceName, "");
    if( TYPE( font->vname ) == T_ARRAY )
    {
        for( i = 0; i < RARRAY_LEN( font->vname ); i++ )
        {
            if( Font_exist( cFont, RARRAY_PTR( font->vname )[i] ) == Qtrue )
            {
                lstrcpy( logfont.lfFaceName, RSTRING_PTR( RARRAY_PTR( font->vname )[i] ) );
                break;
            }
        }
    }
    else if( TYPE( font->vname ) == T_STRING )
    {
        lstrcpy(logfont.lfFaceName, RSTRING_PTR( font->vname ));
    }

    hFont = CreateFontIndirect( &logfont );

    if( hFont == NULL )
    {
        rb_raise( eFreeRGSSError, "tHg̍쐬Ɏs܂ - CreateFontIndirect" );
    }

    SelectObject( hDC, hFont );
    SetRect( &rc, x, y, x + 1, y + 1 );
    SetTextColor( hDC, RGB( 255, 255, 255 ) );
    SetBkColor( hDC, RGB( 0, 0, 0 ) );
    h = DrawText( hDC, RSTRING_PTR( vstr ), -1, &rc, DT_LEFT | DT_NOCLIP | DT_NOPREFIX | DT_NOFULLWIDTHCHARBREAK);
    pD3DSurface->lpVtbl->ReleaseDC( pD3DSurface, hDC );

    if( y + h < 0 )
    {
        DeleteObject( hFont );
        RELEASE( pD3DSurface );
        return self;
    }

    /* BitmapIuWFNgɓ] */
    if( x < 0 )
    {
        x = 0;
    }
    if( y < 0 )
    {
        h += y;
        y = 0;
    }

    srcrect.left = x;
    srcrect.top = y;
    srcrect.right = bitmap->width;
    srcrect.bottom = bitmap->height < y + h ? bitmap->height : y + h;
    dstrect.left = x;
    dstrect.top = y;
    dstrect.right = bitmap->width;
    dstrect.bottom = (bitmap->height < y + h ? bitmap->height : y + h);

    bitmap->pD3DTexture->lpVtbl->LockRect( bitmap->pD3DTexture, 0, &dsttrect, &dstrect, 0 );
    pD3DSurface->lpVtbl->LockRect( pD3DSurface, &srctrect, &srcrect, D3DLOCK_READONLY );

    for( i = 0; i < srcrect.bottom - srcrect.top; i++)
    {
        psrc = (int*)((char *)srctrect.pBits + i * srctrect.Pitch);
        pdst = (int*)((char *)dsttrect.pBits + i * dsttrect.Pitch);
        for( j = 0; j < srcrect.right - srcrect.left; j++)
        {
            struct Color s = *((struct Color*)(psrc));

            if( s.red == 255 )
            {
                *((int *)(pdst)) = D3DCOLOR_ARGB(0xff, cr, cg, cb);
            }
            else if( s.red != 0 )
            {
                struct Color d = *((struct Color*)(pdst));
                struct Color data;

                data.alpha = s.red > d.alpha ? s.red : d.alpha;
                data.red = ((int)s.red * cr * 255 + (int)d.red * (int)d.alpha * (255 - (int)s.red) ) / 255 / 255;
                data.green = ((int)s.red * cg * 255 + (int)d.green * (int)d.alpha * (255 - (int)s.red) ) / 255 / 255;
                data.blue = ((int)s.red * cb * 255 + (int)d.blue * (int)d.alpha * (255 - (int)s.red) ) / 255 / 255;

                *((struct Color*)(pdst)) = data;
            }
            psrc++;
            pdst++;
        }
    }

    bitmap->pD3DTexture->lpVtbl->UnlockRect( bitmap->pD3DTexture, 0 );
    pD3DSurface->lpVtbl->UnlockRect( pD3DSurface );

    RELEASE( pD3DSurface );
    DeleteObject( hFont );
    return self;
}


/*--------------------------------------------------------------------
   擾
 ---------------------------------------------------------------------*/
static VALUE Bitmap_text_size( VALUE self, VALUE str )
{
    HDC hDC;
    struct FR_Bitmap *bitmap = FR_GET_STRUCT( Bitmap, self );
    struct FR_Font *font;
    RECT rc;
    HANDLE hFont;
    LOGFONT logfont;
    int i;
    VALUE vrect;

    Data_Get_Struct( bitmap->vfont, struct FR_Font, font );

    hDC = GetDC( g_hWnd );
    if( hDC == NULL )
    {
        rb_raise( eFreeRGSSError, "DC̎擾Ɏs܂ - GetDC" );
    }

    ZeroMemory( &logfont, sizeof(logfont) );
    logfont.lfHeight          = NUM2INT( font->vsize );
    logfont.lfWidth           = 0;
    logfont.lfWeight          = font->vbold == Qnil || font->vbold == Qfalse ? 400 : 1000;
    logfont.lfItalic          = font->vbold == Qnil || font->vbold == Qfalse ? FALSE : TRUE;
    logfont.lfCharSet         = DEFAULT_CHARSET;
    logfont.lfQuality         = ANTIALIASED_QUALITY;

    lstrcpy(logfont.lfFaceName, "");
    if( TYPE( font->vname ) == T_ARRAY )
    {
        for( i = 0; i < RARRAY_LEN( font->vname ); i++ )
        {
            if( Font_exist( cFont, RARRAY_PTR( font->vname )[i] ) == Qtrue )
            {
                lstrcpy( logfont.lfFaceName, RSTRING_PTR( RARRAY_PTR( font->vname )[i] ) );
                break;
            }
        }
    }
    else if( TYPE( font->vname ) == T_STRING )
    {
        lstrcpy(logfont.lfFaceName, RSTRING_PTR( font->vname ));
    }

    hFont = CreateFontIndirect( &logfont );

    if( hFont == NULL )
    {
        rb_raise( eFreeRGSSError, "tHg̍쐬Ɏs܂ - CreateFontIndirect" );
    }

    SelectObject( hDC, hFont );
    SetRect( &rc, 0, 0, 1, 1 );
    DrawText( hDC, RSTRING_PTR( str ), -1, &rc, DT_LEFT | DT_NOCLIP | DT_NOPREFIX | DT_CALCRECT | DT_SINGLELINE);
    ReleaseDC( g_hWnd, hDC );

    DeleteObject( hFont );

    vrect = Rect_allocate( cRect );

    ((struct FR_Rect*)DATA_PTR( vrect ))->width = rc.right;
    ((struct FR_Rect*)DATA_PTR( vrect ))->height = NUM2INT( font->vsize );
    return vrect;
}


/*********************************************************************
 * ViewportNX
 *
 * `͈͏ێNXB
 *********************************************************************/
/*--------------------------------------------------------------------
   QƂȂȂƂGCĂ΂֐
 ---------------------------------------------------------------------*/
static void release_Viewport( struct FR_Viewport* vp )
{
    vp->z = 1; /* œKɂ֐܂Ƃ߂邱Ƃ̑΍ */
    free( vp );
}

/*--------------------------------------------------------------------
   Viewportmark֐
 ---------------------------------------------------------------------*/
static void mark_Viewport( struct FR_Viewport *vp )
{
    rb_gc_mark( vp->vrect );
    rb_gc_mark( vp->vcolor );
    rb_gc_mark( vp->vtone );
    rb_gc_mark( vp->vsprites );
}

/*--------------------------------------------------------------------
   ViewportNXallocateBmۂׂinitializeOɌĂ΂B
 ---------------------------------------------------------------------*/
static VALUE Viewport_allocate( VALUE klass )
{
    VALUE obj;
    struct FR_Viewport *vp;
    int i;

    /* 擾ViewportIuWFNg */
    vp = malloc(sizeof(struct FR_Viewport));
    if( vp == NULL ) rb_raise( eFreeRGSSError, "̎擾Ɏs܂ - Viewport_allocate" );
    obj = Data_Wrap_Struct(klass, mark_Viewport, release_Viewport, vp);

    vp->internal_draw = Viewport_internal_draw;
    vp->vdispose = Qfalse;
    vp->vrect = Rect_allocate( cRect );
    vp->y = 0;
    vp->z = 0;
    vp->vvisible = Qtrue;
    vp->ox = 0;
    vp->oy = 0;
    vp->vcolor = Color_allocate( cColor );
    vp->vtone = Tone_allocate( cTone );
    vp->flash_count = 0;
    vp->flash_count_start = 0;
    vp->flash_red = 0;
    vp->flash_green = 0;
    vp->flash_blue = 0;
    vp->flash_alpha = 0;
    vp->vsprites = rb_ary_new();

    return obj;
}

/*--------------------------------------------------------------------
   ViewportNXInitialize
 ---------------------------------------------------------------------*/
static VALUE Viewport_initialize( int argc, VALUE *argv, VALUE self )
{
    struct FR_Viewport *vp = FR_GET_STRUCT( Viewport, self );
    VALUE arg1, arg2, arg3, arg4;
    struct FR_Rect *rect;

    rb_scan_args( argc, argv, "13", &arg1, &arg2, &arg3, &arg4 );
    Data_Get_Struct( vp->vrect, struct FR_Rect, rect );

    if( TYPE( arg1 ) == T_FIXNUM )
    {
        rect->x = NUM2INT( arg1 );
        rect->y = NUM2INT( arg2 );
        rect->width = NUM2INT( arg3 );
        rect->height = NUM2INT( arg4 );
    }
    else
    {
        FR_TYPECHECK( Rect, arg1 );
        Rect_copy( vp->vrect, arg1 );
    }

    vp->y = rect->y;

    rb_ary_push( g_graphics.vsprites, self );

    return self;
}

static VALUE Viewport_dispose( VALUE self )
{
    FR_GET_STRUCT( Viewport, self )->vdispose = Qtrue;
    rb_ary_delete( g_graphics.vsprites, self );
    return self;
}
static VALUE Viewport_get_dispose( VALUE self )
{
    return FR_GET_STRUCT( Viewport, self )->vdispose;
}

static VALUE Viewport_flash( VALUE self, VALUE vcolor, VALUE vcount )
{
    struct FR_Viewport *viewport = FR_GET_STRUCT( Viewport, self );
    struct FR_Color *color;

    if( vcolor == Qnil )
    {
        viewport->flash_delete = 1;
    }
    else
    {
        FR_TYPECHECK( Color, vcolor );
        Data_Get_Struct( vcolor, struct FR_Color, color );
        viewport->flash_red = color->red;
        viewport->flash_green = color->green;
        viewport->flash_blue = color->blue;
        viewport->flash_alpha = color->alpha;
        viewport->flash_delete = 0;
    }

    viewport->flash_count = viewport->flash_count_start = NUM2INT( vcount );
 
    return self;
}

static VALUE Viewport_update( VALUE self )
{
    struct FR_Viewport *viewport = FR_GET_STRUCT( Viewport, self );
    if( viewport->flash_count > 0 )
    {
        viewport->flash_count--;
    }
    return self;
}

static VALUE Viewport_set_z( VALUE self, VALUE vz )
{
    FR_GET_STRUCT( Viewport, self )->z = NUM2INT( vz );
    return vz;
}
static VALUE Viewport_get_z( VALUE self )
{
    return INT2FIX( FR_GET_STRUCT( Viewport, self )->z );
}
static VALUE Viewport_set_ox( VALUE self, VALUE vox )
{
    FR_GET_STRUCT( Viewport, self )->ox = NUM2INT( vox );
    return vox;
}
static VALUE Viewport_get_ox( VALUE self )
{
    return INT2FIX( FR_GET_STRUCT( Viewport, self )->ox );
}
static VALUE Viewport_set_oy( VALUE self, VALUE voy )
{
    FR_GET_STRUCT( Viewport, self )->oy = NUM2INT( voy );
    return voy;
}
static VALUE Viewport_get_oy( VALUE self )
{
    return INT2FIX( FR_GET_STRUCT( Viewport, self )->oy );
}
static VALUE Viewport_set_rect( VALUE self, VALUE vrect )
{
    Rect_copy( FR_GET_STRUCT( Viewport, self )->vrect, vrect );
    return vrect;
}
static VALUE Viewport_get_rect( VALUE self )
{
    return FR_GET_STRUCT( Viewport, self )->vrect;
}
static VALUE Viewport_set_color( VALUE self, VALUE vcolor )
{
    Color_copy( FR_GET_STRUCT( Viewport, self )->vcolor, vcolor );
    return vcolor;
}
static VALUE Viewport_get_color( VALUE self )
{
    return FR_GET_STRUCT( Viewport, self )->vcolor;
}
static VALUE Viewport_set_tone( VALUE self, VALUE vtone )
{
    Tone_copy( FR_GET_STRUCT( Viewport, self )->vtone, vtone );
    return vtone;
}
static VALUE Viewport_get_tone( VALUE self )
{
    return FR_GET_STRUCT( Viewport, self )->vtone;
}
static VALUE Viewport_set_visible( VALUE self, VALUE vvisible )
{
    FR_GET_STRUCT( Viewport, self )->vvisible = FR_IS_TRUE( vvisible );
    return vvisible;
}
static VALUE Viewport_get_visible( VALUE self )
{
    return FR_GET_STRUCT( Viewport, self )->vvisible;
}

/*--------------------------------------------------------------------
   ViewportNX̓draw
 ---------------------------------------------------------------------*/
static void Viewport_internal_draw( VALUE self, int ox, int oy )
{
    struct FR_Viewport *vp = FR_GET_STRUCT( Viewport, self );
    VALUE *vpsprites;
    int spritecount, i, x, y, width, height;
    D3DVIEWPORT9 d3dvp;
    HRESULT hr;

    if( FR_IS_TRUE(vp->vdispose) || FR_IS_FALSE(vp->vvisible) || ( vp->flash_delete == 1 && vp->flash_count > 0 ) )
    {
        return;
    }

    x = ((struct FR_Rect*)DATA_PTR( vp->vrect ))->x;
    y = ((struct FR_Rect*)DATA_PTR( vp->vrect ))->y;
    width = ((struct FR_Rect*)DATA_PTR( vp->vrect ))->width;
    height = ((struct FR_Rect*)DATA_PTR( vp->vrect ))->height;

    /* r[|[g̐ݒ */
    d3dvp.X       = x;
    d3dvp.Y       = y;
    d3dvp.Width   = width;
    d3dvp.Height  = height;
    d3dvp.MinZ    = 0.0f;
    d3dvp.MaxZ    = 1.0f;

//    hr = g_pD3DDevice->lpVtbl->SetViewport( g_pD3DDevice, &d3dvp );

  //  if( FAILED( hr ) )
  //  {
   //     rb_raise( eFreeRGSSError, "ݒɎs܂ - SetViewport" );
   // }

    vpsprites = RARRAY_PTR( vp->vsprites );
    spritecount = RARRAY_LEN( vp->vsprites );
    /* XvCgz\[g */
    SortSuperSpriteList( vpsprites, spritecount );
    for( i = 0; i < spritecount; i++ )
    {
        ((struct FR_SuperSprite*)DATA_PTR( vpsprites[i] ))->internal_draw( vpsprites[i], vp->ox, vp->oy );
    }


    g_pD3DDevice->lpVtbl->SetRenderState(g_pD3DDevice, D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);
    g_pD3DDevice->lpVtbl->SetRenderState(g_pD3DDevice, D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA);

//    if( vp->vcolor != Qnil || vp->flash_count > 0 || vp->vtone != Qnil )
    if( ((struct FR_Color*)DATA_PTR(vp->vcolor))->c != 0 || vp->flash_count > 0 ||
        ((struct FR_Tone*)DATA_PTR(vp->vtone))->red != 0 ||
        ((struct FR_Tone*)DATA_PTR(vp->vtone))->green != 0 ||
        ((struct FR_Tone*)DATA_PTR(vp->vtone))->blue != 0 ||
        ((struct FR_Tone*)DATA_PTR(vp->vtone))->gray != 0 )
    {
        TLVERTX VertexDataTbl[6];

        /* _P */
        VertexDataTbl[0].x = x;
        VertexDataTbl[0].y = y;
        /* _Q */
        VertexDataTbl[1].x = VertexDataTbl[3].x = x + width;
        VertexDataTbl[1].y = VertexDataTbl[3].y = y;
        /* _R */
        VertexDataTbl[4].x = x + width;
        VertexDataTbl[4].y = y + height;
        /* _S */
        VertexDataTbl[2].x = VertexDataTbl[5].x = x;
        VertexDataTbl[2].y = VertexDataTbl[5].y = y + height;
        /* yW */
        VertexDataTbl[0].z      =  
        VertexDataTbl[1].z      =  
        VertexDataTbl[2].z      =  
        VertexDataTbl[3].z      =  
        VertexDataTbl[4].z      =  
        VertexDataTbl[5].z      =  0.0f;
        /* eNX`W */
        VertexDataTbl[0].tu     =  VertexDataTbl[5].tu = VertexDataTbl[2].tu = 0;
        VertexDataTbl[0].tv     =  VertexDataTbl[1].tv = VertexDataTbl[3].tv = 0;
        VertexDataTbl[1].tu     =  VertexDataTbl[3].tu = VertexDataTbl[4].tu = 0;
        VertexDataTbl[4].tv     =  VertexDataTbl[5].tv = VertexDataTbl[2].tv = 0;

        g_pD3DDevice->lpVtbl->SetTexture(g_pD3DDevice, 0, NULL);

        if( vp->vcolor != Qnil )
        {
            struct FR_Color* color;
            D3DXVECTOR4 c;

            color = DATA_PTR( vp->vcolor );
            c.x = color->red / 255.0f;
            c.y = color->green / 255.0f;
            c.z = color->blue / 255.0f;
            c.w = color->alpha / 255.0f;
            /* _F */
            VertexDataTbl[0].color  =  
            VertexDataTbl[1].color  =  
            VertexDataTbl[2].color  =  
            VertexDataTbl[3].color  =  
            VertexDataTbl[4].color  =  
            VertexDataTbl[5].color  =  D3DCOLOR_ARGB((int)color->alpha,(int)color->red,(int)color->green,(int)color->blue);
            /* ` */
            g_pD3DDevice->lpVtbl->DrawPrimitiveUP( g_pD3DDevice, D3DPT_TRIANGLELIST, 2, VertexDataTbl, sizeof(TLVERTX) );
        }

        if( vp->flash_count > 0 )
        {
            D3DXVECTOR4 c;

            c.x = vp->flash_red / 255.0f;
            c.y = vp->flash_green / 255.0f;
            c.z = vp->flash_blue / 255.0f;
            c.w = (int)vp->flash_alpha * vp->flash_count / vp->flash_count_start / 255.0f;
            /* _F */
            VertexDataTbl[0].color  =  
            VertexDataTbl[1].color  =  
            VertexDataTbl[2].color  =  
            VertexDataTbl[3].color  =  
            VertexDataTbl[4].color  =  
            VertexDataTbl[5].color  =  D3DCOLOR_ARGB((int)vp->flash_alpha * vp->flash_count / vp->flash_count_start,vp->flash_red,vp->flash_green,vp->flash_blue);
            /* ` */
            g_pD3DDevice->lpVtbl->DrawPrimitiveUP( g_pD3DDevice, D3DPT_TRIANGLELIST, 2, VertexDataTbl, sizeof(TLVERTX) );
        }
/*
        if( vp->vcolor != Qnil )
        {
            struct FR_Color* color;
            D3DXVECTOR4 c;

            color = DATA_PTR( vp->vcolor );
            c.x = color->red / 255.0f;
            c.y = color->green / 255.0f;
            c.z = color->blue / 255.0f;
            c.w = color->alpha / 255.0f;

            m_pEffect->lpVtbl->SetVector( m_pEffect, g_hcolor_viewport, &c );
            m_pEffect->lpVtbl->SetTechnique( m_pEffect, m_hTechnique_viewport );
            m_pEffect->lpVtbl->Begin( m_pEffect, NULL, 0 );
            m_pEffect->lpVtbl->BeginPass( m_pEffect, 0 );
            g_pD3DDevice->lpVtbl->DrawPrimitiveUP( g_pD3DDevice, D3DPT_TRIANGLELIST, 2, VertexDataTbl, sizeof(TLVERTX) );
            m_pEffect->lpVtbl->EndPass( m_pEffect );
            m_pEffect->lpVtbl->End( m_pEffect );
        }

        if( vp->flash_count > 0 )
        {
            D3DXVECTOR4 c;

            c.x = vp->flash_red / 255.0f;
            c.y = vp->flash_green / 255.0f;
            c.z = vp->flash_blue / 255.0f;
            c.w = (int)vp->flash_alpha * vp->flash_count / vp->flash_count_start / 255.0f;

            m_pEffect->lpVtbl->SetVector( m_pEffect, g_hcolor_viewport, &c );
            m_pEffect->lpVtbl->SetTechnique( m_pEffect, m_hTechnique_viewport );
            m_pEffect->lpVtbl->Begin( m_pEffect, NULL, 0 );
            m_pEffect->lpVtbl->BeginPass( m_pEffect, 0 );
            g_pD3DDevice->lpVtbl->DrawPrimitiveUP( g_pD3DDevice, D3DPT_TRIANGLELIST, 2, VertexDataTbl, sizeof(TLVERTX) );
            m_pEffect->lpVtbl->EndPass( m_pEffect );
            m_pEffect->lpVtbl->End( m_pEffect );
        }
*/
    }

    /* r[|[g̐ݒ */
    d3dvp.X       = 0;
    d3dvp.Y       = 0;
    d3dvp.Width   = g_WindowInfo.width;
    d3dvp.Height  = g_WindowInfo.height;
    d3dvp.MinZ    = 0.0f;
    d3dvp.MaxZ    = 1.0f;

//    hr = g_pD3DDevice->lpVtbl->SetViewport( g_pD3DDevice, &d3dvp );

//    if( FAILED( hr ) )
//    {
//        rb_raise( eFreeRGSSError, "ݒɎs܂ - SetViewport" );
//    }
}



/*********************************************************************
 * SpriteNX
 *
 * `ێNXB
 *********************************************************************/

/*--------------------------------------------------------------------
   QƂȂȂƂGCĂ΂֐
 ---------------------------------------------------------------------*/
static void release_Sprite( struct FR_Sprite* sprite )
{
    free( sprite );
}

/*--------------------------------------------------------------------
   Spritemark֐
 ---------------------------------------------------------------------*/
static void mark_Sprite( struct FR_Sprite *sprite )
{
    rb_gc_mark( sprite->vbitmap );
    rb_gc_mark( sprite->vrect );
    rb_gc_mark( sprite->vviewport );
    rb_gc_mark( sprite->vcolor );
    rb_gc_mark( sprite->vtone );
}

/*--------------------------------------------------------------------
   SpriteNXallocateBmۂׂinitializeOɌĂ΂B
 ---------------------------------------------------------------------*/
static VALUE Sprite_allocate( VALUE klass )
{
    VALUE obj;
    struct FR_Sprite *sprite;

    /* 擾SpriteIuWFNg */
    sprite = malloc(sizeof(struct FR_Sprite));
    if( sprite == NULL ) rb_raise( eFreeRGSSError, "̎擾Ɏs܂ - Sprite_allocate" );
    obj = Data_Wrap_Struct(klass, mark_Sprite, release_Sprite, sprite);

    sprite->internal_draw = Sprite_internal_draw;
    sprite->vdispose = Qfalse;
    sprite->vbitmap = Qnil;
    sprite->vviewport = Qnil;
    sprite->vrect = Rect_allocate( cRect );
    sprite->vcolor = Color_allocate( cColor );
    sprite->vtone = Tone_allocate( cTone );
    sprite->vvisible = Qtrue;
    sprite->x = 0;
    sprite->y = 0;
    sprite->z = 0;
    sprite->ox = 0;
    sprite->oy = 0;
    sprite->zoom_x = 1.0f;
    sprite->zoom_y = 1.0f;
    sprite->angle = 0.0f;
    sprite->vmirror = Qfalse;
    sprite->opacity = 255;
    sprite->blend_type = 0;
    sprite->bush_depth = 0;
    sprite->bush_opacity = 128;
    sprite->flash_count = 0;
    sprite->flash_count_start = 0;
    sprite->flash_red = 0;
    sprite->flash_green = 0;
    sprite->flash_blue = 0;
    sprite->flash_alpha = 0;
    sprite->flash_delete = 0;

    return obj;
}

/*--------------------------------------------------------------------
   SpriteNXInitialize
 ---------------------------------------------------------------------*/
static VALUE Sprite_initialize( int argc, VALUE *argv, VALUE self )
{
    struct FR_Sprite *sprite = FR_GET_STRUCT( Sprite, self );
    VALUE vviewport;

    rb_scan_args( argc, argv, "01", &vviewport );

    if( vviewport != Qnil )
    {
        FR_TYPECHECK( Viewport, vviewport ); 
        sprite->vviewport = vviewport;
        rb_ary_push( FR_GET_STRUCT( Viewport, vviewport )->vsprites, self );
    }
    else
    {
        rb_ary_push( g_graphics.vsprites, self );
    }
    return self;
}

static VALUE Sprite_set_bitmap( VALUE self, VALUE vbitmap )
{
    struct FR_Sprite *sprite = FR_GET_STRUCT( Sprite, self );

    FR_TYPECHECK( Bitmap, vbitmap );
    sprite->vbitmap = vbitmap;
    Rect_copy( sprite->vrect ,Bitmap_get_rect( vbitmap ) );

    return vbitmap;
}

static VALUE Sprite_dispose( VALUE self )
{
    struct FR_Sprite *sprite = FR_GET_STRUCT( Sprite, self );
    sprite->vdispose = Qtrue;
    if( sprite->vviewport == Qnil )
    {
        rb_ary_delete( g_graphics.vsprites, self );
    }
    else
    {
        rb_ary_delete( ((struct FR_Viewport*)DATA_PTR( sprite->vviewport ))->vsprites, self );
    }
    return self;
}
static VALUE Sprite_get_dispose( VALUE self )
{
    return FR_GET_STRUCT( Sprite, self )->vdispose;
}

static VALUE Sprite_flash( VALUE self, VALUE vcolor, VALUE vcount )
{
    struct FR_Sprite *sprite = FR_GET_STRUCT( Sprite, self );
    struct FR_Color *color;

    if( vcolor == Qnil )
    {
        sprite->flash_delete = 1;
    }
    else
    {
        FR_TYPECHECK( Color, vcolor );
        Data_Get_Struct( vcolor, struct FR_Color, color );
        sprite->flash_red = color->red;
        sprite->flash_green = color->green;
        sprite->flash_blue = color->blue;
        sprite->flash_alpha = color->alpha;
        sprite->flash_delete = 0;
    }

    sprite->flash_count = sprite->flash_count_start = NUM2INT( vcount );
 
    return self;
}

static VALUE Sprite_update( VALUE self )
{
    struct FR_Sprite *sprite = FR_GET_STRUCT( Sprite, self );
    if( sprite->flash_count > 0 )
    {
        sprite->flash_count--;
    }
    return self;
}

static VALUE Sprite_get_bitmap( VALUE self )
{
    return FR_GET_STRUCT( Sprite, self )->vbitmap;
}
static VALUE Sprite_set_rect( VALUE self, VALUE vrect )
{
    FR_TYPECHECK( Rect, vrect );
    Rect_copy( FR_GET_STRUCT( Sprite, self )->vrect, vrect );
    return vrect;
}
static VALUE Sprite_get_rect( VALUE self )
{
    return FR_GET_STRUCT( Sprite, self )->vrect;
}
static VALUE Sprite_get_width( VALUE self )
{
    struct FR_Sprite *sprite = FR_GET_STRUCT( Sprite, self );
    return INT2FIX( FR_GET_STRUCT( Rect, sprite->vrect )->width ) ;
}
static VALUE Sprite_get_height( VALUE self )
{
    struct FR_Sprite *sprite = FR_GET_STRUCT( Sprite, self );
    return INT2FIX( FR_GET_STRUCT( Rect, sprite->vrect )->height ) ;
}
static VALUE Sprite_set_viewport( VALUE self, VALUE vviewport )
{
    struct FR_Sprite *sprite = FR_GET_STRUCT( Sprite, self );
    if( sprite->vviewport != Qnil )
    {
        FR_TYPECHECK( Viewport, vviewport );
        rb_ary_delete( FR_GET_STRUCT( Viewport, sprite->vviewport )->vsprites, self );
    }
    sprite->vviewport = vviewport;
    rb_ary_push( FR_GET_STRUCT( Viewport, sprite->vviewport )->vsprites, self );
    return vviewport;
}
static VALUE Sprite_get_viewport( VALUE self )
{
    return FR_GET_STRUCT( Sprite, self )->vviewport;
}
static VALUE Sprite_set_x( VALUE self, VALUE vx )
{
    FR_GET_STRUCT( Sprite, self )->x = NUM2INT( vx );
    return vx;
}
static VALUE Sprite_get_x( VALUE self )
{
    return INT2FIX( FR_GET_STRUCT( Sprite, self )->x );
}
static VALUE Sprite_set_y( VALUE self, VALUE vy )
{
    FR_GET_STRUCT( Sprite, self )->y = NUM2INT( vy );
    return vy;
}
static VALUE Sprite_get_y( VALUE self )
{
    return INT2FIX( FR_GET_STRUCT( Sprite, self )->y );
}
static VALUE Sprite_set_z( VALUE self, VALUE vz )
{
    FR_GET_STRUCT( Sprite, self )->z = NUM2INT( vz );
    return vz;
}
static VALUE Sprite_get_z( VALUE self )
{
    return INT2FIX( FR_GET_STRUCT( Sprite, self )->z );
}
static VALUE Sprite_set_angle( VALUE self, VALUE vangle )
{
    FR_GET_STRUCT( Sprite, self )->angle = NUM2DBL( vangle );
    return vangle;
}
static VALUE Sprite_get_angle( VALUE self )
{
    return rb_float_new( FR_GET_STRUCT( Sprite, self )->angle );
}
static VALUE Sprite_set_zoom_x( VALUE self, VALUE vzoom_x )
{
    FR_GET_STRUCT( Sprite, self )->zoom_x = NUM2DBL( vzoom_x );
    return vzoom_x;
}
static VALUE Sprite_get_zoom_x( VALUE self )
{
    return rb_float_new( FR_GET_STRUCT( Sprite, self )->zoom_x );
}
static VALUE Sprite_set_zoom_y( VALUE self, VALUE vzoom_y )
{
    FR_GET_STRUCT( Sprite, self )->zoom_y = NUM2DBL( vzoom_y );
    return vzoom_y;
}
static VALUE Sprite_get_zoom_y( VALUE self )
{
    return rb_float_new( FR_GET_STRUCT( Sprite, self )->zoom_y );
}
static VALUE Sprite_set_blend_type( VALUE self, VALUE vblend_type )
{
    FR_GET_STRUCT( Sprite, self )->blend_type = NUM2INT( vblend_type );
    return vblend_type;
}
static VALUE Sprite_get_blend_type( VALUE self )
{
    return INT2FIX( FR_GET_STRUCT( Sprite, self )->blend_type );
}
static VALUE Sprite_set_mirror( VALUE self, VALUE vmirror )
{
    FR_GET_STRUCT( Sprite, self )->vmirror = FR_IS_TRUE( NUM2INT( vmirror ) );
    return vmirror;
}
static VALUE Sprite_get_mirror( VALUE self )
{
    return INT2FIX( FR_GET_STRUCT( Sprite, self )->vmirror );
}
static VALUE Sprite_set_opacity( VALUE self, VALUE vopacity )
{
    FR_GET_STRUCT( Sprite, self )->opacity = FR_0_255( NUM2INT( vopacity) );
    return vopacity;
}
static VALUE Sprite_get_opacity( VALUE self )
{
    return INT2FIX( FR_GET_STRUCT( Sprite, self )->opacity );
}
static VALUE Sprite_set_ox( VALUE self, VALUE vox )
{
    FR_GET_STRUCT( Sprite, self )->ox = NUM2INT( vox );
    return vox;
}
static VALUE Sprite_get_ox( VALUE self )
{
    return INT2FIX( FR_GET_STRUCT( Sprite, self )->ox );
}
static VALUE Sprite_set_oy( VALUE self, VALUE voy )
{
    FR_GET_STRUCT( Sprite, self )->oy = NUM2INT( voy );
    return voy;
}
static VALUE Sprite_get_oy( VALUE self )
{
    return INT2FIX( FR_GET_STRUCT( Sprite, self )->oy );
}
static VALUE Sprite_set_color( VALUE self, VALUE vcolor )
{
    FR_TYPECHECK( Color, vcolor );
    Color_copy( FR_GET_STRUCT( Sprite, self )->vcolor, vcolor );
    return vcolor;
}
static VALUE Sprite_get_color( VALUE self )
{
    return FR_GET_STRUCT( Sprite, self )->vcolor;
}
static VALUE Sprite_set_tone( VALUE self, VALUE vtone )
{
    FR_TYPECHECK( Tone, vtone );
    Tone_copy( FR_GET_STRUCT( Sprite, self )->vtone, vtone );
    return vtone;
}
static VALUE Sprite_get_tone( VALUE self )
{
    return FR_GET_STRUCT( Sprite, self )->vtone;
}
static VALUE Sprite_set_visible( VALUE self, VALUE vvisible )
{
    FR_GET_STRUCT( Sprite, self )->vvisible = FR_IS_TRUE( vvisible );
    return vvisible;
}
static VALUE Sprite_get_visible( VALUE self )
{
    return FR_GET_STRUCT( Sprite, self )->vvisible;
}


/*--------------------------------------------------------------------
   SpriteNX̓draw
 ---------------------------------------------------------------------*/
static void Sprite_internal_draw( VALUE self, int ox, int oy )
{
    struct FR_Sprite *sprite = FR_GET_STRUCT( Sprite, self );
    struct FR_Rect *rect = FR_GET_STRUCT( Rect, sprite->vrect );
    struct FR_Color* color = FR_GET_STRUCT( Color, sprite->vcolor );
    struct FR_Tone* tone = FR_GET_STRUCT( Tone, sprite->vtone );
    struct FR_Bitmap *bitmap;
    float angle;

    if( sprite->vbitmap == Qnil || FR_IS_TRUE(sprite->vdispose) ||
        FR_IS_FALSE(sprite->vvisible) || ( sprite->flash_delete == 1 && sprite->flash_count > 0 ) )
    {
        return;
    }

    bitmap = FR_GET_STRUCT( Bitmap, sprite->vbitmap );
    if( FR_IS_TRUE(bitmap->vdispose) )
    {
        return;
    }

    switch( sprite->blend_type )
    {
    case 0:          /*  */
        g_pD3DDevice->lpVtbl->SetRenderState(g_pD3DDevice, D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);
        g_pD3DDevice->lpVtbl->SetRenderState(g_pD3DDevice, D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA);
        break;
    case 1:          /* Z̐ݒ */
        g_pD3DDevice->lpVtbl->SetRenderState(g_pD3DDevice, D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);
        g_pD3DDevice->lpVtbl->SetRenderState(g_pD3DDevice, D3DRS_DESTBLEND, D3DBLEND_ONE);
        break;
    case 2:          /* Z̐ݒ */
        g_pD3DDevice->lpVtbl->SetRenderState(g_pD3DDevice, D3DRS_SRCBLEND, D3DBLEND_ZERO);
        g_pD3DDevice->lpVtbl->SetRenderState(g_pD3DDevice, D3DRS_DESTBLEND, D3DBLEND_INVSRCCOLOR);
        break;
    }

    angle = -3.141592653589793115997963468544185161590576171875f / 180.0f * sprite->angle;

    {
        TLVERTX VertexDataTbl[6];

        float sina = sin(angle);
        float cosa = cos(angle);
        float data1x = sprite->zoom_x * cosa;
        float data2x = sprite->zoom_x * sina;
        float data1y = sprite->zoom_y * sina;
        float data2y = sprite->zoom_y * cosa;
        float tu1 = rect->x / bitmap->real_width;
        float tu2 = (rect->x + rect->width) / bitmap->real_width;
        float tv1 = rect->y / bitmap->real_height;
        float tv2 = (rect->y + rect->height) / bitmap->real_height;
        float centerx = -sprite->ox;
        float centery = -sprite->oy;
        float width = rect->width;
        float height = rect->height;
        float basex = sprite->x - ox;
        float basey = sprite->y - oy;

        /* _P */
        VertexDataTbl[0].x =  centerx * data1x - centery * data1y + basex;
        VertexDataTbl[0].y =  centerx * data2x + centery * data2y + basey;
        /* _Q */
        VertexDataTbl[1].x = VertexDataTbl[3].x =  (centerx+width) * data1x - centery * data1y + basex;
        VertexDataTbl[1].y = VertexDataTbl[3].y =  (centerx+width) * data2x + centery * data2y + basey;
        /* _R */
        VertexDataTbl[4].x =  (centerx+width) * data1x - (centery+height) * data1y + basex;
        VertexDataTbl[4].y =  (centerx+width) * data2x + (centery+height) * data2y + basey;
        /* _S */
        VertexDataTbl[2].x = VertexDataTbl[5].x =  centerx * data1x - (centery+height) * data1y + basex;
        VertexDataTbl[2].y = VertexDataTbl[5].y =  centerx * data2x + (centery+height) * data2y + basey;
        /* _F */
        VertexDataTbl[0].color  =  
        VertexDataTbl[1].color  =  
        VertexDataTbl[2].color  =  
        VertexDataTbl[3].color  =  
        VertexDataTbl[4].color  =  
        VertexDataTbl[5].color  =  D3DCOLOR_ARGB(sprite->opacity,255,255,255);
        /* yW */
        VertexDataTbl[0].z      =  
        VertexDataTbl[1].z      =  
        VertexDataTbl[2].z      =  
        VertexDataTbl[3].z      =  
        VertexDataTbl[4].z      =  
        VertexDataTbl[5].z      =  0.0f;
        /* eNX`W */
        VertexDataTbl[0].tu     =  VertexDataTbl[5].tu = VertexDataTbl[2].tu = tu1;
        VertexDataTbl[0].tv     =  
        VertexDataTbl[1].tv     =  VertexDataTbl[3].tv = tv1;
        VertexDataTbl[1].tu     =  VertexDataTbl[3].tu = VertexDataTbl[4].tu = tu2;
        VertexDataTbl[4].tv     =  VertexDataTbl[5].tv = VertexDataTbl[2].tv = tv2;

        if( color->c != 0 || sprite->flash_count > 0 ||
            tone->red != 0 ||
            tone->green != 0 ||
            tone->blue != 0 ||
            tone->gray != 0 )
        {
            D3DXVECTOR4 c;
            D3DXVECTOR4 t;

            // colorflashɎw肳ꂽꍇ
            if( color->c != 0 && sprite->flash_count > 0 )
            {
                if( (int)color->alpha > (int)sprite->flash_alpha * sprite->flash_count / sprite->flash_count_start )
                {
                    c.x = color->red / 255.0f;
                    c.y = color->green / 255.0f;
                    c.z = color->blue / 255.0f;
                    c.w = color->alpha / 255.0f;
                }
                else
                {
                    c.x = sprite->flash_red / 255.0f;
                    c.y = sprite->flash_green / 255.0f;
                    c.z = sprite->flash_blue / 255.0f;
                    c.w = (int)sprite->flash_alpha * sprite->flash_count / sprite->flash_count_start / 255.0f;
                }
            }
            else if( color->c != 0 )
            {
                c.x = color->red / 255.0f;
                c.y = color->green / 255.0f;
                c.z = color->blue / 255.0f;
                c.w = color->alpha / 255.0f;
            }
            else if( sprite->flash_count > 0 )
            {
                c.x = sprite->flash_red / 255.0f;
                c.y = sprite->flash_green / 255.0f;
                c.z = sprite->flash_blue / 255.0f;
                c.w = (int)sprite->flash_alpha * sprite->flash_count / sprite->flash_count_start / 255.0f;
            }
            else
            {
                c.x = 0;
                c.y = 0;
                c.z = 0;
                c.w = 0;
            }

            if( tone->red != 0 ||
                tone->green != 0 ||
                tone->blue != 0 ||
                tone->gray != 0 )
            {
                t.x = tone->red / 255.0f;
                t.y = tone->green / 255.0f;
                t.z = tone->blue / 255.0f;
                t.w = tone->gray / 255.0f;
            }
            else
            {
                t.x = 0;
                t.y = 0;
                t.z = 0;
                t.w = 0;
            }

            m_pEffect->lpVtbl->SetVector( m_pEffect, g_hcolor_sprite, &c );
            m_pEffect->lpVtbl->SetVector( m_pEffect, g_htone_sprite, &t );
            m_pEffect->lpVtbl->SetTexture( m_pEffect, "Tex", (IDirect3DBaseTexture9*)bitmap->pD3DTexture);
            m_pEffect->lpVtbl->SetTechnique( m_pEffect, m_hTechnique_sprite );
            m_pEffect->lpVtbl->Begin( m_pEffect, NULL, 0 );
            m_pEffect->lpVtbl->BeginPass( m_pEffect, 0 );
            /* ` */
            g_pD3DDevice->lpVtbl->DrawPrimitiveUP( g_pD3DDevice, D3DPT_TRIANGLELIST, 2, VertexDataTbl, sizeof(TLVERTX) );
            m_pEffect->lpVtbl->EndPass( m_pEffect );
            m_pEffect->lpVtbl->End( m_pEffect );
        }
        else
        {
            /* eNX`Zbg */
            g_pD3DDevice->lpVtbl->SetTexture(g_pD3DDevice, 0, (IDirect3DBaseTexture9*)bitmap->pD3DTexture);

            /* ` */
            g_pD3DDevice->lpVtbl->DrawPrimitiveUP(g_pD3DDevice, D3DPT_TRIANGLELIST, 2, VertexDataTbl, sizeof(TLVERTX));
        }
    }
}


/*********************************************************************
 * PlaneNX
 *
 * `ێNXB
 *********************************************************************/

/*--------------------------------------------------------------------
   QƂȂȂƂGCĂ΂֐
 ---------------------------------------------------------------------*/
static void release_Plane( struct FR_Plane* plane )
{
    free( plane );
}

/*--------------------------------------------------------------------
   Planemark֐
 ---------------------------------------------------------------------*/
static void mark_Plane( struct FR_Plane *plane )
{
    rb_gc_mark( plane->vbitmap );
    rb_gc_mark( plane->vviewport );
    rb_gc_mark( plane->vcolor );
    rb_gc_mark( plane->vtone );
}

/*--------------------------------------------------------------------
   PlaneNXallocateBmۂׂinitializeOɌĂ΂B
 ---------------------------------------------------------------------*/
static VALUE Plane_allocate( VALUE klass )
{
    VALUE obj;
    struct FR_Plane *plane;

    /* 擾PlaneIuWFNg */
    plane = malloc(sizeof(struct FR_Plane));
    if( plane == NULL ) rb_raise( eFreeRGSSError, "̎擾Ɏs܂ - Plane_allocate" );
    obj = Data_Wrap_Struct(klass, mark_Plane, release_Plane, plane);

    plane->internal_draw = Plane_internal_draw;
    plane->vdispose = Qfalse;
    plane->vbitmap = Qnil;
    plane->vviewport = Qnil;
    plane->vcolor = Color_allocate( cColor );
    plane->vtone = Tone_allocate( cTone );
    plane->vvisible = Qtrue;
    plane->y = 0;
    plane->z = 0;
    plane->ox = 0;
    plane->oy = 0;
    plane->zoom_x = 1.0f;
    plane->zoom_y = 1.0f;
    plane->opacity = 255;
    plane->blend_type = 0;

    return obj;
}

/*--------------------------------------------------------------------
   PlaneNXInitialize
 ---------------------------------------------------------------------*/
static VALUE Plane_initialize( int argc, VALUE *argv, VALUE self )
{
    struct FR_Plane *plane = FR_GET_STRUCT( Plane, self );
    struct FR_Viewport *vp;
    VALUE vviewport;

    rb_scan_args( argc, argv, "01", &vviewport );

    if( vviewport != Qnil )
    {
        FR_TYPECHECK( Viewport, vviewport ); 
        plane->vviewport = vviewport;
        vp = (struct FR_Viewport *)DATA_PTR( vviewport );
        rb_ary_push( vp->vsprites, self );
    }
    else
    {
        rb_ary_push( g_graphics.vsprites, self );
    }
    return self;
}

static VALUE Plane_set_bitmap( VALUE self, VALUE vbitmap )
{
    struct FR_Plane *plane = FR_GET_STRUCT( Plane, self );
    FR_TYPECHECK( Bitmap, vbitmap );
    plane->vbitmap = vbitmap;
    return vbitmap;
}

static VALUE Plane_dispose( VALUE self )
{
    struct FR_Plane *plane = FR_GET_STRUCT( Plane, self );
    plane->vdispose = Qtrue;
    if( plane->vviewport == Qnil )
    {
        rb_ary_delete( g_graphics.vsprites, self );
    }
    else
    {
        rb_ary_delete( FR_GET_STRUCT( Viewport, plane->vviewport )->vsprites, self );
    }
    return self;
}
static VALUE Plane_get_dispose( VALUE self )
{
    return FR_GET_STRUCT( Plane, self )->vdispose;
}

static VALUE Plane_get_bitmap( VALUE self )
{
    return FR_GET_STRUCT( Plane, self )->vbitmap;
}
static VALUE Plane_set_viewport( VALUE self, VALUE vviewport )
{
    struct FR_Plane *plane = FR_GET_STRUCT( Plane, self );
    if( plane->vviewport != Qnil )
    {
        FR_TYPECHECK( Viewport, vviewport );
        rb_ary_delete( FR_GET_STRUCT( Viewport, plane->vviewport )->vsprites, self );
    }
    plane->vviewport = vviewport;
    rb_ary_push( FR_GET_STRUCT( Viewport, plane->vviewport )->vsprites, self );
    return vviewport;
}
static VALUE Plane_get_viewport( VALUE self )
{
    return FR_GET_STRUCT( Plane, self )->vviewport;
}
static VALUE Plane_set_z( VALUE self, VALUE vz )
{
    FR_GET_STRUCT( Plane, self )->z = NUM2INT( vz );
    return vz;
}
static VALUE Plane_get_z( VALUE self )
{
    return INT2FIX( FR_GET_STRUCT( Plane, self )->z );
}
static VALUE Plane_set_zoom_x( VALUE self, VALUE vzoom_x )
{
    FR_GET_STRUCT( Plane, self )->zoom_x = NUM2DBL( vzoom_x );
    return vzoom_x;
}
static VALUE Plane_get_zoom_x( VALUE self )
{
    return rb_float_new( FR_GET_STRUCT( Plane, self )->zoom_x );
}
static VALUE Plane_set_zoom_y( VALUE self, VALUE vzoom_y )
{
    FR_GET_STRUCT( Plane, self )->zoom_y = NUM2DBL( vzoom_y );
    return vzoom_y;
}
static VALUE Plane_get_zoom_y( VALUE self )
{
    return rb_float_new( FR_GET_STRUCT( Plane, self )->zoom_y );
}
static VALUE Plane_set_blend_type( VALUE self, VALUE vblend_type )
{
    FR_GET_STRUCT( Plane, self )->blend_type = NUM2INT( vblend_type );
    return vblend_type;
}
static VALUE Plane_get_blend_type( VALUE self )
{
    return INT2FIX( FR_GET_STRUCT( Plane, self )->blend_type );
}
static VALUE Plane_set_opacity( VALUE self, VALUE vopacity )
{
    FR_GET_STRUCT( Plane, self )->opacity = FR_0_255( NUM2INT( vopacity ) );
    return vopacity;
}
static VALUE Plane_get_opacity( VALUE self )
{
    return INT2FIX( FR_GET_STRUCT( Plane, self )->opacity );
}
static VALUE Plane_set_ox( VALUE self, VALUE vox )
{
    FR_GET_STRUCT( Plane, self )->ox = NUM2INT( vox );
    return vox;
}
static VALUE Plane_get_ox( VALUE self )
{
    return INT2FIX( FR_GET_STRUCT( Plane, self )->ox );
}
static VALUE Plane_set_oy( VALUE self, VALUE voy )
{
    FR_GET_STRUCT( Plane, self )->oy = NUM2INT( voy );
    return voy;
}
static VALUE Plane_get_oy( VALUE self )
{
    return INT2FIX( FR_GET_STRUCT( Plane, self )->oy );
}
static VALUE Plane_set_color( VALUE self, VALUE vcolor )
{
    FR_TYPECHECK( Color, vcolor );
    Color_copy( FR_GET_STRUCT( Plane, self )->vcolor, vcolor );
    return vcolor;
}
static VALUE Plane_get_color( VALUE self )
{
    return FR_GET_STRUCT( Plane, self )->vcolor;
}
static VALUE Plane_set_tone( VALUE self, VALUE vtone )
{
    FR_TYPECHECK( Tone, vtone );
    Tone_copy( FR_GET_STRUCT( Plane, self )->vtone, vtone );
    return vtone;
}
static VALUE Plane_get_tone( VALUE self )
{
    return FR_GET_STRUCT( Plane, self )->vtone;
}
static VALUE Plane_set_visible( VALUE self, VALUE vvisible )
{
    FR_GET_STRUCT( Plane, self )->vvisible = FR_IS_TRUE( vvisible );
    return vvisible;
}
static VALUE Plane_get_visible( VALUE self )
{
    return FR_GET_STRUCT( Plane, self )->vvisible;
}


/*--------------------------------------------------------------------
   PlaneNX̓draw
 ---------------------------------------------------------------------*/
static void Plane_internal_draw( VALUE self, int ox, int oy )
{
    struct FR_Plane *plane = FR_GET_STRUCT( Plane, self );
    struct FR_Color* color = FR_GET_STRUCT( Color, plane->vcolor );
    struct FR_Tone* tone = FR_GET_STRUCT( Tone, plane->vtone );
    struct FR_Bitmap *bitmap;
    float angle;

    if( plane->vbitmap == Qnil || FR_IS_TRUE(plane->vdispose) || FR_IS_FALSE(plane->vvisible) )
    {
        return;
    }

    bitmap = FR_GET_STRUCT( Bitmap, plane->vbitmap );
    if( FR_IS_TRUE(bitmap->vdispose) )
    {
        return;
    }

    switch( plane->blend_type )
    {
    case 0:          /*  */
        g_pD3DDevice->lpVtbl->SetRenderState(g_pD3DDevice, D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);
        g_pD3DDevice->lpVtbl->SetRenderState(g_pD3DDevice, D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA);
        break;
    case 1:          /* Z̐ݒ */
        g_pD3DDevice->lpVtbl->SetRenderState(g_pD3DDevice, D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);
        g_pD3DDevice->lpVtbl->SetRenderState(g_pD3DDevice, D3DRS_DESTBLEND, D3DBLEND_ONE);
        break;
    case 2:          /* Z̐ݒ */
        g_pD3DDevice->lpVtbl->SetRenderState(g_pD3DDevice, D3DRS_SRCBLEND, D3DBLEND_ZERO);
        g_pD3DDevice->lpVtbl->SetRenderState(g_pD3DDevice, D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA);
        break;
    }

    {
        TLVERTX VertexDataTbl[6];
        float tu1 = 0;
        float tu2 = (float)bitmap->width / bitmap->real_width;
        float tv1 = 0;
        float tv2 = (float)bitmap->height / bitmap->real_height;
        int x, y;

        for( y = 0; y < (g_WindowInfo.height + plane->oy) / (bitmap->height * plane->zoom_y); y++ )
        {
            for( x = 0; x < (g_WindowInfo.width + plane->ox) / (bitmap->width * plane->zoom_x); x++ )
            {
                /* _P */
                VertexDataTbl[0].x = -plane->ox + x * bitmap->width * plane->zoom_x;
                VertexDataTbl[0].y = -plane->oy + y * bitmap->height * plane->zoom_y;
                /* _Q */
                VertexDataTbl[1].x = VertexDataTbl[3].x = -plane->ox + (x+1) * bitmap->width * plane->zoom_x;
                VertexDataTbl[1].y = VertexDataTbl[3].y = -plane->oy + y * bitmap->height * plane->zoom_y;
                /* _R */
                VertexDataTbl[4].x = -plane->ox + (x+1) * bitmap->width * plane->zoom_x;
                VertexDataTbl[4].y = -plane->oy + (y+1) * bitmap->height * plane->zoom_y;
                /* _S */
                VertexDataTbl[2].x = VertexDataTbl[5].x = -plane->ox + x * bitmap->width * plane->zoom_x;
                VertexDataTbl[2].y = VertexDataTbl[5].y = -plane->oy + (y+1) * bitmap->height * plane->zoom_y;
                /* _F */
                VertexDataTbl[0].color  =  
                VertexDataTbl[1].color  =  
                VertexDataTbl[2].color  =  
                VertexDataTbl[3].color  =  
                VertexDataTbl[4].color  =  
                VertexDataTbl[5].color  =  D3DCOLOR_ARGB(plane->opacity,255,255,255);
                /* yW */
                VertexDataTbl[0].z      =  
                VertexDataTbl[1].z      =  
                VertexDataTbl[2].z      =  
                VertexDataTbl[3].z      =  
                VertexDataTbl[4].z      =  
                VertexDataTbl[5].z      =  0.0f;
                /* eNX`W */
                VertexDataTbl[0].tu     =  VertexDataTbl[5].tu = VertexDataTbl[2].tu = tu1;
                VertexDataTbl[0].tv     =  VertexDataTbl[1].tv = VertexDataTbl[3].tv = tv1;
                VertexDataTbl[1].tu     =  VertexDataTbl[3].tu = VertexDataTbl[4].tu = tu2;
                VertexDataTbl[4].tv     =  VertexDataTbl[5].tv = VertexDataTbl[2].tv = tv2;

                if( color->c != 0 ||
                    tone->red != 0 ||
                    tone->green != 0 ||
                    tone->blue != 0 ||
                    tone->gray != 0 )
                {
                    D3DXVECTOR4 c;
                    D3DXVECTOR4 t;

                    if( color->c != 0 )
                    {
                        c.x = color->red / 255.0f;
                        c.y = color->green / 255.0f;
                        c.z = color->blue / 255.0f;
                        c.w = color->alpha / 255.0f;
                    }
                    else
                    {
                        c.x = 0;
                        c.y = 0;
                        c.z = 0;
                        c.w = 0;
                    }

                    if( tone->red != 0 ||
                        tone->green != 0 ||
                        tone->blue != 0 ||
                        tone->gray != 0 )
                    {
                        t.x = tone->red / 255.0f;
                        t.y = tone->green / 255.0f;
                        t.z = tone->blue / 255.0f;
                        t.w = tone->gray / 255.0f;
                    }
                    else
                    {
                        t.x = 0;
                        t.y = 0;
                        t.z = 0;
                        t.w = 0;
                    }

                    m_pEffect->lpVtbl->SetVector( m_pEffect, g_hcolor_sprite, &c );
                    m_pEffect->lpVtbl->SetVector( m_pEffect, g_htone_sprite, &t );
                    m_pEffect->lpVtbl->SetTexture( m_pEffect, "Tex", (IDirect3DBaseTexture9*)bitmap->pD3DTexture);
                    m_pEffect->lpVtbl->SetTechnique( m_pEffect, m_hTechnique_sprite );
                    m_pEffect->lpVtbl->Begin( m_pEffect, NULL, 0 );
                    m_pEffect->lpVtbl->BeginPass( m_pEffect, 0 );
                    /* ` */
                    g_pD3DDevice->lpVtbl->DrawPrimitiveUP( g_pD3DDevice, D3DPT_TRIANGLELIST, 2, VertexDataTbl, sizeof(TLVERTX) );
                    m_pEffect->lpVtbl->EndPass( m_pEffect );
                    m_pEffect->lpVtbl->End( m_pEffect );
                }
                else
                {
                    /* eNX`Zbg */
                    g_pD3DDevice->lpVtbl->SetTexture(g_pD3DDevice, 0, (IDirect3DBaseTexture9*)bitmap->pD3DTexture);

                    /* ` */
                    g_pD3DDevice->lpVtbl->DrawPrimitiveUP(g_pD3DDevice, D3DPT_TRIANGLELIST, 2, VertexDataTbl, sizeof(TLVERTX));
                }
            }
        }
    }
}


/*********************************************************************
 * WindowNX
 *
 * `ێNXB
 *********************************************************************/

/*--------------------------------------------------------------------
   QƂȂȂƂGCĂ΂֐
 ---------------------------------------------------------------------*/
static void release_Window( struct FR_Window* window )
{
    free( window );
}

/*--------------------------------------------------------------------
   Windowmark֐
 ---------------------------------------------------------------------*/
static void mark_Window( struct FR_Window *window )
{
    rb_gc_mark( window->vwindowskin );
    rb_gc_mark( window->vcursor_rect );
    rb_gc_mark( window->vviewport );
    rb_gc_mark( window->vcontents );
}

/*--------------------------------------------------------------------
   WindowNXallocateBmۂׂinitializeOɌĂ΂B
 ---------------------------------------------------------------------*/
static VALUE Window_allocate( VALUE klass )
{
    VALUE obj;
    struct FR_Window *window;

    /* 擾WindowIuWFNg */
    window = malloc(sizeof(struct FR_Window));
    if( window == NULL ) rb_raise( eFreeRGSSError, "̎擾Ɏs܂ - Window_allocate" );
    obj = Data_Wrap_Struct(klass, mark_Window, release_Window, window);

    window->internal_draw = Window_internal_draw;
    window->vdispose = Qfalse;
    window->vwindowskin = Qnil;
    window->vcontents = Qnil;
    window->vviewport = Qnil;
    window->vcursor_rect = Rect_allocate( cRect );
    window->vvisible = Qtrue;
    window->x = 0;
    window->y = 0;
    window->z = 0;
    window->ox = 0;
    window->oy = 0;
    window->opacity = 255;
    window->vactive = Qtrue;
    window->vpause = Qfalse;
    window->width = 0;
    window->height = 0;
    window->back_opacity = 255;
    window->contents_opacity = 255;
    window->openness = 255;
    window->pause_count = 0;
    window->active_count = 100;
    window->active_flag = -3;

    return obj;
}

/*--------------------------------------------------------------------
   WindowNXInitialize
 ---------------------------------------------------------------------*/
static VALUE Window_initialize( int argc, VALUE *argv, VALUE self )
{
    struct FR_Window *window = FR_GET_STRUCT( Window, self );
    VALUE vviewport;

    rb_scan_args( argc, argv, "01", &vviewport );

    if( vviewport != Qnil )
    {
        FR_TYPECHECK( Viewport, vviewport ); 
        window->vviewport = vviewport;
        rb_ary_push( FR_GET_STRUCT( Viewport, vviewport )->vsprites, self );
    }
    else
    {
        rb_ary_push( g_graphics.vsprites, self );
    }
    return self;
}

static VALUE Window_set_windowskin( VALUE self, VALUE vbitmap )
{
    struct FR_Window *window = FR_GET_STRUCT( Window, self );

    FR_TYPECHECK( Bitmap, vbitmap );
    window->vwindowskin = vbitmap;

    return vbitmap;
}

static VALUE Window_set_contents( VALUE self, VALUE vbitmap )
{
    struct FR_Window *window = FR_GET_STRUCT( Window, self );

    FR_TYPECHECK( Bitmap, vbitmap );
    window->vcontents = vbitmap;

    return vbitmap;
}

static VALUE Window_dispose( VALUE self )
{
    struct FR_Window *window = FR_GET_STRUCT( Window, self );
    window->vdispose = Qtrue;
    if( window->vviewport == Qnil )
    {
        rb_ary_delete( g_graphics.vsprites, self );
    }
    else
    {
        rb_ary_delete( ((struct FR_Viewport*)DATA_PTR( window->vviewport ))->vsprites, self );
    }
    return self;
}
static VALUE Window_get_dispose( VALUE self )
{
    return FR_GET_STRUCT( Window, self )->vdispose;
}

static VALUE Window_update( VALUE self )
{
    struct FR_Window *window = FR_GET_STRUCT( Window, self );
    if( FR_IS_TRUE( window->vpause ) )
    {
        window->pause_count++;
        if( window->pause_count > 63 )
        {
            window->pause_count = 0;
        }
    }
    else
    {
        window->pause_count = 0;
    }
    if( FR_IS_TRUE( window->vactive ) )
    {
        window->active_count += window->active_flag;
        if( window->active_count < 40 || window->active_count == 100 )
        {
            window->active_flag *= -1;
        }
    }
    else
    {
        window->active_count = 100;
        window->active_flag = -1;
    }
    return self;
}

static VALUE Window_get_windowskin( VALUE self )
{
    return FR_GET_STRUCT( Window, self )->vwindowskin;
}
static VALUE Window_get_contents( VALUE self )
{
    return FR_GET_STRUCT( Window, self )->vcontents;
}
static VALUE Window_set_cursor_rect( VALUE self, VALUE vrect )
{
    FR_TYPECHECK( Rect, vrect );
    Rect_copy( FR_GET_STRUCT( Window, self )->vcursor_rect, vrect );
    return vrect;
}
static VALUE Window_get_cursor_rect( VALUE self )
{
    return FR_GET_STRUCT( Window, self )->vcursor_rect;
}
static VALUE Window_set_width( VALUE self, VALUE vwidth )
{
    FR_GET_STRUCT( Window, self )->width = NUM2INT( vwidth ) ;
    return vwidth;
}
static VALUE Window_get_width( VALUE self )
{
    return INT2FIX( FR_GET_STRUCT( Window, self )->width ) ;
}
static VALUE Window_set_height( VALUE self, VALUE vheight )
{
    FR_GET_STRUCT( Window, self )->height = NUM2INT( vheight ) ;
    return vheight;
}
static VALUE Window_get_height( VALUE self )
{
    return INT2FIX( FR_GET_STRUCT( Window, self )->height ) ;
}
static VALUE Window_set_viewport( VALUE self, VALUE vviewport )
{
    struct FR_Window *window = FR_GET_STRUCT( Window, self );
    if( window->vviewport != Qnil )
    {
        FR_TYPECHECK( Viewport, vviewport );
        rb_ary_delete( FR_GET_STRUCT( Viewport, window->vviewport )->vsprites, self );
    }
    window->vviewport = vviewport;
    rb_ary_push( FR_GET_STRUCT( Viewport, window->vviewport )->vsprites, self );
    return vviewport;
}
static VALUE Window_get_viewport( VALUE self )
{
    return FR_GET_STRUCT( Window, self )->vviewport;
}
static VALUE Window_set_x( VALUE self, VALUE vx )
{
    FR_GET_STRUCT( Window, self )->x = NUM2INT( vx );
    return vx;
}
static VALUE Window_get_x( VALUE self )
{
    return INT2FIX( FR_GET_STRUCT( Window, self )->x );
}
static VALUE Window_set_y( VALUE self, VALUE vy )
{
    FR_GET_STRUCT( Window, self )->y = NUM2INT( vy );
    return vy;
}
static VALUE Window_get_y( VALUE self )
{
    return INT2FIX( FR_GET_STRUCT( Window, self )->y );
}
static VALUE Window_set_z( VALUE self, VALUE vz )
{
    FR_GET_STRUCT( Window, self )->z = NUM2INT( vz );
    return vz;
}
static VALUE Window_get_z( VALUE self )
{
    return INT2FIX( FR_GET_STRUCT( Window, self )->z );
}
static VALUE Window_set_opacity( VALUE self, VALUE vopacity )
{
    FR_GET_STRUCT( Window, self )->opacity = FR_0_255( NUM2INT( vopacity ) );
    return vopacity;
}
static VALUE Window_get_opacity( VALUE self )
{
    return INT2FIX( FR_GET_STRUCT( Window, self )->opacity );
}
static VALUE Window_set_contents_opacity( VALUE self, VALUE vcontents_opacity )
{
    FR_GET_STRUCT( Window, self )->contents_opacity = FR_0_255( NUM2INT( vcontents_opacity ) );
    return vcontents_opacity;
}
static VALUE Window_get_contents_opacity( VALUE self )
{
    return INT2FIX( FR_GET_STRUCT( Window, self )->contents_opacity );
}
static VALUE Window_set_back_opacity( VALUE self, VALUE vback_opacity )
{
    FR_GET_STRUCT( Window, self )->back_opacity = FR_0_255( NUM2INT( vback_opacity ) );
    return vback_opacity;
}
static VALUE Window_get_back_opacity( VALUE self )
{
    return INT2FIX( FR_GET_STRUCT( Window, self )->back_opacity );
}
static VALUE Window_set_ox( VALUE self, VALUE vox )
{
    FR_GET_STRUCT( Window, self )->ox = NUM2INT( vox );
    return vox;
}
static VALUE Window_get_ox( VALUE self )
{
    return INT2FIX( FR_GET_STRUCT( Window, self )->ox );
}
static VALUE Window_set_oy( VALUE self, VALUE voy )
{
    FR_GET_STRUCT( Window, self )->oy = NUM2INT( voy );
    return voy;
}
static VALUE Window_get_oy( VALUE self )
{
    return INT2FIX( FR_GET_STRUCT( Window, self )->oy );
}
static VALUE Window_set_visible( VALUE self, VALUE vvisible )
{
    FR_GET_STRUCT( Window, self )->vvisible = FR_IS_TRUE( vvisible );
    return vvisible;
}
static VALUE Window_get_visible( VALUE self )
{
    return FR_GET_STRUCT( Window, self )->vvisible;
}
static VALUE Window_set_active( VALUE self, VALUE vactive )
{
    FR_GET_STRUCT( Window, self )->vactive = FR_IS_TRUE( vactive );
    return vactive;
}
static VALUE Window_get_active( VALUE self )
{
    return FR_GET_STRUCT( Window, self )->vactive;
}
static VALUE Window_set_pause( VALUE self, VALUE vpause )
{
    FR_GET_STRUCT( Window, self )->vpause = FR_IS_TRUE( vpause );
    return vpause;
}
static VALUE Window_get_pause( VALUE self )
{
    return FR_GET_STRUCT( Window, self )->vpause;
}
static VALUE Window_set_openness( VALUE self, VALUE vopenness )
{
    FR_GET_STRUCT( Window, self )->openness = FR_0_255( NUM2INT( vopenness ) );
    return vopenness;
}
static VALUE Window_get_openness( VALUE self )
{
    return INT2FIX( FR_GET_STRUCT( Window, self )->openness );
}


/*--------------------------------------------------------------------
   WindowNX̓draw
 ---------------------------------------------------------------------*/
#define OPENNESS_Y( y, height, openness ) ( (float)y + (windowopnnessy - y) * (255-openness) / 255.0f )
#define OPENNESS_H( y, height, openness ) ( height * openness / 255.0f )
static float windowopnnessy; /* ߂Ȃ */
static void Window_draw( int x, int y, int width, int height,
                         int tx, int ty, int twidth, int theight,
                         int opacity, struct FR_Bitmap* bitmap, int openness )
{
    TLVERTX VertexDataTbl[6];

    float tu1 = (float)tx / bitmap->real_width;
    float tu2 = (float)(tx + twidth) / bitmap->real_width;
    float tv1 = (float)ty / bitmap->real_height;
    float tv2 = (float)(ty + theight) / bitmap->real_height;

    /* _P */
    VertexDataTbl[0].x =  x;
    VertexDataTbl[0].y =  OPENNESS_Y( y, height, openness );
    /* _Q */
    VertexDataTbl[1].x = VertexDataTbl[3].x = x + width;
    VertexDataTbl[1].y = VertexDataTbl[3].y = OPENNESS_Y( y, height, openness );
    /* _R */
    VertexDataTbl[4].x = x + width;
    VertexDataTbl[4].y = OPENNESS_Y( y, height, openness ) + OPENNESS_H( y, height, openness );
    /* _S */
    VertexDataTbl[2].x = VertexDataTbl[5].x = x;
    VertexDataTbl[2].y = VertexDataTbl[5].y = OPENNESS_Y( y, height, openness ) + OPENNESS_H( y, height, openness );
    /* _F */
    VertexDataTbl[0].color  =  
    VertexDataTbl[1].color  =  
    VertexDataTbl[2].color  =  
    VertexDataTbl[3].color  =  
    VertexDataTbl[4].color  =  
    VertexDataTbl[5].color  =  D3DCOLOR_ARGB(opacity,255,255,255);
    /* yW */
    VertexDataTbl[0].z      =  
    VertexDataTbl[1].z      =  
    VertexDataTbl[2].z      =  
    VertexDataTbl[3].z      =  
    VertexDataTbl[4].z      =  
    VertexDataTbl[5].z      =  0.0f;
    /* eNX`W */
    VertexDataTbl[0].tu     =  VertexDataTbl[5].tu = VertexDataTbl[2].tu = tu1;
    VertexDataTbl[0].tv     =  VertexDataTbl[1].tv = VertexDataTbl[3].tv = tv1;
    VertexDataTbl[1].tu     =  VertexDataTbl[3].tu = VertexDataTbl[4].tu = tu2;
    VertexDataTbl[4].tv     =  VertexDataTbl[5].tv = VertexDataTbl[2].tv = tv2;

    /* eNX`Zbg */
    g_pD3DDevice->lpVtbl->SetTexture(g_pD3DDevice, 0, (IDirect3DBaseTexture9*)bitmap->pD3DTexture);

    /* ` */
    g_pD3DDevice->lpVtbl->DrawPrimitiveUP(g_pD3DDevice, D3DPT_TRIANGLELIST, 2, VertexDataTbl, sizeof(TLVERTX));
}

static void Window_internal_draw( VALUE self, int ox, int oy )
{
    struct FR_Window *window = FR_GET_STRUCT( Window, self );
    struct FR_Rect *cursor_rect = FR_GET_STRUCT( Rect, window->vcursor_rect );
    struct FR_Bitmap *windowskin;
    struct FR_Bitmap *contents;
    int x, y;;

    if( window->vwindowskin == Qnil || window->vcontents == Qnil || FR_IS_TRUE(window->vdispose) ||
        FR_IS_FALSE(window->vvisible) )
    {
        return;
    }

    windowskin = FR_GET_STRUCT( Bitmap, window->vwindowskin );
    contents = FR_GET_STRUCT( Bitmap, window->vcontents );
    if( FR_IS_TRUE(windowskin->vdispose) || FR_IS_TRUE(contents->vdispose) )
    {
        return;
    }

    g_pD3DDevice->lpVtbl->SetRenderState(g_pD3DDevice, D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);
    g_pD3DDevice->lpVtbl->SetRenderState(g_pD3DDevice, D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA);

    windowopnnessy = window->y + window->height/2;

    /* wi` */
    Window_draw( window->x+2, window->y+2, window->width-4, window->height-4, 0, 0, 64, 64, window->back_opacity * window->opacity / 255, windowskin, window->openness );

    for( y = 0; y < (window->height-4) / 64 + 1; y++ )
    {
        int ysize = 64;
        if( y == (window->height-4) / 64 )
        {
            ysize = (window->height-4) % 64;
        }
        for( x = 0; x < (window->width-4) / 64 + 1; x++ )
        {
            int xsize = 64;
            if( x == (window->width-4) / 64 )
            {
                xsize = (window->width-4) % 64;
            }
            Window_draw( x * 64 + window->x + 2, y * 64 + window->y + 2, xsize, ysize, 0, 64, xsize, ysize, window->back_opacity * window->opacity / 255, windowskin, window->openness );
        }
    }

    /* g` */
    Window_draw( window->x, window->y, 16, 16, 64, 0, 16, 16, window->opacity, windowskin, window->openness );
    Window_draw( window->x, window->y + window->height - 16, 16, 16, 64, 48, 16, 16, window->opacity, windowskin, window->openness );
    Window_draw( window->x + window->width - 16, window->y, 16, 16, 112, 0, 16, 16, window->opacity, windowskin, window->openness );
    Window_draw( window->x + window->width - 16, window->y + window->height - 16, 16, 16, 112, 48, 16, 16, window->opacity, windowskin, window->openness );

    for( x = 0; x < window->width / 32; x++ )
    {
        int xsize = 32;
        if( x == window->width / 32 - 1)
        {
            xsize = window->width % 32;
        }
        Window_draw( x * 32 + window->x + 16, window->y, xsize, 16, 80, 0, xsize, 16, window->opacity, windowskin, window->openness );
        Window_draw( x * 32 + window->x + 16, window->y + window->height - 16, xsize, 16, 80, 48, xsize, 16, window->opacity, windowskin, window->openness );
    }
    for( y = 0; y < window->height / 32; y++ )
    {
        int ysize = 32;
        if( y == window->height / 32 - 1)
        {
            ysize = window->height % 32;
        }
        Window_draw( window->x, y * 32 + window->y + 16, 16, ysize, 64, 16, 16, ysize, window->opacity, windowskin, window->openness );
        Window_draw( window->x + window->width - 16, y * 32 + window->y + 16, 16, ysize, 112, 16, 16, ysize, window->opacity, windowskin, window->openness );
    }

    if( window->openness < 255 )
    {
        return;
    }

    /* J[\` */
    {
        int x, y, width, height;
        struct FR_Rect* cursor_rect = FR_GET_STRUCT( Rect, window->vcursor_rect );

        if( cursor_rect->x < -16 )
        {
            x = -16;
        }
        else
        {
            x = cursor_rect->x;
        }
        if( cursor_rect->y < -16 )
        {
            y = -16;
        }
        else
        {
            y = cursor_rect->y;
        }
        if( cursor_rect->x + cursor_rect->width + 16 < window->width )
        {
            width = cursor_rect->width;
        }
        else
        {
            width = cursor_rect->width - ((cursor_rect->x + cursor_rect->width + 16) - window->width);
        }
        if( cursor_rect->y + cursor_rect->height + 16 < window->height )
        {
            height = cursor_rect->height;
        }
        else
        {
            height = cursor_rect->height - ((cursor_rect->y + cursor_rect->height + 16) - window->height);
        }
        if( width > 0 && height > 0 && x < window->width && y < window->height && x + width > 0 && y + height > 0 )
        {
            Window_draw( window->x + x + 18, window->y + y + 18, width - 4, height - 4, 66, 66, 28, 28, window->contents_opacity * window->active_count / 100, windowskin, window->openness );
            Window_draw( window->x + x + 16, window->y + y + 16, 2, 2, 64, 64, 2, 2, window->contents_opacity * window->active_count / 100, windowskin, window->openness );
            Window_draw( window->x + x + width + 14, window->y + y + 16, 2, 2, 94, 64, 2, 2, window->contents_opacity * window->active_count / 100, windowskin, window->openness );
            Window_draw( window->x + x + 16, window->y + y + height + 14, 2, 2, 64, 94, 2, 2, window->contents_opacity * window->active_count / 100, windowskin, window->openness );
            Window_draw( window->x + x + width + 14, window->y + y + height + 14, 2, 2, 94, 94, 2, 2, window->contents_opacity * window->active_count / 100, windowskin, window->openness );

            Window_draw( window->x + x + 18, window->y + y + 16, width - 4, 2, 66, 64, 28, 2, window->contents_opacity * window->active_count / 100, windowskin, window->openness );
            Window_draw( window->x + x + 18, window->y + y + height + 14, width - 4, 2, 66, 94, 28, 2, window->contents_opacity * window->active_count / 100, windowskin, window->openness );
            Window_draw( window->x + x + 16, window->y + y + 18, 2, height - 4, 64, 66, 2, 28, window->contents_opacity * window->active_count / 100, windowskin, window->openness );
            Window_draw( window->x + x + width + 14, window->y + y + 18, 2, height - 4, 94, 66, 2, 28, window->contents_opacity * window->active_count / 100, windowskin, window->openness );
        }
    }

    /* Rec` */
    {
        int x, y, width, height, tx, ty, twidth, theight;
        if( -window->ox < 0 )
        {
            x = 0;
            tx = window->ox;
        }
        else
        {
            x = -window->ox;
            tx = 0;
        }
        if( -window->oy < 0 )
        {
            y = 0;
            ty = window->oy;
        }
        else
        {
            y = -window->oy;
            ty = 0;
        }
        if( window->width - 32 < contents->width - window->ox )
        {
            if( window->ox > 0 )
            {
                width = window->width - 32;
                twidth = window->width - 32;
            }
            else
            {
                width = window->width - 32 + window->ox;
                twidth = window->width - 32 + window->ox;
            }
        }
        else
        {
            if( -window->ox > 0 )
            {
                width = contents->width;
                twidth = contents->width;
            }
            else
            {
                width = contents->width - window->ox;
                twidth = contents->width - tx;
            }
        }
        if( window->height - 32 < contents->height - window->oy )
        {
            if( window->oy > 0 )
            {
                height = window->height - 32;
                theight = window->height - 32;
            }
            else
            {
                height = window->height - 32 + window->oy;
                theight = window->height - 32 + window->oy;
            }
        }
        else
        {
            if( -window->oy > 0 )
            {
                height = contents->height;
                theight = contents->height;
            }
            else
            {
                height = contents->height - window->oy;
                theight = contents->height - ty;
            }
        }
        if( width >= 0 && height >= 0 &&
            x < window->width - 32 && y < window->height - 32 )
        {
            Window_draw( window->x + x + 16, window->y + y + 16, width, height,
                         tx, ty, twidth, theight, window->contents_opacity, contents, 255 );
        }

        /* ͂ݏo` */
        if( tx > 0 )
        {
            Window_draw( window->x + 3, window->y + window->height / 2 - 8, 8, 16,
                         80, 24, 8, 16, 255, windowskin, 255 );
        }
        if( ty > 0 )
        {
            Window_draw( window->x + window->width / 2 - 8, window->y + 3, 16, 8,
                         88, 16, 16, 8, 255, windowskin, 255 );
        }
        if( -window->ox + contents->width > window->width - 32 )
        {
            Window_draw( window->x + window->width - 11, window->y + window->height / 2 - 8, 8, 16,
                         104, 24, 8, 16, 255, windowskin, 255 );
        }
        if( -window->oy + contents->height > window->height - 32 && FR_IS_FALSE( window->vpause ) )
        {
            Window_draw( window->x + window->width / 2 - 8, window->y + window->height - 11, 16, 8,
                         88, 40, 16, 8, 255, windowskin, 255 );
        }
    }
    /* |[YTC */
    {
        int x[4] = {96, 112, 96, 112};
        int y[4] = {64, 64, 80, 80};
        if( FR_IS_TRUE( window->vpause ) )
        {
            Window_draw( window->x + window->width / 2 - 8, window->y + window->height - 16, 16, 16,
                         x[window->pause_count / 16], y[window->pause_count / 16], 16, 16, 255, windowskin, 255 );
        }
    }
}



/*********************************************************************
 * TableNX
 *
 * ȑzNXB
 *********************************************************************/

/*--------------------------------------------------------------------
   QƂȂȂƂGCĂ΂֐
 ---------------------------------------------------------------------*/
static void release_Table( struct FR_Table* table )
{
    if( table->memory ) free( table->memory );
    free( table );
}

/*--------------------------------------------------------------------
   TableNXallocateBmۂׂinitializeOɌĂ΂B
 ---------------------------------------------------------------------*/
static VALUE Table_allocate( VALUE klass )
{
    VALUE obj;
    struct FR_Table *table;

    /* 擾TableIuWFNg */
    table = malloc(sizeof(struct FR_Table));
    if( table == NULL ) rb_raise( eFreeRGSSError, "̎擾Ɏs܂ - Table_allocate" );
    obj = Data_Wrap_Struct(klass, 0, release_Table, table);

    table->memory = NULL;
    table->xsize = 0;
    table->ysize = 0;
    table->zsize = 0;

    return obj;
}

/*--------------------------------------------------------------------
   TableNXInitialize
 ---------------------------------------------------------------------*/
static VALUE Table_initialize( int argc, VALUE *argv, VALUE self )
{
    struct FR_Table *table = FR_GET_STRUCT( Table, self );
    VALUE vxsize, vysize, vzsize;

    rb_scan_args( argc, argv, "12", &vxsize, &vysize, &vzsize );

    table->xsize = vxsize == Qnil ? 1 : NUM2INT( vxsize );
    table->ysize = vysize == Qnil ? 1 : NUM2INT( vysize );
    table->zsize = vzsize == Qnil ? 1 : NUM2INT( vzsize );
    if( table->xsize != 0 && table->ysize != 0 && table->zsize != 0 )
    {
        table->memory = (short*)malloc( table->xsize * table->ysize * table->zsize * sizeof( short ) );
        if( table->memory == NULL ) rb_raise( eFreeRGSSError, "̎擾Ɏs܂ - Table_initialize" );
        ZeroMemory(table->memory, table->xsize * table->ysize * table->zsize * sizeof(short) );
    }
    table->count = argc;
    return self;
}


static VALUE Table_get( int argc, VALUE *argv, VALUE self )
{
    struct FR_Table *table = FR_GET_STRUCT( Table, self );
    VALUE vx, vy, vz;
    int x, y, z;

    switch( table->count )
    {
        case 1:
            rb_scan_args( argc, argv, "10", &vx );
            vy = INT2FIX( 1 );
            vz = INT2FIX( 1 );
            break;
        case 2:
            rb_scan_args( argc, argv, "20", &vx, &vy );
            vz = INT2FIX( 1 );
            break;
        case 3:
            rb_scan_args( argc, argv, "30", &vx, &vy, &vz );
            break;
        default:
            rb_raise( eFreeRGSSError, "͎̐ƓɂĂ - Table_[]" );
            break;
    }

    x = NUM2INT( vx );
    y = NUM2INT( vy );
    z = NUM2INT( vz );

    if( table->memory == NULL || x > table->xsize || y > table->ysize || z > table->zsize )
    {
        return Qnil;
    }

    return INT2FIX( table->memory[x + y * table->xsize + z * table->xsize * table->ysize] );
}

static VALUE Table_set( int argc, VALUE *argv, VALUE self )
{
    struct FR_Table *table = FR_GET_STRUCT( Table, self );
    VALUE vx, vy, vz, varg;
    int x, y, z;

    switch( table->count )
    {
        case 1:
            rb_scan_args( argc, argv, "20", &vx, &varg );
            vy = INT2FIX( 1 );
            vz = INT2FIX( 1 );
            break;
        case 2:
            rb_scan_args( argc, argv, "30", &vx, &vy, &varg );
            vz = INT2FIX( 1 );
            break;
        case 3:
            rb_scan_args( argc, argv, "40", &vx, &vy, &vz, &varg );
            break;
        default:
            rb_raise( eFreeRGSSError, "͎̐ƓɂĂ - Table_[]=" );
            break;
    }

    x = NUM2INT( vx );
    y = NUM2INT( vy );
    z = NUM2INT( vz );

    if( table->memory == NULL || x > table->xsize || y > table->ysize || z > table->zsize )
    {
        return Qnil;
    }

    table->memory[x + y * table->xsize + z * table->xsize * table->ysize] = FIX2INT( varg );
    return varg;
}

static VALUE Table_resize( int argc, VALUE *argv, VALUE self )
{
    struct FR_Table *table = FR_GET_STRUCT( Table, self );
    VALUE vxsize, vysize, vzsize;
    int xsize, ysize, zsize;
    short* temp;
    int x, y, z;

    rb_scan_args( argc, argv, "12", &vxsize, &vysize, &vzsize );

    xsize = vxsize == Qnil ? 1 : NUM2INT( vxsize );
    ysize = vysize == Qnil ? 1 : NUM2INT( vysize );
    zsize = vzsize == Qnil ? 1 : NUM2INT( vzsize );

    if( xsize == 0 || ysize == 0 || zsize == 0 )
    {
        table->memory = NULL;
        table->xsize = xsize;
        table->ysize = ysize;
        table->zsize = zsize;
        table->count = argc;
        return self;
    }

    temp = (short*)malloc( xsize * ysize * zsize * sizeof( short ) );
    if( temp == NULL ) rb_raise( eFreeRGSSError, "̎擾Ɏs܂ - Table_resize" );
    ZeroMemory(temp, xsize * ysize * zsize * sizeof(short) );

    for( z = 0; z < (table->zsize < zsize ? table->zsize : zsize ); z++ )
    {
        for( y = 0; y < (table->ysize < ysize ? table->ysize : ysize ); y++ )
        {
            for( x = 0; x < (table->xsize < xsize ? table->xsize : xsize ); x++ )
            {
                temp[x + y * xsize + z * xsize * ysize] = table->memory[x + y * table->xsize + z * table->xsize * table->ysize];
            }
        }
    }
    free( table->memory );
    table->memory = temp;
    table->xsize = xsize;
    table->ysize = ysize;
    table->zsize = zsize;
    table->count = argc;

    return self;
}


static VALUE Table_xsize( VALUE self )
{
    return INT2FIX( FR_GET_STRUCT( Table, self )->xsize );
}
static VALUE Table_ysize( VALUE self )
{
    return INT2FIX( FR_GET_STRUCT( Table, self )->ysize );
}
static VALUE Table_zsize( VALUE self )
{
    return INT2FIX( FR_GET_STRUCT( Table, self )->zsize );
}

/*********************************************************************
 * InputW[
 *
 * DirectInputgpăL[{[hEpbh̓͂sB
 *********************************************************************/

/*--------------------------------------------------------------------
   ͍XV
 ---------------------------------------------------------------------*/
static VALUE Input_update( VALUE obj )
{
    /* bZ[W */
    /* ͏ԍXV */
    inputupdate();
    return obj;
}


/*--------------------------------------------------------------------
   InputW[̓͏
 ---------------------------------------------------------------------*/
static void inputupdate( void )
{
    int i, j;
    DIJOYSTATE paddata;

    for( i = 0; i < 30; i++ )
    {
        g_fr_button[i] = 0;
    }

    /* tH[JX͂ꂽꍇAL[ƃpbhA}EX{^̓͂󂯕tȂ */
    if( g_bActive == 0 )
    {
        /* L[{[h̃f[^NA */
        ZeroMemory( &g_diKeyState, sizeof(g_diKeyState) );

        /* pbhf[^NA */
        for( i = 0; i < g_JoystickCount; i++ )
        {
            for( j = 0; j < 20; j++ )
            {
                g_PadState[i].button[j] = 0;
            }
        }

        return;
    }

    /* foCXANZXĎ擾 */
    g_pDIDKeyBoard->lpVtbl->Acquire( g_pDIDKeyBoard );

    for( i = 0; i < g_JoystickCount; i++ )
    {
        g_pDIDJoyPad[i]->lpVtbl->Poll( g_pDIDJoyPad[i] );
        g_pDIDJoyPad[i]->lpVtbl->Acquire( g_pDIDJoyPad[i] );
    }

    /* L[{[h̒ڃf[^擾 */
    g_pDIDKeyBoard->lpVtbl->GetDeviceState( g_pDIDKeyBoard, 256, g_diKeyState );

    for( i = 0; i < 256; i++ )
    {
        if( g_diKeyState[i] & 0x80 && g_diKeyConfig[i] != -1 )
        {
            g_fr_button[g_diKeyConfig[i]] = 1;
        }
    }

    /* Q[pbh̃f[^擾 */
    for( i = 0; i < g_JoystickCount; i++ )
    {
        int j;

        g_pDIDJoyPad[i]->lpVtbl->GetDeviceState( g_pDIDJoyPad[i], sizeof(DIJOYSTATE), &paddata );

        for( j = 0; j < 20; j++ )
        {
            g_PadState[i].button[j] = 0;
        }

        /*  */
        if( paddata.lX < g_PadInfo[i].left )
        {
            g_PadState[i].button[P_LEFT] = 1;
        }
        /* E */
        else if( paddata.lX > g_PadInfo[i].right )
        {
            g_PadState[i].button[P_RIGHT] = 1;
        }

        /*  */
        if( paddata.lY < g_PadInfo[i].up )
        {
            g_PadState[i].button[P_UP] = 1;
        }
        /*  */
        else if( paddata.lY > g_PadInfo[i].down )
        {
            g_PadState[i].button[P_DOWN] = 1;
        }

        /* {^ */
        for( j = 0; j < 16; j++)
        {
            g_PadState[i].button[j + 4] = paddata.rgbButtons[j] >> 7;
        }
    }

    for( i = 0; i < 20; i++ )
    {
        if( g_PadState[0].button[i] == 1 && g_PadState[0].PadConfig[i] != -1 )
        {
            g_fr_button[g_PadState[0].PadConfig[i]] = 1;
        }
    }

    /* I[gs[gpJEg */
    for( i = 0; i < 30; i++ )
    {
        if( g_fr_button[i] == 1 )
        {
            g_fr_button_count[i]++;
        }
        else
        {
            g_fr_button_count[i] = 0;
        }
    }

    return;
}


/*--------------------------------------------------------------------
   InputW[̃f[^擾

   ͕2468ŕԂ
 ---------------------------------------------------------------------*/
static VALUE Input_dir4( VALUE klass )
{
    int x = 0, y = 0;
    static int oldx = 0, oldy = 0;
    int stick[16] = {INT2FIX( 0 ), INT2FIX( 4 ), INT2FIX( 6 ), INT2FIX( 0 ), INT2FIX( 8 ), INT2FIX( 7 ), INT2FIX( 9 ), INT2FIX( 8 ),
                     INT2FIX( 2 ), INT2FIX( 1 ), INT2FIX( 3 ), INT2FIX( 2 ), INT2FIX( 0 ), INT2FIX( 4 ), INT2FIX( 6 ), INT2FIX( 0 )};

	/* Ђ */
    if( g_fr_button[FRB_LEFT] == 1 )
    {
        x = x - 1;
    }

    /* ݂ */
    if( g_fr_button[FRB_RIGHT] == 1 )
    {
        x = x + 1;
    }

    /*  */
    if( g_fr_button[FRB_UP] == 1 )
    {
        y = y - 1;
    }

    /*  */
    if( g_fr_button[FRB_DOWN] == 1 )
    {
        y = y + 1;
    }

    if( x != 0 && y != 0 )
    {
        if( oldx == 0 )
        {
            y = 0;
        }
        else
        {
            x = 0;
        }
    }
    else
    {
        oldx = x;
        oldy = y;
    }

    return stick[(x == -1 ? 1 : (x == 1 ? 2 : 0)) + (y == -1 ? 4 : (y == 1 ? 8 : 0))];
}


/*--------------------------------------------------------------------
   InputW[̃f[^擾

   ͕1234567890ŕԂ
 ---------------------------------------------------------------------*/
static VALUE Input_dir8( VALUE obj )
{
    int x = 0, y = 0;
    int stick[16] = {INT2FIX( 0 ), INT2FIX( 4 ), INT2FIX( 6 ), INT2FIX( 0 ), INT2FIX( 8 ), INT2FIX( 7 ), INT2FIX( 9 ), INT2FIX( 8 ),
                     INT2FIX( 2 ), INT2FIX( 1 ), INT2FIX( 3 ), INT2FIX( 2 ), INT2FIX( 0 ), INT2FIX( 4 ), INT2FIX( 6 ), INT2FIX( 0 )};

	/* Ђ */
    if( g_fr_button[FRB_LEFT] == 1 )
    {
        x = x - 1;
    }

    /* ݂ */
    if( g_fr_button[FRB_RIGHT] == 1 )
    {
        x = x + 1;
    }

    /*  */
    if( g_fr_button[FRB_UP] == 1 )
    {
        y = y - 1;
    }

    /*  */
    if( g_fr_button[FRB_DOWN] == 1 )
    {
        y = y + 1;
    }

    return stick[(x == -1 ? 1 : (x == 1 ? 2 : 0)) + (y == -1 ? 4 : (y == 1 ? 8 : 0))];
}


/*--------------------------------------------------------------------
   InputW[̃f[^擾

   ĂtrueɂȂB̓L[R[hB
 ---------------------------------------------------------------------*/
static VALUE Input_press( VALUE klass , VALUE vbutton )
{
    int button;

    button = NUM2INT( vbutton );
    if( button < 0 || button >= 30 )
    {
        return Qfalse;
    }

    if( g_fr_button[button] == 1 )
    {
        return Qtrue;
    }

    return Qfalse;
}


/*--------------------------------------------------------------------
   InputW[̃f[^擾

   uԂtrueɂȂB̓L[R[hB
 ---------------------------------------------------------------------*/
static VALUE Input_trigger( VALUE klass , VALUE vbutton )
{
    int button;

    button = NUM2INT( vbutton );
    if( button < 0 || button >= 30 )
    {
        return Qfalse;
    }

    if( g_fr_button_count[button] == 1 )
    {
        return Qtrue;
    }

    return Qfalse;
}


/*--------------------------------------------------------------------
   InputW[̃f[^擾

   I[gs[g
 ---------------------------------------------------------------------*/
static VALUE Input_repeat( VALUE klass , VALUE vbutton )
{
    int button;

    button = NUM2INT( vbutton );
    if( button < 0 || button >= 30 )
    {
        return Qfalse;
    }

    if( g_fr_button_count[button] == 1 || (g_fr_button_count[button] >= 24 && g_fr_button_count[button] % 6 == 0) )
    {
        return Qtrue;
    }

    return Qfalse;
}


/*--------------------------------------------------------------------
   pbhƃL[̑Ήݒ肷
 ---------------------------------------------------------------------*/
static void Input_SetConfig( int number, int fr, int pad, int key )
{
    g_PadState[number].PadConfig[pad] = fr;
    g_diKeyConfig[key] = fr;
}



char *hlsl = 
"float4 g_blend_sprite;"
"float4 g_tone_sprite;"
"float4 g_blend_viewport;"
"float4 g_tone_viewport;"
""
"texture Tex;"
"sampler Samp = sampler_state"
"{"
" Texture =<Tex>;"
"};"
""
"struct PixelIn"
"{"
"  float2 UV : TEXCOORD0;"
"};"
"struct PixelOut"
"{"
"  float4 Color : COLOR0;"
"};"
""
"PixelOut PS_sprite(PixelIn input)"
"{"
"  PixelOut output;"
"  float3 temp;"
"  float3 ntsc = {0.298912, 0.586611, 0.114478};"
"  float ntscy;"
"  output.Color = tex2D( Samp, input.UV );"
""
"  ntsc = ntsc * output.Color.rgb;"
"  ntscy = ntsc.r + ntsc.g + ntsc.b;"
"  temp.r = output.Color.r + ((ntscy - output.Color.r) * g_tone_sprite.a);"
"  temp.g = output.Color.g + ((ntscy - output.Color.g) * g_tone_sprite.a);"
"  temp.b = output.Color.b + ((ntscy - output.Color.b) * g_tone_sprite.a);"
""
"  output.Color.rgb = min(1, temp + g_tone_sprite.rgb) * (1.0 - g_blend_sprite.a) + g_blend_sprite.rgb * g_blend_sprite.a;"
""
"  return output;"
"}"
""
"PixelOut PS_viewport(PixelIn input)"
"{"
"  PixelOut output;"
""
"  output.Color.rgb = g_blend_viewport.rgb;"
"  output.Color.a = g_blend_viewport.a;"
""
"  return output;"
"}"
""
"technique TShader_sprite"
"{"
" pass P0"
" {"
"  PixelShader = compile ps_2_0 PS_sprite();"
" }"
"}"
""
"technique TShader_viewport"
"{"
" pass P0"
" {"
"  PixelShader = compile ps_2_0 PS_viewport();"
" }"
"}";


/*
***************************************************************
*
*         Global functions
*
***************************************************************/

void Init_freergss()
{
    HRESULT hr;
    int i, j;

    hr = CoInitialize(NULL);

    if( FAILED( hr ) )
    {
        rb_raise( eFreeRGSSError, "COM̏Ɏs܂ - CoInitialize" );
    }

    /* CX^Xnh擾 */
    g_hInstance = (HINSTANCE)GetModuleHandle( NULL );

    /* FreeRGSSW[o^ */
    mFreeRGSS = rb_define_module( "FreeRGSS" );

    /* GraphicsW[o^ */
    mGraphics = rb_define_module_under( mFreeRGSS, "Graphics" );

    /* GraphicsW[Ƀ\bho^ */
    rb_define_singleton_method( mGraphics, "update"      , Graphics_update, 0 );
    rb_define_singleton_method( mGraphics, "wait"        , Graphics_wait, 0 );
    rb_define_singleton_method( mGraphics, "frame_reset" , Graphics_frame_reset, 0 );
    rb_define_singleton_method( mGraphics, "width"       , Graphics_get_width, 0 );
    rb_define_singleton_method( mGraphics, "height"      , Graphics_get_height, 0 );
    rb_define_singleton_method( mGraphics, "frame_rate=" , Graphics_set_frame_rate, 1 );
    rb_define_singleton_method( mGraphics, "frame_rate"  , Graphics_get_frame_rate, 0 );
    rb_define_singleton_method( mGraphics, "frame_count=" , Graphics_set_frame_count, 1 );
    rb_define_singleton_method( mGraphics, "frame_count"  , Graphics_get_frame_count, 0 );
    rb_define_singleton_method( mGraphics, "brightness=" , Graphics_set_brightness, 1 );
    rb_define_singleton_method( mGraphics, "brightness"  , Graphics_get_brightness, 0 );
    rb_define_singleton_method( mGraphics, "fadeout" , Graphics_fadeout, 1 );
    rb_define_singleton_method( mGraphics, "fadein"  , Graphics_fadein, 1 );
    rb_define_singleton_method( mGraphics, "resize_screen"  , Graphics_resize_screen, 2 );
    rb_define_singleton_method( mGraphics, "snap_to_bitmap"  , Graphics_snap_to_bitmap, 0 );

    g_graphics.vsprites = rb_ary_new();
    rb_global_variable(&g_graphics.vsprites);
    g_graphics.frame_count = 0;
    g_graphics.brightness = 255;

    /* ViewportNX` */
    cViewport = rb_define_class_under( mFreeRGSS, "Viewport", rb_cObject );

    /* ViewportNXɃ\bho^*/
    rb_define_method( cViewport, "initialize", Viewport_initialize, -1 );
    rb_define_method( cViewport, "z=", Viewport_set_z, 1 );
    rb_define_method( cViewport, "z",  Viewport_get_z, 0 );
    rb_define_method( cViewport, "rect=", Viewport_set_rect, 1 );
    rb_define_method( cViewport, "rect",  Viewport_get_rect, 0 );
    rb_define_method( cViewport, "dispose",  Viewport_dispose, 0 );
    rb_define_method( cViewport, "disposed?", Viewport_get_dispose, 0 );
    rb_define_method( cViewport, "color=", Viewport_set_color, 1 );
    rb_define_method( cViewport, "color",  Viewport_get_color, 0 );
    rb_define_method( cViewport, "flash",  Viewport_flash, 2 );
    rb_define_method( cViewport, "update",  Viewport_update, 0 );
    rb_define_method( cViewport, "tone=", Viewport_set_tone, 1 );
    rb_define_method( cViewport, "tone",  Viewport_get_tone, 0 );
    rb_define_method( cViewport, "ox=", Viewport_set_ox, 1 );
    rb_define_method( cViewport, "ox",  Viewport_get_ox, 0 );
    rb_define_method( cViewport, "oy=", Viewport_set_oy, 1 );
    rb_define_method( cViewport, "oy",  Viewport_get_oy, 0 );
    rb_define_method( cViewport, "visible=", Viewport_set_visible, 1 );
    rb_define_method( cViewport, "visible",  Viewport_get_visible, 0 );

    /* ViewportIuWFNg𐶐initializȇOɌĂ΂郁蓖Ċ֐o^ */
    rb_define_alloc_func( cViewport, Viewport_allocate );


    /* SpriteNX` */
    cSprite = rb_define_class_under( mFreeRGSS, "Sprite", rb_cObject );

    /* SpriteNXɃ\bho^*/
    rb_define_method( cSprite, "initialize", Sprite_initialize, -1 );
    rb_define_method( cSprite, "width",  Sprite_get_width, 0 );
    rb_define_method( cSprite, "height",  Sprite_get_height, 0 );
    rb_define_method( cSprite, "x=", Sprite_set_x, 1 );
    rb_define_method( cSprite, "x",  Sprite_get_x, 0 );
    rb_define_method( cSprite, "y=", Sprite_set_y, 1 );
    rb_define_method( cSprite, "y",  Sprite_get_y, 0 );
    rb_define_method( cSprite, "z=", Sprite_set_z, 1 );
    rb_define_method( cSprite, "z",  Sprite_get_z, 0 );
    rb_define_method( cSprite, "visible=", Sprite_set_visible, 1 );
    rb_define_method( cSprite, "visible",  Sprite_get_visible, 0 );
    rb_define_method( cSprite, "bitmap=", Sprite_set_bitmap, 1 );
    rb_define_method( cSprite, "bitmap",  Sprite_get_bitmap, 0 );
    rb_define_method( cSprite, "src_rect=", Sprite_set_rect, 1 );
    rb_define_method( cSprite, "src_rect",  Sprite_get_rect, 0 );
    rb_define_method( cSprite, "angle=", Sprite_set_angle, 1 );
    rb_define_method( cSprite, "angle",  Sprite_get_angle, 0 );
    rb_define_method( cSprite, "zoom_x=", Sprite_set_zoom_x, 1 );
    rb_define_method( cSprite, "zoom_x",  Sprite_get_zoom_x, 0 );
    rb_define_method( cSprite, "zoom_y=", Sprite_set_zoom_y, 1 );
    rb_define_method( cSprite, "zoom_y",  Sprite_get_zoom_y, 0 );
    rb_define_method( cSprite, "blend_type=", Sprite_set_blend_type, 1 );
    rb_define_method( cSprite, "blend_type",  Sprite_get_blend_type, 0 );
    rb_define_method( cSprite, "mirror=", Sprite_set_mirror, 1 );
    rb_define_method( cSprite, "mirror",  Sprite_get_mirror, 0 );
    rb_define_method( cSprite, "ox=", Sprite_set_ox, 1 );
    rb_define_method( cSprite, "ox",  Sprite_get_ox, 0 );
    rb_define_method( cSprite, "oy=", Sprite_set_oy, 1 );
    rb_define_method( cSprite, "oy",  Sprite_get_oy, 0 );
    rb_define_method( cSprite, "opacity=", Sprite_set_opacity, 1 );
    rb_define_method( cSprite, "opacity",  Sprite_get_opacity, 0 );
    rb_define_method( cSprite, "dispose",  Sprite_dispose, 0 );
    rb_define_method( cSprite, "disposed?", Sprite_get_dispose, 0 );
    rb_define_method( cSprite, "viewport=", Sprite_set_viewport, 1 );
    rb_define_method( cSprite, "viewport",  Sprite_get_viewport, 0 );
    rb_define_method( cSprite, "color=", Sprite_set_color, 1 );
    rb_define_method( cSprite, "color",  Sprite_get_color, 0 );
    rb_define_method( cSprite, "flash",  Sprite_flash, 2 );
    rb_define_method( cSprite, "update",  Sprite_update, 0 );
    rb_define_method( cSprite, "tone=", Sprite_set_tone, 1 );
    rb_define_method( cSprite, "tone",  Sprite_get_tone, 0 );

    /* SpriteIuWFNg𐶐initializȇOɌĂ΂郁蓖Ċ֐o^ */
    rb_define_alloc_func( cSprite, Sprite_allocate );


    /* PlaneNX` */
    cPlane = rb_define_class_under( mFreeRGSS, "Plane", rb_cObject );

    /* PlaneNXɃ\bho^*/
    rb_define_method( cPlane, "initialize", Plane_initialize, -1 );
    rb_define_method( cPlane, "z=", Plane_set_z, 1 );
    rb_define_method( cPlane, "z",  Plane_get_z, 0 );
    rb_define_method( cPlane, "visible=", Plane_set_visible, 1 );
    rb_define_method( cPlane, "visible",  Plane_get_visible, 0 );
    rb_define_method( cPlane, "bitmap=", Plane_set_bitmap, 1 );
    rb_define_method( cPlane, "bitmap",  Plane_get_bitmap, 0 );
    rb_define_method( cPlane, "zoom_x=", Plane_set_zoom_x, 1 );
    rb_define_method( cPlane, "zoom_x",  Plane_get_zoom_x, 0 );
    rb_define_method( cPlane, "zoom_y=", Plane_set_zoom_y, 1 );
    rb_define_method( cPlane, "zoom_y",  Plane_get_zoom_y, 0 );
    rb_define_method( cPlane, "blend_type=", Plane_set_blend_type, 1 );
    rb_define_method( cPlane, "blend_type",  Plane_get_blend_type, 0 );
    rb_define_method( cPlane, "ox=", Plane_set_ox, 1 );
    rb_define_method( cPlane, "ox",  Plane_get_ox, 0 );
    rb_define_method( cPlane, "oy=", Plane_set_oy, 1 );
    rb_define_method( cPlane, "oy",  Plane_get_oy, 0 );
    rb_define_method( cPlane, "opacity=", Plane_set_opacity, 1 );
    rb_define_method( cPlane, "opacity",  Plane_get_opacity, 0 );
    rb_define_method( cPlane, "dispose",  Plane_dispose, 0 );
    rb_define_method( cPlane, "disposed?", Plane_get_dispose, 0 );
    rb_define_method( cPlane, "viewport=", Plane_set_viewport, 1 );
    rb_define_method( cPlane, "viewport",  Plane_get_viewport, 0 );
    rb_define_method( cPlane, "color=", Plane_set_color, 1 );
    rb_define_method( cPlane, "color",  Plane_get_color, 0 );
    rb_define_method( cPlane, "tone=", Plane_set_tone, 1 );
    rb_define_method( cPlane, "tone",  Plane_get_tone, 0 );

    /* PlaneIuWFNg𐶐initializȇOɌĂ΂郁蓖Ċ֐o^ */
    rb_define_alloc_func( cPlane, Plane_allocate );


    /* WindowNX` */
    cWindow = rb_define_class_under( mFreeRGSS, "Window", rb_cObject );

    /* WindowNXɃ\bho^*/
    rb_define_method( cWindow, "initialize", Window_initialize, -1 );
    rb_define_method( cWindow, "width=",  Window_set_width, 1 );
    rb_define_method( cWindow, "width",  Window_get_width, 0 );
    rb_define_method( cWindow, "height=",  Window_set_height, 1 );
    rb_define_method( cWindow, "height",  Window_get_height, 0 );
    rb_define_method( cWindow, "x=", Window_set_x, 1 );
    rb_define_method( cWindow, "x",  Window_get_x, 0 );
    rb_define_method( cWindow, "y=", Window_set_y, 1 );
    rb_define_method( cWindow, "y",  Window_get_y, 0 );
    rb_define_method( cWindow, "z=", Window_set_z, 1 );
    rb_define_method( cWindow, "z",  Window_get_z, 0 );
    rb_define_method( cWindow, "visible=", Window_set_visible, 1 );
    rb_define_method( cWindow, "visible",  Window_get_visible, 0 );
    rb_define_method( cWindow, "windowskin=", Window_set_windowskin, 1 );
    rb_define_method( cWindow, "windowskin",  Window_get_windowskin, 0 );
    rb_define_method( cWindow, "contents=", Window_set_contents, 1 );
    rb_define_method( cWindow, "contents",  Window_get_contents, 0 );
    rb_define_method( cWindow, "cursor_rect=", Window_set_cursor_rect, 1 );
    rb_define_method( cWindow, "cursor_rect",  Window_get_cursor_rect, 0 );
    rb_define_method( cWindow, "active=", Window_set_active, 1 );
    rb_define_method( cWindow, "active",  Window_get_active, 0 );
    rb_define_method( cWindow, "pause=", Window_set_pause, 1 );
    rb_define_method( cWindow, "pause",  Window_get_pause, 0 );
    rb_define_method( cWindow, "ox=", Window_set_ox, 1 );
    rb_define_method( cWindow, "ox",  Window_get_ox, 0 );
    rb_define_method( cWindow, "oy=", Window_set_oy, 1 );
    rb_define_method( cWindow, "oy",  Window_get_oy, 0 );
    rb_define_method( cWindow, "opacity=", Window_set_opacity, 1 );
    rb_define_method( cWindow, "opacity",  Window_get_opacity, 0 );
    rb_define_method( cWindow, "back_opacity=", Window_set_back_opacity, 1 );
    rb_define_method( cWindow, "back_opacity",  Window_get_back_opacity, 0 );
    rb_define_method( cWindow, "contents_opacity=", Window_set_contents_opacity, 1 );
    rb_define_method( cWindow, "contents_opacity",  Window_get_contents_opacity, 0 );
    rb_define_method( cWindow, "dispose",  Window_dispose, 0 );
    rb_define_method( cWindow, "disposed?", Window_get_dispose, 0 );
    rb_define_method( cWindow, "viewport=", Window_set_viewport, 1 );
    rb_define_method( cWindow, "viewport",  Window_get_viewport, 0 );
    rb_define_method( cWindow, "update",  Window_update, 0 );
    rb_define_method( cWindow, "openness=", Window_set_openness, 1 );
    rb_define_method( cWindow, "openness",  Window_get_openness, 0 );

    /* WindowIuWFNg𐶐initializȇOɌĂ΂郁蓖Ċ֐o^ */
    rb_define_alloc_func( cWindow, Window_allocate );


    /* BitmapNX` */
    cBitmap = rb_define_class_under( mFreeRGSS, "Bitmap", rb_cObject );

    /* BitmapNXɃ\bho^*/
    rb_define_method( cBitmap, "initialize", Bitmap_initialize, -1 );
    rb_define_method( cBitmap, "width", Bitmap_get_width, 0 );
    rb_define_method( cBitmap, "height", Bitmap_get_height, 0 );
    rb_define_method( cBitmap, "rect", Bitmap_get_rect, 0 );
    rb_define_method( cBitmap, "fill_rect", Bitmap_fill_rect, -1 );
    rb_define_method( cBitmap, "clear", Bitmap_clear, 0 );
    rb_define_method( cBitmap, "clear_rect", Bitmap_clear_rect, -1 );
    rb_define_method( cBitmap, "set_pixel", Bitmap_set_pixel, 3 );
    rb_define_method( cBitmap, "get_pixel", Bitmap_get_pixel, 2 );
    rb_define_method( cBitmap, "draw_text", Bitmap_draw_text, -1 );
    rb_define_method( cBitmap, "text_size", Bitmap_text_size, 1 );

    /* BitmapIuWFNg𐶐initializȇOɌĂ΂郁蓖Ċ֐o^ */
    rb_define_alloc_func( cBitmap, Bitmap_allocate );


    /* RectNX` */
    cRect = rb_define_class_under( mFreeRGSS, "Rect", rb_cObject );

    /* RectNXɃ\bho^*/
    rb_define_method( cRect, "initialize", Rect_initialize, 4 );
    rb_define_method( cRect, "x=", Rect_set_x, 1 );
    rb_define_method( cRect, "x",  Rect_get_x, 0 );
    rb_define_method( cRect, "y=", Rect_set_y, 1 );
    rb_define_method( cRect, "y",  Rect_get_y, 0 );
    rb_define_method( cRect, "width=", Rect_set_width, 1 );
    rb_define_method( cRect, "width",  Rect_get_width, 0 );
    rb_define_method( cRect, "height=", Rect_set_height, 1 );
    rb_define_method( cRect, "height",  Rect_get_height, 0 );
    rb_define_method( cRect, "to_s",  Rect_to_s, 0 );
    rb_define_method( cRect, "empty",  Rect_empty, 0 );
    rb_define_method( cRect, "dup",  Rect_dup, 0 );

    /* RectIuWFNg𐶐initializȇOɌĂ΂郁蓖Ċ֐o^ */
    rb_define_alloc_func( cRect, Rect_allocate );


    /* ColorNX` */
    cColor = rb_define_class_under( mFreeRGSS, "Color", rb_cObject );

    /* ColorNXɃ\bho^*/
    rb_define_method( cColor, "initialize", Color_initialize, -1 );
    rb_define_method( cColor, "set", Color_initialize, -1 );
    rb_define_method( cColor, "red=", Color_set_red, 1 );
    rb_define_method( cColor, "red",  Color_get_red, 0 );
    rb_define_method( cColor, "green=", Color_set_green, 1 );
    rb_define_method( cColor, "green",  Color_get_green, 0 );
    rb_define_method( cColor, "blue=", Color_set_blue, 1 );
    rb_define_method( cColor, "blue",  Color_get_blue, 0 );
    rb_define_method( cColor, "alpha=", Color_set_alpha, 1 );
    rb_define_method( cColor, "alpha",  Color_get_alpha, 0 );
    rb_define_method( cColor, "==", Color_equal, 1 );
    rb_define_method( cColor, "to_s", Color_to_s, 0 );
    rb_define_method( cColor, "dup", Color_dup, 0 );

    /* ColorIuWFNg𐶐initializȇOɌĂ΂郁蓖Ċ֐o^ */
    rb_define_alloc_func( cColor, Color_allocate );


    /* ToneNX` */
    cTone = rb_define_class_under( mFreeRGSS, "Tone", rb_cObject );

    /* ToneNXɃ\bho^*/
    rb_define_method( cTone, "initialize", Tone_initialize, -1 );
    rb_define_method( cTone, "set", Tone_initialize, -1 );
    rb_define_method( cTone, "red=", Tone_set_red, 1 );
    rb_define_method( cTone, "red",  Tone_get_red, 0 );
    rb_define_method( cTone, "green=", Tone_set_green, 1 );
    rb_define_method( cTone, "green",  Tone_get_green, 0 );
    rb_define_method( cTone, "blue=", Tone_set_blue, 1 );
    rb_define_method( cTone, "blue",  Tone_get_blue, 0 );
    rb_define_method( cTone, "gray=", Tone_set_gray, 1 );
    rb_define_method( cTone, "gray",  Tone_get_gray, 0 );
    rb_define_method( cTone, "==", Tone_equal, 1 );
    rb_define_method( cTone, "to_s", Tone_to_s, 0 );
    rb_define_method( cTone, "dup", Tone_dup, 0 );

    /* ToneIuWFNg𐶐initializȇOɌĂ΂郁蓖Ċ֐o^ */
    rb_define_alloc_func( cTone, Tone_allocate );


    /* FontNX` */
    cFont = rb_define_class_under( mFreeRGSS, "Font", rb_cObject );

    rb_define_singleton_method( cFont, "install", Font_install, 1 );
    rb_define_singleton_method( cFont, "exist?"  , Font_exist  , 1  );
    rb_define_singleton_method( cFont, "default_name=", Font_set_default_name, 1 );
    rb_define_singleton_method( cFont, "default_name",  Font_get_default_name, 0 );
    rb_define_singleton_method( cFont, "default_size=", Font_set_default_size, 1 );
    rb_define_singleton_method( cFont, "default_size",  Font_get_default_size, 0 );
    rb_define_singleton_method( cFont, "default_bold=", Font_set_default_bold, 1 );
    rb_define_singleton_method( cFont, "default_bold",  Font_get_default_bold, 0 );
    rb_define_singleton_method( cFont, "default_italic=", Font_set_default_italic, 1 );
    rb_define_singleton_method( cFont, "default_italic",  Font_get_default_italic, 0 );
    rb_define_singleton_method( cFont, "default_shadow=", Font_set_default_shadow, 1 );
    rb_define_singleton_method( cFont, "default_shadow",  Font_get_default_shadow, 0 );
    rb_define_singleton_method( cFont, "default_color=", Font_set_default_color, 1 );
    rb_define_singleton_method( cFont, "default_color",  Font_get_default_color, 0 );

    /* FontNXɃ\bho^*/
    rb_define_method( cFont, "initialize", Font_initialize, -1 );
    rb_define_method( cFont, "name=", Font_set_name, 1 );
    rb_define_method( cFont, "name",  Font_get_name, 0 );
    rb_define_method( cFont, "size=", Font_set_size, 1 );
    rb_define_method( cFont, "size",  Font_get_size, 0 );
    rb_define_method( cFont, "bold=", Font_set_bold, 1 );
    rb_define_method( cFont, "bold",  Font_get_bold, 0 );
    rb_define_method( cFont, "italic=", Font_set_italic, 1 );
    rb_define_method( cFont, "italic",  Font_get_italic, 0 );
    rb_define_method( cFont, "shadow=", Font_set_shadow, 1 );
    rb_define_method( cFont, "shadow",  Font_get_shadow, 0 );
    rb_define_method( cFont, "color=", Font_set_color, 1 );
    rb_define_method( cFont, "color",  Font_get_color, 0 );

    /* FontIuWFNg𐶐initializȇOɌĂ΂郁蓖Ċ֐o^ */
    rb_define_alloc_func( cFont, Font_allocate );

    g_default_font.vname = rb_ary_new3( 3,
        rb_locale_str_new( "UmePlus Gothic", strlen( "UmePlus Gothic" ) ),
        rb_locale_str_new( "lr SVbN", strlen( "lr SVbN" ) ),
        rb_locale_str_new( "Courier New", strlen( "Courier New" ) ) );
    g_default_font.vsize = INT2FIX( 20 );
    g_default_font.vbold = Qfalse;
    g_default_font.vitalic = Qfalse;
    g_default_font.vshadow = Qtrue;
    g_default_font.vcolor = Color_allocate( cColor );
    ((struct FR_Color*)DATA_PTR( g_default_font.vcolor ))->red = 255;
    ((struct FR_Color*)DATA_PTR( g_default_font.vcolor ))->green = 255;
    ((struct FR_Color*)DATA_PTR( g_default_font.vcolor ))->blue = 255;
    ((struct FR_Color*)DATA_PTR( g_default_font.vcolor ))->alpha = 255;

    rb_global_variable( &g_default_font.vname );
    rb_global_variable( &g_default_font.vsize );
    rb_global_variable( &g_default_font.vbold );
    rb_global_variable( &g_default_font.vitalic );
    rb_global_variable( &g_default_font.vshadow );
    rb_global_variable( &g_default_font.vcolor );
    
    
    /* TableNX` */
    cTable = rb_define_class_under( mFreeRGSS, "Table", rb_cObject );

    /* TableNXɃ\bho^*/
    rb_define_method( cTable, "initialize", Table_initialize, -1 );
    rb_define_method( cTable, "[]=", Table_set, -1 );
    rb_define_method( cTable, "[]", Table_get, -1 );
    rb_define_method( cTable, "resize",  Table_resize, -1 );
    rb_define_method( cTable, "xsize",  Table_xsize, 0 );
    rb_define_method( cTable, "ysize",  Table_ysize, 0 );
    rb_define_method( cTable, "zsize",  Table_zsize, 0 );

    /* TableIuWFNg𐶐initializȇOɌĂ΂郁蓖Ċ֐o^ */
    rb_define_alloc_func( cTable, Table_allocate );


    
    
    /* InputW[o^ */
    mInput = rb_define_module_under( mFreeRGSS, "Input" );

    /* InputW[Ƀ\bho^ */
    rb_define_singleton_method( mInput, "dir4"           , Input_dir4            , 0  );
    rb_define_singleton_method( mInput, "dir8"           , Input_dir8            , 0  );
    rb_define_singleton_method( mInput, "trigger?"       , Input_trigger         , 1  );
    rb_define_singleton_method( mInput, "press?"         , Input_press           , 1  );
    rb_define_singleton_method( mInput, "repeat?"        , Input_repeat          , 1  );
    rb_define_singleton_method( mInput, "update"         , Input_update          , 0  );


    /* L[{[h̃XLR[h萔ݒ */
    rb_define_const( mInput, "UP"         , INT2FIX(FRB_UP)    );
    rb_define_const( mInput, "LEFT"       , INT2FIX(FRB_LEFT)  );
    rb_define_const( mInput, "RIGHT"      , INT2FIX(FRB_RIGHT) );
    rb_define_const( mInput, "DOWN"       , INT2FIX(FRB_DOWN)  );
    rb_define_const( mInput, "A"          , INT2FIX(FRB_A)     );
    rb_define_const( mInput, "B"          , INT2FIX(FRB_B)     );
    rb_define_const( mInput, "C"          , INT2FIX(FRB_C)     );
    rb_define_const( mInput, "X"          , INT2FIX(FRB_X)     );
    rb_define_const( mInput, "Y"          , INT2FIX(FRB_Y)     );
    rb_define_const( mInput, "Z"          , INT2FIX(FRB_Z)     );
    rb_define_const( mInput, "L"          , INT2FIX(FRB_L)     );
    rb_define_const( mInput, "R"          , INT2FIX(FRB_R)     );
    rb_define_const( mInput, "SHIFT"      , INT2FIX(FRB_SHIFT) );
    rb_define_const( mInput, "CTRL"       , INT2FIX(FRB_CTRL)  );
    rb_define_const( mInput, "ALT"        , INT2FIX(FRB_ALT)   );
    rb_define_const( mInput, "F5"         , INT2FIX(FRB_F5)    );
    rb_define_const( mInput, "F6"         , INT2FIX(FRB_F6)    );
    rb_define_const( mInput, "F7"         , INT2FIX(FRB_F7)    );
    rb_define_const( mInput, "F8"         , INT2FIX(FRB_F8)    );
    rb_define_const( mInput, "F9"         , INT2FIX(FRB_F9)    );

    /* O` */
    eFreeRGSSError = rb_define_class_under( mFreeRGSS, "FreeRGSSError", rb_eRuntimeError );

    /* 萔o^ */
    rb_define_const( mFreeRGSS, "FREERGSS_VERSION", rb_locale_str_new( FREERGSS_VERSION, strlen( FREERGSS_VERSION ) ) );

    {
        VALUE temp;
        temp = rb_eval_string( "$freergss_no_include" );
        if( temp == Qfalse || temp == Qnil )
        {
            rb_include_module( rb_cObject, mFreeRGSS );
        }
    }

    /* IɎs֐ */
    rb_set_end_proc( Window_shutdown, Qnil );

    g_WindowInfo.width    = 640;
    g_WindowInfo.height   = 480;
    g_WindowInfo.windowed = Qtrue;
    g_WindowInfo.created  = Qfalse;
    g_WindowInfo.scale    = 1;
    g_WindowInfo.enablemouse = Qtrue;
    g_WindowInfo.mousewheelpos = 0;
    g_WindowInfo.fps = 60;
    g_WindowInfo.frameskip = Qfalse;
    g_WindowInfo.r = 0;
    g_WindowInfo.g = 0;
    g_WindowInfo.b = 0;
    g_WindowInfo.minfilter = D3DTEXF_LINEAR;
    g_WindowInfo.magfilter = D3DTEXF_LINEAR;
    g_WindowInfo.hIcon = 0;
    g_WindowInfo.loop = 0;
    g_WindowInfo.requestclose = 0;

    /* 蓖ď */
    for( i = 0; i < 256; i++)
    {
        g_diKeyConfig[i] = -1;
    }
    for( i = 0; i < PADMAX; i++)
    {
        for( j = 0; j < 20; j++)
        {
            g_PadState[i].PadConfig[j] = -1;
        }
    }
    for( i = 0; i < 30; i++ )
    {
        g_fr_button[i] = 0;
        g_fr_button_count[i] = 0;
    }

    /* ftHg̊蓖 */
    Input_SetConfig( 0, FRB_LEFT , P_LEFT   , DIK_LEFT  );
    Input_SetConfig( 0, FRB_RIGHT, P_RIGHT  , DIK_RIGHT );
    Input_SetConfig( 0, FRB_UP   , P_UP     , DIK_UP    );
    Input_SetConfig( 0, FRB_DOWN , P_DOWN   , DIK_DOWN  );
    Input_SetConfig( 0, FRB_A    , P_BUTTON0, DIK_LSHIFT);
    Input_SetConfig( 0, FRB_A    , P_BUTTON0, DIK_RSHIFT);
    Input_SetConfig( 0, FRB_B    , P_BUTTON1, DIK_X     );
    Input_SetConfig( 0, FRB_B    , P_BUTTON1, DIK_NUMPAD0);
    Input_SetConfig( 0, FRB_B    , P_BUTTON1, DIK_ESCAPE);
    Input_SetConfig( 0, FRB_C    , P_BUTTON2, DIK_SPACE );
    Input_SetConfig( 0, FRB_C    , P_BUTTON2, DIK_RETURN);
    Input_SetConfig( 0, FRB_C    , P_BUTTON2, DIK_NUMPADENTER);
    Input_SetConfig( 0, FRB_C    , P_BUTTON2, DIK_Z     );
    Input_SetConfig( 0, FRB_X    , P_BUTTON3, DIK_A     );
    Input_SetConfig( 0, FRB_Y    , P_BUTTON4, DIK_S     );
    Input_SetConfig( 0, FRB_Z    , P_BUTTON5, DIK_D     );
    Input_SetConfig( 0, FRB_L    , P_BUTTON6, DIK_Q     );
    Input_SetConfig( 0, FRB_R    , P_BUTTON7, DIK_W     );

	/* EBhE쐬(̎_ł͔\) */
    InitWindow();

    /* DirectX Graphics̏ */
    InitDXGraphics();

    /* DirectInput */
    InitDirectInput();

    {
        LPD3DXBUFFER pErr=NULL;
        if( FAILED( hr = D3DXCreateEffect(
                    g_pD3DDevice, hlsl, strlen(hlsl), NULL, NULL,
                    0 , NULL, &m_pEffect, &pErr ))){
            // VF[_̓ǂݍ݂̎s
            printf("%s\n", pErr->lpVtbl->GetBufferPointer(pErr));
        }else{
            m_hTechnique_sprite = m_pEffect->lpVtbl->GetTechniqueByName( m_pEffect, "TShader_sprite" );
            m_hTechnique_viewport = m_pEffect->lpVtbl->GetTechniqueByName( m_pEffect, "TShader_viewport" );
            g_hcolor_sprite = m_pEffect->lpVtbl->GetParameterByName( m_pEffect, NULL, "g_blend_sprite" );
            g_hcolor_viewport = m_pEffect->lpVtbl->GetParameterByName( m_pEffect, NULL, "g_blend_viewport" );
            g_htone_sprite = m_pEffect->lpVtbl->GetParameterByName( m_pEffect, NULL, "g_tone_sprite" );
            g_htone_viewport = m_pEffect->lpVtbl->GetParameterByName( m_pEffect, NULL, "g_tone_viewport" );
        }
        RELEASE(pErr);
    }

    Window_create();
}


/*--------------------------------------------------------------------
  i֐jEBhE̐
 ---------------------------------------------------------------------*/
static void InitWindow( void )
{
    WNDCLASSEX wcex;
    RECT rect;

    /* EChEENX̓o^ */
    wcex.cbSize        = sizeof( WNDCLASSEX );
    wcex.style         = CS_HREDRAW | CS_VREDRAW;
    wcex.lpfnWndProc   = (WNDPROC)MainWndProc;
    wcex.cbClsExtra    = 0;
    wcex.cbWndExtra    = 0;
    wcex.hInstance     = g_hInstance;
    wcex.hIcon         = NULL;
    wcex.hIconSm       = NULL;
    wcex.hCursor       = LoadCursor( NULL, IDC_ARROW );
    wcex.hbrBackground = (HBRUSH)( COLOR_WINDOW + 1 );
    wcex.lpszMenuName  = NULL;
    wcex.lpszClassName = "FreeRGSS";

    if( !RegisterClassEx( &wcex ) )
    {
        rb_raise( eFreeRGSSError, "EBhȄɎs܂ - RegusterClassEx" );
    }

    /* CEEChE쐬(EChEE[hp) */
    rect.top     = 0;
    rect.left    = 0;
    rect.right   = g_WindowInfo.width;
    rect.bottom  = g_WindowInfo.height;

    AdjustWindowRect( &rect, WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX, FALSE );

    rect.right   = rect.right - rect.left;
    rect.bottom  = rect.bottom - rect.top;
    rect.left    = 0;
    rect.top     = 0;

    g_hWnd = CreateWindow( TEXT("FreeRGSS"), TEXT("FreeRGSS Application"),
                           WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX,
                           CW_USEDEFAULT, CW_USEDEFAULT,
                           rect.right - rect.left, rect.bottom - rect.top,
                           NULL, NULL, g_hInstance, NULL );
    if( g_hWnd == NULL )
    {
        rb_raise( eFreeRGSSError, "EBhȄɎs܂ - CreateWindow" );
    }

    GetWindowRect( g_hWnd, &rect );
    g_WindowInfo.x        = rect.left;
    g_WindowInfo.y        = rect.top;
}


/*--------------------------------------------------------------------
  i֐jDirectX Graphics
 ---------------------------------------------------------------------*/
static void InitDXGraphics( void )
{
    D3DVIEWPORT9 vp;
    HRESULT hr;

    /* Direct3DIuWFNg̍쐬 */
    g_pD3D = Direct3DCreate9( D3D_SDK_VERSION );

    if( g_pD3D == NULL )
    {
        rb_raise( eFreeRGSSError, "DirectX Graphics̏Ɏs܂ - Direct3DCreate9" );
    }

    /* D3DDeviceIuWFNg̍쐬(EChEE[h) */
    ZeroMemory( &g_D3DPP, sizeof( g_D3DPP ) );

    g_D3DPP.BackBufferWidth            = 0;
    g_D3DPP.BackBufferHeight           = 0;
    g_D3DPP.BackBufferFormat           = D3DFMT_UNKNOWN;
    g_D3DPP.BackBufferCount            = 1;
    g_D3DPP.MultiSampleType            = D3DMULTISAMPLE_NONE;
    g_D3DPP.MultiSampleQuality         = 0;
    g_D3DPP.SwapEffect                 = D3DSWAPEFFECT_DISCARD;
    g_D3DPP.hDeviceWindow              = g_hWnd;
    g_D3DPP.Windowed                   = TRUE;
    g_D3DPP.EnableAutoDepthStencil     = FALSE;
    g_D3DPP.AutoDepthStencilFormat     = D3DFMT_UNKNOWN;
    g_D3DPP.Flags                      = 0;
    g_D3DPP.FullScreen_RefreshRateInHz = 0;
    g_D3DPP.PresentationInterval       = D3DPRESENT_INTERVAL_IMMEDIATE;

    hr = g_pD3D->lpVtbl->CreateDevice( g_pD3D, D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, g_hWnd,
                                       D3DCREATE_HARDWARE_VERTEXPROCESSING, &g_D3DPP, &g_pD3DDevice );

    if( FAILED( hr ) )
    {
        hr = g_pD3D->lpVtbl->CreateDevice( g_pD3D, D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, g_hWnd,
                                           D3DCREATE_SOFTWARE_VERTEXPROCESSING, &g_D3DPP, &g_pD3DDevice );

        if( FAILED( hr ) )
        {
            rb_raise( eFreeRGSSError, "DirectX Graphics̏Ɏs܂ - CreateDevice" );
        }
    }

    /* r[|[g̐ݒ */
    vp.X       = 0;
    vp.Y       = 0;
    vp.Width   = g_D3DPP.BackBufferWidth;
    vp.Height  = g_D3DPP.BackBufferHeight;
    vp.MinZ    = 0.0f;
    vp.MaxZ    = 1.0f;

    hr = g_pD3DDevice->lpVtbl->SetViewport( g_pD3DDevice, &vp );

    if( FAILED( hr ) )
    {
        rb_raise( eFreeRGSSError, "DirectX Graphics̏Ɏs܂ - SetViewport" );
    }

    g_pD3DDevice->lpVtbl->Clear( g_pD3DDevice, 0, NULL, D3DCLEAR_TARGET,
                                 D3DCOLOR_XRGB(0,0,0), 1.0f, 0 );

    /* XvCgIuWFNg쐬 */
    hr = D3DXCreateSprite( g_pD3DDevice, &g_pD3DXSprite );

    if( FAILED( hr ) )
    {
        rb_raise( eFreeRGSSError, "DirectX Graphics̏Ɏs܂ - CreateSprite" );
    }
}


/*--------------------------------------------------------------------
  i֐jt[
 ---------------------------------------------------------------------*/
static void InitSync( void )
{
    timeBeginPeriod( 1 );

    /* ptH[}XJE^̕bԃJEgl擾 */
    if( QueryPerformanceFrequency( (LARGE_INTEGER *)&g_OneSecondCount ) )
    {
        /* ptH[}XJE^ꍇ */
        g_isPerformanceCounter = 1;
        QueryPerformanceCounter( (LARGE_INTEGER *)&g_OldTime );
    }
    else
    {
        /* ptH[}XJE^ꍇ */
        g_isPerformanceCounter = 0;
        g_OneSecondCount = 1000;
        g_OldTime = timeGetTime();
    }
}


/* foCX񋓊֐ */
BOOL CALLBACK EnumJoysticksCallback( const DIDEVICEINSTANCE* pdidInstance, void* pContext )
{
    HRESULT hr;

    /* 񋓂ꂽWCXeBbNւ̃C^[tFCX擾 */
    hr = g_pDInput->lpVtbl->CreateDevice( g_pDInput,
                            &pdidInstance->guidInstance,
                            &g_pDIDJoyPad[g_JoystickCount],
                            NULL );
    if( SUCCEEDED( hr ) )
    {
        return (++g_JoystickCount == PADMAX)?(DIENUM_STOP):(DIENUM_CONTINUE);
    }

    return DIENUM_STOP;
}

/* IuWFNgij񋓊֐ */
BOOL CALLBACK EnumAxisCallback( const DIDEVICEOBJECTINSTANCE* pdidoi, void *pContext )
{
    HRESULT hr;
    DIPROPRANGE diprg = { sizeof(DIPROPRANGE), sizeof(DIPROPHEADER) };
    struct DXRubyPadInfo *pad;

    pad = (struct DXRubyPadInfo *)pContext;

    diprg.diph.dwHow = DIPH_BYID; 
    diprg.diph.dwObj = pdidoi->dwType;

    /*========================================================*/
    /* 擾 */
    hr =  pad->pDIDJoyPad->lpVtbl->GetProperty( pad->pDIDJoyPad, DIPROP_RANGE, &diprg.diph );

    if( FAILED( hr ) )
    {
        rb_raise( eFreeRGSSError, "DirectInput̏Ɏs܂ - GetProperty" );
    }

    /* x */
    if( memcmp( &pdidoi->guidType, &GUID_XAxis ,sizeof(GUID)) == 0 )
    {
        int xcenter;
        xcenter = (diprg.lMin + diprg.lMax) / 2;
        pad->left  = (xcenter - diprg.lMin) / 2;
        pad->right = (diprg.lMax - xcenter) / 2 + xcenter;
    }

    /* y */
    if( memcmp( &pdidoi->guidType, &GUID_YAxis ,sizeof(GUID)) == 0 )
    {
        int ycenter;
        ycenter = (diprg.lMin + diprg.lMax) / 2;
        pad->up   = (ycenter - diprg.lMin) / 2;
        pad->down = (diprg.lMax - ycenter) / 2 + ycenter;
    }

    return DIENUM_CONTINUE;
}

/*--------------------------------------------------------------------
  i֐jDirectInput
 ---------------------------------------------------------------------*/
static void InitDirectInput( void )
{
    HRESULT hr;
    int i;

/* DirectInput */

    /* DirectInputIuWFNg̍쐬 */
    hr = DirectInput8Create( g_hInstance, DIRECTINPUT_VERSION,
                             &IID_IDirectInput8, (void **)&g_pDInput, NULL );

    if( FAILED( hr ) )
    {
        rb_raise( eFreeRGSSError, "DirectInput̏Ɏs܂ - DirectInput8Create" );
    }

/* L[{[h */

    /* foCXEIuWFNg쐬iL[{[hj */
    hr = g_pDInput->lpVtbl->CreateDevice( g_pDInput, &GUID_SysKeyboard, &g_pDIDKeyBoard, NULL );

    if( FAILED( hr ) )
    {
        rb_raise( eFreeRGSSError, "DirectInput̏Ɏs܂ - CreateDevice" );
    }

    /* f[^`ݒiL[{[hłj */
    hr = g_pDIDKeyBoard->lpVtbl->SetDataFormat( g_pDIDKeyBoard, &c_dfDIKeyboard );

    if( FAILED( hr ) )
    {
        rb_raise( eFreeRGSSError, "DirectInput̏Ɏs܂ - SetDataFormat" );
    }

    /* L[{[h̃[hݒitHAOEhr[hj */
    hr = g_pDIDKeyBoard->lpVtbl->SetCooperativeLevel( g_pDIDKeyBoard, g_hWnd, DISCL_NONEXCLUSIVE | DISCL_FOREGROUND );

    if( FAILED( hr ) )
    {
        rb_raise( eFreeRGSSError, "DirectInput̏Ɏs܂ - SetCooperativeLevel" );
    }

    /* ͐Jn */
    g_pDIDKeyBoard->lpVtbl->Acquire( g_pDIDKeyBoard );


/* Q[pbh */

    for( i = 0; i < PADMAX; i++)
    {
        g_pDIDJoyPad[i] = NULL;
    }
    g_JoystickCount = 0;

    /* Q[foCX */
    hr = g_pDInput->lpVtbl->EnumDevices( g_pDInput, DI8DEVCLASS_GAMECTRL, EnumJoysticksCallback, NULL, DIEDFL_ATTACHEDONLY );

    if( FAILED( hr ) )
    {
        rb_raise( eFreeRGSSError, "DirectInput̏Ɏs܂ - EnumDevices" );
    }

    /* Q[foCX */
    for ( i = 0; i < g_JoystickCount; i++ )
    {
        /* f[^`ݒ */
        hr = g_pDIDJoyPad[i]->lpVtbl->SetDataFormat( g_pDIDJoyPad[i], &c_dfDIJoystick );

        if( FAILED( hr ) )
        {
            rb_raise( eFreeRGSSError, "DirectInput̏Ɏs܂ - SetDataFormat" );
        }

        /* L[{[h̃[hݒitHAOEhr[hj */
        hr = g_pDIDJoyPad[i]->lpVtbl->SetCooperativeLevel( g_pDIDJoyPad[i], g_hWnd, DISCL_NONEXCLUSIVE | DISCL_FOREGROUND );

        if( FAILED( hr ) )
        {
            rb_raise( eFreeRGSSError, "DirectInput̏Ɏs܂ - SetCooperativeLevel" );
        }

        /* IuWFNg */
        g_PadInfo[i].pDIDJoyPad = g_pDIDJoyPad[i];
        hr = g_pDIDJoyPad[i]->lpVtbl->EnumObjects( g_pDIDJoyPad[i], EnumAxisCallback, &g_PadInfo[i], DIDFT_AXIS );

        if( FAILED( hr ) )
        {
            rb_raise( eFreeRGSSError, "DirectInput̏Ɏs܂ - EnumObjects" );
        }

        /* ͐Jn */
        g_pDIDJoyPad[i]->lpVtbl->Acquire( g_pDIDJoyPad[i] );
    }

}


/* }[W\[g */
void merge( VALUE *list, VALUE *temp, int left, int mid, int right )
{
    int left_end, num_elements, tmp_pos;

    left_end = mid - 1;
    tmp_pos = left;
    num_elements = right - left + 1;

    while ((left <= left_end) && (mid <= right))
    {
        int leftz = ((struct FR_SuperSprite*)DATA_PTR( list[left] ))->z;
        int midz = ((struct FR_SuperSprite*)DATA_PTR( list[mid] ))->z;
        if ( leftz <= midz ||
           (leftz == midz && ((struct FR_SuperSprite*)DATA_PTR( list[left] ))->y
            <= ((struct FR_SuperSprite*)DATA_PTR( list[mid] ))->y ))
            temp[tmp_pos++] = list[left++];
        else
            temp[tmp_pos++] = list[mid++];
    }

    while (left <= left_end)
    {
        temp[tmp_pos++] = list[left++];
    }
    while (mid <= right)
    {
        temp[tmp_pos++] = list[mid++];
    }

    while (num_elements--)
    {
        list[right] = temp[right--];
    }
}
void m_sort( VALUE *list, VALUE *temp, int left, int right )
{
    int mid;

    if( right > left )
    {
        mid = (right + left) / 2;
        m_sort( list, temp, left, mid );
        m_sort( list, temp, mid+1, right );

        merge( list, temp, left, mid+1, right );
    }
}
void SortSuperSpriteList( VALUE* vpsprites, int spritecount )
{
    VALUE *temp;
    int i;

    for( i = 0; i < spritecount; i++ )
    {
        if( ((struct FR_SuperSprite*)DATA_PTR( vpsprites[i] ))->z != 0.0f )
        {
            temp = malloc( sizeof(VALUE) * spritecount );
            m_sort( vpsprites, temp, 0, spritecount - 1 );
            free(temp);
            break;
        }
    }
}


