/*
 * Decompiled with CFR 0.152.
 */
package com.small_it_office.flatserve.purehtml.internal.document;

import com.small_it_office.flatserve.purehtml.internal.document.HtmlTagValueModifier;
import com.small_it_office.flatserve.purehtml.internal.document.ModifierUtil;
import java.util.List;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.EndTag;
import net.htmlparser.jericho.OutputDocument;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.StartTag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListTagValueModifier
implements HtmlTagValueModifier {
    @Override
    public boolean modifyDocument(OutputDocument outputDocument, List<Element> elements, Object responseValue) {
        boolean modified = false;
        Element element = elements.get(0);
        if (responseValue instanceof List) {
            StartTag start = element.getStartTag();
            EndTag end = element.getEndTag();
            if (end != null || start.isSyntacticalEmptyElementTag()) {
                StringBuilder sb;
                String liEndTag;
                String liStartTag;
                Element li = element.getFirstElement("li");
                if (li == null) {
                    liStartTag = "<li>";
                    liEndTag = "</li>";
                } else if (li.getStartTag().isSyntacticalEmptyElementTag()) {
                    sb = new StringBuilder(li.getStartTag().toString());
                    sb.deleteCharAt(sb.lastIndexOf("/"));
                    liStartTag = sb.toString();
                    liEndTag = "</li>";
                } else if (li.getEndTag() == null) {
                    liStartTag = "<li>";
                    liEndTag = "</li>";
                } else {
                    liStartTag = li.getStartTag().toString();
                    liEndTag = li.getEndTag().toString();
                }
                sb = new StringBuilder();
                sb.append(start.toString());
                if (start.isSyntacticalEmptyElementTag()) {
                    sb.deleteCharAt(sb.lastIndexOf("/"));
                }
                for (Object value : (List)responseValue) {
                    sb.append(liStartTag);
                    if (value != null) {
                        sb.append(value.toString());
                    }
                    sb.append(liEndTag);
                }
                if (end == null) {
                    sb.append("</").append(start.getName()).append(">");
                } else {
                    sb.append(end.toString());
                }
                outputDocument.replace((Segment)element, (CharSequence)sb.toString());
                modified = true;
            }
        }
        return modified;
    }

    @Override
    public boolean responsible(String elementName) {
        return ModifierUtil.matchesAny(elementName, "ol", "ul");
    }
}

