<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.parameters
 */
/**
 * @file Parameter.php
 * @brief Parameter for php
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @author <a href="mailto:sumi@wakhok.ac.jp">SUMI Masafumi</a>
 * @version $Id: Parameter.php 2 2007-07-11 10:37:48Z ishitoya $
 * 
 * Parameter class
 */

require_once("ficus/exception/IllegalTypeException.php");
require_once("ficus/exception/IllegalArgumentException.php");

/**
 * @class Ficus_Parameter
 */
class Ficus_Parameter
{
	const PATTERN = '/^([a-zA-Z][a-zA-Z0-9_\-\.:]*|[_\.:]+[a-zA-Z0-9_\-\.:]*[a-zA-Z0-9])$/';
	/**
	 * @var $name string name of this Parameter
	 */
	protected $name = null;

	/**
	 * @var $typeName string type name of this Parameter
	 */
	protected $typeName = null;

	/**
	 * @var $value mixed value of this Parameter
	 */
	protected $value = null;

	/**
	 * constructor
	 * @param $name string name
	 * @param $typeName string type
	 * @param $value mixed value mixed
	 */
	function __construct($name, $typeName, $value){
		$this->setName($name);
		$this->setTypeName($typeName);
		$this->setValue($value);
	}

	/**
	 * get parameter name
	 * @return string name of this type
	 */
	public function name(){
		return $this->name;
	}

	/**
	 * get parameter type name
	 * @return string typename
	 */
    public function typeName(){
		return $this->typeName;
	}

    /**
	 * get value
	 * @return mixed value
	 */
	public function value(){
		return $this->value;
	}	
	
	/**
	 * set value
	 * @param $value mixed value
	 */
	public function setValue($value){
		$this->value = $value;
	}

	/**
	 * set name
	 * @param $name string name
     * @throw Ficus_IllegalTypeException no string.
     * @throw Ficus_IllegalArgumentException illegal format.
	 */
	protected function setName($name){
		if(is_string($name) === false){
			throw new Ficus_IllegalTypeException("name must be string");
		}else if(preg_match(self::PATTERN, $name) === false){
			throw new Ficus_IllegalArgumentException("illegal format name");
		}
		$this->name = $name;
	}

	/**
	 * set typeName
	 * @param $typeName string typeName
     * @throw Ficus_IllegalTypeException no string.
     * @throw Ficus_IllegalArgumentException illegal format.
	 */
	protected function setTypeName($typeName){
		if(is_string($typeName) === false){
			throw new Ficus_IllegalTypeException("typename must be string");
		}else if(preg_match(self::PATTERN, $typeName) === false){
			throw new Ficus_IllegalArgumentException("Illegal format typename");
		}
		$this->typeName = ($typeName === null) ? "" : $typeName;
	}
}
?>
