<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.pages.scaffold.organizer
 */
/**
 * @file NewScaffoldOrganizer.php
 * @brief NewScaffoldOrganizer.
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: NewScaffoldOrganizer.php 19 2007-07-25 18:20:09Z ishitoya $
 *
 */

require_once("ficus/lang/Assert.php");

/**
 * @class Ficus_NewScaffoldOrganizer
 */
class Ficus_NewScaffoldOrganizer
extends Ficus_AbstractScaffoldOrganizer{
    const TEMPLATE_PREFIX = "form/";

    /**
     * @var $hiddens array hidden parts
     */
    protected $hiddens = array();
    
    /**
     * prefix
     * @return string template prefix
     */
    public function prefix(){
        return parent::prefix() . self::TEMPLATE_PREFIX;
    }

    /**
     * on visit
     * @param $part Ficus_ScaffoldPart part
     */
    protected function onVisit($part){
        $config = $this->mediator->table();
        $entityName = $part->entity()->getEntityName();
        if($part->type() == self::TYPE_DIRECT ||
           ($config->isExcludeProperty($part, self::ACTION_NEW) &&
           $config->isTransitionParentProperty($part) == false)){
            $this->hiddens[] = $part;
            return;
        }
        
        $input = null;

        if($config->isTransitionParentProperty($part)){
            $input = $this->getChildren($part);
        }else if($part->value() instanceof Ficus_S2DaoEntity){
            if($part->type() == self::TYPE_LIST){
                $key = $part->value()->name();
                if(is_null($key)){
                    $key = $config->getDefaultValue($part);
                }
                $this->assign("qname", $part->qname());
                $this->assign("items", $part->value()->names());
                $this->assign("selected", $key);
                $input = $this->fetch("select");
            }else if($config->isNoChildren(self::ACTION_NEW)){
                return;
            }else{
                $input = $this->getChildren($part);
            }
        }else{
            $this->assign("qname", $part->qname());
            $this->assign("value", $part->value());
            $this->assign("validators", $part->validators());
            $input =
                $this->fetch("input");
        }

        if($config->isTransitionProperty($part) == false &&
           $config->isTransitionParentProperty($part) == false){
            $this->hiddens[] = $part;
            return;
        }
        if($config->isNoLabelProperty($part)){
            $this->assign("nolabel", true);
        }
        
        $this->assign("qname", $part->qname());
        $this->assign("label", $part->label());
        $this->assign("validators", $part->validators());
        $this->assign("input", $input);
        return $this->fetch($this->itemTemplate);
    }

    /**
     * get child
     */
    protected function getChildren($part){
        $input = "";
        $result = $this->result;
        foreach($part->parts() as $child){
            $this->result = "";
            $child->accept($this);
            $input .= $this->result;
            $this->assign("nolabel", false);
        }
        $this->result = $result;
        $this->assign("result", $input);
        return $this->fetch($this->entityTemplate);
    }

    /**
     * on end visit
     * @param $container Ficus_ScaffoldPartsContainer
     */
    protected function onEndVisit($container){
        foreach($this->hiddens as $hidden){
            $this->showHidden($hidden);
        }
    }

    /**
     * show hidden
     */
    protected function showHidden($hidden){
        if($hidden->value() instanceof Ficus_S2DaoEntity){
            foreach($hidden->parts() as $part){
                $this->addResult($this->showHidden($part));
            }
            return;
        }
        if($hidden->type() == self::TYPE_DIRECT &&
           $hidden->isEmptyValue()){
            $config = $this->mediator->table();
            if(($value = $config->getDefaultValue($hidden)) !== null){
                $hidden->setValue($value);
            }
        }
        $this->assign("qname", $hidden->qname());
        $this->assign("value", $hidden->value());
        $this->addResult($this->fetch("hidden"));
    }
}
?>