<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.pages.scaffold
 */
/**
 * @file ScaffoldConfiguration.php
 * @brief ScaffoldConfiguration.
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: ScaffoldConfiguration.php 19 2007-07-25 18:20:09Z ishitoya $
 *
 */

/**
 * @class Ficus_ScaffoldConfiguration
 */
class Ficus_ScaffoldConfiguration implements Ficus_ScaffoldConstants{
    /**
     * $settings array scaffold settings
     */
    protected $settings = array();

    /**
     * $tables Ficus_ScaffoldTableConfiguration
     */
    protected $tables = array();

    /**
     * constructor
     */
    public function __construct($settings){
        if(isset($settings[self::REGISTRY_TABLESETTINGS]) == false){
            throw new Ficus_IllegalArgumentException("settings must have TableSettings field");
        }
        foreach($settings[self::REGISTRY_TABLESETTINGS] as $name => $setting){
            $this->tables[$name] = $this->createTableConfiguration($setting);
        }
    }

    /**
     * get table settings
     * @param $name string name of table
     * @return Ficus_ScaffoldTableConfiguration
     */
    public function table($name){
        if(isset($this->tables[$name])){
            return $this->tables[$name];
        }else{
            throw new Ficus_IllegalArgumentException("table $name is not found");
        }
    }

    /**
     * create Ficus_ScaffoldTableConfiguration from array
     * @param $settings array of settings
     * @return Ficus_ScaffoldTableConfiguration configuration
     */
    protected function createTableConfiguration($settings){
        $config = new Ficus_ScaffoldTableConfiguration();
        if(isset($settings[self::REGISTRY_EXCLUDES])){
            foreach($settings[self::REGISTRY_EXCLUDES] as $context => $qnames){
                if(is_array($qnames) === false){
                    $config->addExcludeProperty($context, "");
                    continue;
                }
                foreach($qnames as $qname){
                    $config->addExcludeProperty($context, $qname);
                }
            }
        }
        if(isset($settings[self::REGISTRY_NOLABELS])){
            foreach($settings[self::REGISTRY_NOLABELS] as $table => $column){
                $config->addNoLabelProperty($table, $column);
            }
        }
        if(isset($settings[self::REGISTRY_DEFAULTS])){
            foreach($settings[self::REGISTRY_DEFAULTS] as $column => $value){
                $config->addDefaultValues($column, $value);
            }
        }
        if(isset($settings[self::REGISTRY_PARENT])){
            $config->setParentPart($settings[self::REGISTRY_PARENT]);
        }
        if(isset($settings[self::REGISTRY_TRANSITION])){
            $config->setTransitions($settings[self::REGISTRY_TRANSITION]);
        }
        if(isset($settings[self::REGISTRY_PROPERTIES])){
            $config->setProperties($settings[self::REGISTRY_PROPERTIES]);
        }
        if(isset($settings[self::REGISTRY_NOCHILDREN])){
            foreach($settings[self::REGISTRY_NOCHILDREN] as $context => $nochildren){
                $config->addNoChildren($context, $nochildren);
            }
        }
        return $config;
    }
}
?>
