<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.pages.scaffold
 */
/**
 * @file DeleteScaffoldForeperson.php
 * @brief table manager page
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: DeleteScaffoldForeperson.php 14 2007-07-18 14:55:12Z ishitoya $
 */

require_once("ficus/pages/AbstractPage.php");
require_once("ficus/config/Registry.php");

/**
 * @class Ficus_DeleteScaffoldForeperson
 */
class Ficus_DeleteScaffoldForeperson extends Ficus_AbstractScaffoldForeperson{
    /**
     * delete
     */
    public function doDefault(){
        $ids = $this->mediator->request()->extractAsInt(self::KEY_IDS);
        $entities = $this->mediator->daoManager()->getEntities($ids);
        $container = $this->mediator->getContainer($entities);

        $organizer =
            $this->mediator->organizerFactory()->createListOrganizer();
        $organizer->setItemTemplate("item");
        $organizer->setRowTemplate("row");
        $organizer->setHeaderTemplate("header");
        $organizer->setEntityTemplate("table");
        $container->addOrganizers($organizer);

        $this->mediator->smarty()->assign(self::KEY_IDS, $ids);
        $this->mediator->formBean()->setDo(self::DO_SUBMIT);
        return $container->build();
    }
    
    /**
     * delete submit
     */
    public function doSubmit(){
        $ids = $this->mediator->request()->extractAsString(self::KEY_IDS);

        $dao = $this->mediator->daoManager()->dao();
        $entity = $dao->entity();
        foreach($ids as $id){
            $entity->setId($id);
            $dao->delete($entity);
        }

        $this->mediator->smarty()->assign(self::KEY_IDS, $ids);
        return "";
    }
}    
?>
