<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.pages
 */
/**
 * @file PageConstants.php
 * @brief Page component factory
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: PageConstants.php 7 2007-07-14 10:55:18Z ishitoya $
 * 
 * Page component factory
 */

/**
 * @interface Ficus_PageConstants
 */
interface Ficus_PageConstants {
    /**
     * component smarty
     */
    const COMPONENT_SMARTY = "pagesSmarty";

    /**
     * component template resolver
     */
    const COMPONENT_TEMPLATERESOLVER = "templateResolver";

    /**
     * component pageLoader
     */
    const COMPONENT_PAGELOADER = "pageLoader";

    /**
     * component pageController
     */
    const COMPONENT_PAGECONTROLLER = "controller";

    /**
     * component inline page loader
     */
    const COMPONENT_INLINEPAGELOADER = "inlinePageLoader";
    
    /**
     * component inline page controller
     */
    const COMPONENT_INLINEPAGECONTROLLER = "inlineController";
    
    /**
     * component environment bean
     */
    const COMPONENT_ENVBEAN = "envBean";
    
    /**
     * component visit bean
     */
    const COMPONENT_VISITBEAN = "visitBean";

    
    /**
     * smarty cache
     */
    const REGISTRY_SMARTY = "pages.smarty";
    
    /**
     * assign name of properties
     */
    const REGISTRY_SMARTY_PROPERTIES = "pages.smarty.properties";

    /**
     * assign name of plugins
     */
    const REGISTRY_SMARTY_PLUGINS = "pages.smarty.plugins";

    /**
     * assign name of env
     */
    const REGISTRY_SMARTY_ENV = "pages.smarty.env";

    /**
     * assign name of visit
     */
    const REGISTRY_SMARTY_VISIT = "pages.smarty.visit";

    /**
     * base dir
     */
    const REGISTRY_BASE = "pages.base";

    /**
     * prefixes
     */
    const REGISTRY_PREFIXES = "pages.prefixes";

    /**
     * suffix
     */
    const REGISTRY_SUFFIX = "pages.suffix";

    /**
     * inline suffix
     */
    const REGISTRY_INLINE_SUFFIX = "pages.inline.suffix";

    /**
     * default page
     */
    const REGISTRY_DEFAULT = "pages.default";

    
    /**
     * default smarty plugins
     */
    const DEFAULT_SMARTY_PLUGINS = "plugins";
     
    /**
     * default smarty properties
     */
    const DEFAULT_SMARTY_PROPERTIES = "properties";

    /**
     * default smarty env
     */
    const DEFAULT_SMARTY_ENV = "env";

    /**
     * default smarty visit
     */
    const DEFAULT_SMARTY_VISIT = "visit";
     
    /**
     * default suffix
     */
    const DEFAULT_SUFFIX = "Page";
     
    /**
     * default inline suffix
     */
    const DEFAULT_INLINE_SUFFIX = "InlinePage";
     
    /**
     * default default page
     */
    const DEFAULT_DEFAULT = "Index";

    /**
     * default mode
     */
    const PAGE_DEFAULT_MODE = "default";

    /**
     * page exception
     */
    const PAGE_ERROR = "error";

    /**
     * page exception
     */
    const PAGE_EXCEPTION = "exception";

    /**
     * page exception template
     */
    const REGISTRY_EXCEPTION_TEMPLATE = "exception.tpl";

    /**
     * page exception template
     */
    const DEFAULT_EXCEPTION_TEMPLATE = "exception.tpl";

    /**
     * pagename
     */
    const PAGENAME = "pagename";

    /**
     * actionname
     */
    const ACTIONNAME= "actioname";

    /**
     * not display
     */
    const NODISPLAY = "nodisplay";

    /**
     * get template as mode template
     */
    const MODE_TEMPLATE = "modetemplate";

    /**
     * current page name
     */
    const CURRENT_PAGENAME = "currentPage";

    /**
     * fowarded
     */
    const FORWARDED = "forwarded";

    /**
     * authorization not required
     */
    const AUTHORIZATION_NOT_REQUIRED = "authorization not required";

    /**
     * auth user name
     */
    const KEY_USER = "PHP_AUTH_USER";

    /**
     * auth password
     */
    const KEY_PASSWORD = "PHP_AUTH_PW";

    /**
     * fail counts
     */
    const AUTH_FAILUER_COUNT = "auth_failuer_count";

    /**
     * guest user
     */
    const USER_GUEST = "__guest";

    /**
     * pages dir
     */
    const PAGES_DIR = "pages";

    /**
     * page class suffix
     */
    const PAGE_SUFFIX = "Page";

    /**
     * template dir
     */
    const TEMPLATES_DIR = "templates";

    /**
     * template name
     */
    const TEMPLATE_NAME = "pages";
}
?>
