<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.pages
 */
/**
 * @file InlinePageController.php
 * @brief controll page
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: InlinePageController.php 2 2007-07-11 10:37:48Z ishitoya $
 */

require_once("ficus/pages/PageComponentFactory.php");

/**
 * @class Ficus_InlinePageController
 */
class Ficus_InlinePageController{
    /**
     * pages
     */
    protected $pages = array();
    
    /**
     * call function
     */
    public function __call($name, $arguments){
        $page = $this->load($name);
        call_user_func_array(array($page, "action"), $arguments);
    }

    /**
     * add pages
     */
    protected function load($name){
        if(array_key_exists($name, $this->pages) === false){
            $loader = Ficus_PageComponentFactory::getInlinePageLoader();
            try{
                $page = $loader->load($name);
                if($page instanceof Ficus_InlinePage == false){
                    throw new Ficus_TypeMismatchException("page, $name is not instance of InlinePage");
                }
                $this->pages[$name] = $page;
            }catch(Ficus_PageNotFoundException $e){
                throw new Ficus_PageNotFoundException("inline page, $name is not found in class path.");
            }
        }
        return $this->pages[$name];
    }
}
?>