<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.net
 */
/**
 * @file RMIComponentFactory.php
 * @brief RMI component factory
 * @author <a href="mailto:sumi@wakhok.ac.jp">SUMI Masafumi</a>
 * @version $Id: RMIComponentFactory.php 2 2007-07-11 10:37:48Z ishitoya $
 * 
 * RMI component factory
 */

require_once("ficus/io/File.php");
require_once("ficus/config/Registry.php");
require_once("ficus/lang/AutoLoad.php");
require_once("ficus/lang/S2ContainerAutoLoad.php");
require_once("ficus/lang/ClassLoaderAutoLoad.php");
require_once("ficus/net/rmi/RemoteMethodInvocation.php");
require_once("ficus/net/rmi/fml/FMLRMI.php");
require_once("ficus/net/rmi/pukiwiki/PukiWikiRMI.php");

/**
 * @class Ficus_RMIComponentFactory
 */
class Ficus_RMIComponentFactory {

    /**
     * Default dicon file name.
     */
    const DEFAULT_DICON_FILE = 'rmi.dicon';

    /**
     * dicon namespace.
     */
    const DICON_NAMESPACE = 'rmi';

    /**
     * @var S2Container S2Container.
     */
    private static $container = null;

    /**
     * Get dicon path.
     *
     * return string dicon path..
     */
    private static function getDiconPath() {
        $diconPath = Ficus_File::currentDir()
            ->resolve(self::DEFAULT_DICON_FILE)->getPath();
        return $diconPath;
    }

    /**
     * Get S2Container.
     *
     * return S2Container S2Container.
     */
    private static function getS2Container() {
        if (self::$container == null) {
            $diconPath = self::getDiconPath();
            self::$container = S2ContainerFactory::create($diconPath);
            Ficus_AutoLoad::add(new Ficus_S2ContainerAutoLoad());
        }
        return self::$container;
    }

    /**
     * Get RMI component
     *
     * @param $name string name of RemoteMethodInvocation
     * @return Ficus_RemoteMethodInvocation RMI component.
     */
    public static function getRMIComponent($name) {
        $container = self::getS2Container();
        $componentName = self::DICON_NAMESPACE  . '.' . strtolower($name);
        return $container->getComponent($componentName);
    }

}
?>
