<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.net
 */
/**
 * @file URIFactoryImpl.php
 * @brief URIFactoryImpl for php
 * @author <a href="mailto:sumi@wakhok.ac.jp">SUMI Masafumi</a>
 * @version $Id: URIFactoryImpl.php 2 2007-07-11 10:37:48Z ishitoya $
 * 
 * URIFactoryImpl for php
 */
require_once('ficus/net/URIFactory.php');
require_once("ficus/net/URI.php");
require_once("ficus/net/OpaqueURI.php");
require_once("ficus/net/MailtoURI.php");
require_once("ficus/exception/ClassNotFoundException.php");
/**
 * @class Ficus_URIFactoryImpl
 */
class Ficus_URIFactoryImpl implements Ficus_URIFactory {

    /**
     * Get suffix of class name.
     *
     * @return string suffix.
     */
    public function getSuffix() {
        return 'URI';
    }

    /**
     * Default URI .
     *
     * @param $uri string URI.
     * @return Ficus_URI URI.
     */
    public function defaultInstance($uri) {
        throw new Ficus_ClassNotFoundException($uri);
    }

    /**
     * Factory method.
     *
     * @param $uri string URI.
     * @return Ficus_URI URI.
     */
    public function createInstance($scheme, $uri) {
        $className = 'Ficus_' . ucwords(strtolower($scheme)) . $this->getSuffix();
        if (class_exists($className)) {
            return new $className($uri);
        } else {
            return $this->defaultInstance($uri);
        }
    }

}
?>
