<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.net
 */
/**
 * @file OpaqueURI.php
 * @brief Opaque URI.
 * @author <a href="mailto:sumi@wakhok.ac.jp">SUMI Masafumi</a>
 * @version $Id: OpaqueURI.php 2 2007-07-11 10:37:48Z ishitoya $
 * 
 * Opaque URI.
 */
require_once("ficus/net/URI.php");
require_once("ficus/net/AbsoluteURI.php");
require_once("ficus/net/URIBuilder.php");
require_once("ficus/exception/URISyntaxException.php");
/**
 * @class Ficus_OpaqueURI
 */
class Ficus_OpaqueURI extends Ficus_URI implements Ficus_AbsoluteURI {

    /**
     * Constructor.
     *
     * @param $uri string URI.
     * @throw Ficus_URISyntaxException invalid opaque URI.
     */
    public function __construct($uri) {
        parent::__construct($uri);
    }

    /**
     * Parse opaque URI.
     */
    protected function parse() {
        parent::parse();
        $specific = $this->getSpecific();
        if ($specific{0} == '/') {
            throw new Ficus_URISyntaxException("No opaque URI. " . $this->uri);
        }
    }

    /**
     * Resovle relative URI.
     *
     * @param $uri mixed string or Ficus_URI relative URI.
     */
    final public function resolve($uri) {
        if ($uri->isAbsolute()) {
            return $uri;
        }
        if (!is_null($uri->getRawFragment())) {
            $fragment = $uri->getRawFragment();
        } else {
            $fragment = $this->getRawFragment();
        }
        return Ficus_URIBuilder::createByParts($this->getRawScheme(),
                                       null,
                                       $this->getRawSpecific(),
                                       null, $fragment);
    }

    /**
     * Normalize URI.
     *
     * @return Ficus_OpaqueURI URI.
     */
    final public function normalize() {
        return $this;
    }

}
?>
