<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * PHP Version 5
 *
 * LICENSE: This source file is subject to version 3.0 of the PHP license
 * that is available through the world-wide-web at the following URI:
 * http://www.php.net/license/3_0.txt.  If you did not receive a copy of
 * the PHP License and are unable to obtain it through the web, please
 * send a note to license@php.net so we can mail you a copy immediately.
 *
 * @category   PHP
 * @package      Ficus_ReflectionAnnotation
 * @author     Sebastian Bergmann <sb@sebastian-bergmann.de>
 * @copyright  2005 Sebastian Bergmann <sb@sebastian-bergmann.de>
 * @license    http://www.php.net/license/3_0.txt  PHP License 3.0
 * @version    CVS: $Id: ReflectionAnnotation.php 2 2007-07-11 10:37:48Z ishitoya $
 * @link       http://pear.php.net/package/  Ficus_ReflectionAnnotation
 * @since      File available since Release 1.0.0
 */

/**
 * Abstract base class for Annotations.
 *
 * @category   PHP
 * @package      Ficus_ReflectionAnnotation
 * @author     Sebastian Bergmann <sb@sebastian-bergmann.de>
 * @copyright  2005 Sebastian Bergmann <sb@sebastian-bergmann.de>
 * @license    http://www.php.net/license/3_0.txt  PHP License 3.0
 * @version    Release: @package_version@
 * @link       http://pear.php.net/package/  Ficus_ReflectionAnnotation
 * @since      Class available since Release 1.0.0
 */
abstract class Ficus_ReflectionAnnotation {
    private $reflector;
    private $arguments;
    private static $prefixes;

    /**
     * Constructor.
     *
     * @param  Reflector $reflector
     * @param  Array     $arguments
     * @param  Array     $prefixes
     * @throws InvalidArgumentException
     * @access protected
     */
    protected function __construct($reflector, $arguments) {
        if (!($reflector instanceof ReflectionClass    ||
              $reflector instanceof ReflectionFunction ||
              $reflector instanceof ReflectionMethod   ||
              $reflector instanceof ReflectionProperty)) {
            throw new InvalidArgumentException;
        }

        $this->reflector = $reflector;
        $this->arguments = $arguments;

        // XXX: TODO: Implement parameter mapping.
    }

    /**
     * set class name prefix
     *
     * @param array $prefixes
     */
    public static final function setPrefixes($prefixes){
        self::$prefixes = $prefixes;
    }
    
    /**
     * Factory for concrete implementations of   Ficus_ReflectionAnnotation.
     *
     * @param  Object $reflector
     * @param  String $name
     * @param  Array  $arguments
     * @return   Ficus_ReflectionAnnotation
     * @throws ReflectionException
     * @access public
     * @static
     * @final
     */
    public static final function factory($reflector, $name, $arguments) {
        $className = $name . 'Annotation';
        if(class_exists($className) == false){
            $className = ucfirst($name) . 'Annotation';
            foreach(self::$prefixes as $prefix){
                if(class_exists($prefix . $className)){
                    $className = $prefix . $className;
                    break;
                }
            }
        }
        $class = new ReflectionClass($className);

        if ($class->isSubclassOf('Ficus_ReflectionAnnotation') &&
            $class->isInstantiable()) {
            return $class->newInstance(
              $reflector,
              $arguments
            );
        }
    }

    /**
     * Returns the reflector this annotation is associated with.
     *
     * @return Reflector
     * @access public
     */
    public final function getReflector() {
        return $this->reflector;
    }
}

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * c-hanging-comment-ender-p: nil
 * End:
 */
?>
