<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.lang.annotation
 */
/**
 * @file VarAnnotation.php
 * @brief This class stores var annotation data
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: VarAnnotation.php 2 2007-07-11 10:37:48Z ishitoya $
 */

require_once "ficus/lang/reflect/ReflectionAnnotation.php";
require_once "ficus/lang/Assert.php";

/**
 * @class Ficus_VarAnnotation
 */
class Ficus_VarAnnotation extends Ficus_ReflectionAnnotation
{
    const T_NAME = "name";
    const T_TYPE = "type";
    const T_COMMENT = "comment";
    const T_ISARRAY = "isArray";
    const T_VAR = "var";

    /**
     * array of annotations
     */
    private $annotations = array();
    
    /**
     * constructor
     * @param $reflector object reflector object
     * @param $arguments string arguments written in annotation section
     */
    public function __construct($reflector, $arguments){
        preg_match('/\$([^\s]+)\s+(([a|A]rray)\s+of\s+(.*)|([^\s]+)\s+(.*))/',
                   $arguments, $matches);
        $annotations = array();
        if($matches[3] == "array"){
            $this->annotations[self::T_NAME] = $matches[1];
            $this->annotations[self::T_TYPE] = $matches[4];
            $this->annotations[self::T_COMMENT] = $matches[2];
            $this->annotations[self::T_ISARRAY] = true;
        }else{
            $this->annotations[self::T_NAME] = $matches[1];
            $this->annotations[self::T_TYPE] = $matches[5];
            $this->annotations[self::T_COMMENT] = $matches[6];
            $this->annotations[self::T_ISARRAY] = false;
        }            
        parent::__construct($reflector, $arguments);
    }

    /**
     * get Name
     * @return string name
     */
    public function getName(){
        return $this->annotations[self::T_NAME];
    }

    /**
     * get Type
     * @return string type
     */
    public function getType(){
        return $this->annotations[self::T_TYPE];
    }

    /**
     * get COMMENT
     * @return string comment
     */
    public function getComment(){
        return $this->annotations[self::T_COMMENT];
    }

    /**
     * is Array
     * @return boolean 
     */
    public function isArray(){
        return $this->annotations[self::T_ISARRAY];
    }

    /**
     * is Class
     * @return boolean
     */
    public function isClass(){
        if(strpos($this->getType(), "urn:") !== false){
            return true;
        }
        return false;
    }
}
?>
