<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.lang
 */
/**
 * @file RangeIterator.php
 * @brief RangeIterator for php
 * @author <a href="mailto:sumi@wakhok.ac.jp">SUMI Masafumi</a>
 * @version $Id: RangeIterator.php 2 2007-07-11 10:37:48Z ishitoya $
 * 
 * Util RangeIterator.
 */
/**
 * @class Ficus_RangeIterator
 */
class Ficus_RangeIterator implements Iterator
{
    /**
     * Current value.
     */
    private $current;

    /**
     * First value.
     */
    private $first;

    /**
     * Last value.
     */
    private $last;

    /**
     * Constructor.
     */
    public function __construct($first, $last = null) {
        $this->first = $first;
        if (isset($last)) {
            $this->last = $last;
        } else {
            $this->last = $first;
        }
        $this->current = $first;
    }

    /**
     * Return the current number.
     *
     * @return int current number.
     */
    public function current() {
        return $this->current;
    }

    /**
     * Return the key of the current number.
     *
     * @return int current char position.
     */
    public function key() {
        return $this->current - $this->first;
    }

    /**
     * Move forward to next number.
     */
    public function next() {
        $this->current++;
    }

    /**
     * Rewind the Iterator to the first number.
     */
    public function rewind() {
        $this->current = $this->first;
    }

    /**
     * Check if there is a current char after calls to rewind() or next().
     */
    public function valid() {
        return $this->current <= $this->last;
    }

}
?>
