<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.lang
 */
/**
 * @file AutoLoad.php
 * @brief define __autoload class
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: AutoLoad.php 2 2007-07-11 10:37:48Z ishitoya $
 */

/**
 * @class Ficus_AutoLoad
 */
abstract class Ficus_AutoLoad {
    /**
     * autoloads function classes
     */
    protected static $autoloads = array();

    /**
     * abstract autoload
     * @param $classname string class name to load
     * @return boolean true if load succeeded
     */
    protected abstract function load($classname);

    /**
     * add auto load instance
     */
    public static function add(Ficus_AutoLoad $autoload){
        self::$autoloads[get_class($autoload)] = $autoload;
    }
    
    /**
     * autoload function
     * @param $classname string class name toload
     * @return boolean true if load succeeded
     */
    public static function autoload($classname){
        if(empty($classname)){
            return false;
        }
        foreach(self::$autoloads as $autoload){
            if($autoload->load($classname)){
                return true;
            }
        }
        return false;
    }
}

if (!function_exists('__autoload')) {
    function __autoload($class = null){
        Ficus_AutoLoad::autoload($class);
    }
}
?>
