<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.lang
 */
/**
 * @file Arrays.php
 * @brief Arrays for php
 * @author <a href="mailto:sumi@wakhok.ac.jp">SUMI Masafumi</a>
 * @version $Id: Arrays.php 2 2007-07-11 10:37:48Z ishitoya $
 * 
 * Util Type utility.
 */
require_once("ficus/exception/TypeMismatchException.php");
/**
 * @class Ficus_Arrays
 */
class Ficus_Arrays
{
    /**
     * collect equals key.
     *
     * example:
     *      $ary = Ficus_Arrays::delete($ary, $target,
     *          create_function('$obj1, $obj2', 'return $obj1->equals($obj2);'));
     *
     * @param $ary array target
     * @param $obj mixed object defined equals().
     * @param $callback callback predicate function
     * @return array of equals $obj
     */
    public static function delete($ary, $obj, $callback) {
        $survivor = array();
        foreach ($ary as $element) {
            if (!call_user_func($callback, $element, $obj)) {
                array_push($survivor, $element);
            }
        }
        return $survivor;
    }

    /**
     * collect equals key.
     *
     * example:
     *      $ary = Ficus_Arrays::deleteBy($ary, $target, "equals");
     *
     * @param $ary array target
     * @param $obj mixed object defined equals().
     * @param $function string predicate method name
     * @return array of equals $obj
     */
    public static function deleteBy($ary, $obj, $function) {
        $survivor = array();
        foreach ($ary as $element) {
            if (!$element->$function($obj)) {
                array_push($survivor, $element);
            }
        }
        return $survivor;
    }
    /**
     * Array to string.
     *
     * @param $array array.
     * @return string string.
     */
    static public function arrayToString($array) {
        $buf = '';
        foreach ($array as $element) {
            $buf .= $element->__toString();
        }
        return $buf;
    }
}
?>
