<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.lang
 */
/**
 * @file Array.php
 * @brief Array for php
 * @author <a href="mailto:sumi@wakhok.ac.jp">SUMI Masafumi</a>
 * @version $Id: Array.php 15 2007-07-18 15:02:48Z ishitoya $
 * 
 * Array wrapper class.
 */
require_once('ficus/exception/NotSupportedException.php');
require_once('ficus/exception/MethodNotFoundException.php');
/**
 * @class Ficus_Array
 */
class Ficus_Array implements IteratorAggregate
{

    /**
     * @var $array array.
     */
    private $array;

    /**
     * Constructor.
     *
     * @param $array array.
     */
    public function __construct() {
        if (func_num_args() == 1 && is_array(func_get_arg(0))) {
            $this->array = func_get_arg(0);
        } else {
            $this->array = func_get_args();
        }
    }

    /**
     * Copy.
     *
     * @return Ficus_Array clone myself.
     */
    public function copy() {
        return new Ficus_Array($this->array);
    }

    /**
     * At element.
     *
     * @return mixed element of array.
     */
    public function at($index) {
        return $this->array[$index];
    }

    /**
     * As array.
     *
     * @return array this array.
     */
    public function asArray() {
        return $this->array;
    }

    /**
     * Get iterator.
     *
     * @return ArrayObject iterator.
     */
    public function getIterator() {
        return new ArrayObject($this->array);
    }

    /**
     * Equals.
     *
     * @param $array mixed array or Ficus_Array.
     * @return boolean true if equals.
     */
    public function equals($array) {
        if ($array instanceof Ficus_Array) {
            return ($this->array == $array->asArray());
        } else {
            return ($this->array == $array);
        }
    }

    /**
     * Call PHP arrays function.
     *
     * @param $name array function name.
     * @param $arguments function arguments.
     * @return mixed function return value.
     * @throw Ficus_MethodNotFoundException method not found.
     */
    public function __call($name, $arguments) {
        $arguments = array_map(array($this, 'asArrayFilter'), $arguments);
        if (substr($name, -1) == '_') {
            $strip = true;
            $name = substr($name, 0, -1);
        } else {
            $strip = false;
        }
        $ret = $this->call($name, $arguments);
        if (!$strip && is_array($ret)) {
            return new Ficus_Array($ret);
        } else {
            return $ret;
        }
    }

    /**
     * Call PHP arrays function.
     *
     * @param $name array function name.
     * @param $arguments function arguments.
     * @return mixed function return value.
     * @throw Ficus_MethodNotFoundException method not found.
     */
    protected function call($name, $arguments) {
        switch ($name) {
            case 'change_key_case':
            case 'chunk':
            case 'combine': //(array keys, array values)
            case 'count_values':
            case 'diff_assoc':
            case 'diff_key':
            case 'diff_uassoc':
            case 'diff_ukey':
            case 'diff':
            case 'filter':
            case 'flip':
            case 'intersect_assoc':
            case 'intersect_key':
            case 'intersect_uassoc':
            case 'intersect_ukey':
            case 'intersect':
            case 'keys':
            case 'merge_recursive':
            case 'merge':
            case 'multisort':
            case 'pad':
            case 'pop':
            case 'product':
            case 'push':
            case 'rand':
            case 'reduce':
            case 'reverse':
            case 'shift':
            case 'slice':
            case 'splice':
            case 'sum':
            case 'udiff_assoc':
            case 'udiff_uassoc':
            case 'udiff':
            case 'uintersect_assoc':
            case 'uintersect_uassoc':
            case 'uintersect':
            case 'unique':
            case 'unshift':
            case 'values':
            case 'walk_recursive':
            case 'walk':
            $name = 'array_' . $name;

            case 'array_change_key_case':
            case 'array_chunk':
            case 'array_combine': //(array keys, array values)
            case 'array_count_values':
            case 'array_diff_assoc':
            case 'array_diff_key':
            case 'array_diff_uassoc':
            case 'array_diff_ukey':
            case 'array_diff':
            case 'array_filter':
            case 'array_flip':
            case 'array_intersect_assoc':
            case 'array_intersect_key':
            case 'array_intersect_uassoc':
            case 'array_intersect_ukey':
            case 'array_intersect':
            case 'array_keys':
            case 'array_merge_recursive':
            case 'array_merge':
            case 'array_multisort':
            case 'array_pad':
            case 'array_pop':
            case 'array_product':
            case 'array_push':
            case 'array_rand':
            case 'array_reduce':
            case 'array_reverse':
            case 'array_shift':
            case 'array_slice':
            case 'array_splice':
            case 'array_sum':
            case 'array_udiff_assoc':
            case 'array_udiff_uassoc':
            case 'array_udiff':
            case 'array_uintersect_assoc':
            case 'array_uintersect_uassoc':
            case 'array_uintersect':
            case 'array_unique':
            case 'array_unshift':
            case 'array_values':
            case 'array_walk_recursive':
            case 'array_walk':
            case 'arsort':
            case 'asort':
            case 'count':
            case 'current':
            case 'each':
            case 'end':
            case 'extract':
            case 'key':
            case 'krsort':
            case 'ksort':
            case 'natcasesort':
            case 'natsort':
            case 'next':
            case 'pos':
            case 'prev':
            case 'reset':
            case 'rsort':
            case 'shuffle':
            case 'sizeof':
            case 'sort':
            case 'uasort':
            case 'uksort':
            case 'usort':
            if (is_array($arguments)) {
                $argumentsWithArray = array_merge(array($this->array), $arguments);
            } else {
                $argumentsWithArray = array($this->array);
            }
            return call_user_func_array($name, $argumentsWithArray);
            break;

            // this array is second argument.
            case 'key_exists':
            case 'map':
            case 'search':
            $name = 'array_' . $name;

            case 'array_key_exists':
            case 'array_map':
            case 'array_search':
            case 'in_array':
            $arrangedArguments = array();
            $arrangedArguments []= $arguments[0];
            $arrangedArguments []= $this->array;
            $arrangedArguments += array_slice($arguments, 1);
            return call_user_func_array($name, $arrangedArguments);
            break;

            //case 'array_fill':
            //case 'compact':
            //case 'list':
            //case 'range':

            default:
            break;

        }
        throw new Ficus_MethodNotFoundException($name);
    }

    /**
     * As array filter.
     *
     * @param $array Ficus_array array.
     * @return array primitive array.
     */
    public function asArrayFilter($arg) {
        return ($arg instanceof Ficus_Array) ? $arg->asArray() : $arg;
    }

    /**
     * string to array. fazy.
     *
     * @param $string string
     * @return array of value
     */
    public static function stringToArray($string){
        $values = explode(",", $string);
        foreach($values as $key => $value){
            $values[$key] = trim($value);
        }
        return $values;
    }

    /**
     * convert encoding
     *
     * @param $target array values to convert
     * @param $dest string dest encoding
     * @param $src string source encoding
     */
    public static function convertEncoding($target, $dest = null, $src = null){
        if(!extension_loaded("mbstring")){
            throw new Ficus_NotSupportedException("mbstring is not supported on this computer");
        }
        if(is_null($dest)){
            $dest = mb_detect_encoding("Ꮇ");
        }
        if(is_null($src)){
            $hint = "";
            foreach($target as $key => $value){
                $hint .= $key . $value;
            }
            $src = mb_detect_encoding($hint, "EUC-JP,SJIS,UTF-8,JIS,ASCII");
        }

        $converted = array();
        foreach($target as $key => $value){
            $key = mb_convert_encoding($key, $dest, $src);
            $value = mb_convert_encoding($value, $dest, $src);
            $converted[$key] = $value;
        }
        return $converted;
    }
}
?>
