<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.io
 */
/**
 * @file YAMLFileReader.php
 * @brief YAMLFileReader for php
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @author <a href="mailto:sumi@wakhok.ac.jp">SUMI Masafumi</a>
 * @version $Id: YAMLFileReader.php 2 2007-07-11 10:37:48Z ishitoya $
 * 
 * YAML File Reader for php
 */

require_once("ficus/io/AbstractFileReader.php");
require_once("spyc/spyc.php");

/**
 * @class Ficus_YAMLFileReader
 */
class Ficus_YAMLFileReader extends Ficus_AbstractFileReader{

    /** extension of property file */
    const PROPERTY_SUFFIX = "yml"; 

	/**
	 * read property file.
	 * @param $package string property file name.
     * @param $suffix string suffix of property file name
     * @param $class string caller class
     * @throw Ficus_NotReadyException no initialized.
     * @throw Ficus_MultipleFileFoundException multiple file found.
     * @throw Ficus_FileNotFoundException file not found.
	 */
	public static function read($package, $suffix = "", $class = __CLASS__){
        if(empty($suffix)){
            $suffix = self::PROPERTY_SUFFIX;
        }
        return parent::read($package, $suffix, $class);
    }

    /**
     * on read
     * @param $filename string file name
     * @return array of result
     */
    public function onRead($filename){ 
        return Spyc::YAMLLoad($filename);
	}
}
?>
