<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2006 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.cli.phing
 */
/**
 * @file PhingTestResult.php
 * @brief phing test
 * @author <a href="kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: PhingTestResult.php 2 2007-07-11 10:37:48Z ishitoya $
 *
 * executes phing test result (depends on PHPUnit result formatting)
 */

require_once("ficus/exception/IllegalArgumentException.php");
require_once("ficus/cli/phing/Phing.php");
require_once("ficus/lang/Runtime.php");

/**
 * @class Ficus_PhingTestResult
 */
class Ficus_PhingTestResult
{
    protected $fatalError = "";
    protected $warnings = array();
    protected $notices = array();

    protected $failureCount = 0;
    protected $testCount = 0;
    protected $errorCount = 0;

    public function __construct($output){
        $error = $output[Ficus_Runtime::ERROR];
        unset($output[Ficus_Runtime::ERROR]);
        $this->parseError($error);
        $this->parseOutput($output);
    }

    protected function parseError($output){
        $error = explode("\n", $output);
        foreach($error as $line){
            if(preg_match('/fatal error/i', $line)){
                $this->fatalError = $line;
            }else if(preg_match('/warning/i', $line)){
                $this->warnings[]= $line;
            }else if(preg_match('/notice/i', $line)){
                $this->notices[] = $line;
            }
        }        
    }
    
    protected function parseOutput($output){
        foreach($output as $line){
            if(preg_match('/Tests Run: ([0-9]+)[^0-9]+([0-9]+)[^0-9]+([0-9]+)/i', $line, $regs)){
                $this->testCount = $regs[1];
                $this->failureCount = $regs[2];
                $this->errorCount = $regs[3];
            }
        }        
    }

    public function getFatalError(){
        return $this->fatalError;
    }

    public function getWarnings(){
        return $this->warnings;
    }
    
    public function getNotices(){
        return $this->notices;
    }

    public function getWarningCount(){
        return count($this->warnings);
    }

    public function getNoticeCount(){
        return count($this->notices);
    }

    public function getFailureCount(){
        return $this->failureCount;
    }

    public function getTestCount(){
        return $this->testCount;
    }
    
    public function getErrorCount(){
        return $this->errorCount;
    }

    public function isSucceeded(){
        return empty($this->fatalError);
    }

    public function __toString(){
        $str = $this->getTestCount() . " tests executed.\n";
        $str .= "  " . $this->getFailureCount() . " Failures.\n";
        $str .= "  " . $this->getErrorCount() . " Errors.\n";
        $str .= "Additionaly, while executing test task,\n";
        $str .= "  " . $this->getWarningCount() . " of Warnings reported.\n";
        $str .= "  " . $this->getNoticeCount() . " of Notices reported.\n";
        $str .= "\n";
        return $str;
    }
}
?>
