<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.cli
 */
/**
 * @file CommandLineArgument.php
 * @brief command line argument class class
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: CommandLineArgument.php 15 2007-07-18 15:02:48Z ishitoya $
 *
 * Command line argument class
 */

/**
 * @class Soya_CommandLineArgument
 */
class Soya_CommandLineArgument{
    const PREFIX = "-";
    const PREFIX_LONG = "--";
    const ARGUMENT_PATTERN = '/(-|--)([^ ]+)/';

    private $names = array();
    private $value = null;

    public function __construct($shortNames = array(),
                                $longNames = array()){
        $this->names[self::PREFIX]      = $shortNames;
        $this->names[self::PREFIX_LONG] = $longNames;
    }
    
    public function addShortName($name){
        $this->names[self::PREFIX] = $name;
    }

    public function addLongName($name){
        $this->names[self::PREFIX_LONG] = $name;
    }

    public function addShortNames($names){
        $this->names[self::PREFIX] =
          array_merge($this->names[self::PREFIX], $names);
    }

    public function addLongNames($names){
        $this->names[self::PREFIX_LONG] =
          array_merge($this->name[self::PREFIX_LONG], $names);
    }

    public function value(){
        return $this->value;
    }

    public function check($arguments, $type){
        if(empty($this->names[self::PREFIX]) &&
           empty($this->names[self::PREFIX_LONG])){
            return false;
        }

        reset($arguments);
        while($argument = next($arguments)){
            if(preg_match(self::ARGUMENT_PATTERN, $argument, $regs) == false){
                continue;
            }
            foreach($this->names[$regs[1]] as $name){
                if($regs[2] == $name){
                    if($type == Soya_CommandLineCommand::PARAMETER){
                        $this->value = next($arguments);
                    }
                    return true;
                }
            }
        }
        return false;
    }
}
?>