<?php 
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.beans.serializer
 */
/**
 * @file BeanDeserializer.php
 * @brief deserialize Bean.
 * @author <a href="mailto:kent@guarana.cc">ISHITOYA Kentaro</a>
 * @version $Id: BeanDeserializer.php 2 2007-07-11 10:37:48Z ishitoya $
 */

/**
 * @interface Ficus_BeanDeserializer
 */
interface Ficus_BeanDeserializer{
    /**
     * unserialize bean
     * @param $bean Ficus_Bean target bean
     * @param $data array array to deserialize
     * @return Ficus_Bean bean
     */
    public function deserialize($bean, $data);
}
?>
