<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.analyzer
 */
/**
 * @file ThrowAnalyzeData.php
 * @brief ThrowAnalyzeData of PHP.
 * @author <a href="mailto:sumi@wakhok.ac.jp">SUMI Masafumi</a>
 * @version $Id: ThrowAnalyzeData.php 2 2007-07-11 10:37:48Z ishitoya $
 * 
 * Throw Analyze data of PHP.
 */
require_once('ficus/analyzer/AnalyzeData.php');
/**
 * @class Ficus_ThrowAnalyzeData
 */
class Ficus_ThrowAnalyzeData extends Ficus_AnalyzeData {
    /**
     * Constructor.
     *
     * @param $name string of name.
     */
    public function __construct($name) { $this->name = $name; }
    /**
     * To string.
     *
     * @return string of this.
     */
    public function __toString() {
        return 'throw ' . $this->name . "\n";
    }
}
?>
