<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */
/*
 * Copyright 2004-2007 Project Guarana Development Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @package ficus.analyzer
 */
/**
 * @file ParameterAnalyzeData.php
 * @brief ParameterAnalyzeData of PHP.
 * @author <a href="mailto:sumi@wakhok.ac.jp">SUMI Masafumi</a>
 * @version $Id: ParameterAnalyzeData.php 2 2007-07-11 10:37:48Z ishitoya $
 * 
 * Parameter Analyze data of PHP.
 */
require_once('ficus/analyzer/AnalyzeData.php');
/**
 * @class Ficus_ParameterAnalyzeData
 */
class Ficus_ParameterAnalyzeData extends Ficus_AnalyzeData {
    /**
     * @var default parameter value.
     */
    protected $defaultValue;
    /**
     * Constructor.
     *
     * @param $name string parameter name.
     */
    public function __construct($name) { $this->name = $name; }
    /**
     * Set default parameter value.
     *
     * @param $defaultValue default parameter value.
     */
    public function setDefaultValue($defaultValue) { $this->defaultValue = $defaultValue; }
    /**
     * Get default parameter value.
     *
     * @return default parameter value.
     */
    public function getDefaultValue() { return $this->defaultValue; }
    /**
     * To string.
     *
     * @return string of this.
     */
    public function __toString() {
        if ($thid->defaultValue != null) {
            return $this->name . ' = ' . $this->defaultValue . "\n";
        } else {
            return $this->name . "\n";
        }
    }
}
?>
