/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.poi.POIXMLException;
import org.apache.poi.POIXMLFactory;
import org.apache.poi.POIXMLRelation;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackagePartName;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.openxml4j.opc.PackageRelationshipCollection;
import org.apache.poi.openxml4j.opc.PackagingURIHelper;
import org.apache.poi.openxml4j.opc.TargetMode;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;
import org.apache.xmlbeans.XmlOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class POIXMLDocumentPart {
    private static POILogger logger = POILogFactory.getLogger(POIXMLDocumentPart.class);
    public static final XmlOptions DEFAULT_XML_OPTIONS = new XmlOptions();
    private PackagePart packagePart;
    private PackageRelationship packageRel;
    private POIXMLDocumentPart parent;
    private List<POIXMLDocumentPart> relations;

    public POIXMLDocumentPart(OPCPackage pkg) {
        PackageRelationship coreRel = pkg.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument").getRelationship(0);
        this.relations = new LinkedList<POIXMLDocumentPart>();
        this.packagePart = pkg.getPart(coreRel);
        this.packageRel = coreRel;
    }

    public POIXMLDocumentPart() {
        this.relations = new LinkedList<POIXMLDocumentPart>();
    }

    public POIXMLDocumentPart(PackagePart part, PackageRelationship rel) {
        this.relations = new LinkedList<POIXMLDocumentPart>();
        this.packagePart = part;
        this.packageRel = rel;
    }

    public final PackagePart getPackagePart() {
        return this.packagePart;
    }

    public final PackageRelationship getPackageRelationship() {
        return this.packageRel;
    }

    public final List<POIXMLDocumentPart> getRelations() {
        return this.relations;
    }

    protected final void addRelation(POIXMLDocumentPart part) {
        this.relations.add(part);
    }

    public final void removeRelation(POIXMLDocumentPart part) {
        this.getPackagePart().removeRelationship(part.getPackageRelationship().getId());
        this.getPackagePart().getPackage().removePart(part.getPackagePart());
        this.relations.remove(part);
    }

    public final POIXMLDocumentPart getParent() {
        return this.parent;
    }

    public String toString() {
        return this.packagePart.toString();
    }

    protected void commit() throws IOException {
    }

    protected final void onSave() throws IOException {
        this.commit();
        for (POIXMLDocumentPart p : this.relations) {
            p.onSave();
        }
    }

    protected final POIXMLDocumentPart createRelationship(POIXMLRelation descriptor, POIXMLFactory factory) {
        return this.createRelationship(descriptor, factory, -1, false);
    }

    protected final POIXMLDocumentPart createRelationship(POIXMLRelation descriptor, POIXMLFactory factory, int idx) {
        return this.createRelationship(descriptor, factory, idx, false);
    }

    protected final POIXMLDocumentPart createRelationship(POIXMLRelation descriptor, POIXMLFactory factory, int idx, boolean noRelation) {
        try {
            PackagePartName ppName = PackagingURIHelper.createPartName(descriptor.getFileName(idx));
            PackageRelationship rel = null;
            if (!noRelation) {
                rel = this.packagePart.addRelationship(ppName, TargetMode.INTERNAL, descriptor.getRelation());
            }
            PackagePart part = this.packagePart.getPackage().createPart(ppName, descriptor.getContentType());
            POIXMLDocumentPart doc = factory.newDocumentPart(descriptor);
            doc.packageRel = rel;
            doc.packagePart = part;
            doc.parent = this;
            this.addRelation(doc);
            return doc;
        }
        catch (Exception e) {
            throw new POIXMLException(e);
        }
    }

    protected final void read(POIXMLFactory factory) throws OpenXML4JException {
        PackageRelationshipCollection rels = this.packagePart.getRelationships();
        for (PackageRelationship rel : rels) {
            if (rel.getTargetMode() != TargetMode.INTERNAL) continue;
            PackagePartName relName = PackagingURIHelper.createPartName(rel.getTargetURI());
            PackagePart p = this.packagePart.getPackage().getPart(relName);
            if (p == null) {
                logger.log(7, (Object)("Skipped invalid entry " + rel.getTargetURI()));
                continue;
            }
            POIXMLDocumentPart childPart = factory.createDocumentPart(rel, p);
            childPart.parent = this;
            this.addRelation(childPart);
            if (!p.hasRelationships()) continue;
            childPart.read(factory);
        }
    }

    protected void onDocumentCreate() throws IOException {
    }

    protected void onDocumentRead() throws IOException {
    }

    static {
        DEFAULT_XML_OPTIONS.setSaveOuter();
        DEFAULT_XML_OPTIONS.setUseDefaultNamespace();
        DEFAULT_XML_OPTIONS.setSaveAggressiveNamespaces();
    }
}

