/*
 * Decompiled with CFR 0.152.
 */
package org.bbreak.excella.core.tag.excel2java;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.core.tag.TagParser;
import org.bbreak.excella.core.util.PoiUtil;
import org.bbreak.excella.core.util.TagUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapParser
extends TagParser<Map<?, ?>> {
    protected static final String PARAM_CELL_DELIM = ":";
    protected static final int SPLIT_FIRST_INDEX = 0;
    protected static final int SPLIT_LAST_INDEX = 1;
    protected static final String PARAM_DATA_ROW_FROM = "DataRowFrom";
    protected static final String PARAM_DATA_ROW_TO = "DataRowTo";
    protected static final String PARAM_KEY_COLUMN = "KeyColumn";
    protected static final String PARAM_VALUE_COLUMN = "ValueColumn";
    protected static final String PARAM_KEY_CELL = "KeyCell";
    protected static final String PARAM_KEY = "Key";
    protected static final String PARAM_VALUE = "Value";
    protected static final String PARAM_VALUE_CELL = "ValueCell";
    protected static final int DEFAULT_VALUE_ROW_FROM_ADJUST = 1;
    protected static final int DEFAULT_KEY_COLUMN_ADJUST = 0;
    protected static final int DEFAULT_VALUE_COLUMN_ADJUST = 1;

    public MapParser(String tag) {
        super(tag);
    }

    @Override
    public Map<?, ?> parse(Sheet sheet, Cell tagCell, Object data) throws ParseException {
        boolean valueCellTagFlag;
        boolean valueTagFlag;
        boolean keyCellTagFlag;
        boolean keyTagFlag;
        int tagRowIdx = tagCell.getRowIndex();
        int tagColIdx = tagCell.getColumnIndex();
        int valueRowToIdx = sheet.getLastRowNum();
        int keyColIdx = 0;
        int valueColIdx = 0;
        String defKey = null;
        String defValue = null;
        int keyRowIdx = 0;
        int valueRowIdx = 0;
        try {
            String value;
            Map<String, String> paramDef = TagUtil.getParams(tagCell.getStringCellValue());
            this.checkParam(paramDef, tagCell);
            int valueRowFromIdx = TagUtil.adjustValue(tagRowIdx, paramDef, PARAM_DATA_ROW_FROM, 1);
            if (valueRowFromIdx < 0 || valueRowFromIdx > sheet.getLastRowNum()) {
                throw new ParseException(tagCell);
            }
            if ((valueRowToIdx = TagUtil.adjustValue(tagRowIdx, paramDef, PARAM_DATA_ROW_TO, valueRowToIdx - tagRowIdx)) < valueRowFromIdx || valueRowToIdx > sheet.getLastRowNum() || valueRowToIdx < 0) {
                throw new ParseException(tagCell);
            }
            keyTagFlag = paramDef.containsKey(PARAM_KEY);
            keyCellTagFlag = paramDef.containsKey(PARAM_KEY_CELL);
            if (keyTagFlag) {
                defKey = paramDef.get(PARAM_KEY);
            } else if (keyCellTagFlag) {
                value = paramDef.get(PARAM_KEY_CELL);
                keyRowIdx = tagRowIdx + Integer.valueOf(value.split(PARAM_CELL_DELIM)[0]);
                if (keyRowIdx < 0 || keyRowIdx > sheet.getLastRowNum()) {
                    throw new ParseException(tagCell);
                }
                keyColIdx = tagColIdx + Integer.valueOf(value.split(PARAM_CELL_DELIM)[1]);
                if (keyColIdx > PoiUtil.getLastColNum(sheet) || keyColIdx < 0) {
                    throw new ParseException(tagCell);
                }
            } else {
                keyColIdx = TagUtil.adjustValue(tagColIdx, paramDef, PARAM_KEY_COLUMN, 0);
                if (keyColIdx > PoiUtil.getLastColNum(sheet) || keyColIdx < 0) {
                    throw new ParseException(tagCell);
                }
            }
            valueTagFlag = paramDef.containsKey(PARAM_VALUE);
            valueCellTagFlag = paramDef.containsKey(PARAM_VALUE_CELL);
            if (valueTagFlag) {
                defValue = paramDef.get(PARAM_VALUE);
            } else if (valueCellTagFlag) {
                value = paramDef.get(PARAM_VALUE_CELL);
                valueRowIdx = tagRowIdx + Integer.valueOf(value.split(PARAM_CELL_DELIM)[0]);
                if (valueRowIdx < 0 || valueRowIdx > sheet.getLastRowNum()) {
                    throw new ParseException(tagCell);
                }
                valueColIdx = tagColIdx + Integer.valueOf(value.split(PARAM_CELL_DELIM)[1]);
                if (valueColIdx > PoiUtil.getLastColNum(sheet) || valueColIdx < 0) {
                    throw new ParseException(tagCell);
                }
            } else {
                valueColIdx = TagUtil.adjustValue(tagColIdx, paramDef, PARAM_VALUE_COLUMN, 1);
                if (valueColIdx > PoiUtil.getLastColNum(sheet) || valueColIdx < 0) {
                    throw new ParseException(tagCell);
                }
            }
        }
        catch (Exception e) {
            throw new ParseException(tagCell, (Throwable)e);
        }
        LinkedHashMap<String, String> results = new LinkedHashMap<String, String>();
        Row keyRow = null;
        Row valueRow = null;
        for (int rowCnt = valueRowFromIdx; rowCnt <= valueRowToIdx; ++rowCnt) {
            Object value;
            Object key;
            if (keyTagFlag) {
                key = defKey;
            } else {
                keyRow = keyCellTagFlag ? sheet.getRow(keyRowIdx) : sheet.getRow(rowCnt);
                if (keyRow == null) continue;
                key = PoiUtil.getCellValue(keyRow.getCell(keyColIdx));
            }
            if (valueTagFlag) {
                value = defValue;
            } else {
                valueRow = valueCellTagFlag ? sheet.getRow(valueRowIdx) : sheet.getRow(rowCnt);
                value = valueRow != null ? PoiUtil.getCellValue(valueRow.getCell(valueColIdx)) : null;
            }
            results.put((String)key, (String)value);
        }
        return results;
    }

    private void checkParam(Map<String, String> paramDef, Cell tagCell) throws ParseException {
        if (paramDef.containsKey(PARAM_KEY) && paramDef.containsKey(PARAM_KEY_COLUMN)) {
            throw new ParseException(tagCell, "\u4e8c\u91cd\u5b9a\u7fa9\uff1aKey,KeyColumn");
        }
        if (paramDef.containsKey(PARAM_KEY) && paramDef.containsKey(PARAM_KEY_CELL)) {
            throw new ParseException(tagCell, "\u4e8c\u91cd\u5b9a\u7fa9\uff1aKey,KeyCell");
        }
        if (paramDef.containsKey(PARAM_KEY_COLUMN) && paramDef.containsKey(PARAM_KEY_CELL)) {
            throw new ParseException(tagCell, "\u4e8c\u91cd\u5b9a\u7fa9\uff1aKeyColumn,KeyCell");
        }
        if (paramDef.containsKey(PARAM_VALUE) && paramDef.containsKey(PARAM_VALUE_COLUMN)) {
            throw new ParseException(tagCell, "\u4e8c\u91cd\u5b9a\u7fa9\uff1aValue,ValueColumn");
        }
        if (paramDef.containsKey(PARAM_VALUE) && paramDef.containsKey(PARAM_VALUE_CELL)) {
            throw new ParseException(tagCell, "\u4e8c\u91cd\u5b9a\u7fa9\uff1aValue,ValueCell");
        }
        if (paramDef.containsKey(PARAM_VALUE_COLUMN) && paramDef.containsKey(PARAM_VALUE_CELL)) {
            throw new ParseException(tagCell, "\u4e8c\u91cd\u5b9a\u7fa9\uff1aValueColumn,ValueCell");
        }
    }
}

