/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.functions;

import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.Eval;
import org.apache.poi.hssf.record.formula.eval.EvaluationException;
import org.apache.poi.hssf.record.formula.eval.NumberEval;
import org.apache.poi.hssf.record.formula.eval.ValueEval;
import org.apache.poi.hssf.record.formula.functions.TextFunction;

public final class Find
extends TextFunction {
    protected ValueEval evaluateFunc(Eval[] args, int srcCellRow, short srcCellCol) throws EvaluationException {
        int startpos;
        int nArgs = args.length;
        if (nArgs < 2 || nArgs > 3) {
            return ErrorEval.VALUE_INVALID;
        }
        String needle = Find.evaluateStringArg(args[0], srcCellRow, srcCellCol);
        String haystack = Find.evaluateStringArg(args[1], srcCellRow, srcCellCol);
        if (nArgs == 3) {
            startpos = Find.evaluateIntArg(args[2], srcCellRow, srcCellCol);
            if (startpos <= 0) {
                return ErrorEval.VALUE_INVALID;
            }
            --startpos;
        } else {
            startpos = 0;
        }
        int result = haystack.indexOf(needle, startpos);
        if (result == -1) {
            return ErrorEval.VALUE_INVALID;
        }
        return new NumberEval(result + 1);
    }
}

