/*
 * Decompiled with CFR 0.152.
 */
package org.bbreak.excella.trans.tag.sheet2sql.converter;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.trans.tag.sheet2sql.converter.SheetToSqlDataConverter;

public class DefaultSheetToSqlDataConverter
implements SheetToSqlDataConverter {
    public static final String DATA_TYPE_STRING = "\u6587\u5b57\u5217";
    public static final String DATA_TYPE_NUMERIC = "\u6570\u5024";
    public static final String DATA_TYPE_INTEGER = "\u6574\u6570";
    public static final String DATA_TYPE_BOOLEAN = "\u8ad6\u7406\u5024";
    public static final String DATA_TYPE_DATE = "\u65e5\u4ed8";
    public static final String DATA_TYPE_TIME = "\u6642\u9593";
    public static final String DATA_TYPE_TIMESTAMP = "\u30bf\u30a4\u30e0\u30b9\u30bf\u30f3\u30d7";
    public static final String DATA_TYPE_FUNCTION = "\u95a2\u6570";
    private static final String SINGLE_QUOTE = "'";
    private static final String DATE_SEPARATOR = "-";
    private static final String TIME_SEPARATOR = ":";
    private static final String PERIOD = ".";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String convert(Object object, String dataType) throws ParseException {
        String result = null;
        if (object == null) {
            return null;
        }
        if (dataType == null || DATA_TYPE_STRING.equals(dataType)) {
            String value = object.toString();
            return this.getSingleQuotedString(value);
        }
        if (DATA_TYPE_NUMERIC.equals(dataType)) {
            try {
                Double value = Double.parseDouble(object.toString());
                return value.toString();
            }
            catch (Exception e) {
                throw new ParseException("\u5024\u304c\u6570\u5024\u3067\u306f\u3042\u308a\u307e\u305b\u3093\uff1a" + object.toString());
            }
        }
        if (DATA_TYPE_INTEGER.equals(dataType)) {
            try {
                Double value = Double.parseDouble(object.toString());
                Integer valueInt = value.intValue();
                return valueInt.toString();
            }
            catch (Exception e) {
                throw new ParseException("\u5024\u304c\u6574\u6570\u3067\u306f\u3042\u308a\u307e\u305b\u3093\uff1a" + object.toString());
            }
        }
        if (DATA_TYPE_BOOLEAN.equals(dataType)) {
            String value = object.toString();
            if (this.isTrueExpression(value)) {
                return "TRUE";
            }
            if (!this.isFalseExpression(value)) throw new ParseException("\u5024\u304c\u8ad6\u7406\u5024\u3067\u306f\u3042\u308a\u307e\u305b\u3093\uff1a" + object.toString());
            return "FALSE";
        }
        if (DATA_TYPE_DATE.equals(dataType)) {
            try {
                Date date = (Date)object;
                GregorianCalendar gCal = new GregorianCalendar();
                gCal.setTime(date);
                String ymd = this.getYmdString(gCal);
                return this.getSingleQuotedString(ymd);
            }
            catch (Exception e) {
                throw new ParseException("\u5024\u304c\u65e5\u4ed8\u3067\u306f\u3042\u308a\u307e\u305b\u3093\uff1a" + object.toString());
            }
        }
        if (DATA_TYPE_TIME.equals(dataType)) {
            try {
                Date date = (Date)object;
                GregorianCalendar gCal = new GregorianCalendar();
                gCal.setTime(date);
                String time = this.getTimeString(gCal);
                return this.getSingleQuotedString(time);
            }
            catch (Exception e) {
                throw new ParseException("\u5024\u304c\u6642\u9593\u3067\u306f\u3042\u308a\u307e\u305b\u3093\uff1a" + object.toString());
            }
        }
        if (DATA_TYPE_TIMESTAMP.equals(dataType)) {
            try {
                Date date = (Date)object;
                GregorianCalendar gCal = new GregorianCalendar();
                gCal.setTime(date);
                String timestamp = this.getTimestampString(gCal);
                return this.getSingleQuotedString(timestamp);
            }
            catch (Exception e) {
                throw new ParseException("\u5024\u304c\u30bf\u30a4\u30e0\u30b9\u30bf\u30f3\u30d7\u3067\u306f\u3042\u308a\u307e\u305b\u3093\uff1a" + object.toString());
            }
        }
        if (!DATA_TYPE_FUNCTION.equals(dataType)) throw new ParseException("\u30c7\u30fc\u30bf\u578b\u4e0d\u6b63\uff1a" + dataType);
        return object.toString();
    }

    private String getTimestampString(GregorianCalendar gCal) {
        StringBuilder strBuild = new StringBuilder();
        strBuild.append(this.getYmdString(gCal));
        strBuild.append(" ");
        strBuild.append(this.getTimeString(gCal));
        return strBuild.toString();
    }

    private String getTimeString(GregorianCalendar gCal) {
        StringBuilder strBuild = new StringBuilder();
        strBuild.append(this.getTwoDigitString(gCal.get(11)));
        strBuild.append(TIME_SEPARATOR);
        strBuild.append(this.getTwoDigitString(gCal.get(12)));
        strBuild.append(TIME_SEPARATOR);
        strBuild.append(this.getTwoDigitString(gCal.get(13)));
        strBuild.append(PERIOD);
        strBuild.append(gCal.get(14));
        return strBuild.toString();
    }

    private String getYmdString(GregorianCalendar gCal) {
        StringBuilder strBuild = new StringBuilder();
        strBuild.append(gCal.get(1));
        strBuild.append(DATE_SEPARATOR);
        strBuild.append(this.getTwoDigitString(gCal.get(2) + 1));
        strBuild.append(DATE_SEPARATOR);
        strBuild.append(this.getTwoDigitString(gCal.get(5)));
        return strBuild.toString();
    }

    private String getSingleQuotedString(String string) {
        StringBuilder strBuild = new StringBuilder();
        strBuild.append(SINGLE_QUOTE).append(string).append(SINGLE_QUOTE);
        return strBuild.toString();
    }

    private boolean isTrueExpression(String string) {
        boolean result = false;
        ArrayList<String> trueStrings = new ArrayList<String>();
        trueStrings.add("true");
        trueStrings.add("TRUE");
        trueStrings.add("t");
        trueStrings.add("T");
        trueStrings.add("y");
        trueStrings.add("Y");
        trueStrings.add("yes");
        trueStrings.add("YES");
        trueStrings.add("1");
        if (trueStrings.contains(string)) {
            result = true;
        }
        return result;
    }

    private boolean isFalseExpression(String string) {
        boolean result = false;
        ArrayList<String> falseStrings = new ArrayList<String>();
        falseStrings.add("false");
        falseStrings.add("FALSE");
        falseStrings.add("f");
        falseStrings.add("F");
        falseStrings.add("n");
        falseStrings.add("N");
        falseStrings.add("no");
        falseStrings.add("NO");
        falseStrings.add("0");
        if (falseStrings.contains(string)) {
            result = true;
        }
        return result;
    }

    private String getTwoDigitString(int num) {
        DecimalFormat decimalFormat = new DecimalFormat("00");
        return decimalFormat.format(num);
    }
}

