/*
 * Decompiled with CFR 0.152.
 */
package org.bbreak.excella.trans.tag.sheet2sql;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.core.tag.TagParser;
import org.bbreak.excella.core.util.PoiUtil;
import org.bbreak.excella.core.util.TagUtil;
import org.bbreak.excella.trans.tag.sheet2sql.model.SheetToSqlParseInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SheetToSqlParser
extends TagParser<List<SheetToSqlParseInfo>> {
    public static final String DEFAULT_TAG = "@SheetToSql";
    protected static final String PARAM_SETTING_TAG_NAME = "SettingTagName";
    protected static final String DEFAULT_SETTING_SUFFIX = "Setting";
    protected static final String PARAM_DATA_ROW_FROM = "DataRowFrom";
    protected static final String PARAM_DATA_ROW_TO = "DataRowTo";
    protected static final String PARAM_RESULT_KEY = "ResultKey";
    protected static final int DEFAULT_DATA_ROW_FROM_ADJUST = 2;

    public SheetToSqlParser() {
        super(DEFAULT_TAG);
    }

    public SheetToSqlParser(String tag) {
        super(tag);
    }

    public List<SheetToSqlParseInfo> parse(Sheet sheet, Cell tagCell, Object data) throws ParseException {
        int tagRowIdx = tagCell.getRowIndex();
        int tagColIdx = tagCell.getColumnIndex();
        int valueRowToIdx = sheet.getLastRowNum();
        String settingTagName = this.getTag() + DEFAULT_SETTING_SUFFIX;
        try {
            Map paramDef = TagUtil.getParams((String)tagCell.getStringCellValue());
            int valueRowFromIdx = TagUtil.adjustValue((int)tagRowIdx, (Map)paramDef, (String)PARAM_DATA_ROW_FROM, (int)2);
            if (valueRowFromIdx < 0 || valueRowFromIdx > sheet.getLastRowNum()) {
                throw new ParseException(tagCell);
            }
            if ((valueRowToIdx = TagUtil.adjustValue((int)tagRowIdx, (Map)paramDef, (String)PARAM_DATA_ROW_TO, (int)(valueRowToIdx - tagRowIdx))) < valueRowFromIdx || valueRowToIdx > sheet.getLastRowNum() || valueRowToIdx < 0) {
                throw new ParseException(tagCell);
            }
            if (paramDef.containsKey(PARAM_SETTING_TAG_NAME)) {
                settingTagName = (String)paramDef.get(PARAM_SETTING_TAG_NAME);
            }
            if (paramDef.containsKey(PARAM_RESULT_KEY)) {
                throw new ParseException(tagCell);
            }
        }
        catch (Exception e) {
            throw new ParseException(tagCell, (Throwable)e);
        }
        ArrayList<SheetToSqlParseInfo> sheetInfoList = new ArrayList<SheetToSqlParseInfo>();
        int sheetNameColIdx = tagColIdx++;
        int logicalRowColIdx = tagColIdx++;
        int dataRowColIdx = tagColIdx;
        for (int rowNum = valueRowFromIdx; rowNum <= valueRowToIdx; ++rowNum) {
            int valueRowNum;
            int logicalRowNum;
            Row row = sheet.getRow(rowNum);
            if (row == null) continue;
            Cell sheetNameCell = row.getCell(sheetNameColIdx);
            Cell logicalRowNumCell = row.getCell(logicalRowColIdx);
            Cell valueRowNumCell = row.getCell(dataRowColIdx);
            if (sheetNameCell == null && logicalRowNumCell == null && valueRowNumCell == null) continue;
            Cell requiredErrorCell = null;
            if (sheetNameCell == null) {
                requiredErrorCell = row.createCell(sheetNameColIdx);
            } else if (logicalRowNumCell == null) {
                requiredErrorCell = row.createCell(logicalRowColIdx);
            } else if (valueRowNumCell == null) {
                requiredErrorCell = row.createCell(dataRowColIdx);
            }
            if (requiredErrorCell != null) {
                throw new ParseException(requiredErrorCell);
            }
            try {
                logicalRowNum = (Integer)PoiUtil.getCellValue((Cell)logicalRowNumCell, Integer.class);
            }
            catch (Exception e) {
                throw new ParseException(logicalRowNumCell);
            }
            try {
                valueRowNum = (Integer)PoiUtil.getCellValue((Cell)valueRowNumCell, Integer.class);
            }
            catch (Exception e) {
                throw new ParseException(valueRowNumCell);
            }
            SheetToSqlParseInfo sheetInfo = new SheetToSqlParseInfo();
            sheetInfo.setSettingTagName(settingTagName);
            sheetInfo.setSheetName(sheetNameCell.getStringCellValue());
            sheetInfo.setLogicalNameRowNum(logicalRowNum);
            sheetInfo.setValueRowNum(valueRowNum);
            sheetInfoList.add(sheetInfo);
        }
        return sheetInfoList;
    }
}

