class IP_Addr
  def ipaddr_change_10_2(ip)
  # "192.168.1.1" -> "11000000101010000000000100000001"
    b = ""
    ip.split(/\./).each{|c|
    b = b + sprintf("%08b", c)
    }
    return b
  end

  def ipaddr_change_10_2_dot(ip)
  # "192.168.1.1" -> "11000000.101010000.00000010.0000001"
    b = ""
    ip.split(/\./).each{|c|
      b = b + "." + sprintf("%08b", c)
    }
    return b.sub(/^\./,"")
  end

  def ipaddr_change_2_10_dot(ip)
  # "11000000101010000000000100000001" -> "192.168.1.1"
    o1 = ip[0, 8].to_i(2).to_s
    o2 = ip[8, 8].to_i(2).to_s
    o3 = ip[16, 8].to_i(2).to_s
    o4 = ip[24, 8].to_i(2).to_s
    
    return o1 + "." + o2 + "." + o3 + "." + o4
  end

  def check_ipaddr(nwork_2, nmask_2, start_ip_2)
    # 32bits?(IPv4 only)
    if nwork_2.length != 32
      puts "Error! NETWORK is not 32 bits"
      return 1
    end
    if nmask_2.length != 32
      puts "Error! NETMASK is not 32 bits"
      return 1
    end
    if start_ip_2.length != 32
      puts "Error! IP ADDRESS is not 32 bits"
      return 1
    end
    
    # (network | netmask) & netmask is /^1*10*0$/
    unless ("%032b") % (nwork_2.to_i(2) | nmask_2.to_i(2)) =~ /^1*10*0$/
      puts "Error! #{ipaddr_change_2_10_dot(nwork_2)} is not NETWORK"
      return 1
    end
    unless nmask_2 =~ /^1*10*0$/
      puts "Error! #{ipaddr_change_2_10_dot(nmask_2)} is not NETMASK"
      return 1
    end
    
    # start_ip > nwork
    unless start_ip_2 > nwork_2
      puts "Bad NETWORK or NETMASK"
      return 1
    end

  # START IP ADDRESS
    unless @max_ipaddr - (start_ip_2.to_i(2) - nwork_2.to_i(2)) + 1 > 0
      puts "Bad START IP ADDRESS"
      return 1
    end

  # MAX IP >= NUMBER OF NODES
    unless @max_ipaddr - (start_ip_2.to_i(2) - nwork_2.to_i(2)) + 1 >= @num
      puts "Not enough IP ADDRESS. Change START IP ADDRESS"
      return 1
    end
    return 0
  end

  def initialize(nmask, start_ip, num)
    @nmask_2 = ipaddr_change_10_2(nmask)
    @start_ip_2 = ipaddr_change_10_2(start_ip)
    @nwork = ipaddr_change_2_10_dot(("%032b") % (@nmask_2.to_i(2) & @start_ip_2.to_i(2)))
    @nwork_2 = ipaddr_change_10_2(@nwork)
    @num = num.to_i
    @max_ipaddr = 2**(31 - @nmask_2.rindex(/1/)) - 2 # IPɥ쥹θĿ
    exit 1 if check_ipaddr(@nwork_2, @nmask_2, @start_ip_2) == 1
  end

  def nw_range
    return @max_ipaddr
  end

  def ip_range
    a = Array.new
    (@max_ipaddr - (@start_ip_2.to_i(2) - @nwork_2.to_i(2)) + 1).times{|i|
#      puts ipaddr_change_2_10_dot("%032b" % (@start_ip_2.to_i(2) + i))
      a.push(ipaddr_change_2_10_dot("%032b" % (@start_ip_2.to_i(2) + i)))
    }
    return a[0..@num-1]
  end

  def nwork_to_2
    @nwork_2.to_i
  end
  def nmask_to_2
    @nmask_2.to_i
  end
  def start_ip_to_2
    @start_ip_2.to_i
  end
  def nwork
    @nwork
  end
end
