#!/usr/bin/env ruby

def nfs_fstab
  file = "/etc/fstab"
  nfs_line = Array.new
  open(file, "r"){|io|
    while line = io.gets
      if line.split[2] == "nfs"
        nfs_line.push(line) unless line =~ /^#/
      end
    end
  }
  
  return nfs_line
end

def fstab_info(win)
  bindtextdomain("dcast", localedir="./locale")
  win.remove(win.child)
  table = Gtk::Table.new(9, 4, false) #ġ
  dummy = ""

  label = Gtk::Label.new(NKF.nkf("-m0 -w", _("Please set the NFS mount. $MASTER is converted into \nIP Address of the master node (this machine). \nThe setting after it changes is saved in \"./fstab.conf\".")))
  table.attach(label, 1, 4, 0, 1)

  image_show(0, 1, 0, 8, table) # ϡĻϡĽ

# ɽΥ٥
  label_show(1, 2, 1, 2, table, "device", dummy)
  label_show(2, 3, 1, 2, table, "mount point", dummy)
#  label = Gtk::Label.new("mount point")
#  table.attach(label, 2, 3, 1, 2, Gtk::SHRINK, Gtk::SHRINK, 0, 0)
  label_show(3, 4, 1, 2, table, "options", dummy)

# filesystem
  entry_fs_1 = Gtk::Entry.new ; entry_fs_2 = Gtk::Entry.new
  entry_fs_3 = Gtk::Entry.new ; entry_fs_4 = Gtk::Entry.new
  entry_fs_5 = Gtk::Entry.new ; entry_fs_6 = Gtk::Entry.new

  i = 12
  entry_fs_1::width_chars = i
  entry_fs_2::width_chars = i
  entry_fs_3::width_chars = i
  entry_fs_4::width_chars = i
  entry_fs_5::width_chars = i
  entry_fs_6::width_chars = i

  fstab = Path.new.fstab_conf
  fs_dirs = Array.new
  if FileTest.exist?(fstab)
    open(fstab, "r"){|io|
      while line = io.gets
        fs_dirs.push(line.split[0]) if line.split[0] != nil
      end
    }
  end
 
#  nfs_fstab.each{|line|
#    fs_dirs.push(line.split[0]) if line.split[0] != nil
#  }

  entry_fs_1.set_text(fs_dirs[0]) ; table.attach(entry_fs_1, 1, 2, 2, 3, 5, 0)
  entry_fs_2.set_text(fs_dirs[1]) ; table.attach(entry_fs_2, 1, 2, 3, 4, 5, 0)
  entry_fs_3.set_text(fs_dirs[2]) ; table.attach(entry_fs_3, 1, 2, 4, 5, 5, 0)
  entry_fs_4.set_text(fs_dirs[3]) ; table.attach(entry_fs_4, 1, 2, 5, 6, 5, 0)
  entry_fs_5.set_text(fs_dirs[4]) ; table.attach(entry_fs_5, 1, 2, 6, 7, 5, 0)
  entry_fs_6.set_text(fs_dirs[5]) ; table.attach(entry_fs_6, 1, 2, 7, 8, 5, 0)

# mount point
  entry_mp_1 = Gtk::Entry.new ; entry_mp_2 = Gtk::Entry.new
  entry_mp_3 = Gtk::Entry.new ; entry_mp_4 = Gtk::Entry.new
  entry_mp_5 = Gtk::Entry.new ; entry_mp_6 = Gtk::Entry.new

  i = 0
  entry_mp_1::width_chars = i
  entry_mp_2::width_chars = i
  entry_mp_3::width_chars = i
  entry_mp_4::width_chars = i
  entry_mp_5::width_chars = i
  entry_mp_6::width_chars = i

  mp_dirs = Array.new
  if FileTest.exist?(fstab)
    open(fstab, "r"){|io|
      while line = io.gets
        mp_dirs.push(line.split[1]) if line.split[1] != nil
      end
    }
  end

  entry_mp_1.set_text(mp_dirs[0]) ; table.attach(entry_mp_1, 2, 3, 2, 3, 5, 0)
  entry_mp_2.set_text(mp_dirs[1]) ; table.attach(entry_mp_2, 2, 3, 3, 4, 5, 0)
  entry_mp_3.set_text(mp_dirs[2]) ; table.attach(entry_mp_3, 2, 3, 4, 5, 5, 0)
  entry_mp_4.set_text(mp_dirs[3]) ; table.attach(entry_mp_4, 2, 3, 5, 6, 5, 0)
  entry_mp_5.set_text(mp_dirs[4]) ; table.attach(entry_mp_5, 2, 3, 6, 7, 5, 0)
  entry_mp_6.set_text(mp_dirs[5]) ; table.attach(entry_mp_6, 2, 3, 7, 8, 5, 0)

# option
  entry_op_1 = Gtk::Entry.new ; entry_op_2 = Gtk::Entry.new
  entry_op_3 = Gtk::Entry.new ; entry_op_4 = Gtk::Entry.new
  entry_op_5 = Gtk::Entry.new ; entry_op_6 = Gtk::Entry.new

  op_dirs = Array.new
  if FileTest.exist?(fstab)
    open(fstab, "r"){|io|
      while line = io.gets
        op_dirs.push(line.split[3]) if line.split[3] != nil
      end
    }
  end

  entry_op_1.set_text(op_dirs[0]) ; table.attach(entry_op_1, 3, 4, 2, 3, Gtk::SHRINK, Gtk::EXPAND, 5, 0)
  entry_op_2.set_text(op_dirs[1]) ; table.attach(entry_op_2, 3, 4, 3, 4, Gtk::SHRINK, Gtk::EXPAND, 5, 0)
  entry_op_3.set_text(op_dirs[2]) ; table.attach(entry_op_3, 3, 4, 4, 5, Gtk::SHRINK, Gtk::EXPAND, 5, 0)
  entry_op_4.set_text(op_dirs[3]) ; table.attach(entry_op_4, 3, 4, 5, 6, Gtk::SHRINK, Gtk::EXPAND, 5, 0)
  entry_op_5.set_text(op_dirs[4]) ; table.attach(entry_op_5, 3, 4, 6, 7, Gtk::SHRINK, Gtk::EXPAND, 5, 0)
  entry_op_6.set_text(mp_dirs[5]) ; table.attach(entry_op_6, 3, 4, 7, 8, Gtk::SHRINK, Gtk::EXPAND, 5, 0)

# Υܥ
  frame = Gtk::Frame.new("DCAST")
  hbox = Gtk::HBox.new(false, 0)

# cancel_button = Gtk::Button.new(Gtk::Stock::CANCEL)
  cancel_button = Gtk::Button.new(Gtk::Stock::GO_BACK)
  save_button = Gtk::Button.new(Gtk::Stock::SAVE)
  hbox.pack_end(save_button, false, false, 0)

  hbox.pack_start(cancel_button, false, false, 10)

  cancel_button.signal_connect("clicked") {
    Gtk::main_quit
    run_gtk(win)
  }

  save_button.signal_connect("clicked") {
    Gtk::main_quit
    open(fstab, "w"){|io|
      io.puts entry_fs_1.text + "\t" + entry_mp_1.text + "\tnfs\t" + entry_op_1.text + " 0 2" if entry_fs_1.text != ""
      io.puts entry_fs_2.text + "\t" + entry_mp_2.text + "\tnfs\t" + entry_op_2.text + " 0 2"  if entry_fs_2.text != ""
      io.puts entry_fs_3.text + "\t" + entry_mp_3.text + "\tnfs\t" + entry_op_3.text + " 0 2"  if entry_fs_3.text != ""
      io.puts entry_fs_4.text + "\t" + entry_mp_4.text + "\tnfs\t" + entry_op_4.text + " 0 2"  if entry_fs_4.text != ""
      io.puts entry_fs_5.text + "\t" + entry_mp_5.text + "\tnfs\t" + entry_op_5.text + " 0 2"  if entry_fs_5.text != ""
      io.puts entry_fs_6.text + "\t" + entry_mp_6.text + "\tnfs\t" + entry_op_6.text + " 0 2"  if entry_fs_6.text != ""
    }
    run_gtk(win)
  }

  frame.add(hbox)
  table.attach(frame, 0, 4, 8, 9)
######
  win.set_title("Configuration of /etc/fstab")
  win.set_default_size(500,300)
  win.add(table)
  win.show_all
  Gtk.main
end


if __FILE__ == $0
  require "load"

  Gtk.init

  win = Gtk::Window.new
  win.signal_connect("destroy") {
    Gtk::main_quit
  }

  $h = Hash.new
  $h.store("ip_address", "192.168.1.1")

  fstab_info(win)
#  Gtk.main
end
