#!/usr/bin/env ruby

def first_select(win)
  win.remove(win.child)
  bindtextdomain("dcast", localedir="./locale")

  table = Gtk::Table.new(4, 3, false)
  image_show(0, 1, 0, 3, table)

  $flag="first-select"
  label = Gtk::Label.new(NKF.nkf("-m0 -w", _("\n\n\"./dcast.conf\" - Configuration file - exists.\n\nPlease select \"Create new configration file\" or       \n\"Use the present configuration file\".\n\n\n\n\n\n\n")))

  table.attach(label, 1, 3, 0, 1, Gtk::FILL, Gtk::FILL, 0, 10)

  label1 = Gtk::Label.new(NKF.nkf("-m0 -w", _("Create new configration file")))
  table.attach(label1, 1, 2, 1, 2, Gtk::FILL, Gtk::FILL, 0, 0)

  button1 = Gtk::Button.new(Gtk::Stock::EXECUTE)
  table.attach(button1, 2, 3, 1, 2, Gtk::FILL, Gtk::FILL, 0, 10)

  button1.signal_connect("clicked") do
    select_eth(win)
  end

  label2 = Gtk::Label.new(NKF.nkf("-m0 -w", _("Use the present configuration file")))
  table.attach(label2, 1, 2, 2, 3, Gtk::FILL, Gtk::FILL, 0, 0)

  button2 = Gtk::Button.new(Gtk::Stock::EXECUTE)
  table.attach(button2, 2, 3, 2, 3, Gtk::FILL, Gtk::FILL, 0, 10)

  button2.signal_connect("clicked") do
    run_gtk(win)
  end

# Υܥ
  frame = Gtk::Frame.new("DCAST")
  hbox = Gtk::HBox.new(false, 0)

  cancel_button = Gtk::Button.new(Gtk::Stock::QUIT)

  hbox.pack_start(cancel_button, false, false, 10)
  cancel_button.signal_connect("clicked") {
    Gtk::main_quit
  }

  frame.add(hbox)
  table.attach(frame, 0, 3, 3, 4)

  win.set_default_size(500,300)
  win.set_title(NKF.nkf("-m0 -w", "The configuration file updated?"))
  win.add(table)
  win.show_all
end

if __FILE__ == $0
  require "load"

  Gtk.init

  win = Gtk::Window.new
  win.signal_connect("destroy") {
    Gtk::main_quit
  }

  first_select(win)

  Gtk.main
end
