#!/usr/bin/env ruby

def cluster_info(win)
  win.remove(win.child)
  bindtextdomain("dcast", localedir="./locale")

  table = Gtk::Table.new(8, 3, false) #ġ

  label = Gtk::Label.new(NKF.nkf("-m0 -w", _("Please set the configration of cluster.")))
  table.attach(label, 1, 3, 0, 1)

  image_show(0, 1, 0, 7, table) # ϡĻϡĽ

  entry_domain = Gtk::Entry.new
  entry_name = Gtk::Entry.new

  # Number of slave node
  label_show(1, 2, 1, 2, table, "Number of Slave Nodes", Gtk::JUSTIFY_LEFT)
  spin_adjust_num = Gtk::Adjustment.new($h["number"], 1, 65534, 1, 2, 0)
  spin_botton_num = Gtk::SpinButton.new(spin_adjust_num, 0, 0)
  spin_botton_num.set_numeric(true)
  table.attach(spin_botton_num, 2, 3, 1, 2)

  # Swap Size
  label_show(1, 2, 2, 3, table, "Swap Size[MByte]\n(only diskfull node)", Gtk::JUSTIFY_LEFT)
  spin_adjust_swap = Gtk::Adjustment.new($h["swap"], 1, 2048, 1, 2, 0)
  spin_botton_swap = Gtk::SpinButton.new(spin_adjust_swap, 0, 0)
  spin_botton_swap.set_numeric(true)
  table.attach(spin_botton_swap, 2, 3, 2, 3)

  # Slave Node Prefix
  label_show(1, 2, 3, 4, table, "Slave Node Prefix\n(node1, node2..)", Gtk::JUSTIFY_LEFT)
  entry_name.set_text($h["prefix"])
  table.attach(entry_name, 2, 3, 3, 4)

  # Domain Name
  label_show(1, 2, 4, 5, table, "Domain Name\n(node1.dcast.org)", Gtk::JUSTIFY_LEFT)
  entry_domain.set_text($h["domain"])
  table.attach(entry_domain, 2, 3, 4, 5)

  # HOST Number Prefix
  label_show(1, 2, 5, 6, table, "Start Slave Number\n(eg:2 node2, node3..)", Gtk::JUSTIFY_LEFT)
  spin_adjust_start_slave_num = Gtk::Adjustment.new($h["start_slave_num"], 1, 65534, 1, 2, 0)
  spin_botton_start_slave_num = Gtk::SpinButton.new(spin_adjust_start_slave_num, 0, 0)
  spin_botton_start_slave_num.set_numeric(true)
  table.attach(spin_botton_start_slave_num, 2, 3, 5, 6)

  # Digit of HOST Number
  label_show(1, 2, 6, 7, table, "Digit of Slave Number\n(eg.3 node001, node002..)", Gtk::JUSTIFY_LEFT)
  spin_adjust_digit = Gtk::Adjustment.new($h["digit"], 1, 5, 1, 2, 0)
  spin_botton_digit = Gtk::SpinButton.new(spin_adjust_digit, 0, 0)
  spin_botton_digit.set_numeric(true)
  table.attach(spin_botton_digit, 2, 3, 6, 7)

  h = Hash.new
  h.store("number", spin_botton_num)
  h.store("swap", spin_botton_swap)
  h.store("name", entry_name)
  h.store("domain", entry_domain)
  h.store("start_slave_num", spin_botton_start_slave_num)
  h.store("digit", spin_botton_digit)

  $flag = "cluster_info"
  bottom_show(0, 3, 7, 8, win, table, h)
  win.set_title("Configuration of Cluster")
  win.set_default_size(500,300)
  win.add(table)
  win.show_all
end


if __FILE__ == $0
  require "load"

  Gtk.init

  win = Gtk::Window.new
  win.signal_connect("destroy") {
    Gtk::main_quit
  }


  $h = Hash.new
  $h.store("eth", "eth1")
  $h.store("ip_address", get_interfaces_info("ip_address", $h["eth"]))
  $h.store("netmask", get_interfaces_info("netmask", $h["eth"]))
  $h.store("network", get_interfaces_info("network", $h["eth"]))
  $h.store("broadcast", get_interfaces_info("broadcast", $h["eth"]))
  # local IP Address + 1
  b = IP_Addr.new($h["netmask"], $h["ip_address"], 2)
  ip = ("%032b") % (b.ipaddr_change_10_2($h["ip_address"]).to_i(2) + 1)
  $h.store("startip", b.ipaddr_change_2_10_dot(ip))

  $h.store("start_slave_num", 2)
  $h.store("number", 1)
  $h.store("swap", 512)
  $h.store("prefix", "pc")
  $h.store("domain", "dcast.org")
  $h.store("digit", 3)

  cluster_info(win)

  Gtk.main
end
