/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.connectionmanager;

import java.util.ArrayList;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.logging.Logger;
import org.jboss.tm.TransactionLocal;

public class TransactionSynchronizer
implements Synchronization {
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$resource$connectionmanager$TransactionSynchronizer == null ? (class$org$jboss$resource$connectionmanager$TransactionSynchronizer = TransactionSynchronizer.class$("org.jboss.resource.connectionmanager.TransactionSynchronizer")) : class$org$jboss$resource$connectionmanager$TransactionSynchronizer));
    protected static TransactionLocal txSynchs;
    protected Transaction tx;
    protected ArrayList txRemoverSynchs;
    protected Synchronization ccmSynch;
    static /* synthetic */ Class class$org$jboss$resource$connectionmanager$TransactionSynchronizer;

    public static void setTransactionManager(TransactionManager tm) {
        txSynchs = new TransactionLocal(tm);
    }

    public static void registerTxRemoverSynchronization(Transaction tx, Synchronization synch) throws RollbackException, SystemException {
        TransactionSynchronizer ts = TransactionSynchronizer.getRegisteredSynchronizer(tx);
        if (ts.txRemoverSynchs == null) {
            ts.txRemoverSynchs = new ArrayList();
        }
        ts.txRemoverSynchs.add(synch);
    }

    public static Synchronization getCCMSynchronization(Transaction tx) {
        TransactionSynchronizer ts = (TransactionSynchronizer)txSynchs.get(tx);
        if (ts != null) {
            return ts.ccmSynch;
        }
        return null;
    }

    public static void registerCCMSynchronization(Transaction tx, Synchronization synch) throws RollbackException, SystemException {
        TransactionSynchronizer ts = TransactionSynchronizer.getRegisteredSynchronizer(tx);
        ts.ccmSynch = synch;
    }

    private TransactionSynchronizer(Transaction tx) {
        this.tx = tx;
    }

    public void beforeCompletion() {
        if (this.txRemoverSynchs != null) {
            for (int i = 0; i < this.txRemoverSynchs.size(); ++i) {
                Synchronization synch = (Synchronization)this.txRemoverSynchs.get(i);
                this.invokeBefore(synch);
            }
        }
        if (this.ccmSynch != null) {
            this.invokeBefore(this.ccmSynch);
        }
    }

    public void afterCompletion(int status) {
        if (this.txRemoverSynchs != null) {
            for (int i = 0; i < this.txRemoverSynchs.size(); ++i) {
                Synchronization synch = (Synchronization)this.txRemoverSynchs.get(i);
                this.invokeAfter(synch, status);
            }
        }
        if (this.ccmSynch != null) {
            this.invokeAfter(this.ccmSynch, status);
        }
    }

    protected void invokeBefore(Synchronization synch) {
        try {
            synch.beforeCompletion();
        }
        catch (Throwable t) {
            log.warn((Object)("Transaction " + this.tx + " error in before completion " + synch), t);
        }
    }

    protected void invokeAfter(Synchronization synch, int status) {
        try {
            synch.afterCompletion(status);
        }
        catch (Throwable t) {
            log.warn((Object)("Transaction " + this.tx + " error in after completion " + synch), t);
        }
    }

    protected static TransactionSynchronizer getRegisteredSynchronizer(Transaction tx) throws RollbackException, SystemException {
        TransactionSynchronizer result = (TransactionSynchronizer)txSynchs.get(tx);
        if (result == null) {
            result = new TransactionSynchronizer(tx);
            tx.registerSynchronization((Synchronization)result);
            txSynchs.set(tx, (Object)result);
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

