/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Arrays;
import javax.naming.InitialContext;
import javax.net.SocketFactory;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.jboss.logging.Logger;
import org.jboss.security.SecurityDomain;
import org.jboss.security.ssl.ClientSocketFactory;
import org.jboss.security.ssl.Context;

public class DomainSocketFactory
extends SSLSocketFactory
implements HandshakeCompletedListener {
    private static Logger log = Logger.getLogger((Class)DomainSocketFactory.class);
    private transient SecurityDomain securityDomain;
    private transient SSLContext sslCtx = null;
    private boolean wantsClientAuth = true;
    private boolean needsClientAuth = false;

    public DomainSocketFactory() {
    }

    public DomainSocketFactory(SecurityDomain securityDomain) throws IOException {
        if (securityDomain == null) {
            throw new IOException("The securityDomain may not be null");
        }
        this.securityDomain = securityDomain;
    }

    public SecurityDomain getSecurityDomain() {
        return this.securityDomain;
    }

    public void setSecurityDomain(SecurityDomain securityDomain) {
        this.securityDomain = securityDomain;
    }

    public boolean isWantsClientAuth() {
        return this.wantsClientAuth;
    }

    public void setWantsClientAuth(boolean wantsClientAuth) {
        this.wantsClientAuth = wantsClientAuth;
    }

    public boolean isNeedsClientAuth() {
        return this.needsClientAuth;
    }

    public void setNeedsClientAuth(boolean needsClientAuth) {
        this.needsClientAuth = needsClientAuth;
    }

    public Socket createSocket(String serverHost, int serverPort) throws IOException, UnknownHostException {
        InetAddress serverAddr = InetAddress.getByName(serverHost);
        return this.createSocket(serverAddr, serverPort);
    }

    public Socket createSocket(String serverHost, int serverPort, InetAddress clientAddr, int clientPort) throws IOException, UnknownHostException {
        InetAddress serverAddr = InetAddress.getByName(serverHost);
        return this.createSocket(serverAddr, serverPort, clientAddr, clientPort);
    }

    public Socket createSocket(InetAddress serverAddr, int serverPort) throws IOException {
        return this.createSocket(serverAddr, serverPort, null, 0);
    }

    public Socket createSocket(InetAddress serverAddr, int serverPort, InetAddress clientAddr, int clientPort) throws IOException {
        this.initSSLContext();
        SSLSocketFactory factory = this.sslCtx.getSocketFactory();
        SSLSocket socket = (SSLSocket)factory.createSocket(serverAddr, serverPort, clientAddr, clientPort);
        String[] supportedProtocols = socket.getSupportedProtocols();
        log.debug((Object)("Supported protocols: " + Arrays.asList(supportedProtocols)));
        String[] protocols = supportedProtocols;
        socket.setEnabledProtocols(protocols);
        socket.addHandshakeCompletedListener(this);
        socket.setNeedClientAuth(this.needsClientAuth);
        socket.setWantClientAuth(this.wantsClientAuth);
        return socket;
    }

    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        this.initSSLContext();
        SSLSocketFactory factory = this.sslCtx.getSocketFactory();
        SSLSocket socket = (SSLSocket)factory.createSocket(s, host, port, autoClose);
        socket.addHandshakeCompletedListener(this);
        return socket;
    }

    public String[] getDefaultCipherSuites() {
        String[] cipherSuites = new String[]{};
        try {
            this.initSSLContext();
            SSLSocketFactory factory = this.sslCtx.getSocketFactory();
            cipherSuites = factory.getDefaultCipherSuites();
        }
        catch (IOException e) {
            log.error((Object)"Failed to get default SSLSocketFactory", (Throwable)e);
        }
        return cipherSuites;
    }

    public String[] getSupportedCipherSuites() {
        String[] cipherSuites = new String[]{};
        try {
            this.initSSLContext();
            SSLSocketFactory factory = this.sslCtx.getSocketFactory();
            cipherSuites = factory.getSupportedCipherSuites();
        }
        catch (IOException e) {
            log.error((Object)"Failed to get default SSLSocketFactory", (Throwable)e);
        }
        return cipherSuites;
    }

    public static SocketFactory getDefault() {
        DomainSocketFactory ssf = null;
        try {
            InitialContext iniCtx = new InitialContext();
            SecurityDomain sd = (SecurityDomain)iniCtx.lookup("java:/jaas/other");
            ssf = new DomainSocketFactory(sd);
        }
        catch (Exception e) {
            log.error((Object)"Failed to create default SocketFactory", (Throwable)e);
        }
        return ssf;
    }

    public void handshakeCompleted(HandshakeCompletedEvent handshakeCompletedEvent) {
        Logger log = Logger.getLogger((Class)ClientSocketFactory.class);
        if (log.isTraceEnabled()) {
            String cipher = handshakeCompletedEvent.getCipherSuite();
            SSLSession session = handshakeCompletedEvent.getSession();
            String peerHost = session.getPeerHost();
            log.debug((Object)("SSL handshakeCompleted, cipher=" + cipher + ", peerHost=" + peerHost));
        }
    }

    private void initSSLContext() throws IOException {
        if (this.sslCtx != null) {
            return;
        }
        this.sslCtx = Context.forDomain(this.securityDomain);
    }
}

