/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.Fact;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MRequisition;
import org.compiere.model.MRequisitionLine;
import org.compiere.util.Env;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Doc_Requisition
extends Doc {
    public Doc_Requisition(MAcctSchema[] ass, ResultSet rs, String trxName) {
        super(ass, MRequisition.class, rs, "POR", trxName);
    }

    @Override
    public String loadDocumentDetails() {
        this.setC_Currency_ID(-2);
        MRequisition req = (MRequisition)this.getPO();
        this.setDateDoc(req.getDateDoc());
        this.setDateAcct(req.getDateDoc());
        this.setAmount(0, req.getTotalLines());
        this.setAmount(1, req.getTotalLines());
        this.p_lines = this.loadLines(req);
        return null;
    }

    private DocLine[] loadLines(MRequisition req) {
        ArrayList<DocLine> list = new ArrayList<DocLine>();
        MRequisitionLine[] lines = req.getLines();
        for (int i = 0; i < lines.length; ++i) {
            MRequisitionLine line = lines[i];
            DocLine docLine = new DocLine(line, this);
            BigDecimal Qty = line.getQty();
            docLine.setQty(Qty, false);
            line.getPriceActual();
            BigDecimal LineNetAmt = line.getLineNetAmt();
            docLine.setAmount(LineNetAmt);
            list.add(docLine);
        }
        DocLine[] dls = new DocLine[list.size()];
        list.toArray(dls);
        return dls;
    }

    @Override
    public BigDecimal getBalance() {
        BigDecimal retValue = new BigDecimal(0.0);
        return retValue;
    }

    @Override
    public ArrayList<Fact> createFacts(MAcctSchema as) {
        ArrayList<Fact> facts = new ArrayList<Fact>();
        Fact fact = new Fact(this, as, "R");
        this.setC_Currency_ID(as.getC_Currency_ID());
        this.getAmount(0);
        if (as.isCreateReservation()) {
            BigDecimal total = Env.ZERO;
            for (int i = 0; i < this.p_lines.length; ++i) {
                DocLine line = this.p_lines[i];
                BigDecimal cost = line.getAmtSource();
                total = total.add(cost);
                MAccount expense = line.getAccount(2, as);
                fact.createLine(line, expense, as.getC_Currency_ID(), cost, null);
            }
            MAccount offset = this.getAccount(111, as);
            if (offset == null) {
                this.p_Error = "@NotFound@ @CommitmentOffset_Acct@";
                this.log.log(Level.SEVERE, this.p_Error);
                return null;
            }
            fact.createLine(null, offset, this.getC_Currency_ID(), null, total);
            facts.add(fact);
        }
        return facts;
    }
}

