/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.DocTax;
import org.compiere.acct.Fact;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MBPartner;
import org.compiere.model.MBilling;
import org.compiere.model.MBillingLine;
import org.compiere.model.MCurrency;
import org.compiere.model.MTax;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Doc_Billing
extends Doc {
    private DocTax[] m_taxes = null;
    private DocLine[] m_requisitions = null;
    private int m_precision = -1;

    protected Doc_Billing(MAcctSchema[] ass, ResultSet rs, String trxName) {
        super(ass, MBilling.class, rs, null, trxName);
    }

    @Override
    public String loadDocumentDetails() {
        MBilling billing = (MBilling)this.getPO();
        this.setDateDoc(billing.getDateBilling());
        this.setIsTaxIncluded(billing.isTaxIncluded());
        this.setAmount(0, billing.getGrandTotal());
        this.setAmount(1, billing.getTotalLines());
        this.setAmount(2, billing.getChargeAmt());
        this.m_taxes = this.loadTaxes();
        this.p_lines = this.loadLines(billing);
        return null;
    }

    private DocLine[] loadLines(MBilling billing) {
        ArrayList<DocLine> list = new ArrayList<DocLine>();
        MBillingLine[] lines = billing.getLines();
        MBPartner partner = MBPartner.get(this.getCtx(), billing.getC_BPartner_ID());
        for (int i = 0; i < lines.length; ++i) {
            MTax tax;
            MBillingLine line = lines[i];
            DocLine docLine = new DocLine(line, this);
            BigDecimal Qty = line.getQtyBilling();
            docLine.setQty(Qty, billing.isSOTrx());
            BigDecimal PriceCost = null;
            BigDecimal LineNetAmt = null;
            LineNetAmt = PriceCost != null && PriceCost.signum() != 0 ? Qty.multiply(PriceCost) : line.getLineNetAmt();
            docLine.setAmount(LineNetAmt);
            BigDecimal PriceList = line.getPriceList();
            int C_Tax_ID = docLine.getC_Tax_ID();
            if (this.isTaxIncluded() && C_Tax_ID != 0 && !(tax = MTax.get(this.getCtx(), C_Tax_ID)).isZeroTax()) {
                BigDecimal LineNetAmtTax = tax.calculateTax(LineNetAmt, true, this.getStdPrecision(), partner.getTaxRoundModeAsInt());
                this.log.fine("LineNetAmt=" + LineNetAmt + " - Tax=" + LineNetAmtTax);
                LineNetAmt = LineNetAmt.subtract(LineNetAmtTax);
                for (int t = 0; t < this.m_taxes.length; ++t) {
                    if (this.m_taxes[t].getC_Tax_ID() != C_Tax_ID) continue;
                    this.m_taxes[t].addIncludedTax(LineNetAmtTax);
                    break;
                }
                BigDecimal PriceListTax = tax.calculateTax(PriceList, true, this.getStdPrecision(), partner.getTaxRoundModeAsInt());
                PriceList = PriceList.subtract(PriceListTax);
            }
            docLine.setAmount(LineNetAmt, PriceList, Qty);
            list.add(docLine);
        }
        DocLine[] dl = new DocLine[list.size()];
        list.toArray(dl);
        return dl;
    }

    private int getStdPrecision() {
        if (this.m_precision == -1) {
            this.m_precision = MCurrency.getStdPrecision(this.getCtx(), this.getC_Currency_ID());
        }
        return this.m_precision;
    }

    private DocTax[] loadTaxes() {
        ArrayList<DocTax> list = new ArrayList<DocTax>();
        String sql = "SELECT it.C_Tax_ID, t.Name, t.Rate, it.TaxBaseAmt, it.TaxAmt, t.IsSalesTax FROM C_Tax t, C_BillingTax it WHERE t.C_Tax_ID=it.C_Tax_ID AND it.C_Billing_ID=?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, this.getTrxName());
            pstmt.setInt(1, this.get_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                int C_Tax_ID = rs.getInt(1);
                String name = rs.getString(2);
                BigDecimal rate = rs.getBigDecimal(3);
                BigDecimal taxBaseAmt = rs.getBigDecimal(4);
                BigDecimal amount = rs.getBigDecimal(5);
                boolean salesTax = "Y".equals(rs.getString(6));
                DocTax taxLine = new DocTax(C_Tax_ID, name, rate, taxBaseAmt, amount, salesTax);
                list.add(taxLine);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        DocTax[] tl = new DocTax[list.size()];
        list.toArray(tl);
        return tl;
    }

    @Override
    public BigDecimal getBalance() {
        int i;
        BigDecimal retValue = new BigDecimal(0.0);
        StringBuffer sb = new StringBuffer(" [");
        retValue = retValue.add(this.getAmount(0));
        sb.append(this.getAmount(0));
        retValue = retValue.subtract(this.getAmount(2));
        sb.append("-").append(this.getAmount(2));
        if (this.m_taxes != null) {
            for (i = 0; i < this.m_taxes.length; ++i) {
                retValue = retValue.subtract(this.m_taxes[i].getAmount());
                sb.append("-").append(this.m_taxes[i].getAmount());
            }
        }
        if (this.p_lines != null) {
            for (i = 0; i < this.p_lines.length; ++i) {
                retValue = retValue.subtract(this.p_lines[i].getAmtSource());
                sb.append("-").append(this.p_lines[i].getAmtSource());
            }
            sb.append("]");
        }
        this.log.fine(this.toString() + " Balance=" + retValue + sb.toString());
        return retValue;
    }

    @Override
    public ArrayList<Fact> createFacts(MAcctSchema as) {
        ArrayList<Fact> facts = new ArrayList<Fact>();
        return facts;
    }
}

