/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import org.compiere.acct.DocLine;
import org.compiere.acct.Doc_Bank;
import org.compiere.model.MBankStatementCharge;
import org.compiere.util.Env;

public class DocLine_BankCharge
extends DocLine {
    private BigDecimal m_ChargeAmt = Env.ZERO;
    private BigDecimal m_ChargeAmtNoTax = Env.ZERO;
    private BigDecimal m_TaxAmt = Env.ZERO;
    private BigDecimal m_TotalAmt = Env.ZERO;
    private int m_C_Charge_ID = 0;
    private int m_C_Tax_ID = 0;
    private boolean m_IsTaxIncluded = true;

    public DocLine_BankCharge(MBankStatementCharge charge, Doc_Bank doc) {
        super(charge, doc);
        this.m_ChargeAmt = charge.getChargeAmt();
        this.m_TaxAmt = charge.getTaxAmt();
        this.m_TotalAmt = charge.getTotalAmt();
        this.m_C_Charge_ID = charge.getC_Charge_ID();
        this.m_C_Tax_ID = charge.getC_Tax_ID();
        this.m_IsTaxIncluded = charge.isTaxIncluded();
        this.m_ChargeAmtNoTax = this.m_IsTaxIncluded ? this.m_ChargeAmt.subtract(this.m_TaxAmt) : this.m_ChargeAmt;
    }

    public BigDecimal getChargeAmt() {
        return this.m_ChargeAmt;
    }

    public BigDecimal getTaxAmt() {
        return this.m_TaxAmt;
    }

    public BigDecimal getTotalAmt() {
        return this.m_TotalAmt;
    }

    public int getC_Charge_ID() {
        return this.m_C_Charge_ID;
    }

    public BigDecimal getChargeAmtNoTax() {
        return this.m_ChargeAmtNoTax;
    }

    public int getC_Tax_ID() {
        return this.m_C_Tax_ID;
    }

    public boolean isTaxIncluded() {
        return this.m_IsTaxIncluded;
    }
}

