/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jetspeed.portletcontainer.tags;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.jetspeed.portlet.PortletConfig;
import org.apache.jetspeed.portlet.PortletContext;
import org.apache.jetspeed.portlet.PortletData;
import org.apache.jetspeed.portlet.PortletLog;
import org.apache.jetspeed.portlet.PortletRequest;
import org.apache.jetspeed.portletcontainer.util.ThreadAttributesManager;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class DataLoopTag
extends BodyTagSupport {
    private Enumeration iAttributes = null;
    private String iAttribute = null;
    private RE iPattern = null;

    public int doStartTag() {
        PortletRequest portletRequest = (PortletRequest)ThreadAttributesManager.getAttribute((String)"org.apache.jetspeed.portletcontainer.portlet.request");
        PortletData data = portletRequest.getData();
        if (data != null) {
            this.iAttributes = data.getAttributeNames();
        }
        return this.doAfterBody();
    }

    public int doAfterBody() {
        int result = 0;
        try {
            if (this.bodyContent != null) {
                this.bodyContent.writeOut((Writer)this.bodyContent.getEnclosingWriter());
                this.bodyContent.clearBuffer();
            }
            this.iAttribute = null;
            while (this.iAttributes != null && this.iAttributes.hasMoreElements() && this.iAttribute == null) {
                this.iAttribute = (String)this.iAttributes.nextElement();
                if (this.iPattern == null || this.iPattern.match(this.iAttribute)) {
                    ((TagSupport)this).pageContext.setAttribute("portletData", (Object)this.iAttribute);
                    result = 2;
                    continue;
                }
                this.iAttribute = null;
            }
        }
        catch (IOException exc) {
            PortletConfig portletConfig = (PortletConfig)ThreadAttributesManager.getAttribute((String)"org.apache.jetspeed.portletcontainer.portlet.config");
            PortletContext portletContext = portletConfig.getContext();
            PortletLog portletLog = portletContext.getLog();
            portletLog.error("DataLoopTag: An I/O error occurred.", exc);
        }
        return result;
    }

    public int doEndTag() {
        try {
            if (this.bodyContent != null) {
                this.bodyContent.writeOut((Writer)this.bodyContent.getEnclosingWriter());
            }
        }
        catch (IOException exc) {
            PortletConfig portletConfig = (PortletConfig)ThreadAttributesManager.getAttribute((String)"org.apache.jetspeed.portletcontainer.portlet.config");
            PortletContext portletContext = portletConfig.getContext();
            PortletLog portletLog = portletContext.getLog();
            portletLog.error("DataLoopTag: An I/O error occurred: ", exc);
        }
        this.resetCustomAttributes();
        return 6;
    }

    private void resetCustomAttributes() {
        this.iAttribute = null;
        this.iAttributes = null;
        this.iPattern = null;
    }

    public void release() {
        ((TagSupport)this).pageContext.removeAttribute("portletData");
    }

    public void setPattern(String aPattern) {
        try {
            this.iPattern = new RE(aPattern);
        }
        catch (RESyntaxException exc) {
            PortletConfig portletConfig = (PortletConfig)ThreadAttributesManager.getAttribute((String)"org.apache.jetspeed.portletcontainer.portlet.config");
            PortletContext portletContext = portletConfig.getContext();
            PortletLog portletLog = portletContext.getLog();
            portletLog.error("DataLoopTag: Pattern syntax exception: ", exc);
            this.iPattern = null;
        }
    }
}

