/*
 * Decompiled with CFR 0.152.
 */
package dori.jasper.engine.xml;

import dori.jasper.engine.JRException;
import dori.jasper.engine.JasperPrint;
import dori.jasper.engine.xml.JRXmlDigester;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class JRPrintXmlLoader
implements ErrorHandler {
    private JasperPrint jasperPrint = null;
    private List errors = new ArrayList();

    protected JRPrintXmlLoader() {
    }

    public void setJasperPrint(JasperPrint jasperPrint) {
        this.jasperPrint = jasperPrint;
    }

    public static JasperPrint load(String sourceFileName) throws JRException {
        JasperPrint jasperPrint = null;
        try {
            FileInputStream fis = new FileInputStream(sourceFileName);
            JRPrintXmlLoader printXmlLoader = new JRPrintXmlLoader();
            jasperPrint = printXmlLoader.loadXML(fis);
            fis.close();
        }
        catch (IOException e) {
            throw new JRException(e);
        }
        return jasperPrint;
    }

    public static JasperPrint load(InputStream is) throws JRException {
        JasperPrint jasperPrint = null;
        JRPrintXmlLoader printXmlLoader = new JRPrintXmlLoader();
        jasperPrint = printXmlLoader.loadXML(is);
        return jasperPrint;
    }

    private JasperPrint loadXML(InputStream is) throws JRException {
        try {
            JRXmlDigester digester = this.prepareDigester();
            digester.parse(is);
        }
        catch (ParserConfigurationException e) {
            throw new JRException(e);
        }
        catch (SAXException e) {
            throw new JRException(e);
        }
        catch (IOException e) {
            throw new JRException(e);
        }
        if (this.errors.size() > 0) {
            Exception e = (Exception)this.errors.get(0);
            if (e instanceof JRException) {
                throw (JRException)e;
            }
            throw new JRException(e);
        }
        return this.jasperPrint;
    }

    private JRXmlDigester prepareDigester() throws ParserConfigurationException, SAXException {
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        SAXParser saxParser = saxParserFactory.newSAXParser();
        XMLReader xmlReader = saxParser.getXMLReader();
        String validation = System.getProperty("jasper.reports.export.xml.validation");
        if (validation == null || validation.length() == 0) {
            validation = "true";
        }
        xmlReader.setFeature("http://xml.org/sax/features/validation", Boolean.valueOf(validation));
        JRXmlDigester digester = new JRXmlDigester(xmlReader);
        digester.push(this);
        digester.setErrorHandler(this);
        digester.setValidating(true);
        digester.addFactoryCreate("jasperPrint", "dori.jasper.engine.xml.JasperPrintFactory");
        digester.addSetNext("jasperPrint", "setJasperPrint", "dori.jasper.engine.JasperPrint");
        digester.addFactoryCreate("jasperPrint/reportFont", "dori.jasper.engine.xml.JRReportFontFactory");
        digester.addSetNext("jasperPrint/reportFont", "addFont", "dori.jasper.engine.JRReportFont");
        digester.addFactoryCreate("jasperPrint/page", "dori.jasper.engine.xml.JRPrintPageFactory");
        digester.addSetNext("jasperPrint/page", "addPage", "dori.jasper.engine.JRPrintPage");
        digester.addFactoryCreate("*/line", "dori.jasper.engine.xml.JRPrintLineFactory");
        digester.addSetNext("*/line", "addElement", "dori.jasper.engine.JRPrintElement");
        digester.addFactoryCreate("*/reportElement", "dori.jasper.engine.xml.JRPrintElementFactory");
        digester.addFactoryCreate("*/graphicElement", "dori.jasper.engine.xml.JRPrintGraphicElementFactory");
        digester.addFactoryCreate("*/rectangle", "dori.jasper.engine.xml.JRPrintRectangleFactory");
        digester.addSetNext("*/rectangle", "addElement", "dori.jasper.engine.JRPrintElement");
        digester.addFactoryCreate("*/ellipse", "dori.jasper.engine.xml.JRPrintEllipseFactory");
        digester.addSetNext("*/ellipse", "addElement", "dori.jasper.engine.JRPrintElement");
        digester.addFactoryCreate("*/image", "dori.jasper.engine.xml.JRPrintImageFactory");
        digester.addSetNext("*/image", "addElement", "dori.jasper.engine.JRPrintElement");
        digester.addFactoryCreate("*/image/imageSource", "dori.jasper.engine.xml.JRPrintImageSourceFactory");
        digester.addCallMethod("*/image/imageSource", "setImageSource", 0);
        digester.addFactoryCreate("*/text", "dori.jasper.engine.xml.JRPrintTextFactory");
        digester.addSetNext("*/text", "addElement", "dori.jasper.engine.JRPrintElement");
        digester.addCallMethod("*/text/textContent", "setText", 0);
        digester.addFactoryCreate("*/text/font", "dori.jasper.engine.xml.JRPrintFontFactory");
        digester.addSetNext("*/text/font", "setFont", "dori.jasper.engine.JRFont");
        return digester;
    }

    public void addError(Exception e) {
        this.errors.add(e);
    }

    public void error(SAXParseException e) {
        this.errors.add(e);
    }

    public void fatalError(SAXParseException e) {
        this.errors.add(e);
    }

    public void warning(SAXParseException e) {
        this.errors.add(e);
    }
}

