/*
 * Decompiled with CFR 0.152.
 */
package com.jware.util.excel;

import com.jware.util.excel.CSVParse;
import com.jware.util.excel.ExcelCSVLexer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Vector;

public class ExcelCSVParser
implements CSVParse {
    private ExcelCSVLexer lexer;
    private String tokenCache;
    private int lineCache;
    private int lastLine = -1;

    public ExcelCSVParser(InputStream in) throws Exception {
        this.lexer = new ExcelCSVLexer(in);
    }

    public ExcelCSVParser(Reader in) {
        this.lexer = new ExcelCSVLexer(in);
    }

    public String nextValue() throws IOException {
        if (this.tokenCache == null) {
            this.tokenCache = this.lexer.getNextToken();
            this.lineCache = this.lexer.getLineNumber();
        }
        this.lastLine = this.lineCache;
        String result = this.tokenCache;
        this.tokenCache = null;
        return result;
    }

    public int lastLineNumber() {
        return this.lastLine;
    }

    public String[] getLine() throws IOException {
        int lineNumber = -1;
        Vector<String> v = new Vector<String>();
        if (this.tokenCache != null) {
            v.add(this.tokenCache);
            lineNumber = this.lineCache;
        }
        while ((this.tokenCache = this.lexer.getNextToken()) != null && (lineNumber == -1 || this.lexer.getLineNumber() == lineNumber)) {
            v.add(this.tokenCache);
            lineNumber = this.lexer.getLineNumber();
        }
        if (v.size() == 0) {
            return null;
        }
        this.lastLine = lineNumber;
        this.lineCache = this.lexer.getLineNumber();
        String[] result = new String[v.size()];
        return v.toArray(result);
    }

    public String[][] getAllValues() throws IOException {
        String[] line;
        Vector<String[]> v = new Vector<String[]>();
        while ((line = this.getLine()) != null) {
            v.add(line);
        }
        if (v.size() == 0) {
            return null;
        }
        String[][] result = new String[v.size()][];
        return (String[][])v.toArray((T[])result);
    }

    public void setCommentStart(String commentDelims) {
        this.lexer.setCommentStart(commentDelims);
    }

    public int getLastLineNumber() {
        return this.lastLine;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void main(String[] args) {
        try {
            String[] t;
            InputStream in;
            if (args.length > 0) {
                File f = new File(args[0]);
                if (!f.exists()) throw new IOException("Could not find " + args[0]);
                if (!f.canRead()) throw new IOException("Could not open " + args[0]);
                in = new FileInputStream(f);
            } else {
                in = System.in;
            }
            ExcelCSVParser p2 = new ExcelCSVParser(in);
            while ((t = p2.getLine()) != null) {
                for (int i2 = 0; i2 < t.length; ++i2) {
                    System.out.print('\"' + t[i2] + '\"');
                    if (i2 >= t.length - 1) continue;
                    System.out.print(", ");
                }
            }
            return;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public static String[][] parse(String s) {
        try {
            return new ExcelCSVParser(new StringReader(s)).getAllValues();
        }
        catch (IOException x) {
            return null;
        }
    }
}

