/*
 * Decompiled with CFR 0.152.
 */
package com.jware.util;

public class StringConverter {
    static final String HANKAKU_LATIN = " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~";
    static final String ZENKAKU_LATIN = "\u3000\uff01\u201d\uff03\uff04\uff05\uff06\u2019\uff08\uff09\uff0a\uff0b\u3001\uff0d\uff0e\uff0f\uff10\uff11\uff12\uff13\uff14\uff15\uff16\uff17\uff18\uff19\uff1a\uff1b\uff1c\uff1d\uff1e\uff1f\uff20\uff21\uff22\uff23\uff24\uff25\uff26\uff27\uff28\uff29\uff2a\uff2b\uff2c\uff2d\uff2e\uff2f\uff30\uff31\uff32\uff33\uff34\uff35\uff36\uff37\uff38\uff39\uff3a\uff3b\uffe5\uff3d\uff3e\uff3f\u2018\uff41\uff42\uff43\uff44\uff45\uff46\uff47\uff48\uff49\uff4a\uff4b\uff4c\uff4d\uff4e\uff4f\uff50\uff51\uff52\uff53\uff54\uff55\uff56\uff57\uff58\uff59\uff5a\uff5b\uff5c\uff5d\uff5e";
    static final String ZENKAKU_KATAKANA = "\u30a2\u30a4\u30a6\u30a8\u30aa\u30ab\u30ad\u30af\u30b1\u30b3\u30b5\u30b7\u30b9\u30bb\u30bd\u30bf\u30c1\u30c4\u30c6\u30c8\u30ca\u30cb\u30cc\u30cd\u30ce\u30cf\u30d2\u30d5\u30d8\u30db\u30de\u30e2\u30e0\u30e1\u30e2\u30e4\u30e6\u30e8\u30e9\u30ea\u30eb\u30ec\u30ed\u30ef\u30f2\u30f3\u30a1\u30a3\u30a5\u30a7\u30a9\u30c3\u30e3\u30e5\u30e7\u30ac\u30ae\u30b0\u30b2\u30b4\u30b6\u30b8\u30ba\u30bc\u30be\u30c0\u30c2\u30c5\u30c7\u30c9\u30d0\u30d3\u30d6\u30d9\u30dc\u30d1\u30d4\u30d7\u30da\u30dd";
    static final String ZENKAKU_GAZADABA = "\u30ac\u30ae\u30b0\u30b2\u30b4\u30b6\u30b8\u30ba\u30bc\u30be\u30c0\u30c2\u30c5\u30c7\u30c9\u30d0\u30d3\u30d6\u30d9\u30dc";
    static final String ZENKAKU_PAPIPUPEPO = "\u30d1\u30d4\u30d7\u30da\u30dd";
    static final String ZENKAKU_HIRAKANA = "\u3042\u3044\u3046\u3048\u304a\u304b\u304d\u304f\u3051\u3053\u3055\u3057\u3059\u305b\u305d\u305f\u3061\u3064\u3066\u3068\u306a\u306b\u306c\u306d\u306e\u306f\u3072\u3075\u3078\u307b\u307e\u3082\u3080\u3081\u3082\u3084\u3086\u3088\u3089\u308a\u308b\u308c\u308d\u308f\u3092\u3093\u3041\u3043\u3045\u3047\u3049\u3063\u3083\u3085\u3087\u304c\u304e\u3050\u3052\u3054\u3056\u3058\u305a\u305c\u305e\u3060\u3062\u3065\u3067\u3069\u3070\u3073\u3076\u3079\u307c\u3071\u3074\u3077\u307a\u307d";
    static final String HANKAKU_KATAKANA = "\uff71\uff72\uff73\uff74\uff75\uff76\uff77\uff78\uff79\uff7a\uff7b\uff7c\uff7d\uff7e\uff7f\uff80\uff81\uff82\uff83\uff84\uff85\uff86\uff87\uff88\uff89\uff8a\uff8b\uff8c\uff8d\uff8e\uff8f\uff90\uff91\uff92\uff93\uff94\uff95\uff96\uff97\uff98\uff99\uff9a\uff9b\uff9c\uff66\uff9d\uff71\uff72\uff73\uff74\uff75\uff82\uff94\uff95\uff96\uff76\uff77\uff78\uff79\uff7a\uff7b\uff7c\uff7d\uff7e\uff7f\uff80\uff81\uff82\uff83\uff84\uff8a\uff8b\uff8c\uff8d\uff8e\uff8a\uff8b\uff8c\uff8d\uff8e";
    static final String HANKAKU_GAMARK = "\uff9e";
    static final String HANKAKU_PAMARK = "\uff9f";
    static final String HANKAKU_GAZADABA = "\uff76\uff77\uff78\uff79\uff7a\uff7b\uff7c\uff7d\uff7e\uff7f\uff80\uff81\uff82\uff83\uff84\uff8a\uff8b\uff8c\uff8d\uff8e";
    static final String HANKAKU_PAPIPUPEPO = "\uff8a\uff8b\uff8c\uff8d\uff8e";

    private StringConverter() {
    }

    public static String hankaku2Zenkaku(String str) {
        if (str == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        for (int j = 0; j < str.length(); ++j) {
            char ch = str.charAt(j);
            for (int i2 = 0; i2 < HANKAKU_LATIN.length(); ++i2) {
                if (ch != HANKAKU_LATIN.charAt(i2)) continue;
                ch = ZENKAKU_LATIN.charAt(i2);
                break;
            }
            buffer.append(ch);
        }
        return buffer.toString();
    }

    public static String zenkaku2Hankeku(String str) {
        if (str == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        for (int j = 0; j < str.length(); ++j) {
            char ch = str.charAt(j);
            for (int i2 = 0; i2 < ZENKAKU_LATIN.length(); ++i2) {
                if (ch != ZENKAKU_LATIN.charAt(i2)) continue;
                ch = HANKAKU_LATIN.charAt(i2);
                break;
            }
            buffer.append(ch);
        }
        return buffer.toString();
    }

    public static String katakana2Hiragana(String str) {
        if (str == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        for (int j = 0; j < str.length(); ++j) {
            char ch = str.charAt(j);
            for (int i2 = 0; i2 < ZENKAKU_KATAKANA.length(); ++i2) {
                if (ch != ZENKAKU_KATAKANA.charAt(i2)) continue;
                ch = ZENKAKU_HIRAKANA.charAt(i2);
                break;
            }
            buffer.append(ch);
        }
        return buffer.toString();
    }

    public static String hiragana2Katakana(String str) {
        if (str == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        for (int j = 0; j < str.length(); ++j) {
            char ch = str.charAt(j);
            for (int i2 = 0; i2 < ZENKAKU_HIRAKANA.length(); ++i2) {
                if (ch != ZENKAKU_HIRAKANA.charAt(i2)) continue;
                ch = ZENKAKU_KATAKANA.charAt(i2);
                break;
            }
            buffer.append(ch);
        }
        return buffer.toString();
    }

    public static String katakana2HankakuKatakana(String str) {
        if (str == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        for (int j = 0; j < str.length(); ++j) {
            char ch1;
            char ch2 = ch1 = str.charAt(j);
            for (int i2 = 0; i2 < ZENKAKU_KATAKANA.length(); ++i2) {
                if (ch1 != ZENKAKU_KATAKANA.charAt(i2)) continue;
                ch2 = HANKAKU_KATAKANA.charAt(i2);
                break;
            }
            buffer.append(ch2);
            if (ZENKAKU_GAZADABA.indexOf(ch1) > 0) {
                buffer.append(HANKAKU_GAMARK);
            }
            if (ZENKAKU_PAPIPUPEPO.indexOf(ch1) <= 0) continue;
            buffer.append(HANKAKU_PAMARK);
        }
        return buffer.toString();
    }

    public static String HankakuKatakana2katakana(String str) {
        if (str == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        for (int j = 0; j < str.length(); ++j) {
            int i2;
            char ch3;
            char ch1 = str.charAt(j);
            char ch2 = j < str.length() - 1 ? str.charAt(j + 1) : (char)'\u0000';
            if (ch2 != HANKAKU_GAMARK.charAt(0) && ch2 != HANKAKU_PAMARK.charAt(0)) {
                for (int i3 = 0; i3 < HANKAKU_KATAKANA.length(); ++i3) {
                    if (ch1 != HANKAKU_KATAKANA.charAt(i3)) continue;
                    ch1 = ZENKAKU_KATAKANA.charAt(i3);
                    break;
                }
                buffer.append(ch1);
                continue;
            }
            if (ch2 == HANKAKU_GAMARK.charAt(0)) {
                ch3 = '\u0000';
                for (i2 = 0; i2 < HANKAKU_GAZADABA.length(); ++i2) {
                    if (ch1 != HANKAKU_GAZADABA.charAt(i2)) continue;
                    ch3 = ZENKAKU_GAZADABA.charAt(i2);
                    break;
                }
                if (ch3 == '\u0000') {
                    for (i2 = 0; i2 < HANKAKU_KATAKANA.length(); ++i2) {
                        if (ch1 != HANKAKU_KATAKANA.charAt(i2)) continue;
                        ch1 = ZENKAKU_KATAKANA.charAt(i2);
                        break;
                    }
                } else {
                    ch1 = ch3;
                }
                buffer.append(ch1);
                ++j;
                continue;
            }
            if (ch2 != HANKAKU_PAMARK.charAt(0)) continue;
            ch3 = '\u0000';
            for (i2 = 0; i2 < HANKAKU_KATAKANA.length(); ++i2) {
                if (ch1 != HANKAKU_KATAKANA.charAt(i2)) continue;
                ch3 = ZENKAKU_KATAKANA.charAt(i2);
                break;
            }
            if (ch3 == '\u0000') {
                for (i2 = 0; i2 < HANKAKU_KATAKANA.length(); ++i2) {
                    if (ch1 != HANKAKU_KATAKANA.charAt(i2)) continue;
                    ch1 = ZENKAKU_KATAKANA.charAt(i2);
                    break;
                }
            } else {
                ch1 = ch3;
            }
            buffer.append(ch1);
            ++j;
        }
        return buffer.toString();
    }
}

