/*
 * Decompiled with CFR 0.152.
 */
package com.jware.apps.scheduler.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.CronTrigger;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.UICronTrigger;
import org.quartz.impl.StdSchedulerFactory;

public class JobSchedulerUtils {
    public static String JOB_DEFINITIONS_PROP = "definitionManager";
    private static final transient Log logger = LogFactory.getLog(JobSchedulerUtils.class);
    public static final String DATE_FORMAT_PATTERN = "yyyy-MM-dd HH:mm:ss";
    static SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final String CURRENT_SCHEDULER_PROP = "currentScheduler";
    public static final String CVS_INFO = "$Id: JobSchedulerUtils.java,v 1.1 2008/09/30 12:26:46 clmg Exp $";

    public static Scheduler getCurrentScheduler(HttpServletRequest request) {
        Scheduler currentScheduler = (Scheduler)request.getSession(true).getAttribute(CURRENT_SCHEDULER_PROP);
        if (currentScheduler == null) {
            block3: {
                try {
                    currentScheduler = StdSchedulerFactory.getDefaultScheduler();
                }
                catch (SchedulerException e) {
                    if (!logger.isDebugEnabled()) break block3;
                    logger.warn((Object)"Scheduler not Exist error ", (Throwable)e);
                }
            }
            request.getSession().setAttribute(CURRENT_SCHEDULER_PROP, (Object)currentScheduler);
        }
        return currentScheduler;
    }

    public static Scheduler getCurrentScheduler(HttpSession session) {
        Scheduler currentScheduler = (Scheduler)session.getAttribute(CURRENT_SCHEDULER_PROP);
        if (currentScheduler == null) {
            block3: {
                try {
                    currentScheduler = StdSchedulerFactory.getDefaultScheduler();
                }
                catch (SchedulerException e) {
                    if (!logger.isDebugEnabled()) break block3;
                    logger.warn((Object)"Scheduler not Exist error ", (Throwable)e);
                }
            }
            session.setAttribute(CURRENT_SCHEDULER_PROP, (Object)currentScheduler);
        }
        return currentScheduler;
    }

    public static String getDateAsString(Date date) {
        if (date == null) {
            return null;
        }
        return dateFormatter.format(date);
    }

    public static Date parseStringToDate(String dateStr) throws ParseException {
        if (dateStr == null) {
            return null;
        }
        return dateFormatter.parse(dateStr);
    }

    public static String getTriggerType(Trigger trigger) {
        String type = null;
        type = trigger instanceof SimpleTrigger ? "simple" : (trigger instanceof CronTrigger ? "cron" : (trigger instanceof UICronTrigger ? "uicron" : trigger.getClass().getName()));
        return type;
    }

    public static Trigger[] getTriggersFromJob(Scheduler scheduler, String jobName, String jobGroup) {
        ArrayList<Trigger> triggerList = new ArrayList<Trigger>();
        String[] groups = new String[]{};
        try {
            groups = scheduler.getTriggerGroupNames();
        }
        catch (SchedulerException e) {
            logger.error((Object)"When getting all trigger groups", (Throwable)e);
            groups = new String[]{};
        }
        for (int i2 = 0; i2 < groups.length; ++i2) {
            String group = groups[i2];
            String[] names = null;
            try {
                names = scheduler.getTriggerNames(group);
            }
            catch (SchedulerException e) {
                logger.error((Object)("When getting all trigger in group groups " + group), (Throwable)e);
                names = new String[]{};
            }
            for (int j = 0; j < names.length; ++j) {
                String name = names[j];
                Trigger trigger = null;
                try {
                    trigger = scheduler.getTrigger(name, group);
                }
                catch (SchedulerException e) {
                    logger.error((Object)("When getting trigger " + name + " in group " + group), (Throwable)e);
                    trigger = null;
                }
                if (trigger == null) {
                    logger.warn((Object)("The trigger " + name + " in group " + group + " was null"));
                    continue;
                }
                if (!trigger.getJobName().equals(jobName) || !trigger.getJobGroup().equals(jobGroup)) continue;
                triggerList.add(trigger);
            }
        }
        Trigger[] retArr = new Trigger[triggerList.size()];
        triggerList.toArray(retArr);
        return retArr;
    }
}

