/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.web.struts.search;

import com.ampiere.web.struts.search.InfoSchedule;
import com.ampiere.web.struts.search.VSchedulePanel;
import java.sql.Timestamp;
import java.util.Calendar;
import javax.swing.JScrollPane;
import org.compiere.model.MAssignmentSlot;
import org.compiere.model.ScheduleUtil;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Language;

public class VSchedule
extends JScrollPane {
    private static Calendar s_calendar = Calendar.getInstance(Language.getLoginLanguage().getLocale());
    private static CLogger log = CLogger.getCLogger(VSchedule.class);
    private Period m_numDays = Period.DAY;
    private ScheduleUtil m_model = null;
    private Timestamp m_startDate;
    private Timestamp m_endDate;
    private VSchedulePanel schedulePanel = new VSchedulePanel();

    public VSchedule(InfoSchedule is, Period type) {
        this.m_numDays = type;
        this.m_model = new ScheduleUtil(Env.getCtx());
        this.schedulePanel.setInfoSchedule(is);
        this.getViewport().add(this.schedulePanel);
    }

    public void recreate(int S_Resource_ID, Timestamp date) {
        s_calendar.setTime(date);
        s_calendar.set(10, 0);
        s_calendar.set(12, 0);
        s_calendar.set(13, 0);
        s_calendar.set(14, 0);
        if (this.m_numDays == Period.WEEK) {
            s_calendar.set(7, s_calendar.getFirstDayOfWeek());
        } else if (this.m_numDays == Period.MONTH) {
            s_calendar.set(5, 1);
        }
        this.m_startDate = new Timestamp(s_calendar.getTimeInMillis());
        s_calendar.add(this.m_numDays.type(), 1);
        this.m_endDate = new Timestamp(s_calendar.getTimeInMillis());
        log.config("(" + (Object)((Object)this.m_numDays) + ") Resource_ID=" + S_Resource_ID + ": " + this.m_startDate + "->" + this.m_endDate);
        MAssignmentSlot[] mas = this.m_model.getAssignmentSlots(S_Resource_ID, this.m_startDate, this.m_endDate, null, true, null);
        MAssignmentSlot[] mts = this.m_model.getDayTimeSlots();
        this.schedulePanel.setAssignmentSlots(mas, mts, S_Resource_ID, this.m_startDate, this.m_numDays);
    }

    public void setCreateNew(boolean createNew) {
        this.schedulePanel.setCreatesNewAssignments(createNew);
    }

    public void dispose() {
        this.m_model = null;
        if (this.schedulePanel != null) {
            this.schedulePanel.dispose();
        }
        this.schedulePanel = null;
        this.removeAll();
    }

    public Timestamp getStartDate() {
        return this.m_startDate;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Period {
        DAY(5),
        WEEK(3),
        MONTH(2);

        private final int type;

        private Period(int type) {
            this.type = type;
        }

        public int type() {
            return this.type;
        }
    }
}

