/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.web.struts.search;

import com.ampiere.acct.Post;
import com.ampiere.util.AWebUtil;
import com.ampiere.util.AmpiereUtil;
import com.ampiere.web.servlet.WWindowStatus;
import com.ampiere.web.struts.search.AcctViewerForm;
import com.jware.util.StringToIntConverter;
import java.math.BigDecimal;
import java.rmi.RemoteException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.tr;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.compiere.db.CConnection;
import org.compiere.interfaces.Server;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAcctSchemaElement;
import org.compiere.model.MRefList;
import org.compiere.report.core.RColumn;
import org.compiere.report.core.RModel;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.ValueNamePair;
import org.compiere.util.WebSessionCtx;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcctViewer
extends Action {
    private CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());
    private static final String SUCCESS = "success";
    private static final String ACTION_FORM = "AcctViewerForm";
    private static final String ERROR_FORWARD = "error";
    int m_leadingColumns = 0;
    String m_ref1;
    String m_ref2;
    String ACTION_SEL_SCHEMA = "1";
    String ACTION_QUERY = "2";
    String ACTION_SEL_DOCUMENT = "3";
    String ACTION_SEL_TABLE = "4";
    String ACTION_RE_POST = "5";
    String ACTION_PRINT = "6";
    int SEL_COUNT = 8;
    String RESULT_DIV_ID = "resultDiv";
    String SELECTED_TABLE_KEY = "selectedKey";

    public final ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        WebSessionCtx wscTest = WebSessionCtx.get(request);
        if (wscTest == null) {
            this.log.log(Level.SEVERE, "Session Time Out.");
            request.setAttribute("sessionTimeoutInfo", (Object)"Session Time Out. Please login again.");
            return mapping.findForward("sessionTimeout");
        }
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        HttpSession session = request.getSession();
        String doQurey = "0";
        if (wsc == null) {
            this.log.log(Level.SEVERE, "Session Time Out.");
            return mapping.findForward(ERROR_FORWARD);
        }
        AcctViewerForm acctViewerForm = (AcctViewerForm)request.getAttribute(ACTION_FORM);
        if (acctViewerForm == null && (acctViewerForm = (AcctViewerForm)actionForm) == null) {
            acctViewerForm = new AcctViewerForm();
        }
        acctViewerForm.statInit(wsc.ctx);
        String actionType = request.getParameter("actionType");
        if (!this.ACTION_SEL_SCHEMA.equals(actionType)) {
            if (this.ACTION_QUERY.equals(actionType)) {
                Document xml_doc = this.actionQuery(request);
                AWebUtil.createCalloutAjaxResponse(response, xml_doc);
                return null;
            }
            if (this.ACTION_RE_POST.equals(actionType)) {
                Document xml_doc = this.actionRePost(request);
                AWebUtil.createCalloutAjaxResponse(response, xml_doc);
                return null;
            }
        }
        acctViewerForm.setTitle(Msg.getMsg(wsc.ctx, "Archive"));
        List<KeyNamePair> acctSchemaList = this.getAcctSchemaList(request);
        List<ValueNamePair> tableList = this.getTableList(request);
        List<ValueNamePair> postingTypeList = this.getPostingTypeList(request);
        List<KeyNamePair> orgList = this.getOrgList(request);
        List<ValueNamePair> sortByItemList = this.getSortByItemList(request);
        request.setAttribute("acctSchemaList", acctSchemaList);
        request.setAttribute("tableList", tableList);
        request.setAttribute("postingTypeList", postingTypeList);
        request.setAttribute("orgList", orgList);
        request.setAttribute("sortByItemList", sortByItemList);
        this.addButtons(request, acctViewerForm);
        acctViewerForm.setRePostMsg(AWebUtil.info(request, "PostImmediate?", null));
        if (tableList != null) {
            acctViewerForm.setRecordId(tableList.get(0).getID() + "_ID");
        }
        request.setAttribute(ACTION_FORM, (Object)acctViewerForm);
        return mapping.findForward(SUCCESS);
    }

    private List<KeyNamePair> getAcctSchemaList(HttpServletRequest request) {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        ArrayList<KeyNamePair> acctSchemaList = new ArrayList<KeyNamePair>();
        int AD_Client_ID = wsc.ctx.getContextAsInt("AD_Client_ID");
        MAcctSchema[] ASchemas = MAcctSchema.getClientAcctSchema(wsc.ctx, AD_Client_ID);
        for (int i2 = 0; i2 < ASchemas.length; ++i2) {
            KeyNamePair onePair = new KeyNamePair(ASchemas[i2].getC_AcctSchema_ID(), ASchemas[i2].getName());
            acctSchemaList.add(onePair);
        }
        return acctSchemaList;
    }

    private List<ValueNamePair> getTableList(HttpServletRequest request) {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        int AD_Table_ID = 0;
        ArrayList<ValueNamePair> tableList = new ArrayList<ValueNamePair>();
        String defaultKey = null;
        String sql = "SELECT AD_Table_ID, TableName FROM AD_Table t WHERE EXISTS (SELECT * FROM AD_Column c WHERE t.AD_Table_ID=c.AD_Table_ID AND c.ColumnName='Posted') AND IsView='N'";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                int id = rs.getInt(1);
                String tableName = rs.getString(2);
                String name = Msg.translate(wsc.ctx, tableName + "_ID");
                ValueNamePair pp = new ValueNamePair(tableName, name);
                tableList.add(pp);
                if (id != AD_Table_ID) continue;
                defaultKey = pp.getValue();
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        return tableList;
    }

    private List<ValueNamePair> getTableIdNameList(HttpServletRequest request) {
        ArrayList<ValueNamePair> tableList = new ArrayList<ValueNamePair>();
        String sql = "SELECT AD_Table_ID, TableName FROM AD_Table t WHERE EXISTS (SELECT * FROM AD_Column c WHERE t.AD_Table_ID=c.AD_Table_ID AND c.ColumnName='Posted') AND IsView='N'";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                int id = rs.getInt(1);
                String tableName = rs.getString(2);
                ValueNamePair pp = new ValueNamePair(String.valueOf(id), tableName);
                tableList.add(pp);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        return tableList;
    }

    private List<ValueNamePair> getPostingTypeList(HttpServletRequest request) {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        int AD_Role_ID = wsc.ctx.getAD_Role_ID();
        int AD_Reference_ID = 125;
        ArrayList<ValueNamePair> postingTypeList = new ArrayList<ValueNamePair>(Arrays.asList(MRefList.getList(AD_Reference_ID, true)));
        return postingTypeList;
    }

    private List<KeyNamePair> getOrgList(HttpServletRequest request) {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        int AD_Client_ID = wsc.ctx.getContextAsInt("AD_Client_ID");
        ArrayList<KeyNamePair> orgList = new ArrayList<KeyNamePair>();
        KeyNamePair pp = new KeyNamePair(0, "");
        orgList.add(pp);
        String sql = "SELECT AD_Org_ID, Name FROM AD_Org WHERE AD_Client_ID=? ORDER BY Value";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, AD_Client_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                orgList.add(new KeyNamePair(rs.getInt(1), rs.getString(2)));
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        return orgList;
    }

    private List<ValueNamePair> getSortByItemList(HttpServletRequest request) {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        int AD_Client_ID = wsc.ctx.getContextAsInt("AD_Client_ID");
        ArrayList<ValueNamePair> sortByItemList = new ArrayList<ValueNamePair>();
        sortByItemList.add(new ValueNamePair("", ""));
        sortByItemList.add(new ValueNamePair("DateAcct", Msg.translate(wsc.ctx, "DateAcct")));
        sortByItemList.add(new ValueNamePair("DateTrx", Msg.translate(wsc.ctx, "DateTrx")));
        sortByItemList.add(new ValueNamePair("C_Period_ID", Msg.translate(wsc.ctx, "C_Period_ID")));
        MAcctSchema[] ASchemas = MAcctSchema.getClientAcctSchema(wsc.ctx, AD_Client_ID);
        MAcctSchemaElement[] elements = ASchemas[0].getAcctSchemaElements();
        int selectionIndex = 0;
        for (int i2 = 0; i2 < elements.length && selectionIndex < 8; ++i2) {
            MAcctSchemaElement ase = elements[i2];
            String columnName = ase.getColumnName();
            String displayColumnName = ase.getDisplayColumnName();
            sortByItemList.add(new ValueNamePair(columnName, Msg.translate(wsc.ctx, displayColumnName)));
        }
        return sortByItemList;
    }

    private void addButtons(HttpServletRequest request, AcctViewerForm acctViewerForm) {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        int AD_Client_ID = wsc.ctx.getContextAsInt("AD_Client_ID");
        int selectionIndex = 1;
        MAcctSchema[] ASchemas = MAcctSchema.getClientAcctSchema(wsc.ctx, AD_Client_ID);
        int acctSchemaId = StringToIntConverter.StringToInt(request.getParameter("acctSchema"));
        MAcctSchemaElement[] elements = ASchemas[0].getAcctSchemaElements();
        for (int i2 = 0; i2 < elements.length && selectionIndex <= this.SEL_COUNT; ++i2) {
            MAcctSchemaElement ase = elements[i2];
            String columnName = ase.getColumnName();
            String displayColumnName = ase.getDisplayColumnName();
            if (ase.isElementType("OO") || ase.isElementType("AC")) continue;
            String label2 = Msg.translate(wsc.ctx, displayColumnName);
            switch (selectionIndex) {
                case 1: {
                    acctViewerForm.setSel1L(label2);
                    acctViewerForm.setSel1(columnName);
                    acctViewerForm.setSel1Id(String.valueOf(AmpiereUtil.getFixedColumnID(columnName)));
                    break;
                }
                case 2: {
                    acctViewerForm.setSel2L(label2);
                    acctViewerForm.setSel2(columnName);
                    acctViewerForm.setSel2Id(String.valueOf(AmpiereUtil.getFixedColumnID(columnName)));
                    break;
                }
                case 3: {
                    acctViewerForm.setSel3L(label2);
                    acctViewerForm.setSel3(columnName);
                    acctViewerForm.setSel3Id(String.valueOf(AmpiereUtil.getFixedColumnID(columnName)));
                    break;
                }
                case 4: {
                    acctViewerForm.setSel4L(label2);
                    acctViewerForm.setSel4(columnName);
                    acctViewerForm.setSel4Id(String.valueOf(AmpiereUtil.getFixedColumnID(columnName)));
                    break;
                }
                case 5: {
                    acctViewerForm.setSel5L(label2);
                    acctViewerForm.setSel5(columnName);
                    acctViewerForm.setSel5Id(String.valueOf(AmpiereUtil.getFixedColumnID(columnName)));
                    break;
                }
                case 6: {
                    acctViewerForm.setSel6L(label2);
                    acctViewerForm.setSel6(columnName);
                    acctViewerForm.setSel6Id(String.valueOf(AmpiereUtil.getFixedColumnID(columnName)));
                    break;
                }
                case 7: {
                    acctViewerForm.setSel7L(label2);
                    acctViewerForm.setSel7(columnName);
                    acctViewerForm.setSel7Id(String.valueOf(AmpiereUtil.getFixedColumnID(columnName)));
                    break;
                }
                case 8: {
                    acctViewerForm.setSel8L(label2);
                    acctViewerForm.setSel8(columnName);
                    acctViewerForm.setSel8Id(String.valueOf(AmpiereUtil.getFixedColumnID(columnName)));
                }
            }
            ++selectionIndex;
        }
    }

    private Document actionQuery(HttpServletRequest request) {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        int AD_Table_ID = this.getAdTableId(request);
        int Record_ID = 0;
        if (!StringUtils.isEmpty(request.getParameter(this.SELECTED_TABLE_KEY))) {
            Record_ID = StringToIntConverter.StringToInt(request.getParameter(this.SELECTED_TABLE_KEY));
        }
        Timestamp from = null;
        Timestamp to = null;
        Document document = this.CreateNewDocument(request);
        StringBuffer para = new StringBuffer();
        int C_AcctSchema_ID = 0;
        int AD_Org_ID = 0;
        C_AcctSchema_ID = StringToIntConverter.StringToInt(request.getParameter("acctSchema"));
        para.append("C_AcctSchema_ID=").append(C_AcctSchema_ID);
        String PostingType = request.getParameter("postingType");
        para.append(", PostingType=").append(PostingType);
        boolean documentQuery = false;
        if ("on".equals(request.getParameter("documentSelected"))) {
            documentQuery = true;
        }
        para.append(", DocumentQuery=").append(documentQuery);
        if (documentQuery) {
            if (AD_Table_ID == 0 || Record_ID == 0) {
                return null;
            }
            para.append(", AD_Table_ID=").append(AD_Table_ID).append(", Record_ID=").append(Record_ID);
        } else {
            String DateTo;
            String DateFrom = request.getParameter("dateFrom");
            if (!StringUtils.isEmpty(DateFrom)) {
                try {
                    try {
                        from = new Timestamp(wsc.dateFormat.parse(DateFrom).getTime());
                    }
                    catch (Exception e) {
                        from = null;
                    }
                    para.append(", DateFrom=").append(from);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (!StringUtils.isEmpty(DateTo = request.getParameter("dateTo"))) {
                try {
                    try {
                        to = new Timestamp(wsc.dateFormat.parse(DateTo).getTime());
                    }
                    catch (Exception e) {
                        to = null;
                    }
                    para.append(", DateTo=").append(to);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            AD_Org_ID = StringToIntConverter.StringToInt(request.getParameter("adOrgID"));
            para.append(", AD_Org_ID=").append(AD_Org_ID);
            for (int i2 = 1; i2 <= this.SEL_COUNT; ++i2) {
                String columnName = "selColumn" + i2;
                String keyColumn = request.getParameter(columnName);
                String queryValue = "sel" + i2 + "D";
                if (StringUtils.isEmpty(request.getParameter(queryValue))) continue;
                String value = request.getParameter(queryValue);
                para.append(", ").append(keyColumn + "=" + value);
            }
        }
        boolean displayQty = AWebUtil.onoffStringToBoolean(request.getParameter("displayQty"));
        para.append(" - Display Qty=").append(displayQty);
        boolean displaySourceAmt = AWebUtil.onoffStringToBoolean(request.getParameter("displaySourceInfo"));
        para.append(", Source=").append(displaySourceAmt);
        boolean displayDocumentInfo = AWebUtil.onoffStringToBoolean(request.getParameter("displayDocumentInfo"));
        para.append(", Doc=").append(displayDocumentInfo);
        String sortBy1 = request.getParameter("sortBy1");
        boolean group1 = AWebUtil.onoffStringToBoolean(request.getParameter("group1"));
        para.append(" - Sorting: ").append(sortBy1).append("/").append(group1);
        String sortBy2 = request.getParameter("sortBy2");
        boolean group2 = AWebUtil.onoffStringToBoolean(request.getParameter("group2"));
        para.append(", ").append(sortBy2).append("/").append(group2);
        String sortBy3 = request.getParameter("sortBy3");
        boolean group3 = AWebUtil.onoffStringToBoolean(request.getParameter("group3"));
        para.append(", ").append(sortBy3).append("/").append(group3);
        String sortBy4 = request.getParameter("sortBy4");
        boolean group4 = AWebUtil.onoffStringToBoolean(request.getParameter("group4"));
        para.append(", ").append(sortBy4).append("/").append(group4);
        this.log.config(para.toString());
        StringBuffer whereClause = new StringBuffer();
        if (C_AcctSchema_ID != 0) {
            whereClause.append("zz").append(".C_AcctSchema_ID=").append(C_AcctSchema_ID);
        }
        if (PostingType != null && PostingType.length() > 0) {
            if (whereClause.length() > 0) {
                whereClause.append(" AND ");
            }
            whereClause.append("zz").append(".PostingType='").append(PostingType).append("'");
        }
        if (documentQuery) {
            if (whereClause.length() > 0) {
                whereClause.append(" AND ");
            }
            whereClause.append("zz").append(".AD_Table_ID=").append(AD_Table_ID).append(" AND ").append("zz").append(".Record_ID=").append(Record_ID);
        } else {
            for (int i3 = 1; i3 <= this.SEL_COUNT; ++i3) {
                String columnName = "selColumn" + i3;
                String keyColumn = request.getParameter(columnName);
                String queryValue = "sel" + i3 + "D";
                if (StringUtils.isEmpty(request.getParameter(queryValue))) continue;
                String value = request.getParameter(queryValue);
                String where = keyColumn + "=" + value;
                whereClause.append(" AND ");
                whereClause.append("zz").append(".").append(where);
            }
            if (from != null || to != null) {
                if (whereClause.length() > 0) {
                    whereClause.append(" AND ");
                }
                if (from != null && to != null) {
                    whereClause.append("TRUNC(").append("zz").append(".DateAcct,'DD') BETWEEN ").append(DB.TO_DATE(from)).append(" AND ").append(DB.TO_DATE(to));
                } else if (from != null) {
                    whereClause.append("TRUNC(").append("zz").append(".DateAcct,'DD') >= ").append(DB.TO_DATE(from));
                } else {
                    whereClause.append("TRUNC(").append("zz").append(".DateAcct,'DD') <= ").append(DB.TO_DATE(to));
                }
            }
            if (AD_Org_ID != 0) {
                if (whereClause.length() > 0) {
                    whereClause.append(" AND ");
                }
                whereClause.append("zz").append(".AD_Org_ID=").append(AD_Org_ID);
            }
        }
        StringBuffer orderClause = new StringBuffer();
        if (sortBy1.length() > 0) {
            orderClause.append("zz").append(".").append(sortBy1);
        }
        if (sortBy2.length() > 0) {
            if (orderClause.length() > 0) {
                orderClause.append(",");
            }
            orderClause.append("zz").append(".").append(sortBy2);
        }
        if (sortBy3.length() > 0) {
            if (orderClause.length() > 0) {
                orderClause.append(",");
            }
            orderClause.append("zz").append(".").append(sortBy3);
        }
        if (sortBy4.length() > 0) {
            if (orderClause.length() > 0) {
                orderClause.append(",");
            }
            orderClause.append("zz").append(".").append(sortBy4);
        }
        if (orderClause.length() == 0) {
            orderClause.append("zz").append(".Fact_Acct_ID");
        }
        RModel rm = this.getRModel(request, wsc.ctx);
        if (group1 && sortBy1.length() > 0) {
            rm.setGroup(sortBy1);
        }
        if (group2 && sortBy2.length() > 0) {
            rm.setGroup(sortBy2);
        }
        if (group3 && sortBy3.length() > 0) {
            rm.setGroup(sortBy3);
        }
        if (group4 && sortBy4.length() > 0) {
            rm.setGroup(sortBy4);
        }
        rm.setFunction("AmtAcctDr", "Sum");
        rm.setFunction("AmtAcctCr", "Sum");
        rm.query(wsc.ctx, whereClause.toString(), orderClause.toString());
        table resultTable = new table("1", "0", "5", "auto", null);
        if (rm.getColumnCount() >= 19) {
            resultTable = new table("1", "0", "5", "2000px", null);
        }
        tr headerTr = new tr();
        resultTable.addElement((org.apache.ecs.Element)headerTr);
        for (int j = 0; j < rm.getColumnCount(); ++j) {
            td oneColumn = new td();
            oneColumn.addElement(rm.getColumnName(j));
            headerTr.addElement((org.apache.ecs.Element)oneColumn);
        }
        for (int i4 = 0; i4 < rm.getRowCount(); ++i4) {
            tr oneTr = new tr();
            resultTable.addElement((org.apache.ecs.Element)oneTr);
            for (int j = 0; j < rm.getColumnCount(); ++j) {
                td oneColumn = new td();
                String content = "";
                if (rm.getValueAt(i4, j) != null) {
                    int idx;
                    content = rm.getValueAt(i4, j).toString();
                    if (rm.getColumnClass(j).equals(Timestamp.class)) {
                        content = wsc.dateFormat.format(rm.getValueAt(i4, j));
                    }
                    if (BigDecimal.class.equals(rm.getColumnClass(j)) && (idx = content.indexOf(".")) + 3 < content.length()) {
                        content = content.substring(0, idx + 2);
                    }
                    if (content != null && content.length() > 50) {
                        content = content.substring(0, 50);
                    }
                }
                oneColumn.addElement(content);
                oneTr.addElement((org.apache.ecs.Element)oneColumn);
            }
        }
        String resultHtml = resultTable.toString();
        ArrayList<String> resultList = new ArrayList<String>();
        int unit = 2000;
        int beginIndex = 0;
        int endIndex = 0;
        String tempStr = "";
        while (resultHtml.length() > 0) {
            if (resultHtml.length() < unit) {
                resultList.add(resultHtml);
                break;
            }
            endIndex = resultHtml.indexOf("<tr>") + "<tr>".length();
            String str1 = resultHtml.substring(beginIndex, endIndex);
            String str2 = resultHtml.substring(endIndex, resultHtml.length());
            if ((tempStr = tempStr + str1).length() > unit) {
                resultList.add(tempStr);
                tempStr = "";
            }
            resultHtml = str2;
        }
        try {
            for (int i5 = 0; i5 < resultList.size(); ++i5) {
                Element element = document.createElement("element");
                document.getFirstChild().appendChild(element);
                Element elm_id = document.createElement("id");
                String objId = this.RESULT_DIV_ID;
                elm_id.appendChild(document.createTextNode(objId));
                element.appendChild(elm_id);
                Element elm_lookup = document.createElement("lookup");
                element.appendChild(elm_lookup);
                elm_lookup.appendChild(document.createTextNode("0"));
                Element elm_visibility = document.createElement("visibility");
                element.appendChild(elm_visibility);
                elm_visibility.appendChild(document.createTextNode("1"));
                Element elm_newValue = document.createElement("newValue");
                element.appendChild(elm_newValue);
                elm_newValue.appendChild(document.createTextNode((String)resultList.get(i5)));
                Element elm_readonly = document.createElement("readonly");
                element.appendChild(elm_readonly);
                elm_readonly.appendChild(document.createTextNode("0"));
                Element elm_type = document.createElement("type");
                element.appendChild(elm_type);
                elm_type.appendChild(document.createTextNode("html"));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return document;
    }

    public RModel getRModel(HttpServletRequest request, Ctx ctx) {
        boolean displayQty = AWebUtil.onoffStringToBoolean(request.getParameter("displayQty"));
        boolean displayDocumentInfo = AWebUtil.onoffStringToBoolean(request.getParameter("displayDocumentInfo"));
        String PostingType = request.getParameter("postingType");
        RModel rm = new RModel("Fact_Acct");
        ArrayList<String> keys = this.createKeyColumns(request);
        int max = this.m_leadingColumns;
        if (max == 0) {
            max = keys.size();
        }
        for (int i2 = 0; i2 < max; ++i2) {
            String column = keys.get(i2);
            if (column != null && column.startsWith("Date")) {
                rm.addColumn(new RColumn(ctx, column, 15));
                continue;
            }
            if (column == null || !column.endsWith("_ID")) continue;
            rm.addColumn(new RColumn(ctx, column, 19));
        }
        rm.addColumn(new RColumn(ctx, "AmtAcctDr", 12));
        rm.addColumn(new RColumn(ctx, "AmtAcctCr", 12));
        boolean displaySourceAmt = AWebUtil.onoffStringToBoolean(request.getParameter("displaySourceInfo"));
        if (displaySourceAmt) {
            if (!keys.contains("DateTrx")) {
                rm.addColumn(new RColumn(ctx, "DateTrx", 15));
            }
            rm.addColumn(new RColumn(ctx, "C_Currency_ID", 19));
            rm.addColumn(new RColumn(ctx, "AmtSourceDr", 12));
            rm.addColumn(new RColumn(ctx, "AmtSourceCr", 12));
            rm.addColumn(new RColumn(ctx, "Rate", 12, "CASE WHEN (AmtSourceDr + AmtSourceCr) = 0 THEN 0 ELSE (AmtAcctDr + AmtAcctCr) / (AmtSourceDr + AmtSourceCr) END"));
        }
        for (int i3 = max; i3 < keys.size(); ++i3) {
            String column = keys.get(i3);
            if (column != null && column.startsWith("Date")) {
                rm.addColumn(new RColumn(ctx, column, 15));
                continue;
            }
            if (column.startsWith("UserElement")) {
                if (column.indexOf("1") != -1) {
                    rm.addColumn(new RColumn(ctx, column, 19, null, 0, this.m_ref1));
                    continue;
                }
                rm.addColumn(new RColumn(ctx, column, 19, null, 0, this.m_ref2));
                continue;
            }
            if (column == null || !column.endsWith("_ID")) continue;
            rm.addColumn(new RColumn(ctx, column, 19));
        }
        if (!keys.contains("DateAcct")) {
            rm.addColumn(new RColumn(ctx, "DateAcct", 15));
        }
        if (!keys.contains("C_Period_ID")) {
            rm.addColumn(new RColumn(ctx, "C_Period_ID", 19));
        }
        if (displayQty) {
            rm.addColumn(new RColumn(ctx, "C_UOM_ID", 19));
            rm.addColumn(new RColumn(ctx, "Qty", 29));
        }
        if (displayDocumentInfo) {
            rm.addColumn(new RColumn(ctx, "AD_Table_ID", 19));
            rm.addColumn(new RColumn(ctx, "Record_ID", 13));
            rm.addColumn(new RColumn(ctx, "Description", 10));
        }
        if (PostingType == null || PostingType.length() == 0) {
            rm.addColumn(new RColumn(ctx, "PostingType", 17, 125));
        }
        return rm;
    }

    private ArrayList<String> createKeyColumns(HttpServletRequest request) {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        int AD_Client_ID = wsc.ctx.getContextAsInt("AD_Client_ID");
        ArrayList<String> columns = new ArrayList<String>();
        String sortBy1 = request.getParameter("sortBy1");
        String sortBy2 = request.getParameter("sortBy2");
        String sortBy3 = request.getParameter("sortBy3");
        String sortBy4 = request.getParameter("sortBy4");
        columns.add(sortBy1);
        if (!columns.contains(sortBy2)) {
            columns.add(sortBy2);
        }
        if (!columns.contains(sortBy3)) {
            columns.add(sortBy3);
        }
        if (!columns.contains(sortBy4)) {
            columns.add(sortBy4);
        }
        MAcctSchema[] ASchemas = MAcctSchema.getClientAcctSchema(wsc.ctx, AD_Client_ID);
        MAcctSchemaElement[] elements = ASchemas[0].getAcctSchemaElements();
        for (int i2 = 0; i2 < elements.length; ++i2) {
            MAcctSchemaElement ase;
            String columnName;
            if (this.m_leadingColumns == 0 && columns.contains("AD_Org_ID") && columns.contains("Account_ID")) {
                this.m_leadingColumns = columns.size();
            }
            if ((columnName = (ase = elements[i2]).getColumnName()).startsWith("UserElement")) {
                if (columnName.indexOf("1") != -1) {
                    this.m_ref1 = ase.getDisplayColumnName();
                } else {
                    this.m_ref2 = ase.getDisplayColumnName();
                }
            }
            if (columns.contains(columnName)) continue;
            columns.add(columnName);
        }
        if (this.m_leadingColumns == 0 && columns.contains("AD_Org_ID") && columns.contains("Account_ID")) {
            this.m_leadingColumns = columns.size();
        }
        return columns;
    }

    int getAdTableId(HttpServletRequest request) {
        int AD_Table_ID = 0;
        String column = request.getParameter("recordId");
        if (!StringUtils.isEmpty(column)) {
            List<ValueNamePair> tableList = this.getTableIdNameList(request);
            for (int i2 = 0; i2 < tableList.size(); ++i2) {
                ValueNamePair valueNamePair = tableList.get(i2);
                if (!column.equals(valueNamePair.getName())) continue;
                AD_Table_ID = StringToIntConverter.StringToInt(valueNamePair.getValue());
                break;
            }
        }
        return AD_Table_ID;
    }

    private Document actionRePost(HttpServletRequest request) {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        int WindowNo = 0;
        int AD_Client_ID = wsc.ctx.getContextAsInt("AD_Client_ID");
        int AD_Table_ID = this.getAdTableId(request);
        int Record_ID = 0;
        if (!StringUtils.isEmpty(request.getParameter(this.SELECTED_TABLE_KEY))) {
            Record_ID = StringToIntConverter.StringToInt(request.getParameter(this.SELECTED_TABLE_KEY));
        }
        boolean documentQuery = false;
        if ("on".equals(request.getParameter("documentSelected"))) {
            documentQuery = true;
        }
        boolean force = false;
        if ("on".equals(request.getParameter("force"))) {
            force = true;
        }
        Document document = this.CreateNewDocument(request);
        if (documentQuery && AD_Table_ID != 0 && Record_ID != 0) {
            String error = AcctViewer.postImmediate(wsc.ctx, WindowNo, AD_Client_ID, AD_Table_ID, Record_ID, force);
            document = this.actionQuery(request);
            if (error != null) {
                String script2 = AWebUtil.info(request, "PostingError-N", error);
                document = AmpiereUtil.addScriptToDocument(document, AmpiereUtil.getAlertScript(script2));
            }
        }
        return document;
    }

    public static String postImmediate(Ctx ctx, int WindowNo, int AD_Client_ID, int AD_Table_ID, int Record_ID, boolean force) {
        Server s_server = null;
        String error = null;
        if (Post.isServerActive()) {
            try {
                s_server = CConnection.get().getServer();
                if (s_server == null) {
                    return "NoAppsServer";
                }
                error = s_server.postImmediate(ctx, AD_Client_ID, AD_Table_ID, Record_ID, force, null);
            }
            catch (RemoteException e) {
                error = e.getMessage();
                s_server = null;
            }
            catch (Exception e) {
                error = e.getMessage();
                s_server = null;
            }
        } else {
            return "NoAppsServer";
        }
        return error;
    }

    private Document CreateNewDocument(HttpServletRequest request) {
        HttpSession session = request.getSession();
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        Document document = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.newDocument();
            Element elements = document.createElement("elements");
            document.appendChild(elements);
        }
        catch (Exception e) {
            // empty catch block
        }
        return document;
    }
}

