/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.web.struts.form;

import com.ampiere.web.servlet.WWindowStatus;
import com.ampiere.web.struts.form.TrxMaterialForm;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.compiere.model.MForm;
import org.compiere.model.MLocatorLookup;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.NamePair;
import org.compiere.util.WebSessionCtx;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrxMaterial
extends Action {
    private CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());
    private static final String IMP_FORMAT_LIST = "IMP_FORMAT_LIST";
    private static final String SUCCESS = "success";
    private static final String ACTION_FORM = "GenerateShipmentFromOrderForm";
    private static final String ERROR_FORWARD = "error";
    private static final int ORDERLINE_WAREHOUSE_COLUMN_ID = 2223;
    private static final int FORM_ID = 110;

    public final ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        WebSessionCtx wscTest = WebSessionCtx.get(request);
        if (wscTest == null) {
            this.log.log(Level.SEVERE, "Session Time Out.");
            request.setAttribute("sessionTimeoutInfo", (Object)"Session Time Out. Please login again.");
            return mapping.findForward("sessionTimeout");
        }
        String doQurey = "0";
        HttpSession session = request.getSession();
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        if (wsc == null) {
            this.log.log(Level.SEVERE, "Session Time Out.");
            return mapping.findForward(ERROR_FORWARD);
        }
        MForm form2 = this.getForm(wsc.ctx, 110);
        wsc.ctx.setContext("FormName", form2.getName());
        TrxMaterialForm trxMaterialForm = (TrxMaterialForm)request.getAttribute(ACTION_FORM);
        if (trxMaterialForm == null && (trxMaterialForm = (TrxMaterialForm)actionForm) == null) {
            trxMaterialForm = new TrxMaterialForm();
        }
        trxMaterialForm.statInit(wsc.ctx);
        session.setAttribute("searchResultPayment", null);
        ArrayList<NamePair> orgList = this.getOrgList(request);
        session.setAttribute("orgList", orgList);
        ArrayList<NamePair> mtypeList = this.getMtypeList(request);
        session.setAttribute("mtypeList", mtypeList);
        ArrayList<NamePair> locatorList = this.getLocatorList(request);
        session.setAttribute("locatorList", locatorList);
        trxMaterialForm.setTitle(Msg.getMsg(wsc.ctx, "TrxMaterial"));
        session.setAttribute("trxMaterialForm", (Object)trxMaterialForm);
        return mapping.findForward(SUCCESS);
    }

    private ArrayList getImpFormatList() {
        ArrayList<NameValuePair> dataList = new ArrayList<NameValuePair>();
        String sql = "SELECT Name from AD_ImpFormat";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                NameValuePair tmp = new NameValuePair(rs.getString(1), rs.getString(1));
                dataList.add(tmp);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        return dataList;
    }

    private MForm getForm(Ctx ctx, int formId) {
        boolean trl;
        MForm form2 = new MForm(ctx, formId, null);
        boolean bl = trl = !Env.isBaseLanguage(ctx, "AD_Form");
        if (trl) {
            String sql = "SELECT t.Name, t.Description, t.Help FROM AD_Form f INNER JOIN AD_Form_Trl t ON (f.AD_Form_ID=t.AD_Form_ID AND AD_Language=?)WHERE f.AD_Form_ID=?";
            try {
                CPreparedStatement pstmt = DB.prepareStatement(sql, null);
                if (trl) {
                    pstmt.setString(1, Env.getAD_Language(ctx));
                    pstmt.setInt(2, formId);
                    ResultSet rs = pstmt.executeQuery();
                    if (rs.next()) {
                        form2.setName(rs.getString(1));
                        form2.setDescription(rs.getString(2));
                        form2.setHelp(rs.getString(3));
                    }
                    rs.close();
                    pstmt.close();
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, e);
            }
        }
        return form2;
    }

    private ArrayList<NamePair> getOrgList(HttpServletRequest request) {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        MLookup orgLookup = MLookupFactory.get(wsc.ctx, 0, 3660, 19);
        ArrayList<NamePair> orgList = orgLookup.getData(true, false, false, false);
        return orgList;
    }

    private ArrayList<NamePair> getLocatorList(HttpServletRequest request) {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        MLocatorLookup locatorLookup = new MLocatorLookup(wsc.ctx, 0);
        ArrayList<NamePair> locatorList = locatorLookup.getData(true, false, false, false);
        return locatorList;
    }

    private ArrayList<NamePair> getMtypeList(HttpServletRequest request) {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        MLookup mtypeLookup = MLookupFactory.get(wsc.ctx, 0, 3666, 17);
        ArrayList<NamePair> mtypeList = mtypeLookup.getData(true, false, false, false);
        return mtypeList;
    }
}

