/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.web.struts.form;

import com.ampiere.web.struts.form.MatchingForm;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.compiere.framework.Lookup;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MMatchInv;
import org.compiere.model.MMatchPO;
import org.compiere.model.MOrderLine;
import org.compiere.model.MRole;
import org.compiere.model.MStorage;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.NamePair;
import org.compiere.util.WebSessionCtx;

public class MatchingAction
extends Action {
    private CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());
    private static final String MATCHING_LIST = "matchinglist";
    private static final String ACTION_FORM = "MatchingForm";
    private static final String ERROR_FORWARD = "error";
    private static final int MATCH_INVOICE = 0;
    private static final int MATCH_SHIPMENT = 1;
    private static final int MATCH_ORDER = 2;
    private StringBuffer m_sql = null;
    private String m_dateColumn = "";
    private String m_qtyColumn = "";
    private String m_groupBy = "";

    public final ActionForward execute(ActionMapping mapping, ActionForm form2, HttpServletRequest request, HttpServletResponse response) throws Exception {
        WebSessionCtx wscTest = WebSessionCtx.get(request);
        if (wscTest == null) {
            this.log.log(Level.SEVERE, "Session Time Out.");
            request.setAttribute("sessionTimeoutInfo", (Object)"Session Time Out. Please login again.");
            return mapping.findForward("sessionTimeout");
        }
        this.log.fine("Begin " + ((Object)((Object)this)).getClass().getName() + ";execute");
        WebSessionCtx wsc = WebSessionCtx.get(request);
        if (wsc == null) {
            this.log.log(Level.SEVERE, "Session Time Out.");
            return mapping.findForward(ERROR_FORWARD);
        }
        ActionForward actionForward = mapping.findForward(MATCHING_LIST);
        MatchingForm myForm = (MatchingForm)request.getAttribute(ACTION_FORM);
        String column = myForm.getChangedColumn();
        if (column.equals("matchFrom")) {
            actionForward = mapping.findForward(MATCHING_LIST);
        } else if (column.equals("matchTo")) {
            actionForward = mapping.findForward(MATCHING_LIST);
        } else if (column.equals("matchMode")) {
            actionForward = mapping.findForward(MATCHING_LIST);
        } else if (column.equals("businessPartnerName")) {
            MLookup lookup = null;
            try {
                lookup = MLookupFactory.get(wsc.ctx, 0, 3499, 19, wsc.language, "C_BPartner_ID", 0, false, "UPPER(NAME) LIKE '" + myForm.getBusinessPartnerName().toUpperCase() + "%' ");
                Iterator<NamePair> keyNames = ((Lookup)lookup).getData(true, false, true, false).iterator();
                if (keyNames.hasNext()) {
                    KeyNamePair keyName = (KeyNamePair)keyNames.next();
                    myForm.setBusinessPartnerId(keyName.getKey());
                    myForm.setBusinessPartnerName(keyName.getName());
                } else {
                    myForm.setBusinessPartnerId(999999999);
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "MLookupFactory.get AD_Column_ID=3499", e);
            }
            actionForward = mapping.findForward(MATCHING_LIST);
        } else if (column.equals("productName")) {
            MLookup lookup = null;
            try {
                lookup = MLookupFactory.get(wsc.ctx, 0, 3840, 19, wsc.language, "M_Product_ID", 0, false, "UPPER(M_Product_Trl.NAME) LIKE '" + myForm.getProductName().toUpperCase() + "%' ");
                Iterator<NamePair> keyNames = ((Lookup)lookup).getData(true, false, true, false).iterator();
                if (keyNames.hasNext()) {
                    KeyNamePair keyName = (KeyNamePair)keyNames.next();
                    myForm.setProductId(keyName.getKey());
                    myForm.setProductName(keyName.getName());
                } else {
                    myForm.setProductId(999999999);
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "MLookupFactory.get AD_Column_ID=3840", e);
            }
            actionForward = mapping.findForward(MATCHING_LIST);
        } else if (column.equals("search")) {
            myForm.setMatchFromCurrentId(0);
            myForm.setMatchToIdList(null);
            myForm.setMatchFromCurrentBusinessPartnerId(-1);
            myForm.setMatchFromCurrentProductId(-1);
            this.search(wsc, myForm);
            if (myForm.getMatchFromDataList().size() > 0) {
                this.searchTo(wsc, myForm);
            }
            actionForward = mapping.findForward(MATCHING_LIST);
        } else if (column.equals("matchFromRowChanged")) {
            myForm.setMatchToIdList(null);
            this.search(wsc, myForm);
            if (myForm.getMatchFromDataList().size() > 0) {
                this.searchTo(wsc, myForm);
            }
            actionForward = mapping.findForward(MATCHING_LIST);
        } else if (column.equals("sameBusinessPartner")) {
            myForm.setMatchToIdList(null);
            this.search(wsc, myForm);
            if (myForm.getMatchFromDataList().size() > 0) {
                this.searchTo(wsc, myForm);
            }
            actionForward = mapping.findForward(MATCHING_LIST);
        } else if (column.equals("sameProduct")) {
            myForm.setMatchToIdList(null);
            this.search(wsc, myForm);
            if (myForm.getMatchFromDataList().size() > 0) {
                this.searchTo(wsc, myForm);
            }
            actionForward = mapping.findForward(MATCHING_LIST);
        } else if (column.equals("sameQuantity")) {
            myForm.setMatchToIdList(null);
            this.search(wsc, myForm);
            if (myForm.getMatchFromDataList().size() > 0) {
                this.searchTo(wsc, myForm);
            }
            actionForward = mapping.findForward(MATCHING_LIST);
        } else if (column.equals("matchToIdList")) {
            this.search(wsc, myForm);
            if (myForm.getMatchFromDataList().size() > 0) {
                this.searchTo(wsc, myForm);
            }
            actionForward = mapping.findForward(MATCHING_LIST);
        } else if (column.equals("process")) {
            this.process(wsc, myForm);
            this.search(wsc, myForm);
            if (myForm.getMatchFromDataList().size() > 0) {
                this.searchTo(wsc, myForm);
            }
            actionForward = mapping.findForward(MATCHING_LIST);
        }
        myForm.setChangedColumn(null);
        request.setAttribute(ACTION_FORM, (Object)myForm);
        this.log.fine("End " + ((Object)((Object)this)).getClass().getName() + ";execute");
        return actionForward;
    }

    private void search(WebSessionCtx wsc, MatchingForm form2) {
        this.makeSQL(form2.getMatchFrom(), form2.getMatchTo(), form2.getMatchMode() == 1);
        if (form2.getProductId() > 0) {
            this.m_sql.append(" AND lin.M_Product_ID=").append(form2.getProductId());
        }
        if (form2.getBusinessPartnerId() > 0) {
            this.m_sql.append(" AND hdr.C_BPartner_ID=").append(form2.getBusinessPartnerId());
        }
        Timestamp from = null;
        if (form2.getDateFrom() != null && !form2.getDateFrom().equals("")) {
            from = new Timestamp(wsc.dateFormat.parse(form2.getDateFrom(), new ParsePosition(0)).getTime());
        }
        Timestamp to = null;
        if (form2.getDateTo() != null && !form2.getDateTo().equals("")) {
            to = new Timestamp(wsc.dateFormat.parse(form2.getDateTo(), new ParsePosition(0)).getTime());
        }
        if (from != null && to != null) {
            this.m_sql.append(" AND ").append(this.m_dateColumn).append(" BETWEEN ").append(DB.TO_DATE(from)).append(" AND ").append(DB.TO_DATE(to));
        } else if (from != null) {
            this.m_sql.append(" AND ").append(this.m_dateColumn).append(" >= ").append(DB.TO_DATE(from));
        } else if (to != null) {
            this.m_sql.append(" AND ").append(this.m_dateColumn).append(" <= ").append(DB.TO_DATE(to));
        }
        ArrayList dataList = new ArrayList();
        HashMap<String, Object> data = new HashMap<String, Object>();
        String sql = MRole.getDefault(wsc.ctx, false).addAccessSQL(this.m_sql.toString(), "hdr", true, false) + this.m_groupBy;
        try {
            Statement stmt = DB.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            int count = 0;
            while (rs.next()) {
                if (++count == 1 && form2.getMatchFromCurrentId() <= 0) {
                    form2.setMatchFromCurrentId(rs.getInt(1));
                    form2.setMatchFromCurrentLine(rs.getInt(7));
                    form2.setMatchFromCurrentBusinessPartnerId(rs.getInt(5));
                    form2.setMatchFromCurrentProductId(rs.getInt(9));
                    form2.setMatchFromCurrentQuantity(rs.getInt(10));
                    form2.setMatchFromCurrentMatchedQuantity(rs.getInt(11));
                }
                data = new HashMap();
                if (count % 2 == 0) {
                    if (form2.getMatchFromCurrentId() == rs.getInt(1) && form2.getMatchFromCurrentLine() == rs.getInt(7)) {
                        data.put("RowType", "current");
                    } else {
                        data.put("RowType", "even");
                    }
                } else if (form2.getMatchFromCurrentId() == rs.getInt(1) && form2.getMatchFromCurrentLine() == rs.getInt(7)) {
                    data.put("RowType", "current");
                } else {
                    data.put("RowType", "odd");
                }
                data.put("ID", rs.getInt(1));
                data.put("DocumentNo", rs.getString(2));
                data.put("Date", wsc.dateFormat.format(rs.getTimestamp(3)));
                data.put("BusinessPartner", rs.getString(4));
                data.put("BusinessPartnerId", rs.getInt(5));
                data.put("Line", rs.getInt(7));
                data.put("Product", rs.getString(8));
                data.put("ProductId", rs.getInt(9));
                data.put("Quantity", wsc.numberFormat.format(rs.getDouble(10)));
                data.put("Matched", wsc.numberFormat.format(rs.getDouble(11)));
                dataList.add(data);
            }
            stmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        form2.setMatchFromDataList(dataList);
    }

    private void searchTo(WebSessionCtx wsc, MatchingForm form2) {
        this.makeSQL(form2.getMatchTo(), form2.getMatchFrom(), form2.getMatchMode() == 1);
        if (form2.getSameBusinessPartner() != null) {
            this.m_sql.append(" AND hdr.C_BPartner_ID=").append(form2.getMatchFromCurrentBusinessPartnerId());
        }
        if (form2.getSameProduct() != null) {
            this.m_sql.append(" AND lin.M_Product_ID=").append(form2.getMatchFromCurrentProductId());
        }
        if (form2.getSameQuantity() != null) {
            this.m_sql.append(" AND ").append(this.m_qtyColumn).append("=").append(form2.getMatchFromCurrentQuantity());
        }
        double docQty = form2.getMatchFromCurrentQuantity();
        double matchedQty = form2.getMatchFromCurrentMatchedQuantity();
        double qty = docQty - matchedQty;
        form2.setToBeMatchedCount(wsc.numberFormat.format(qty));
        ArrayList dataList = new ArrayList();
        HashMap<String, Object> data = new HashMap<String, Object>();
        String sql = MRole.getDefault(wsc.ctx, false).addAccessSQL(this.m_sql.toString(), "hdr", true, false) + this.m_groupBy;
        try {
            Statement stmt = DB.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            int count = 0;
            while (rs.next()) {
                data = new HashMap();
                if (++count % 2 == 0) {
                    data.put("RowType", "even");
                } else {
                    data.put("RowType", "odd");
                }
                data.put("ID", rs.getString(1) + "|" + rs.getString(5) + "|" + rs.getString(9) + "|" + rs.getString(10) + "|" + rs.getString(11) + "|" + rs.getString(7));
                data.put("DocumentNo", rs.getString(2));
                data.put("Date", wsc.dateFormat.format(rs.getTimestamp(3)));
                data.put("BusinessPartner", rs.getString(4));
                data.put("BusinessPartnerId", rs.getInt(5));
                data.put("Line", rs.getInt(7));
                data.put("Product", rs.getString(8));
                data.put("ProductId", rs.getInt(9));
                data.put("Quantity", wsc.numberFormat.format(rs.getInt(10)));
                data.put("Matched", wsc.numberFormat.format(rs.getInt(11)));
                if (form2.getMatchFromCurrentBusinessPartnerId() == rs.getInt(5) && form2.getMatchFromCurrentProductId() == rs.getInt(9)) {
                    data.put("disabled", "false");
                } else {
                    data.put("disabled", "true");
                }
                dataList.add(data);
            }
            stmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        form2.setMatchToDataList(dataList);
        String[] ids = form2.getMatchToIdList();
        double matching = 0.0;
        if (ids != null && ids.length != 0) {
            for (int i2 = 0; i2 < ids.length; ++i2) {
                String[] id = ids[i2].split("\\|");
                if (form2.getMatchMode() == 0) {
                    matching += Double.parseDouble(id[3]);
                }
                matching -= Double.parseDouble(id[4]);
            }
            form2.setProcessButtonDisabled("false");
        } else {
            form2.setProcessButtonDisabled("true");
        }
        form2.setMatchingCount(wsc.numberFormat.format(matching));
        form2.setMatchDifferenceCount(wsc.numberFormat.format(qty - matching));
    }

    private void process(WebSessionCtx wsc, MatchingForm form2) {
        double totalQty = form2.getMatchFromCurrentQuantity();
        String[] ids = form2.getMatchToIdList();
        for (int i2 = 0; i2 < ids.length; ++i2) {
            String[] id = ids[i2].split("\\|");
            double qty = 0.0;
            if (form2.getMatchMode() == 0) {
                qty = Double.parseDouble(id[3]);
            }
            if ((qty -= Double.parseDouble(id[4])) > totalQty) {
                qty = totalQty;
            }
            totalQty -= qty;
            boolean invoice = true;
            if (form2.getMatchFrom() == 2 || form2.getMatchTo() == 2) {
                invoice = false;
            }
            int inOutLineId = 0;
            int lineId = 0;
            if (form2.getMatchFrom() == 1) {
                inOutLineId = form2.getMatchFromCurrentLine();
                lineId = Integer.parseInt(id[5]);
            } else {
                inOutLineId = Integer.parseInt(id[5]);
                lineId = form2.getMatchFromCurrentLine();
            }
            this.createMatchRecord(wsc, invoice, inOutLineId, lineId, new BigDecimal(qty));
        }
    }

    private void makeSQL(int display, int matchToType, boolean matched) {
        this.m_sql = new StringBuffer();
        if (display == 0) {
            this.m_dateColumn = "hdr.DateInvoiced";
            this.m_qtyColumn = "lin.QtyInvoiced";
            this.m_sql.append("SELECT hdr.C_Invoice_ID,hdr.DocumentNo, hdr.DateInvoiced, bp.Name,hdr.C_BPartner_ID, lin.Line,lin.C_InvoiceLine_ID, p.Name,lin.M_Product_ID, lin.QtyInvoiced,SUM(NVL(mi.Qty,0)) FROM C_Invoice hdr INNER JOIN C_BPartner bp ON (hdr.C_BPartner_ID=bp.C_BPartner_ID) INNER JOIN C_InvoiceLine lin ON (hdr.C_Invoice_ID=lin.C_Invoice_ID) INNER JOIN M_Product p ON (lin.M_Product_ID=p.M_Product_ID) INNER JOIN C_DocType dt ON (hdr.C_DocType_ID=dt.C_DocType_ID AND dt.DocBaseType IN ('API','APC')) FULL JOIN M_MatchInv mi ON (lin.C_InvoiceLine_ID=mi.C_InvoiceLine_ID) WHERE hdr.DocStatus IN ('CO','CL')");
            this.m_groupBy = " GROUP BY hdr.C_Invoice_ID,hdr.DocumentNo,hdr.DateInvoiced,bp.Name,hdr.C_BPartner_ID, lin.Line,lin.C_InvoiceLine_ID,p.Name,lin.M_Product_ID,lin.QtyInvoiced HAVING " + (matched ? "0" : "lin.QtyInvoiced") + "<>SUM(NVL(mi.Qty,0))";
        } else if (display == 2) {
            this.m_dateColumn = "hdr.DateOrdered";
            this.m_qtyColumn = "lin.QtyOrdered";
            this.m_sql.append("SELECT hdr.C_Order_ID,hdr.DocumentNo, hdr.DateOrdered, bp.Name,hdr.C_BPartner_ID, lin.Line,lin.C_OrderLine_ID, p.Name,lin.M_Product_ID, lin.QtyOrdered,SUM(COALESCE(mo.Qty,0)) FROM C_Order hdr INNER JOIN C_BPartner bp ON (hdr.C_BPartner_ID=bp.C_BPartner_ID) INNER JOIN C_OrderLine lin ON (hdr.C_Order_ID=lin.C_Order_ID) INNER JOIN M_Product p ON (lin.M_Product_ID=p.M_Product_ID) INNER JOIN C_DocType dt ON (hdr.C_DocType_ID=dt.C_DocType_ID AND dt.DocBaseType='POO') FULL JOIN M_MatchPO mo ON (lin.C_OrderLine_ID=mo.C_OrderLine_ID) WHERE mo.").append(matchToType == 1 ? "M_InOutLine_ID" : "C_InvoiceLine_ID").append(matched ? " IS NOT NULL" : " IS NULL AND hdr.DocStatus IN ('CO','CL')");
            this.m_groupBy = " GROUP BY hdr.C_Order_ID,hdr.DocumentNo,hdr.DateOrdered,bp.Name,hdr.C_BPartner_ID, lin.Line,lin.C_OrderLine_ID,p.Name,lin.M_Product_ID,lin.QtyOrdered HAVING " + (matched ? "0" : "lin.QtyOrdered") + "<>SUM(COALESCE(mo.Qty,0))";
        } else {
            this.m_dateColumn = "hdr.MovementDate";
            this.m_qtyColumn = "lin.MovementQty";
            this.m_sql.append("SELECT hdr.M_InOut_ID,hdr.DocumentNo, hdr.MovementDate, bp.Name,hdr.C_BPartner_ID, lin.Line,lin.M_InOutLine_ID, p.Name,lin.M_Product_ID, lin.MovementQty,SUM(NVL(m.Qty,0)) FROM M_InOut hdr INNER JOIN C_BPartner bp ON (hdr.C_BPartner_ID=bp.C_BPartner_ID) INNER JOIN M_InOutLine lin ON (hdr.M_InOut_ID=lin.M_InOut_ID) INNER JOIN M_Product p ON (lin.M_Product_ID=p.M_Product_ID) INNER JOIN C_DocType dt ON (hdr.C_DocType_ID = dt.C_DocType_ID AND dt.DocBaseType='MMR') FULL JOIN ").append(matchToType == 2 ? "M_MatchPO" : "M_MatchInv").append(" m ON (lin.M_InOutLine_ID=m.M_InOutLine_ID) WHERE hdr.DocStatus IN ('CO','CL')");
            this.m_groupBy = " GROUP BY hdr.M_InOut_ID,hdr.DocumentNo,hdr.MovementDate,bp.Name,hdr.C_BPartner_ID, lin.Line,lin.M_InOutLine_ID,p.Name,lin.M_Product_ID,lin.MovementQty HAVING " + (matched ? "0" : "lin.MovementQty") + "<>SUM(NVL(m.Qty,0))";
        }
    }

    private boolean createMatchRecord(WebSessionCtx wsc, boolean invoice, int M_InOutLine_ID, int Line_ID, BigDecimal qty) {
        if (qty.compareTo(Env.ZERO) == 0) {
            return true;
        }
        this.log.fine("IsInvoice=" + invoice + ", M_InOutLine_ID=" + M_InOutLine_ID + ", Line_ID=" + Line_ID + ", Qty=" + qty);
        boolean success = false;
        MInOutLine sLine = new MInOutLine(wsc.ctx, M_InOutLine_ID, null);
        if (invoice) {
            MInvoiceLine iLine = new MInvoiceLine(wsc.ctx, Line_ID, null);
            iLine.setM_InOutLine_ID(M_InOutLine_ID);
            if (sLine.getC_OrderLine_ID() != 0) {
                iLine.setC_OrderLine_ID(sLine.getC_OrderLine_ID());
            }
            iLine.save();
            if (iLine.getM_Product_ID() != 0) {
                MMatchInv match = new MMatchInv(iLine, null, qty);
                match.setM_InOutLine_ID(M_InOutLine_ID);
                if (match.save()) {
                    success = true;
                } else {
                    this.log.log(Level.SEVERE, "Inv Match not created: " + match);
                }
            } else {
                success = true;
            }
            if (iLine.getC_OrderLine_ID() != 0 && iLine.getM_Product_ID() != 0) {
                MMatchPO matchPO = MMatchPO.create(iLine, sLine, null, qty);
                matchPO.setC_InvoiceLine_ID(iLine);
                matchPO.setM_InOutLine_ID(M_InOutLine_ID);
                if (!matchPO.save()) {
                    this.log.log(Level.SEVERE, "PO(Inv) Match not created: " + matchPO);
                }
            }
        } else {
            sLine.setC_OrderLine_ID(Line_ID);
            sLine.save();
            MOrderLine oLine = new MOrderLine(wsc.ctx, Line_ID, null);
            if (oLine.get_ID() != 0) {
                oLine.setQtyReserved(oLine.getQtyReserved().subtract(qty));
                if (!oLine.save()) {
                    this.log.severe("QtyReserved not updated - C_OrderLine_ID=" + Line_ID);
                }
            }
            if (sLine.getM_Product_ID() != 0) {
                MMatchPO match = new MMatchPO(sLine, null, qty);
                if (!match.save()) {
                    this.log.log(Level.SEVERE, "PO Match not created: " + match);
                } else {
                    success = true;
                    if (sLine.getProduct() != null && sLine.getProduct().isStocked()) {
                        success = MStorage.add(wsc.ctx, sLine.getM_Warehouse_ID(), sLine.getM_Locator_ID(), sLine.getM_Product_ID(), sLine.getM_AttributeSetInstance_ID(), oLine.getM_AttributeSetInstance_ID(), null, null, qty.negate(), null);
                    }
                }
            } else {
                success = true;
            }
        }
        return success;
    }
}

