/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.web.struts.form;

import com.ampiere.web.struts.form.MatchingForm;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.compiere.model.MForm;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.WebSessionCtx;

public class Matching
extends Action {
    private CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());
    private static final String MATCHING_LIST = "matchinglist";
    private static final String ACTION_FORM = "MatchingForm";
    private static final String ERROR_FORWARD = "error";
    private static final int FORM_ID = 108;
    private String[] matchOptions = new String[]{"C_Invoice_ID", "M_InOut_ID", "C_Order_ID"};
    private String[] matchMode = new String[]{"NotMatched", "Matched"};
    private static final int MATCH_INVOICE = 0;
    private static final int MATCH_SHIPMENT = 1;
    private static final int MATCH_ORDER = 2;

    public final ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HashMap<String, Object> data;
        int i2;
        WebSessionCtx wscTest = WebSessionCtx.get(request);
        if (wscTest == null) {
            this.log.log(Level.SEVERE, "Session Time Out.");
            request.setAttribute("sessionTimeoutInfo", (Object)"Session Time Out. Please login again.");
            return mapping.findForward("sessionTimeout");
        }
        this.log.fine("Begin " + ((Object)((Object)this)).getClass().getName() + ";execute");
        WebSessionCtx wsc = WebSessionCtx.get(request);
        if (wsc == null) {
            this.log.log(Level.SEVERE, "Session Time Out.");
            return mapping.findForward(ERROR_FORWARD);
        }
        wsc.ctx.setContext(0, "IsSOTrx", "Y");
        MForm form2 = this.getForm(wsc.ctx, 108);
        wsc.ctx.setContext("FormName", form2.getName());
        MatchingForm myForm = (MatchingForm)request.getAttribute(ACTION_FORM);
        if (myForm == null && (myForm = (MatchingForm)actionForm) == null) {
            myForm = new MatchingForm();
            myForm.setSameBusinessPartner("on");
            myForm.setSameProduct("on");
        }
        myForm.setMainWindowTitle(form2.getName() + " - " + wsc.loginInfo);
        myForm.setPageTitle(form2.getName());
        myForm.setMatchFromLabel(Msg.translate(wsc.ctx, "MatchFrom"));
        ArrayList dataList = new ArrayList();
        for (i2 = 0; i2 < this.matchOptions.length; ++i2) {
            data = new HashMap<String, Object>();
            data.put("key", i2);
            data.put("value", Msg.getElement(wsc.ctx, this.matchOptions[i2], false));
            dataList.add(data);
        }
        myForm.setMatchFromList(dataList);
        myForm.setMatchToLabel(Msg.translate(wsc.ctx, "MatchTo"));
        dataList = new ArrayList();
        switch (myForm.getMatchFrom()) {
            case 0: {
                data = new HashMap();
                data.put("key", 1);
                data.put("value", Msg.getElement(wsc.ctx, this.matchOptions[1], false));
                dataList.add(data);
                myForm.setMatchTo(1);
                break;
            }
            case 1: {
                data = new HashMap();
                data.put("key", 0);
                data.put("value", Msg.getElement(wsc.ctx, this.matchOptions[0], false));
                dataList.add(data);
                data = new HashMap();
                data.put("key", 2);
                data.put("value", Msg.getElement(wsc.ctx, this.matchOptions[2], false));
                dataList.add(data);
                myForm.setMatchTo(0);
                break;
            }
            case 2: {
                data = new HashMap();
                data.put("key", 1);
                data.put("value", Msg.getElement(wsc.ctx, this.matchOptions[1], false));
                dataList.add(data);
                myForm.setMatchTo(1);
            }
        }
        myForm.setMatchToList(dataList);
        myForm.setMatchModeLabel(Msg.translate(wsc.ctx, "MatchMode"));
        dataList = new ArrayList();
        for (i2 = 0; i2 < this.matchMode.length; ++i2) {
            data = new HashMap();
            data.put("key", i2);
            data.put("value", Msg.translate(wsc.ctx, this.matchMode[i2]));
            dataList.add(data);
        }
        myForm.setMatchModeList(dataList);
        myForm.setBusinessPartnerLabel(Msg.translate(wsc.ctx, "C_BPartner_ID"));
        myForm.setProductLabel(Msg.translate(wsc.ctx, "M_Product_ID"));
        myForm.setDateFromLabel(Msg.translate(wsc.ctx, "DateFrom"));
        myForm.setDateToLabel(Msg.translate(wsc.ctx, "DateTo"));
        myForm.setSearchLabel(Msg.translate(wsc.ctx, "Search"));
        myForm.setMatchFromText(Msg.getElement(wsc.ctx, this.matchOptions[myForm.getMatchFrom()], false));
        this.loadFromDataList(wsc, myForm);
        myForm.setSameBusinessPartnerLabel(Msg.translate(wsc.ctx, "SameBPartner"));
        myForm.setSameProductLabel(Msg.translate(wsc.ctx, "SameProduct"));
        myForm.setSameQuantityLabel(Msg.translate(wsc.ctx, "SameQty"));
        myForm.setMatchToText(Msg.getElement(wsc.ctx, this.matchOptions[myForm.getMatchTo()], false));
        this.loadToDataList(wsc, myForm);
        myForm.setToBeMatchedLabel(Msg.translate(wsc.ctx, "ToBeMatched"));
        myForm.setMatchingLabel(Msg.translate(wsc.ctx, "Matching"));
        myForm.setMatchDifferenceLabel(Msg.translate(wsc.ctx, "Difference"));
        myForm.setProcessLabel(Msg.translate(wsc.ctx, "Process"));
        request.setAttribute(ACTION_FORM, (Object)myForm);
        this.log.fine("End " + ((Object)((Object)this)).getClass().getName() + ";execute");
        return mapping.findForward(MATCHING_LIST);
    }

    private void loadFromDataList(WebSessionCtx wsc, MatchingForm form2) {
        ArrayList dataList = form2.getMatchFromDataList();
        if (dataList == null) {
            dataList = new ArrayList();
        }
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("RowType", "title");
        data.put("ID", "");
        data.put("DocumentNo", Msg.translate(wsc.ctx, "DocumentNo"));
        data.put("Date", Msg.translate(wsc.ctx, "Date"));
        data.put("BusinessPartner", Msg.translate(wsc.ctx, "C_BPartner_ID"));
        data.put("Line", Msg.translate(wsc.ctx, "Line"));
        data.put("Product", Msg.translate(wsc.ctx, "M_Product_ID"));
        data.put("Quantity", Msg.translate(wsc.ctx, "Qty"));
        data.put("Matched", Msg.translate(wsc.ctx, "Matched"));
        dataList.add(0, data);
        form2.setMatchFromDataList(dataList);
    }

    private void loadToDataList(WebSessionCtx wsc, MatchingForm form2) {
        ArrayList dataList = form2.getMatchToDataList();
        if (dataList == null) {
            dataList = new ArrayList();
        }
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("RowType", "title");
        data.put("ID", "");
        data.put("DocumentNo", Msg.translate(wsc.ctx, "DocumentNo"));
        data.put("Date", Msg.translate(wsc.ctx, "Date"));
        data.put("BusinessPartner", Msg.translate(wsc.ctx, "C_BPartner_ID"));
        data.put("Line", Msg.translate(wsc.ctx, "Line"));
        data.put("Product", Msg.translate(wsc.ctx, "M_Product_ID"));
        data.put("Quantity", Msg.translate(wsc.ctx, "Qty"));
        data.put("Matched", Msg.translate(wsc.ctx, "Matched"));
        dataList.add(0, data);
        form2.setMatchToDataList(dataList);
    }

    private MForm getForm(Ctx ctx, int formId) {
        boolean trl;
        MForm form2 = new MForm(ctx, formId, null);
        boolean bl = trl = !Env.isBaseLanguage(ctx, "AD_Form");
        if (trl) {
            String sql = "SELECT t.Name, t.Description, t.Help FROM AD_Form f INNER JOIN AD_Form_Trl t ON (f.AD_Form_ID=t.AD_Form_ID AND AD_Language=?)WHERE f.AD_Form_ID=?";
            try {
                CPreparedStatement pstmt = DB.prepareStatement(sql, null);
                if (trl) {
                    pstmt.setString(1, Env.getAD_Language(ctx));
                    pstmt.setInt(2, formId);
                    ResultSet rs = pstmt.executeQuery();
                    if (rs.next()) {
                        form2.setName(rs.getString(1));
                        form2.setDescription(rs.getString(2));
                        form2.setHelp(rs.getString(3));
                    }
                    rs.close();
                    pstmt.close();
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, e);
            }
        }
        return form2;
    }
}

