/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.web.struts.form;

import com.ampiere.web.struts.form.ArchiveViewForm;
import com.jware.util.StringToIntConverter;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.compiere.model.MArchive;
import org.compiere.model.MRole;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.util.ValueNamePair;
import org.compiere.util.WebSessionCtx;

public class ArchiveViewAction
extends Action {
    private CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());
    private static final String ACTION_FORM = "ArchiveViewForm";
    private static final String ERROR_FORWARD = "error";
    private static final String ARICHIVES = "ARICHIVES";
    private static final int FORM_ID = 118;

    public final ActionForward execute(ActionMapping mapping, ActionForm form2, HttpServletRequest request, HttpServletResponse response) throws Exception {
        WebSessionCtx wscTest = WebSessionCtx.get(request);
        if (wscTest == null) {
            this.log.log(Level.SEVERE, "Session Time Out.");
            request.setAttribute("sessionTimeoutInfo", (Object)"Session Time Out. Please login again.");
            return mapping.findForward("sessionTimeout");
        }
        HttpSession session = request.getSession();
        WebSessionCtx wsc = WebSessionCtx.get(request);
        if (wsc == null) {
            this.log.log(Level.SEVERE, "Session Time Out.");
            return mapping.findForward(ERROR_FORWARD);
        }
        ArchiveViewForm archiveViewForm = (ArchiveViewForm)form2;
        archiveViewForm.setTitle(Msg.getMsg(wsc.ctx, "Archive"));
        request.setAttribute(ACTION_FORM, (Object)archiveViewForm);
        MArchive[] archives = this.cmd_query(request, archiveViewForm);
        session.setAttribute(ARICHIVES, (Object)archives);
        ArrayList<ValueNamePair> archiveList = new ArrayList<ValueNamePair>();
        for (int i2 = 0; i2 < archives.length; ++i2) {
            MArchive currentArchive = archives[i2];
            String name = "MArchive[" + currentArchive.get_ID() + ",Name=" + currentArchive.getName() + "]";
            ValueNamePair pair = new ValueNamePair(String.valueOf(i2), name);
            archiveList.add(pair);
        }
        session.setAttribute("archiveList", archiveList);
        session.setAttribute(ACTION_FORM, (Object)archiveViewForm);
        return mapping.findForward("success");
    }

    public MArchive[] cmd_query(HttpServletRequest request, ArchiveViewForm archiveViewForm) {
        String fDateTo;
        String fDateFrom;
        int userId;
        String ss;
        WebSessionCtx wsc = WebSessionCtx.get(request);
        StringBuffer sql = new StringBuffer();
        boolean reports = "on".equals(archiveViewForm.getIsReport());
        MRole role = MRole.getDefault(wsc.ctx, false);
        if (!role.isCanReport()) {
            this.log.warning("User/Role cannot Report AD_User_ID=" + wsc.ctx.getAD_User_ID());
            return null;
        }
        sql.append(" AND IsReport=").append(reports ? "'Y'" : "'N'");
        if (reports && StringToIntConverter.StringToInt(archiveViewForm.getProcess()) > 0) {
            sql.append(" AND AD_Process_ID=").append(archiveViewForm.getProcess());
        }
        int m_AD_Table_ID = StringToIntConverter.StringToInt(archiveViewForm.getTable());
        int m_Record_ID = 0;
        if (m_AD_Table_ID > 0) {
            sql.append(" AND ((AD_Table_ID=").append(m_AD_Table_ID);
            if (m_Record_ID > 0) {
                sql.append(" AND Record_ID=").append(m_Record_ID);
            }
            sql.append(")");
            if (m_AD_Table_ID == 291 && m_Record_ID > 0) {
                sql.append(" OR C_BPartner_ID=").append(m_Record_ID);
            }
            sql.append(")");
            m_AD_Table_ID = 0;
            m_Record_ID = 0;
        } else if (m_AD_Table_ID > 0) {
            sql.append(" AND AD_Table_ID=").append(m_AD_Table_ID);
        }
        if (!reports) {
            String bpartnerId = archiveViewForm.getBpartnerId();
            if (!StringUtils.isEmpty(bpartnerId)) {
                sql.append(" AND C_BPartner_ID=").append(bpartnerId);
            } else {
                sql.append(" AND C_BPartner_ID IS NOT NULL");
            }
        }
        if ((ss = archiveViewForm.getName()) != null && ss.length() > 0) {
            if (ss.indexOf("%") != -1 || ss.indexOf("_") != -1) {
                sql.append(" AND Name LIKE ").append(DB.TO_STRING(ss));
            } else {
                sql.append(" AND Name=").append(DB.TO_STRING(ss));
            }
        }
        if ((ss = archiveViewForm.getDescription()) != null && ss.length() > 0) {
            if (ss.indexOf("%") != -1 || ss.indexOf("_") != -1) {
                sql.append(" AND Description LIKE ").append(DB.TO_STRING(ss));
            } else {
                sql.append(" AND Description=").append(DB.TO_STRING(ss));
            }
        }
        if ((ss = archiveViewForm.getHelp()) != null && ss.length() > 0) {
            if (ss.indexOf("%") != -1 || ss.indexOf("_") != -1) {
                sql.append(" AND Help LIKE ").append(DB.TO_STRING(ss));
            } else {
                sql.append(" AND Help=").append(DB.TO_STRING(ss));
            }
        }
        if ((userId = StringToIntConverter.StringToInt(archiveViewForm.getCreatedBy())) > 0) {
            sql.append(" AND CreatedBy=").append(userId);
        }
        if (!StringUtils.isEmpty(fDateFrom = archiveViewForm.getCreatedFrom())) {
            try {
                Timestamp from = null;
                try {
                    from = new Timestamp(wsc.dateFormat.parse(fDateFrom).getTime());
                }
                catch (Exception e) {
                    from = null;
                }
                if (from != null) {
                    sql.append(" AND Created>=").append(DB.TO_DATE(from, true));
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (!StringUtils.isEmpty(fDateTo = archiveViewForm.getCreatedTo())) {
            try {
                Timestamp to = null;
                try {
                    to = new Timestamp(wsc.dateFormat.parse(fDateTo).getTime());
                }
                catch (Exception e) {
                    to = null;
                }
                sql.append(" AND Created<").append(DB.TO_DATE(TimeUtil.addDays(to, 1), true));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.log.fine(sql.toString());
        sql.append(" AND (AD_Process_ID IS NULL OR AD_Process_ID IN (SELECT AD_Process_ID FROM AD_Process_Access WHERE AD_Role_ID=").append(role.getAD_Role_ID()).append("))");
        sql.append(" AND (AD_Table_ID IS NULL OR (AD_Table_ID IS NOT NULL AND AD_Process_ID IS NOT NULL) OR AD_Table_ID IN (SELECT t.AD_Table_ID FROM AD_Tab t INNER JOIN AD_Window_Access wa ON (t.AD_Window_ID=wa.AD_Window_ID) WHERE wa.AD_Role_ID=").append(role.getAD_Role_ID()).append("))");
        this.log.finest(sql.toString());
        MArchive[] m_archives = MArchive.get(wsc.ctx, sql.toString());
        this.log.info("Length=" + m_archives.length);
        return m_archives;
    }
}

