/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.web.servlet;

import com.ampiere.util.AmpiereUtil;
import com.ampiere.web.servlet.WAbout;
import com.ampiere.web.servlet.WWindowStatus;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Timestamp;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.a;
import org.apache.ecs.xhtml.b;
import org.apache.ecs.xhtml.div;
import org.apache.ecs.xhtml.em;
import org.apache.ecs.xhtml.form;
import org.apache.ecs.xhtml.img;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.label;
import org.apache.ecs.xhtml.li;
import org.apache.ecs.xhtml.link;
import org.apache.ecs.xhtml.script;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.textarea;
import org.apache.ecs.xhtml.tr;
import org.apache.ecs.xhtml.ul;
import org.compiere.model.MRole;
import org.compiere.model.MUser;
import org.compiere.model.MUserPreference;
import org.compiere.util.CLogErrorBuffer;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.compiere.util.WebDoc;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUtil;

public class WToolsPreference
extends HttpServlet {
    private static final long serialVersionUID = -4841905070456127217L;
    private CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());
    public static final int WINDOW_WIDTH = 680;
    public static final int WINDOW_HEIGHT = 520;
    private static final int TAB_HEIGHT = 355;
    private static final String TAB_STYLE = "height:355;";
    private static final String INFO_AREA_STYLE = "width:620px;height:80px;";
    private static final String POST_TYPE_NAME = "postType";
    private static final String POST_TYPE_LOG = "postTypelog";
    private static final String POST_TYPE_SAVE = "postTypeSave";
    private static final String BTN_TYPE_NAME = "btnType";
    private static final String BTN_TYPE_LOG = "btnTypeLog";
    private static final String BTN_TYPE_RESET = "btnTypeReset";
    private static final String ERROR_ONLY_NAME = "errorOnly";
    private static final String AUTOCOMMIT = "AutoCommit";
    private static final String SHOWACCTTAB = "ShowAcctTab";
    private static final String SHOWTRLTAB = "ShowTrlTab";
    private static final String SHOWADVANCEDTAB = "ShowAdvancedTab";
    private static final String DATE = "Date";
    private static final String FORM_NAME = "WForm";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.log.info("WToolsPreference.init");
        if (!WebEnv.initWeb(config)) {
            throw new ServletException("WToolsPreference.init");
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.log.info("WToolsPreference.doGet");
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        if (wsc == null) {
            WebUtil.createTimeoutPage(request, response, this, null);
            return;
        }
        WebDoc doc = WebDoc.createPopup(Msg.translate(wsc.ctx, "Preference"));
        AmpiereUtil.addDatePicker(doc.getHead(), wsc);
        doc.getHead().addElement((Element)new link("js/yui_2.6.0/yui/build/tabview/assets/skins/sam/tabview.css", "stylesheet", "text/css"));
        doc.getHead().addElement((Element)new script((Element)null, "js/yui_2.6.0/yui/build/yahoo-dom-event/yahoo-dom-event.js"));
        doc.getHead().addElement((Element)new script((Element)null, "js/yui_2.6.0/yui/build/connection/connection.js"));
        doc.getHead().addElement((Element)new script((Element)null, "js/yui_2.6.0/yui/build/element/element-beta.js"));
        doc.getHead().addElement((Element)new script((Element)null, "js/yui_2.6.0/yui/build/tabview/tabview.js"));
        doc.getHead().addElement((Element)new script((Element)null, "js/preference.js"));
        table layout = new table();
        layout.setBorder(1);
        layout.setStyle("margin:10px 10px 10px 10px;background-color:#edf5ff;width:100%;");
        div tabPanel = new div();
        tabPanel.setID("tabPanel");
        tabPanel.setClass("yui-navset");
        doc.getBody().addElement((Element)layout.addElement((Element)new tr((Element)new td((Element)tabPanel))));
        ul nav = new ul();
        nav.setClass("yui-nav");
        tabPanel.addElement((Element)nav);
        li tab = new li();
        tab.setClass("selected");
        tab.addElement((Element)new a("#tabPreference", (Element)new em(Msg.translate(wsc.ctx, "Preference"))));
        nav.addElement((Element)tab);
        tab = new li();
        tab.addElement((Element)new a("#tabContext", (Element)new em(Msg.translate(wsc.ctx, "Context"))));
        nav.addElement((Element)tab);
        tab = new li();
        tab.addElement((Element)new a("#tabError", (Element)new em(Msg.translate(wsc.ctx, "Error"))));
        nav.addElement((Element)tab);
        div content = new div();
        content.setClass("yui-content");
        tabPanel.addElement((Element)content);
        content.addElement((Element)this.createPreferenceDiv(wsc));
        content.addElement((Element)this.createContextDiv(wsc));
        content.addElement((Element)this.createErrorDiv(wsc));
        tr line = new tr();
        td item = new td();
        item.setAlign("right");
        input cancel = AmpiereUtil.createImageButton(wsc.ctx, "Cancel", "window.close();");
        item.addElement((Element)cancel);
        input ok = AmpiereUtil.createImageButton(wsc.ctx, "Ok", "submitForm();");
        item.addElement((Element)ok);
        item.addElement("&nbsp;&nbsp;");
        line.addElement((Element)item);
        layout.addElement((Element)line);
        line = new tr();
        item = new td();
        StringBuffer status = new StringBuffer("#");
        status.append(wsc.ctx.size());
        status.append(" - ");
        status.append(Msg.translate(wsc.ctx, "AD_Window_ID"));
        status.append("=");
        int windowNo = 0;
        if (ws != null) {
            windowNo = ws.mWindow.getWindowNo();
        }
        status.append(windowNo);
        item.addElement(status.toString());
        line.addElement((Element)item);
        layout.addElement((Element)line);
        doc.getBody().addElement((Element)layout);
        doc.getBody().setClass("yui-skin-sam");
        doc.getBody().setOnLoad("var tabs = new YAHOO.widget.TabView('tabPanel');");
        WebUtil.createResponse(request, response, this, null, doc, false);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.log.info("WToolsPreference.doPost");
        WebSessionCtx wsc = WebSessionCtx.get(request);
        if (wsc == null) {
            WebUtil.createTimeoutPage(request, response, this, null);
            return;
        }
        String context = "";
        String postType = WebUtil.getParameter(request, POST_TYPE_NAME);
        if (POST_TYPE_LOG.equals(postType)) {
            boolean errorOnly;
            String btnType = WebUtil.getParameter(request, BTN_TYPE_NAME);
            boolean bl = errorOnly = "true".equals(WebUtil.getParameter(request, ERROR_ONLY_NAME));
            if (BTN_TYPE_RESET.equals(btnType)) {
                CLogErrorBuffer.get(true).resetBuffer(errorOnly);
                context = this.getLogTable(wsc, errorOnly).toString();
            } else {
                context = BTN_TYPE_LOG.equals(btnType) ? this.getLogTable(wsc, errorOnly).toString() : this.getLogTable(wsc, true).toString();
            }
        } else if (POST_TYPE_SAVE.equals(postType)) {
            MUserPreference m_preference = MUser.get(wsc.ctx).getPreference();
            m_preference.setIsAutoCommit(WebUtil.getParameterAsBoolean(request, AUTOCOMMIT));
            m_preference.setIsShowAcct(WebUtil.getParameterAsBoolean(request, SHOWACCTTAB));
            wsc.ctx.setContext("#ShowAcct", WebUtil.getParameterAsBoolean(request, SHOWACCTTAB));
            m_preference.setIsShowTrl(WebUtil.getParameterAsBoolean(request, SHOWTRLTAB));
            wsc.ctx.setContext("#ShowTrl", WebUtil.getParameterAsBoolean(request, SHOWTRLTAB));
            m_preference.setIsShowAdvanced(WebUtil.getParameterAsBoolean(request, SHOWADVANCEDTAB));
            wsc.ctx.setContext("#ShowAdvanced", WebUtil.getParameterAsBoolean(request, SHOWADVANCEDTAB));
            Timestamp ts = WebUtil.getParameterAsDate(request, DATE);
            if (ts != null) {
                wsc.ctx.setContext("#Date", ts);
            }
            m_preference.save();
        }
        response.setHeader("Cache-Control", "no-cache");
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter out = response.getWriter();
        out.write(context);
        out.flush();
        out.close();
    }

    private div createPreferenceDiv(WebSessionCtx wsc) {
        MUser user = MUser.get(wsc.ctx);
        div divPreference = new div();
        divPreference.setStyle("height:355;px;width:640px;");
        table layout = new table();
        layout.setStyle("border-collapse:separate;border-spacing:20px;");
        td item = new td();
        item.setColSpan(3);
        textarea infoArea = new textarea();
        infoArea.setStyle(INFO_AREA_STYLE);
        infoArea.setReadOnly(true);
        infoArea.addElement(WAbout.getInfo(wsc.ctx, null, false).toString());
        item.addElement((Element)infoArea);
        tr line = new tr();
        line.addElement((Element)item);
        layout.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new td());
        item = new td();
        input btn = new input("button", "UITheme", Msg.getMsg(wsc.ctx, "UITheme", true));
        btn.setStyle("width:200px");
        item.addElement((Element)btn);
        line.addElement((Element)item);
        item = new td();
        item.setAlign("right");
        btn = new input("button", "AD_Role_ID", Msg.translate(wsc.ctx, "AD_Role_ID"));
        btn.setOnClick("alert('" + Msg.translate(wsc.ctx, "RoleInfo") + "\\r\\n\\r\\n" + MRole.getDefault(wsc.ctx, false).toStringX(wsc.ctx).replaceAll(Env.NL, "\\\\r\\\\n") + "');");
        item.addElement((Element)btn);
        line.addElement((Element)item);
        layout.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new td());
        item = new td();
        input checkBox = new input("checkbox", AUTOCOMMIT, "true");
        checkBox.setID(AUTOCOMMIT);
        checkBox.setChecked(wsc.ctx.isAutoCommit());
        label checkBoxLabel = new label(AUTOCOMMIT, null, Util.maskHTML(Msg.getMsg(wsc.ctx, AUTOCOMMIT, true)));
        checkBox.addElement((Element)checkBoxLabel);
        item.addElement((Element)checkBox);
        line.addElement((Element)item);
        item = new td();
        checkBox = new input("checkbox", SHOWADVANCEDTAB, "true");
        checkBox.setID(SHOWADVANCEDTAB);
        checkBox.setChecked(user.getPreference().isShowAdvanced());
        checkBoxLabel = new label(SHOWADVANCEDTAB, null, Util.maskHTML(Msg.getMsg(wsc.ctx, SHOWADVANCEDTAB, true)));
        checkBox.addElement((Element)checkBoxLabel);
        item.addElement((Element)checkBox);
        line.addElement((Element)item);
        layout.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new td());
        item = new td();
        checkBox = new input("checkbox", SHOWACCTTAB, "true");
        checkBox.setID(SHOWACCTTAB);
        if (MRole.getDefault(wsc.ctx, false).isShowAcct()) {
            checkBox.setChecked(user.getPreference().isShowAcct());
        } else {
            checkBox.setChecked(false);
            checkBox.setDisabled(true);
        }
        checkBoxLabel = new label(SHOWACCTTAB, null, Util.maskHTML(Msg.getMsg(wsc.ctx, SHOWACCTTAB, true)));
        checkBox.addElement((Element)checkBoxLabel);
        item.addElement((Element)checkBox);
        line.addElement((Element)item);
        item = new td();
        checkBox = new input("checkbox", SHOWTRLTAB, "true");
        checkBox.setID(SHOWTRLTAB);
        checkBox.setChecked(user.getPreference().isShowTrl());
        checkBoxLabel = new label(SHOWTRLTAB, null, Util.maskHTML(Msg.getMsg(wsc.ctx, SHOWTRLTAB, true)));
        checkBox.addElement((Element)checkBoxLabel);
        item.addElement((Element)checkBox);
        line.addElement((Element)item);
        layout.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new td(Msg.getMsg(wsc.ctx, DATE, true)));
        item = new td();
        input date = new input("text", DATE, wsc.dateFormat.format(wsc.ctx.getContextAsTime("#Date"))).setSize(20).setMaxlength(10);
        date.setID("DateF");
        item.addElement((Element)date);
        img button2 = new img(WebEnv.getImageDirectory("Calendar16.png"), "DateB");
        button2.setID("DateB");
        item.addElement((Element)button2);
        div dateTimePickerScriptDiv = new div();
        AmpiereUtil.addDatePickerScript((Element)dateTimePickerScriptDiv, "DateF", "DateB", wsc.language);
        item.addElement((Element)dateTimePickerScriptDiv);
        line.addElement((Element)item);
        item = new td();
        line.addElement((Element)item);
        layout.addElement((Element)line);
        form mForm = new form();
        mForm.setMethod("post");
        mForm.setID(FORM_NAME);
        mForm.setName(FORM_NAME);
        mForm.addElement((Element)layout);
        divPreference.addElement((Element)mForm);
        return divPreference;
    }

    private div createContextDiv(WebSessionCtx wsc) {
        div divContext = new div();
        divContext.setStyle("height:355;px;width:100%;overflow:auto;");
        String[] context = wsc.ctx.getEntireContext();
        ul panal = new ul();
        divContext.addElement((Element)panal);
        for (int i2 = 0; i2 < context.length; ++i2) {
            panal.addElement((Element)new li(context[i2]));
        }
        return divContext;
    }

    private div createErrorDiv(WebSessionCtx wsc) {
        div divError = new div();
        divError.setStyle("height:355;px;width:100%;");
        table layout = new table();
        layout.setBorder(1);
        layout.setStyle("width:100%;");
        divError.addElement((Element)layout);
        div logInfo = new div();
        logInfo.setID("logInfo");
        logInfo.setStyle("width:100%;height:320px;overflow:auto;");
        logInfo.addElement((Element)this.getLogTable(wsc, true));
        layout.addElement((Element)new tr((Element)new td((Element)logInfo)));
        td item = new td();
        item.setAlign("right");
        input btn = new input("button", "All", Msg.getMsg(wsc.ctx, "All", true));
        btn.setOnClick("logTypeFlag='false';onBtnLog('btnTypeLog',logTypeFlag);");
        btn.setStyle("width:80px;");
        item.addElement((Element)btn);
        btn = new input("button", "ErrorsOnly", Msg.getMsg(wsc.ctx, "ErrorsOnly", true));
        btn.setStyle("width:80px;");
        btn.setOnClick("logTypeFlag='true';onBtnLog('btnTypeLog',logTypeFlag);");
        item.addElement((Element)btn);
        btn = new input("button", "Reset", Msg.getMsg(wsc.ctx, "Reset", true));
        btn.setStyle("width:80px;");
        btn.setOnClick("onBtnLog('btnTypeReset',logTypeFlag);");
        item.addElement((Element)btn);
        btn = new input("button", "SendEMail", Msg.getMsg(wsc.ctx, "SendEMail", true));
        btn.setStyle("width:80px;");
        StringBuffer parameter = new StringBuffer();
        parameter.append("channelmode=no,");
        parameter.append("directories=no,");
        parameter.append("fullscreen=no,");
        parameter.append("location=no,");
        parameter.append("menubar=no,");
        parameter.append("resizable=no,");
        parameter.append("scrollbars=no,");
        parameter.append("status=no,");
        parameter.append("titlebar=no,");
        parameter.append("toolbar=no");
        StringBuffer sb = new StringBuffer();
        sb.append("openWindow('WEMail?emailType=emailTypeSupport','" + Msg.translate(wsc.ctx, "EMailSupport") + "','" + parameter.toString() + "'," + 600 + "," + 500 + ");");
        btn.setOnClick(sb.toString());
        item.addElement((Element)btn);
        btn = new input("button", "SaveFile", Msg.getMsg(wsc.ctx, "SaveFile", true));
        btn.setStyle("width:120px;");
        item.addElement((Element)btn);
        layout.addElement((Element)new tr((Element)item));
        return divError;
    }

    private table getLogTable(WebSessionCtx wsc, boolean errorOnly) {
        table list = new table();
        list.setStyle("width:100%;");
        list.setBorder(1);
        tr line = new tr();
        try {
            Vector<String> columnNames = CLogErrorBuffer.get(true).getColumnNames(wsc.ctx);
            for (String title : columnNames) {
                td headItem = new td();
                headItem.setAlign("center");
                headItem.addElement((Element)new b(title));
                line.addElement((Element)headItem);
            }
            list.addElement((Element)line);
            Vector<Vector<Object>> datas = CLogErrorBuffer.get(true).getLogData(errorOnly);
            for (Vector<Object> data : datas) {
                line = new tr();
                for (Object item : data) {
                    line.addElement((Element)new td(item == null ? "" : item.toString()));
                }
                list.addElement((Element)line);
            }
        }
        catch (Exception e) {
            line.addElement((Element)new td());
            list.addElement((Element)line);
        }
        return list;
    }
}

