/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.web.servlet;

import com.ampiere.util.AmpiereUtil;
import com.ampiere.web.servlet.WebField;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParsePosition;
import java.util.Date;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.div;
import org.apache.ecs.xhtml.form;
import org.apache.ecs.xhtml.i;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.p;
import org.apache.ecs.xhtml.script;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.tr;
import org.compiere.framework.Lookup;
import org.compiere.model.MAccountLookup;
import org.compiere.model.MLocationLookup;
import org.compiere.model.MLocatorLookup;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MPAttributeLookup;
import org.compiere.model.MPInstance;
import org.compiere.model.MPInstancePara;
import org.compiere.model.MProcess;
import org.compiere.model.MProcessPara;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.NamePair;
import org.compiere.util.Trx;
import org.compiere.util.WebDoc;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUtil;

public class WProcessDialog
extends HttpServlet {
    private static final long serialVersionUID = 3563547961645399121L;
    protected CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb(config)) {
            throw new ServletException("WProcessDialog.init");
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        if (wsc == null) {
            WebUtil.createTimeoutPage(request, response, this, null);
            return;
        }
        WebDoc doc = null;
        int processId = WebUtil.getParameterAsInt(request, "processId");
        int windowNo = WebUtil.getParameterAsInt(request, "windowNo");
        int record_ID = WebUtil.getParameterAsInt(request, "recordId");
        if (processId > 0) {
            this.log.info("doGet - processId=" + processId);
            doc = this.createParameterPage(windowNo, wsc, processId, record_ID, request);
        } else {
            String fileName = WebUtil.getParameter(request, "File");
            int AD_PInstance_ID = WebUtil.getParameterAsInt(request, "AD_PInstance_ID");
            this.log.info("doGet - AD_PInstance_ID=" + AD_PInstance_ID + ", File=" + fileName);
            String error = this.streamResult(request, response, AD_PInstance_ID, fileName);
            if (error == null) {
                return;
            }
            doc = WebDoc.createWindow(error);
        }
        if (doc == null) {
            doc = WebDoc.createWindow("Process Not Found");
        }
        doc.getBody().setOnUnload("closeMyChildren();");
        WebUtil.createResponse(request, response, this, null, doc, false);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        if (wsc == null) {
            WebUtil.createTimeoutPage(request, response, this, null);
            return;
        }
        int AD_Process_ID = WebUtil.getParameterAsInt(request, "AD_Process_ID");
        int record_ID = WebUtil.getParameterAsInt(request, "record_ID");
        this.log.info("doGet - AD_Process_ID=" + AD_Process_ID);
        if (AD_Process_ID == 0) {
            WebUtil.createErrorPage(request, response, this, "No Process");
            return;
        }
        WebDoc doc = this.createProcessPage(request, AD_Process_ID, record_ID);
        doc.getBody().setOnUnload("closeMyChildren();");
        WebUtil.createResponse(request, response, this, null, doc, false);
    }

    private WebDoc createParameterPage(int windowNo, WebSessionCtx wsc, int AD_Process_ID, int record_ID, HttpServletRequest request) {
        boolean trl;
        MProcess process = MProcess.get(wsc.ctx, AD_Process_ID);
        if (process == null) {
            WebDoc doc = WebDoc.createWindow("Process Not Found");
            return doc;
        }
        boolean bl = trl = !Env.isBaseLanguage(wsc.language, "AD_Process");
        if (trl) {
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT ").append("    AD_Process_Trl.NAME, ").append("    AD_Process_Trl.DESCRIPTION, ").append("    AD_Process_Trl.HELP ").append("FROM AD_PROCESS, AD_Process_Trl ").append("WHERE AD_PROCESS.AD_Process_ID=AD_Process_Trl.AD_Process_ID ").append("  AND AD_PROCESS.AD_Process_ID=? ").append("  AND AD_Process_Trl.AD_Language=? ");
            CPreparedStatement pstmt = null;
            try {
                pstmt = DB.prepareStatement(sql.toString(), null);
                pstmt.setInt(1, process.getAD_Process_ID());
                pstmt.setString(2, wsc.language.getAD_Language());
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    process.setName(rs.getString(1));
                    process.setHelp(rs.getString(2));
                    process.setDescription(rs.getString(3));
                }
                rs.close();
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, sql.toString(), e);
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                pstmt = null;
            }
            catch (Exception e) {
                pstmt = null;
            }
        }
        request.setAttribute("IS_POPUP_WINDOW", (Object)"1");
        WebDoc doc = WebDoc.createWindow(process.getName());
        String processName = "process" + process.getAD_Process_ID();
        StringBuffer sb = new StringBuffer();
        sb.append("function processDialogSubmit() {\n").append("var progressObj = document.getElementById('progress000');\n").append("if (progressObj != null) {\n").append("    progressObj.style.display='block';\n").append("}\n").append("var okObj = document.getElementById('PopupOk');\n").append("if (okObj != null) {\n").append("    okObj.disabled = true;\n").append("}\n").append("return true;\n").append("}\n");
        doc.getHead().addElement((Element)new script(sb.toString()));
        AmpiereUtil.addDatePicker(doc.getHead(), wsc);
        td tdCenter = doc.addTd();
        div center = (div)new div().setID("body");
        tdCenter.addElement((Element)center);
        tdCenter.setClass("popupInfoTable");
        if (process.getDescription() != null) {
            center.addElement((Element)new p((Element)new i(process.getDescription())));
        }
        if (process.getHelp() != null) {
            center.addElement((Element)new p(process.getHelp(), "left"));
        }
        form myForm = new form("WProcessDialog").setName(processName);
        myForm.setStyle("margin: 0;");
        myForm.setOnSubmit("return processDialogSubmit();");
        myForm.addElement((Element)new input("hidden", "AD_Process_ID", process.getAD_Process_ID()));
        myForm.addElement((Element)new input("hidden", "record_ID", record_ID));
        table myTable = new table("0", "0", "2", "100%", null);
        myTable.setID("WProcessDialogParameter");
        String sql = null;
        sql = Env.isBaseLanguage(wsc.ctx, "AD_Process_Para") ? "SELECT p.Name, p.Description, p.Help, p.AD_Reference_ID, p.AD_Process_Para_ID, p.FieldLength, p.IsMandatory, p.IsRange, p.ColumnName, p.DefaultValue, p.DefaultValue2, p.VFormat, p.ValueMin, p.ValueMax, p.SeqNo, p.AD_Reference_Value_ID, vr.Code AS ValidationCode FROM AD_Process_Para p LEFT OUTER JOIN AD_Val_Rule vr ON (p.AD_Val_Rule_ID=vr.AD_Val_Rule_ID) WHERE p.AD_Process_ID=? AND p.IsActive='Y' ORDER BY SeqNo" : "SELECT t.Name, t.Description, t.Help, p.AD_Reference_ID, p.AD_Process_Para_ID, p.FieldLength, p.IsMandatory, p.IsRange, p.ColumnName, p.DefaultValue, p.DefaultValue2, p.VFormat, p.ValueMin, p.ValueMax, p.SeqNo, p.AD_Reference_Value_ID, vr.Code AS ValidationCode FROM AD_Process_Para p INNER JOIN AD_Process_Para_Trl t ON (p.AD_Process_Para_ID=t.AD_Process_Para_ID) LEFT OUTER JOIN AD_Val_Rule vr ON (p.AD_Val_Rule_ID=vr.AD_Val_Rule_ID) WHERE p.AD_Process_ID=? AND t.AD_Language='" + Env.getAD_Language(wsc.ctx) + "'" + " AND p.IsActive='Y' " + "ORDER BY SeqNo";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, process.getAD_Process_ID());
            ResultSet rs = pstmt.executeQuery();
            Lookup lookup = null;
            while (rs.next()) {
                boolean retValue = false;
                int displayType = rs.getInt("AD_Reference_ID");
                if (DisplayType.isLookup(displayType)) {
                    retValue = true;
                } else if (displayType == 21 || displayType == 31 || displayType == 25 || displayType == 35) {
                    retValue = true;
                }
                if (retValue) {
                    try {
                        if (DisplayType.isLookup(displayType)) {
                            MLookup mLookup = new MLookup(wsc.ctx, windowNo, rs.getInt("AD_Reference_ID"));
                            lookup = mLookup.initialize(MLookupFactory.getLookupInfo(wsc.ctx, windowNo, rs.getInt("AD_Reference_ID"), rs.getInt("AD_Process_Para_ID"), Env.getLanguage(wsc.ctx), rs.getString("ColumnName"), rs.getInt("AD_Reference_Value_ID"), false, rs.getString("ValidationCode")));
                        } else if (displayType == 21) {
                            MLocationLookup ml;
                            lookup = ml = new MLocationLookup(wsc.ctx, windowNo);
                        } else if (displayType == 31) {
                            MLocatorLookup ml = new MLocatorLookup(wsc.ctx, windowNo);
                            ml.setOnly_Warehouse_ID(AmpiereUtil.getOnly_Warehouse_ID(wsc.ctx, windowNo));
                            lookup = ml;
                        } else if (displayType == 25) {
                            MAccountLookup ma = new MAccountLookup(wsc.ctx, windowNo);
                            lookup = ma;
                        } else if (displayType == 35) {
                            MPAttributeLookup pa = new MPAttributeLookup(wsc.ctx, windowNo);
                            lookup = pa;
                        }
                        if (lookup != null) {
                            lookup.loadComplete();
                        }
                    }
                    catch (Exception e) {
                        CLogger.get().log(Level.SEVERE, "No LookupInfo for " + rs.getString("ColumnName"), e);
                    }
                }
                int displayLength = 240;
                WebField wField = new WebField(windowNo, wsc, rs.getString("ColumnName"), rs.getString("Name"), rs.getString("Description"), rs.getInt("AD_Reference_ID"), rs.getInt("FieldLength"), displayLength, false, false, rs.getString("IsMandatory").equals("Y"), false, false, false, process.getAD_Process_ID(), false);
                td toField = null;
                if (rs.getString("IsRange").equals("Y")) {
                    WebField wFieldTo = new WebField(windowNo, wsc, rs.getString("ColumnName") + "To", rs.getString("Name"), rs.getString("Description"), rs.getInt("AD_Reference_ID"), rs.getInt("FieldLength"), displayLength, false, false, rs.getString("IsMandatory").equals("Y"), false, false, false, process.getAD_Process_ID(), false);
                    toField = wFieldTo.getField(lookup, this.createDefault(wsc, rs.getString("DefaultValue2"), rs.getInt("AD_Reference_ID")), rs.getInt("AD_Process_Para_ID"));
                } else {
                    toField = new td(WebEnv.NBSP);
                }
                myTable.addElement((Element)new tr().addElement((Element)wField.getLabel().setAlign("right")).addElement((Element)wField.getField(lookup, this.createDefault(wsc, rs.getString("DefaultValue"), rs.getInt("AD_Reference_ID")), rs.getInt("AD_Process_Para_ID"))).addElement((Element)toField));
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        td confirmTd = new td();
        confirmTd.setColSpan(3);
        confirmTd.setTagText("\u30d7\u30ed\u30bb\u30b9\u3092\u958b\u59cb\u3057\u307e\u3059\u304b\uff1f");
        myTable.addElement((Element)new tr().addElement((Element)confirmTd));
        div bottomDiv = (div)new div().setClass("bottomMenuRight");
        table bottomTable = new table();
        bottomDiv.addElement((Element)bottomTable);
        bottomTable.addElement((Element)new tr().addElement((Element)AmpiereUtil.createButtons(wsc.ctx, true)));
        myForm.addElement((Element)myTable);
        myForm.addElement((Element)bottomDiv);
        center.addElement((Element)myForm);
        return doc;
    }

    private WebDoc createProcessPage(HttpServletRequest request, int AD_Process_ID, int record_ID) {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        MProcess process = MProcess.get(wsc.ctx, AD_Process_ID);
        if (process == null) {
            WebDoc doc = WebDoc.createWindow("Process Not Found");
            return doc;
        }
        WebDoc doc = WebDoc.createWindow(process.getName());
        AmpiereUtil.addDatePicker(doc.getHead(), wsc);
        td center = doc.addWindowCenter(false);
        center.setClass("popupInfoTable");
        if (process.getDescription() != null) {
            center.addElement((Element)new p((Element)new i(process.getDescription())));
        }
        if (process.getHelp() != null) {
            center.addElement((Element)new p(process.getHelp(), "left"));
        }
        MPInstance pInstance = this.fillParameter(request, process);
        ProcessInfo pi = new ProcessInfo(process.getName(), process.getAD_Process_ID());
        pi.setAD_User_ID(wsc.ctx.getAD_User_ID());
        pi.setAD_Client_ID(wsc.ctx.getAD_Client_ID());
        pi.setAD_PInstance_ID(pInstance.getAD_PInstance_ID());
        pi.setRecord_ID(record_ID);
        boolean processOK = false;
        if (process.isJavaProcess()) {
            Trx trx = Trx.get(Trx.createTrxName("WebPrc"), true);
            try {
                processOK = process.processIt(pi, trx);
                trx.commit();
                trx.close();
            }
            catch (Throwable t) {
                trx.rollback();
                trx.close();
            }
            if (!processOK || pi.isError()) {
                center.addElement(new p("Error:" + pi.getSummary(), "left").setClass("Cerror"));
                processOK = false;
            }
            center.addElement(pi.getLogInfo(true));
        }
        p p2 = new p();
        p2.addElement(Msg.translate(wsc.ctx, "ProcessOK"));
        center.addElement((Element)p2);
        table bottomTable = new table("0", "0", "0", "102%", "topLine");
        bottomTable.addElement((Element)new tr().addElement((Element)AmpiereUtil.createButtons(wsc.ctx, false)));
        center.addElement((Element)bottomTable);
        if (process.isReport()) {
            StringBuffer sb = new StringBuffer();
            sb.append("openPrintWindow(").append("\"/compiere/ampiere/WPrintReport\",").append("\"PrintReport\" );");
            doc.getHead().addElement((Element)new script(sb.toString()));
            wsc.ctx.setContext("AD_Process_ID", AD_Process_ID);
            wsc.ctx.setContext("AD_PInstance_ID", pInstance.getAD_PInstance_ID());
        }
        return doc;
    }

    private MPInstance fillParameter(HttpServletRequest request, MProcess process) {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        MPInstance pInstance = new MPInstance(process, 0);
        MPInstancePara[] iParams = pInstance.getParameters();
        for (int pi = 0; pi < iParams.length; ++pi) {
            MPInstancePara iPara = iParams[pi];
            String key = iPara.getParameterName();
            MProcessPara pPara = process.getParameter(key);
            if (pPara == null) {
                this.log.log(Level.SEVERE, "Parameter not found: " + key);
                continue;
            }
            String valueString = WebUtil.getParameter(request, key);
            String valueStringTo = "";
            if (pPara.isRange()) {
                valueStringTo = WebUtil.getParameter(request, key + "To");
            }
            if (key.endsWith("ID") && "-1".equals(valueString)) {
                valueString = "0";
            }
            this.log.fine("fillParameter - " + key + " = " + valueString);
            String value = valueString;
            String valueTo = valueStringTo;
            if (valueString != null && valueString.length() == 0) {
                value = null;
            }
            if (valueStringTo != null && valueStringTo.length() == 0) {
                valueTo = null;
            }
            if (value == null && valueTo == null) continue;
            try {
                String v;
                Boolean checked;
                Date date;
                NamePair obj;
                BigDecimal bd;
                if (value != null) {
                    if (DisplayType.isNumeric(pPara.getAD_Reference_ID()) || DisplayType.isID(pPara.getAD_Reference_ID())) {
                        bd = null;
                        bd = value instanceof BigDecimal ? (BigDecimal)((Object)value) : (value instanceof Integer ? new BigDecimal((Integer)((Object)value)) : new BigDecimal(value.toString()));
                        iPara.setP_Number(bd);
                        if (DisplayType.isID(pPara.getAD_Reference_ID())) {
                            obj = pPara.getLookup().get(bd);
                            iPara.setInfo(obj.getName());
                        } else {
                            iPara.setInfo(bd.toString());
                        }
                        this.log.fine("fillParameter - " + key + " = " + valueString + " (=" + bd + "=)");
                    } else if (DisplayType.isDate(pPara.getAD_Reference_ID())) {
                        date = null;
                        date = value instanceof Timestamp ? wsc.dateTimeFormat.parse(value.toString(), new ParsePosition(0)) : wsc.dateFormat.parse(value.toString(), new ParsePosition(0));
                        iPara.setP_Date((Timestamp)date);
                        iPara.setInfo(value.toString());
                        this.log.fine("fillParameter - " + key + " = " + valueString + " (=" + date + "=)");
                    } else if (20 == pPara.getAD_Reference_ID()) {
                        checked = new Boolean(value.toString());
                        v = checked != false ? "Y" : "N";
                        iPara.setP_String(v);
                        iPara.setInfo(v);
                        this.log.fine("fillParameter - " + key + " = " + valueString + " (=" + v + "=)");
                    } else {
                        iPara.setP_String(value.toString());
                        iPara.setInfo(value.toString());
                    }
                }
                if (valueTo != null) {
                    if (DisplayType.isNumeric(pPara.getAD_Reference_ID()) || DisplayType.isID(pPara.getAD_Reference_ID())) {
                        bd = null;
                        bd = value instanceof BigDecimal ? (BigDecimal)((Object)valueTo) : (value instanceof Integer ? new BigDecimal((Integer)((Object)valueTo)) : new BigDecimal(valueTo.toString()));
                        iPara.setP_Number_To(bd);
                        if (DisplayType.isID(pPara.getAD_Reference_ID())) {
                            obj = pPara.getLookup().get(bd);
                            iPara.setInfo_To(obj.getName());
                        } else {
                            iPara.setInfo_To(bd.toString());
                        }
                        this.log.fine("fillParameter - " + key + " = " + valueStringTo + " (=" + bd + "=)");
                    } else if (DisplayType.isDate(pPara.getAD_Reference_ID())) {
                        date = null;
                        date = valueTo instanceof Timestamp ? wsc.dateTimeFormat.parse(valueTo.toString(), new ParsePosition(0)) : wsc.dateFormat.parse(valueTo.toString(), new ParsePosition(0));
                        iPara.setP_Date_To((Timestamp)date);
                        iPara.setInfo_To(valueTo.toString());
                        this.log.fine("fillParameter - " + key + " = " + valueString + " (=" + date + "=)");
                    } else if (20 == pPara.getAD_Reference_ID()) {
                        checked = new Boolean(valueTo.toString());
                        v = checked != false ? "Y" : "N";
                        iPara.setP_String_To(v);
                        iPara.setInfo_To(v);
                        this.log.fine("fillParameter - " + key + " = " + valueString + " (=" + v + "=)");
                    } else {
                        iPara.setP_String_To(valueTo.toString());
                        iPara.setInfo_To(valueTo.toString());
                    }
                }
                iPara.save();
                continue;
            }
            catch (Exception e) {
                this.log.warning("fillParameter - " + key + " = " + valueString + " (" + value + ") " + value.getClass().getName() + " - " + e.getLocalizedMessage());
            }
        }
        return pInstance;
    }

    private String streamResult(HttpServletRequest request, HttpServletResponse response, int AD_PInstance_ID, String fileName) {
        if (AD_PInstance_ID == 0) {
            return "Your process not found";
        }
        WebSessionCtx wsc = WebSessionCtx.get(request);
        Object value = wsc.ctx.get("AD_PInstance_ID=" + AD_PInstance_ID);
        if (value == null || !value.equals("ok")) {
            return "Process Instance not found";
        }
        if (fileName == null || fileName.length() == 0) {
            return "No Process Result";
        }
        File file = new File(fileName);
        if (!file.exists()) {
            return "Process Result not found: " + file;
        }
        return WebUtil.streamFile(response, file);
    }

    private Object createDefault(WebSessionCtx wsc, String value, int referenceId) {
        if (value == null || value.toString().length() == 0) {
            return null;
        }
        if ("@#Date@".equals(value)) {
            return wsc.ctx.getContextAsTime("#Date");
        }
        if ("Y".equals(value) || "N".equals(value)) {
            return "Y".equals(value);
        }
        if (value.startsWith("@SQL=")) {
            return DB.getSQLValueObject(null, value.substring(5));
        }
        if (value.startsWith("@")) {
            String id = wsc.ctx.getContext(value.substring(1, value.length() - 1));
            if (id == null || id.length() == 0) {
                return new Integer(0);
            }
            return new Integer(id);
        }
        if (referenceId == 31 || referenceId == 29) {
            return new Integer(value);
        }
        if (referenceId == 22 || referenceId == 12) {
            return new BigDecimal(value);
        }
        return value;
    }
}

